/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedList;
import java.util.List;

public class GDByteBuffer {
    public static final int SIZE_1KB = 1024;
    public static final int SIZE_1MB = 0x100000;
    public static final int SIZE_10MB = 0xA00000;
    public static final int SIZE_100MB = 0x6400000;
    private int bufferSize;
    private int lastBlockSize;
    private int fileSize;
    private List<byte[]> list;
    private int position;
    private ByteOrder bo;

    public GDByteBuffer(String filename) {
        this(new File(filename), 0x6400000);
    }

    public GDByteBuffer(String filename, int bufferSize) {
        this(new File(filename), bufferSize);
    }

    public GDByteBuffer(File file) {
        this(file, 0x6400000);
    }

    public GDByteBuffer(File file, int bufferSize) {
        this.bufferSize = bufferSize;
        this.list = new LinkedList<byte[]>();
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            int rest = this.fileSize = (int)raf.length();
            int size = 0;
            if (rest < bufferSize) {
                size = rest;
                this.lastBlockSize = rest;
            } else {
                size = bufferSize;
            }
            while (size > 0) {
                byte[] bytes = new byte[size];
                raf.readFully(bytes);
                this.list.add(bytes);
                if ((rest -= size) < bufferSize) {
                    size = rest;
                    if (rest <= 0) continue;
                    this.lastBlockSize = rest;
                    continue;
                }
                size = bufferSize;
            }
        }
        catch (IOException ex) {
            this.list = new LinkedList<byte[]>();
        }
        this.position = 0;
        this.bo = ByteOrder.LITTLE_ENDIAN;
    }

    public byte[] getBytes(int position, int length) {
        int listSize = (this.list.size() - 1) * this.bufferSize + this.lastBlockSize;
        if (listSize < position) {
            return null;
        }
        int byteSize = length;
        if (listSize < position + length) {
            byteSize = listSize - position;
        }
        if (byteSize <= 0) {
            return null;
        }
        byte[] result = new byte[byteSize];
        int tempPos = position;
        int tempLen = length;
        int resOffset = 0;
        int listPos = 0;
        for (byte[] bytes : this.list) {
            if (listPos <= tempPos && bytes.length + listPos > tempPos) {
                int bufferOffset = tempPos - listPos;
                int maxPos = bufferOffset + tempLen;
                if (maxPos > bytes.length) {
                    maxPos = bytes.length;
                }
                for (int i = bufferOffset; i < maxPos; ++i) {
                    result[i - bufferOffset + resOffset] = bytes[i];
                }
                if ((listPos += this.bufferSize) > tempPos + tempLen) break;
                tempPos = listPos;
                tempLen -= maxPos - bufferOffset;
                resOffset += maxPos - bufferOffset;
                continue;
            }
            listPos += this.bufferSize;
        }
        this.position = tempPos + tempLen;
        return result;
    }

    public byte[] get(int length) {
        return this.getBytes(this.position, length);
    }

    public int getInt() {
        byte[] bytes = this.getBytes(this.position, 4);
        return ByteBuffer.wrap(bytes).order(this.bo).getInt();
    }

    public long getLong() {
        byte[] bytes = this.getBytes(this.position, 8);
        return ByteBuffer.wrap(bytes).order(this.bo).getLong();
    }

    public String getString0() {
        StringBuffer sb = new StringBuffer(128);
        byte[] b = this.getBytes(this.position, 1);
        while (b[0] != 0) {
            sb.append((char)b[0]);
            b = this.getBytes(this.position, 1);
        }
        return sb.toString();
    }

    public void position(int position) {
        this.position = position;
    }

    public int getSize() {
        return this.fileSize;
    }

    public void close() {
        this.list = null;
    }

    public static String convertString(byte[] bytes) {
        String s = "";
        for (int i = 0; i < bytes.length; ++i) {
            s = s + (char)bytes[i];
        }
        return s;
    }
}

