/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.file;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import org.gdstash.util.GDMsgFormatter;

public class GDReader {
    public static final int XOR_BITMAP = 0x55555555;
    public static final int TABLE_MULT = 39916801;
    public static final long MAX_UNSIGNED_INT = 0x100000000L;
    private static int key;
    private static int[] table;
    private static byte[] buffer;
    private static int pos;

    public static int[] buildTable(int key) {
        int[] table = new int[256];
        int k = key;
        for (int i = 0; i < table.length; ++i) {
            k = Integer.rotateRight(k, 1);
            table[i] = k *= 39916801;
        }
        return table;
    }

    private static void updateKey(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            int j = b[i];
            if (j < 0) {
                j += 256;
            }
            key ^= table[j];
        }
    }

    private static void updateKey(int value) {
        byte[] b = ByteBuffer.allocate(4).putInt(value).array();
        GDReader.updateKey(b);
    }

    private static void updateKey(byte value) {
        byte[] b = new byte[]{value};
        GDReader.updateKey(b);
    }

    public static int readKey() throws IOException {
        int k = GDReader.readEncInt(false);
        key = k ^= 0x55555555;
        table = GDReader.buildTable(key);
        return key;
    }

    private static byte[] readEncByteArr(int len) throws IOException {
        if (pos + len > buffer.length) {
            throw new EOFException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNEXPECTED_EOF"));
        }
        byte[] b = new byte[len];
        for (int i = 0; i < b.length; ++i) {
            b[i] = buffer[pos + i];
        }
        pos += b.length;
        return b;
    }

    public static int readBlockStart(Block block) throws IOException {
        int i = GDReader.readEncInt(true);
        block.length = GDReader.readEncInt(false);
        block.end = pos + block.length;
        return i;
    }

    public static void readBlockEnd(Block block) throws IOException {
        if (pos != block.end) {
            throw new IOException();
        }
        int i = GDReader.readEncInt(false);
        if (i != 0) {
            throw new IOException();
        }
    }

    public static byte readEncByte() throws IOException {
        byte[] bArr = GDReader.readEncByteArr(1);
        byte b = bArr[0];
        bArr[0] = (byte)(bArr[0] ^ key);
        GDReader.updateKey(b);
        return bArr[0];
    }

    public static float readEncFloat(boolean updateKey) throws IOException {
        int i = GDReader.readEncInt(updateKey);
        float f = Float.intBitsToFloat(i);
        return f;
    }

    public static int readEncInt(boolean updateKey) throws IOException {
        byte[] b = GDReader.readEncByteArr(4);
        int i = ByteBuffer.wrap(b).order(ByteOrder.LITTLE_ENDIAN).getInt();
        int result = i ^ key;
        if (updateKey) {
            GDReader.updateKey(i);
        }
        return result;
    }

    public static String readEncString() throws IOException {
        int len = GDReader.readEncInt(true);
        if (len == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(len);
        byte[] b = GDReader.readEncByteArr(len);
        for (int i = 0; i < b.length; ++i) {
            byte temp = b[i];
            b[i] = (byte)(b[i] ^ key);
            GDReader.updateKey(temp);
            sb.append((char)b[i]);
        }
        String s = sb.toString();
        return s;
    }

    public static String readEncWideString() throws IOException {
        int len = GDReader.readEncInt(true);
        if (len == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(len);
        len = 2 * len;
        for (int i = 0; i < len; i += 2) {
            byte b1 = GDReader.readEncByte();
            byte b2 = GDReader.readEncByte();
            short s = b2;
            s = (short)(s << 8);
            char c = (char)(b1 | s);
            sb.append(c);
        }
        String s = sb.toString();
        return s;
    }

    public static void readEncFileToBuffer(File file) throws IOException {
        try (FileInputStream reader = new FileInputStream(file);){
            buffer = new byte[(int)reader.getChannel().size()];
            pos = 0;
            key = 0;
            reader.read(buffer);
            reader.close();
        }
    }

    public static byte[] readBytes(InputStream is, int len) throws IOException {
        byte[] b = new byte[len];
        int i = is.read(b);
        if (i < len) {
            throw new EOFException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNEXPECTED_EOF"));
        }
        return b;
    }

    public static byte[] readBytes4(InputStream is) throws IOException {
        return GDReader.readBytes(is, 4);
    }

    public static byte readByte(InputStream is) throws IOException {
        byte[] b = new byte[1];
        int i = is.read();
        if (i == -1) {
            throw new EOFException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNEXPECTED_EOF"));
        }
        b[0] = (byte)i;
        return b[0];
    }

    public static float readFloat(InputStream is) throws IOException {
        int i = GDReader.readInt(is);
        float f = Float.intBitsToFloat(i);
        return f;
    }

    public static int readInt(InputStream is) throws IOException {
        byte[] b = GDReader.readBytes(is, 4);
        return ByteBuffer.wrap(b).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public static int readUInt(InputStream is) throws IOException {
        int size = 4;
        byte[] b = GDReader.readBytes(is, size);
        int val = 0;
        for (int i = size; i > 0; --i) {
            int temp = b[i - 1];
            if (temp < 0) {
                temp = 256 + temp;
            }
            val = val * 256 + temp;
        }
        return val;
    }

    public static short readShort(InputStream is) throws IOException {
        int size = 2;
        byte[] b = GDReader.readBytes(is, size);
        short val = 0;
        for (int i = size; i > 0; --i) {
            int temp = b[i - 1];
            if (i != size && temp < 0) {
                temp = 256 + temp;
            }
            val = (short)(val * 256 + b[i - 1]);
        }
        return val;
    }

    public static short readUShort(InputStream is) throws IOException {
        int size = 2;
        byte[] b = GDReader.readBytes(is, size);
        short val = 0;
        for (int i = size; i > 0; --i) {
            int temp = b[i - 1];
            if (temp < 0) {
                temp = 256 + temp;
            }
            val = (short)(val * 256 + temp);
        }
        return val;
    }

    public static String readString(InputStream is, int len) throws IOException {
        byte[] b = GDReader.readBytes(is, len);
        String s = "";
        for (int i = 0; i < b.length; ++i) {
            s = s + Character.toString((char)b[i]);
        }
        return s;
    }

    public static boolean getBool(byte[] bytes, int offset) {
        byte[] b = GDReader.getBytes(bytes, offset, 4);
        boolean val = false;
        for (int i = 0; i < b.length; ++i) {
            val = val || b[i] != 0;
        }
        return val;
    }

    public static byte[] getBytes(byte[] bytes, int offset, int len) {
        if (len <= 0) {
            return null;
        }
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            b[i] = bytes[offset + i];
        }
        return b;
    }

    public static byte[] getBytes4(byte[] bytes, int offset) {
        return GDReader.getBytes(bytes, offset, 4);
    }

    public static byte[] getBytes8(byte[] bytes, int offset) {
        return GDReader.getBytes(bytes, offset, 8);
    }

    public static float getFloat(byte[] bytes, int offset) {
        byte[] b = GDReader.getBytes(bytes, offset, 4);
        float val = ByteBuffer.wrap(b).order(ByteOrder.LITTLE_ENDIAN).getFloat();
        return val;
    }

    public static int getInt(byte[] bytes, int offset) {
        byte[] b = GDReader.getBytes(bytes, offset, 4);
        return ByteBuffer.wrap(b).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public static long getLong(byte[] bytes, int offset) {
        byte[] b = GDReader.getBytes(bytes, offset, 8);
        return ByteBuffer.wrap(b).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public static int getUInt(byte[] bytes, int offset) {
        int size = 4;
        int val = 0;
        for (int i = size; i > 0; --i) {
            int temp = bytes[offset + i - 1];
            if (temp < 0) {
                temp = 256 + temp;
            }
            val = val * 256 + temp;
        }
        return val;
    }

    public static short getShort(byte[] bytes, int offset) {
        int size = 2;
        short val = 0;
        for (int i = size; i > 0; --i) {
            int temp = bytes[offset + i - 1];
            if (i != size && temp < 0) {
                temp = 256 + temp;
            }
            val = (short)(val * 256 + temp);
        }
        return val;
    }

    public static short getUShort(byte[] bytes, int offset) {
        int size = 2;
        short val = 0;
        for (int i = size; i > 0; --i) {
            int temp = bytes[offset + i - 1];
            if (temp < 0) {
                temp = 256 + temp;
            }
            val = (short)(val * 256 + temp);
        }
        return val;
    }

    public static String getString(byte[] bytes, int offset, int len) {
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            sb.append((char)bytes[offset + i]);
        }
        return sb.toString();
    }

    public static String getString0(byte[] bytes, int offset) {
        if (offset >= bytes.length) {
            return "";
        }
        StringBuffer sb = new StringBuffer(128);
        int i = offset;
        while (bytes[i] != 0) {
            sb.append((char)bytes[i]);
            ++i;
        }
        return sb.toString();
    }

    public static byte[] getBytes(MappedByteBuffer buffer, int len) {
        byte[] bytes = new byte[len];
        buffer.get(bytes);
        return bytes;
    }

    public static byte[] getBytes4(MappedByteBuffer buffer) {
        return GDReader.getBytes(buffer, 4);
    }

    public static byte[] getBytes8(MappedByteBuffer buffer) {
        return GDReader.getBytes(buffer, 8);
    }

    public static byte[] getBytes(MappedByteBuffer buffer, int offset, int len) {
        byte[] bytes = new byte[len];
        buffer.position(offset);
        buffer.get(bytes);
        return bytes;
    }

    public static short getUShort(MappedByteBuffer buffer) {
        byte[] bytes = GDReader.getBytes(buffer, 2);
        short val = 0;
        for (int i = bytes.length; i > 0; --i) {
            int temp = bytes[i - 1];
            if (temp < 0) {
                temp = 256 + temp;
            }
            val = (short)(val * 256 + temp);
        }
        return val;
    }

    public static short getUShort(MappedByteBuffer buffer, int offset) {
        byte[] bytes = GDReader.getBytes(buffer, offset, 2);
        short val = 0;
        for (int i = bytes.length; i > 0; --i) {
            int temp = bytes[i - 1];
            if (temp < 0) {
                temp = 256 + temp;
            }
            val = (short)(val * 256 + temp);
        }
        return val;
    }

    public static String getString(MappedByteBuffer buffer, int len) {
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            sb.append((char)buffer.get());
        }
        return sb.toString();
    }

    public static String getString0(MappedByteBuffer buffer, int offset) {
        StringBuffer sb = new StringBuffer(128);
        buffer.position(offset);
        byte b = buffer.get();
        while (b != 0) {
            sb.append((char)b);
            b = buffer.get();
        }
        return sb.toString();
    }

    static {
        table = new int[256];
    }

    public static class Block {
        public int length;
        public int end;
    }
}

