/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.file;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDMsgLogger;
import org.ini4j.Ini;

public class IniConfig
implements Cloneable {
    public static final String DEFAULT_LANGUAGE = "English";
    public static final int AFFIX_COMBI_VALID = 1;
    public static final int AFFIX_COMBI_ALL_COMBOS = 2;
    public static final int AFFIX_COMBI_ALL_AFFIXES = 3;
    private static String iniPath = GDConstants.USER_HOME + GDConstants.FILE_SEPARATOR + "GDStash" + GDConstants.FILE_SEPARATOR + "GDStash.ini";
    private File iniFile;
    private Ini ini;
    public DirectorySection sectDir = new DirectorySection();
    public RestrictionSection sectRestrict = new RestrictionSection();
    public UISection sectUI = new UISection();
    public HistorySection sectHistory = new HistorySection();
    public WindowSection sectWindow = new WindowSection();
    private DirectorySection sectDirLoaded = new DirectorySection();
    private RestrictionSection sectRestrictLoaded = new RestrictionSection();
    private UISection sectUILoaded = new UISection();
    private HistorySection sectHistoryLoaded = new HistorySection();
    private WindowSection sectWindowLoaded = new WindowSection();

    public IniConfig() {
    }

    public IniConfig(File file) {
        this();
        this.iniFile = file;
        try {
            if (!file.exists()) {
                File dir = file.getParentFile();
                if (dir != null && !dir.exists()) {
                    dir.mkdirs();
                }
                file.createNewFile();
            }
            this.ini = new Ini(file);
        }
        catch (IOException ex) {
            this.ini = null;
        }
    }

    public Object clone() {
        IniConfig config = new IniConfig();
        config.sectDirLoaded = this.sectDirLoaded.clone();
        config.sectRestrictLoaded = this.sectRestrictLoaded.clone();
        config.sectUILoaded = this.sectUILoaded.clone();
        config.sectHistoryLoaded = this.sectHistoryLoaded.clone();
        config.sectWindowLoaded = this.sectWindowLoaded.clone();
        config.sectDir = this.sectDir.clone();
        config.sectRestrict = this.sectRestrict.clone();
        config.sectUI = this.sectUI.clone();
        config.sectHistory = this.sectHistory.clone();
        config.sectWindow = this.sectWindow.clone();
        config.iniFile = this.iniFile;
        return config;
    }

    public static IniConfig get() {
        File file = new File(iniPath);
        IniConfig config = new IniConfig(file);
        if (!config.read()) {
            config = new IniConfig(file);
        }
        return config;
    }

    public boolean read() {
        boolean success = false;
        try {
            this.ini = new Ini(this.iniFile);
            this.ini.load();
            this.sectDirLoaded.getIniValues(this.ini);
            this.sectRestrictLoaded.getIniValues(this.ini);
            this.sectUILoaded.getIniValues(this.ini);
            this.sectHistoryLoaded.getIniValues(this.ini);
            this.sectWindowLoaded.getIniValues(this.ini);
            this.sectDir = this.sectDirLoaded.clone();
            this.sectRestrict = this.sectRestrictLoaded.clone();
            this.sectUI = this.sectUILoaded.clone();
            this.sectHistory = this.sectHistoryLoaded.clone();
            this.sectWindow = this.sectWindowLoaded.clone();
            success = true;
        }
        catch (IOException ex) {
            success = false;
        }
        return success;
    }

    public boolean write() {
        boolean success = false;
        this.sectDir.putIniValues(this.ini);
        this.sectRestrict.putIniValues(this.ini);
        this.sectUI.putIniValues(this.ini);
        this.sectHistory.putIniValues(this.ini);
        this.sectWindow.putIniValues(this.ini);
        try {
            this.ini.store();
            this.sectDirLoaded = this.sectDir.clone();
            this.sectRestrictLoaded = this.sectRestrict.clone();
            this.sectUILoaded = this.sectUI.clone();
            this.sectHistoryLoaded = this.sectHistory.clone();
            this.sectWindowLoaded = this.sectWindow.clone();
            success = true;
        }
        catch (IOException ex) {
            GDMsgLogger.addError(ex);
            success = false;
        }
        return success;
    }

    public boolean writeWindowSection() {
        boolean success = false;
        this.sectDirLoaded.putIniValues(this.ini);
        this.sectRestrictLoaded.putIniValues(this.ini);
        this.sectUILoaded.putIniValues(this.ini);
        this.sectHistory.putIniValues(this.ini);
        this.sectWindow.putIniValues(this.ini);
        try {
            this.ini.store();
            success = true;
        }
        catch (IOException ex) {
            GDMsgLogger.addError(ex);
            success = false;
        }
        return success;
    }

    public static class WindowSection
    implements Cloneable {
        private static final String SECTION = "window";
        private static final String KEY_X_POS = "x_pos";
        private static final String KEY_Y_POS = "y_pos";
        private static final String KEY_HEIGHT = "height";
        private static final String KEY_WIDTH = "width";
        private static final String KEY_MAXIMIZED = "maximized";
        private static final int DEFAULT_HEIGHT = 920;
        private static final int DEFAULT_WIDTH = 1680;
        public int x;
        public int y;
        public int w;
        public int h;
        public boolean maximized;

        public WindowSection() {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int scrWidth = (int)screenSize.getWidth();
            int scrHeight = (int)screenSize.getHeight();
            this.w = scrWidth < 1680 ? scrWidth : 1680;
            this.w = scrHeight < 920 ? scrHeight : 920;
            this.x = (scrWidth - this.w) / 2;
            if (scrWidth < this.w) {
                this.x = 0;
            }
            this.y = (scrHeight - this.h) / 2;
            if (scrHeight < this.h) {
                this.y = 0;
            }
            this.maximized = false;
        }

        public WindowSection clone() {
            WindowSection section = new WindowSection();
            section.x = this.x;
            section.y = this.y;
            section.w = this.w;
            section.h = this.h;
            section.maximized = this.maximized;
            return section;
        }

        public void getIniValues(Ini ini) {
            block9: {
                int scrHeight;
                block8: {
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    int scrWidth = (int)screenSize.getWidth();
                    scrHeight = (int)screenSize.getHeight();
                    this.maximized = Boolean.parseBoolean(ini.get((Object)SECTION, KEY_MAXIMIZED));
                    try {
                        this.h = Integer.parseInt(ini.get((Object)SECTION, KEY_HEIGHT));
                    }
                    catch (NumberFormatException ex) {
                        this.w = scrHeight < 920 ? scrHeight : 920;
                    }
                    try {
                        this.w = Integer.parseInt(ini.get((Object)SECTION, KEY_WIDTH));
                    }
                    catch (NumberFormatException ex) {
                        this.w = scrWidth < 1680 ? scrWidth : 1680;
                    }
                    try {
                        this.x = Integer.parseInt(ini.get((Object)SECTION, KEY_X_POS));
                    }
                    catch (NumberFormatException ex) {
                        this.x = (scrWidth - this.w) / 2;
                        if (scrWidth >= this.w) break block8;
                        this.x = 0;
                    }
                }
                try {
                    this.y = Integer.parseInt(ini.get((Object)SECTION, KEY_Y_POS));
                }
                catch (NumberFormatException ex) {
                    this.y = (scrHeight - this.h) / 2;
                    if (scrHeight >= this.h) break block9;
                    this.y = 0;
                }
            }
        }

        public void putIniValues(Ini ini) {
            ini.remove((Object)SECTION, KEY_X_POS);
            ini.remove((Object)SECTION, KEY_Y_POS);
            ini.remove((Object)SECTION, KEY_WIDTH);
            ini.remove((Object)SECTION, KEY_HEIGHT);
            ini.remove((Object)SECTION, KEY_MAXIMIZED);
            ini.put(SECTION, KEY_X_POS, Integer.toString(this.x));
            ini.put(SECTION, KEY_Y_POS, Integer.toString(this.y));
            ini.put(SECTION, KEY_WIDTH, Integer.toString(this.w));
            ini.put(SECTION, KEY_HEIGHT, Integer.toString(this.h));
            ini.put(SECTION, KEY_MAXIMIZED, Boolean.toString(this.maximized));
        }

        public void remove(Ini ini) {
            ini.remove(SECTION);
        }
    }

    public static class HistorySection
    implements Cloneable {
        private static final String SECTION = "history";
        private static final String KEY_LAST_STASH = "last_stash";
        private static final String KEY_LAST_MOD = "last_mod";
        public String lastStash = null;
        public String lastMod = null;

        public HistorySection clone() {
            HistorySection section = new HistorySection();
            section.lastStash = this.lastStash;
            section.lastMod = this.lastMod;
            return section;
        }

        public void getIniValues(Ini ini) {
            this.lastStash = ini.get((Object)SECTION, KEY_LAST_STASH);
            this.lastMod = ini.get((Object)SECTION, KEY_LAST_MOD);
        }

        public void putIniValues(Ini ini) {
            ini.remove((Object)SECTION, KEY_LAST_STASH);
            ini.remove((Object)SECTION, KEY_LAST_MOD);
            ini.put(SECTION, KEY_LAST_STASH, this.lastStash);
            ini.put(SECTION, KEY_LAST_MOD, this.lastMod);
        }

        public void remove(Ini ini) {
            ini.remove(SECTION);
        }
    }

    public static class UISection
    implements Cloneable {
        private static final String SECTION = "ui";
        private static final String KEY_LANGUAGE = "language";
        private static final String KEY_LOOK_N_FEEL = "look_feel";
        private static final String KEY_FONT_SIZE = "font_size";
        private static final String KEY_GRAPHIC_SCALE = "graphic_scale";
        private static final String KEY_STASH_LAST = "stash_last";
        private static final int DEFAULT_FONTSIZE = 12;
        private static final int DEFAULT_GRAPHICSCALE = 100;
        private static final String DEFAULT_LOOK_N_FEEL = "Metal";
        public String language = "English";
        public int fontSize = 12;
        public int graphicScale = 100;
        public String lookNFeel = "Metal";

        public UISection clone() {
            UISection section = new UISection();
            section.language = this.language;
            section.fontSize = this.fontSize;
            section.graphicScale = this.graphicScale;
            section.lookNFeel = this.lookNFeel;
            return section;
        }

        public void getIniValues(Ini ini) {
            this.language = ini.get((Object)SECTION, KEY_LANGUAGE);
            if (this.language == null) {
                this.language = IniConfig.DEFAULT_LANGUAGE;
            }
            this.lookNFeel = ini.get((Object)SECTION, KEY_LOOK_N_FEEL);
            if (this.lookNFeel == null) {
                this.lookNFeel = DEFAULT_LOOK_N_FEEL;
            }
            try {
                this.fontSize = Integer.parseInt(ini.get((Object)SECTION, KEY_FONT_SIZE));
            }
            catch (NumberFormatException ex) {
                this.fontSize = 12;
            }
            try {
                this.graphicScale = Integer.parseInt(ini.get((Object)SECTION, KEY_GRAPHIC_SCALE));
            }
            catch (NumberFormatException ex) {
                this.graphicScale = 100;
            }
        }

        public void putIniValues(Ini ini) {
            ini.remove((Object)SECTION, KEY_LANGUAGE);
            ini.remove((Object)SECTION, KEY_FONT_SIZE);
            ini.remove((Object)SECTION, KEY_GRAPHIC_SCALE);
            ini.remove((Object)SECTION, KEY_LOOK_N_FEEL);
            ini.put(SECTION, KEY_LANGUAGE, this.language);
            ini.put(SECTION, KEY_FONT_SIZE, Integer.toString(this.fontSize));
            ini.put(SECTION, KEY_GRAPHIC_SCALE, Integer.toString(this.graphicScale));
            ini.put(SECTION, KEY_LOOK_N_FEEL, this.lookNFeel);
        }

        public void remove(Ini ini) {
            ini.remove(SECTION);
        }
    }

    public static class RestrictionSection
    implements Cloneable {
        private static final String SECTION = "restrictions";
        private static final String KEY_TRANS_SC_HC = "transfer_sc_hc";
        private static final String KEY_TRANS_SOUL = "transfer_soulbound";
        private static final String KEY_COMPLETION_ALL = "completion_all";
        private static final String KEY_BLACKSMITH_ALL = "blacksmith_all";
        private static final String KEY_AFFIX_COMBI = "affix_combi";
        private static final String KEY_STASH_MOVE = "stash_move";
        public boolean transferSCHC = false;
        public boolean transferSoulbound = false;
        public int affixCombi = 1;
        public boolean completionAll = false;
        public boolean blacksmithAll = false;
        public boolean dbStashMove = false;

        public RestrictionSection clone() {
            RestrictionSection section = new RestrictionSection();
            section.transferSCHC = this.transferSCHC;
            section.transferSoulbound = this.transferSoulbound;
            section.affixCombi = this.affixCombi;
            section.completionAll = this.completionAll;
            section.blacksmithAll = this.blacksmithAll;
            section.dbStashMove = this.dbStashMove;
            return section;
        }

        public void getIniValues(Ini ini) {
            this.transferSCHC = Boolean.parseBoolean(ini.get((Object)SECTION, KEY_TRANS_SC_HC));
            this.transferSoulbound = Boolean.parseBoolean(ini.get((Object)SECTION, KEY_TRANS_SOUL));
            this.completionAll = Boolean.parseBoolean(ini.get((Object)SECTION, KEY_COMPLETION_ALL));
            this.blacksmithAll = Boolean.parseBoolean(ini.get((Object)SECTION, KEY_BLACKSMITH_ALL));
            this.dbStashMove = Boolean.parseBoolean(ini.get((Object)SECTION, KEY_STASH_MOVE));
            try {
                this.affixCombi = Integer.parseInt(ini.get((Object)SECTION, KEY_AFFIX_COMBI));
            }
            catch (NumberFormatException ex) {
                this.affixCombi = 1;
            }
        }

        public void putIniValues(Ini ini) {
            ini.remove((Object)SECTION, KEY_TRANS_SC_HC);
            ini.remove((Object)SECTION, KEY_TRANS_SOUL);
            ini.remove((Object)SECTION, KEY_AFFIX_COMBI);
            ini.remove((Object)SECTION, KEY_COMPLETION_ALL);
            ini.remove((Object)SECTION, KEY_BLACKSMITH_ALL);
            ini.remove((Object)SECTION, KEY_STASH_MOVE);
            ini.put(SECTION, KEY_TRANS_SC_HC, Boolean.toString(this.transferSCHC));
            ini.put(SECTION, KEY_TRANS_SOUL, Boolean.toString(this.transferSoulbound));
            ini.put(SECTION, KEY_AFFIX_COMBI, Integer.toString(this.affixCombi));
            ini.put(SECTION, KEY_COMPLETION_ALL, Boolean.toString(this.completionAll));
            ini.put(SECTION, KEY_BLACKSMITH_ALL, Boolean.toString(this.blacksmithAll));
            ini.put(SECTION, KEY_STASH_MOVE, Boolean.toString(this.dbStashMove));
        }

        public void remove(Ini ini) {
            ini.remove(SECTION);
        }
    }

    public static class DirectorySection
    implements Cloneable {
        private static final String SECTION = "directories";
        private static final String KEY_GD_PATH = "gd_path";
        private static final String KEY_SAVE_PATH = "save_path";
        private static final String KEY_EXPORT_PATH = "export_path";
        public String gdPath = "";
        public String savePath = "";
        public String exportPath = GDConstants.USER_DIR;

        public DirectorySection clone() {
            DirectorySection section = new DirectorySection();
            section.gdPath = this.gdPath;
            section.savePath = this.savePath;
            section.exportPath = this.exportPath;
            return section;
        }

        public void getIniValues(Ini ini) {
            this.gdPath = ini.get((Object)SECTION, KEY_GD_PATH);
            this.savePath = ini.get((Object)SECTION, KEY_SAVE_PATH);
            this.exportPath = ini.get((Object)SECTION, KEY_EXPORT_PATH);
        }

        public void putIniValues(Ini ini) {
            ini.remove((Object)SECTION, KEY_GD_PATH);
            ini.remove((Object)SECTION, KEY_SAVE_PATH);
            ini.remove((Object)SECTION, KEY_EXPORT_PATH);
            ini.put(SECTION, KEY_GD_PATH, this.gdPath);
            ini.put(SECTION, KEY_SAVE_PATH, this.savePath);
            ini.put(SECTION, KEY_EXPORT_PATH, this.exportPath);
        }

        public void remove(Ini ini) {
            ini.remove(SECTION);
        }
    }
}

