/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.item;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.item.GDItem;
import org.gdstash.item.GDItemContainer;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public abstract class GDAbstractContainer
implements GDItemContainer {
    protected List<GDItem> items;
    protected List<GDItem> removedItems;
    protected boolean changed;
    protected int containerType;
    protected int width;
    protected int height;

    public GDAbstractContainer(int containerType) {
        this.containerType = containerType;
        this.items = new LinkedList<GDItem>();
        this.removedItems = new LinkedList<GDItem>();
        this.changed = false;
        this.width = -1;
        this.height = -1;
    }

    @Override
    public List<GDItem> getItemList() {
        LinkedList<GDItem> list = new LinkedList<GDItem>();
        for (GDItem item : this.items) {
            list.add(item);
        }
        return list;
    }

    @Override
    public List<GDItem> getRemovedItemList() {
        LinkedList<GDItem> list = new LinkedList<GDItem>();
        for (GDItem item : this.removedItems) {
            list.add(item);
        }
        return list;
    }

    @Override
    public boolean addItem(GDItem item) {
        item.setContainerType(this.containerType);
        this.items.add(item);
        this.changed = true;
        return true;
    }

    @Override
    public boolean removeItem(GDItem item) {
        boolean found = false;
        if (this.items != null) {
            Iterator<GDItem> iter = this.items.iterator();
            while (iter.hasNext()) {
                GDItem ti = iter.next();
                if (ti != item) continue;
                iter.remove();
                found = true;
                this.changed = true;
                break;
            }
        }
        return found;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public int getContainerHeight() {
        if (this.height != -1) {
            return this.height;
        }
        int h = 0;
        switch (this.containerType) {
            case 1: {
                h = 16;
                break;
            }
            case 2: {
                h = 18;
                break;
            }
            case 3: {
                h = 8;
                break;
            }
            case 4: {
                h = 8;
                break;
            }
            default: {
                h = 16;
            }
        }
        return h;
    }

    @Override
    public int getContainerWidth() {
        if (this.width != -1) {
            return this.width;
        }
        int w = 0;
        switch (this.containerType) {
            case 1: {
                w = 8;
                break;
            }
            case 2: {
                w = 10;
                break;
            }
            case 3: {
                w = 12;
                break;
            }
            case 4: {
                w = 8;
                break;
            }
            default: {
                w = 8;
            }
        }
        return w;
    }

    @Override
    public int getContainerType() {
        return this.containerType;
    }

    @Override
    public void refresh() {
        GDItem item2;
        LinkedList<GDItem> temp = new LinkedList<GDItem>();
        Iterator<GDItem> iter = this.items.iterator();
        while (iter.hasNext()) {
            item2 = iter.next();
            item2.refresh();
            if (!item2.hasErrors()) continue;
            try {
                iter.remove();
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            temp.add(item2);
        }
        iter = this.removedItems.iterator();
        while (iter.hasNext()) {
            item2 = iter.next();
            item2.refresh();
            if (item2.hasErrors()) continue;
            try {
                iter.remove();
                this.items.add(item2);
            }
            catch (UnsupportedOperationException ex) {}
        }
        if (!temp.isEmpty()) {
            for (GDItem item2 : temp) {
                this.removedItems.add(item2);
            }
        }
        if (!this.removedItems.isEmpty()) {
            GDMsgLogger.addWarning(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_STASH_ITEMS_REMOVED"));
        }
    }
}

