/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.item;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.gdstash.db.DBAffix;
import org.gdstash.db.DBAffixSet;
import org.gdstash.db.DBDamage;
import org.gdstash.db.DBItem;
import org.gdstash.db.DBLootTable;
import org.gdstash.db.DBLootTableAffixSetAlloc;
import org.gdstash.db.DBSkill;
import org.gdstash.db.DBSkillBonus;
import org.gdstash.db.DBStashItem;
import org.gdstash.db.ItemSlots;
import org.gdstash.description.DetailComposer;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.item.ItemInfo;
import org.gdstash.util.GDLog;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class GDItem
implements Cloneable,
Comparable<GDItem> {
    private static Random random = new Random();
    private static final byte[] BEGINBLOCK = new byte[]{-50, -6, 29, -80};
    private static final byte[] ENDBLOCK = new byte[]{-34, -64, -83, -34};
    public static final Color COLOR_BLACK = Color.BLACK;
    public static final Color COLOR_WHITE = Color.WHITE;
    public static final Color COLOR_BLUE = new Color(0, 50, 125);
    public static final Color COLOR_GREEN = new Color(0, 85, 15);
    public static final Color COLOR_PURPLE = new Color(68, 0, 125);
    public static final Color COLOR_YELLOW = new Color(200, 145, 0);
    public static final Color COLOR_BLUE_LIGHT = new Color(200, 230, 250);
    public static final Color COLOR_GREEN_LIGHT = new Color(200, 240, 180);
    public static final Color COLOR_PURPLE_LIGHT = new Color(230, 200, 250);
    public static final Color COLOR_YELLOW_LIGHT = new Color(240, 240, 140);
    public static final Color COLOR_COMPONENT = new Color(182, 122, 57);
    public static final Color COLOR_ENCHANTMENT = new Color(112, 157, 0);
    public static final Color COLOR_ARTIFACT = new Color(0, 120, 200);
    public static final Color COLOR_BG_ARTIFACT = new Color(0, 255, 255);
    public static final Color COLOR_BG_COMPONENT = new Color(255, 178, 51);
    public static final Color COLOR_BG_ENCHANTMENT = new Color(145, 203, 0);
    public static final Color COLOR_BG_QUEST = new Color(204, 51, 229);
    public static final Color COLOR_BG_LORE = new Color(194, 176, 196);
    public static final Color COLOR_BG_COMMON = new Color(204, 204, 204);
    public static final Color COLOR_BG_MAGICAL = new Color(229, 204, 0);
    public static final Color COLOR_BG_RARE = new Color(102, 217, 0);
    public static final Color COLOR_BG_EPIC = new Color(76, 115, 217);
    public static final Color COLOR_BG_LEGENDARY = new Color(76, 38, 166);
    public static final int CONTAINER_UNDEF = 0;
    public static final int CONTAINER_STASH_SHARED = 1;
    public static final int CONTAINER_STASH_CHAR = 2;
    public static final int CONTAINER_INVENTORY_CHAR = 3;
    public static final int CONTAINER_BAG_CHAR = 4;
    public static final int CONTAINER_EQUIPPED_CHAR = 5;
    private InputStream reader;
    private byte[] beginBlock;
    private DBStashItem stashItem;
    private byte[] endBlock;
    private float xPos;
    private int x;
    private float yPos;
    private int y;
    private byte attached;
    private DBItem dbItem;
    private DBAffix dbPrefix;
    private DBAffix dbSuffix;
    private DBAffix dbModifier;
    private DBItem dbComponent;
    private DBAffix dbBonus;
    private DBItem dbEnchantment;
    private int reqDex;
    private int reqInt;
    private int reqStr;
    private boolean error;
    private String filename;
    private int containerType;

    public GDItem(String charName, boolean hardcore, int containerType) {
        this.containerType = containerType;
        this.error = false;
        this.stashItem = new DBStashItem(charName, hardcore);
    }

    public GDItem(DBItem item) {
        this.containerType = 0;
        this.error = false;
        this.stashItem = new DBStashItem(item);
        this.init();
        this.error = GDMsgLogger.errorsInLog();
        if (!this.error) {
            this.loadData(0);
        }
    }

    public GDItem(DBStashItem item) {
        this(item, null);
    }

    public GDItem(DBStashItem item, String filename) {
        this.containerType = 0;
        this.error = false;
        this.filename = filename;
        this.stashItem = new DBStashItem(item);
        this.init();
        this.error = GDMsgLogger.errorsInLog();
        if (!this.error) {
            this.loadData(0);
        }
    }

    public GDItem(InputStream reader, int stashType, int version, boolean hardcore, String filename, int page, GDLog log) {
        this.containerType = 1;
        this.error = false;
        this.filename = filename;
        this.stashItem = new DBStashItem();
        this.reader = reader;
        this.stashItem.setHardcore(hardcore);
        this.stashItem.setCharName(null);
        GDLog tLog = new GDLog();
        if (stashType == 0) {
            this.readOldFormat(tLog);
        }
        if (stashType == 1) {
            this.readNewFormat(version, page, tLog);
        }
        this.stashItem.fillDependentStats(tLog);
        if (log == null) {
            GDMsgLogger.addLog(tLog);
        } else {
            log.addLog(tLog);
        }
        if (!this.error) {
            this.loadData(page);
        }
    }

    private void init() {
        this.beginBlock = BEGINBLOCK;
        this.endBlock = ENDBLOCK;
    }

    private void loadData(int page) {
        if (this.stashItem == null) {
            return;
        }
        if (this.stashItem.getItemID() != null) {
            this.dbItem = this.stashItem.getDBItem();
            if (this.dbItem == null) {
                Object[] args = new Object[]{this.filename, page, this.stashItem.getItemID()};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_ITEM_NOT_FOUND", args);
                GDMsgLogger.addWarning(msg);
                this.error = true;
            }
        }
        if (this.stashItem.getStackCount() == 0) {
            this.stashItem.setStackCount(1);
        }
        this.dbPrefix = this.stashItem.getDBPrefix();
        this.dbSuffix = this.stashItem.getDBSuffix();
        this.dbModifier = this.stashItem.getDBModifier();
        this.dbComponent = this.stashItem.getDBComponent();
        this.dbBonus = this.stashItem.getDBCompletionBonus();
        this.dbEnchantment = this.stashItem.getDBAugment();
        this.reqDex = this.stashItem.getRequiredCunning();
        this.reqInt = this.stashItem.getRequiredSpirit();
        this.reqStr = this.stashItem.getRequiredPhysique();
    }

    public GDItem clone() {
        this.stashItem.fillDependentStats(null);
        GDItem item = new GDItem(this.stashItem);
        return item;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(GDItem item) {
        int iLevel;
        int i = 0;
        if (item.dbItem != null) {
            if (this.dbItem == null) return -1;
            i = this.dbItem.compareTo(item.dbItem);
            if (i != 0) {
                return i;
            }
        } else {
            if (this.dbItem == null) return 0;
            return 1;
        }
        int oAffix = 0;
        int iAffix = 0;
        if (this.dbPrefix != null) {
            ++oAffix;
        }
        if (this.dbSuffix != null) {
            oAffix += 2;
        }
        if (item.dbPrefix != null) {
            ++iAffix;
        }
        if (item.dbSuffix != null) {
            iAffix += 2;
        }
        if (iAffix != oAffix) {
            return oAffix - iAffix;
        }
        if (item.dbModifier == null && this.dbModifier != null) {
            return 1;
        }
        if (item.dbModifier != null && this.dbModifier == null) {
            return -1;
        }
        if (item.dbComponent == null && this.dbComponent != null) {
            return 1;
        }
        if (item.dbComponent != null && this.dbComponent == null) {
            return -1;
        }
        if (item.dbEnchantment == null && this.dbEnchantment != null) {
            return 1;
        }
        if (item.dbEnchantment != null && this.dbEnchantment == null) {
            return -1;
        }
        int oLevel = this.getRequiredLevel();
        if (oLevel < (iLevel = item.getRequiredLevel())) {
            return -1;
        }
        if (oLevel > iLevel) {
            return 1;
        }
        if (item.dbPrefix != null) {
            if (this.dbPrefix == null) throw new AssertionError((Object)GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_PREFIX_BOTH"));
            i = this.dbPrefix.compareTo(item.dbPrefix);
            if (i != 0) {
                return i;
            }
        } else if (this.dbPrefix != null) {
            throw new AssertionError((Object)GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_PREFIX_NEITHER"));
        }
        if (item.dbSuffix != null) {
            if (this.dbSuffix == null) throw new AssertionError((Object)GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_SUFFIX_BOTH"));
            i = this.dbSuffix.compareTo(item.dbSuffix);
            if (i != 0) {
                return i;
            }
        } else if (this.dbSuffix != null) {
            throw new AssertionError((Object)GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_SUFFIX_NEITHER"));
        }
        if (item.dbModifier != null) {
            if (this.dbModifier == null) throw new AssertionError((Object)GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_MODIFIER_BOTH"));
            i = this.dbModifier.compareTo(item.dbModifier);
            if (i != 0) {
                return i;
            }
        } else if (this.dbModifier != null) {
            throw new AssertionError((Object)GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_MODIFIER_NEITHER"));
        }
        if (item.dbComponent != null) {
            if (this.dbComponent == null) throw new AssertionError((Object)GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_COMPONENT_BOTH"));
            i = this.dbComponent.compareTo(item.dbComponent);
            if (i != 0) {
                return i;
            }
            if (item.stashItem.getCompletionBonusID() != null) {
                if (this.stashItem.getCompletionBonusID() == null) return -1;
                if (!item.stashItem.getCompletionBonusID().equals(this.stashItem.getCompletionBonusID()) && (i = this.stashItem.getCompletionBonusID().compareTo(item.stashItem.getCompletionBonusID())) != 0) {
                    return i;
                }
            } else if (this.stashItem.getCompletionBonusID() != null) {
                return 1;
            }
        } else if (this.dbComponent != null) {
            throw new AssertionError((Object)GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_COMPONENT_NEITHER"));
        }
        if (item.dbEnchantment != null) {
            if (this.dbEnchantment == null) throw new AssertionError((Object)GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_ENCHANTMENT_BOTH"));
            i = this.dbEnchantment.compareTo(item.dbEnchantment);
            if (i != 0) {
                return i;
            }
        } else if (this.dbEnchantment != null) {
            throw new AssertionError((Object)GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_ENCHANTMENTENT_NEITHER"));
        }
        if (this.stashItem.getItemSeed() < item.stashItem.getItemSeed()) {
            return -1;
        }
        if (this.stashItem.getItemSeed() <= item.stashItem.getItemSeed()) return 0;
        return 1;
    }

    public boolean hasErrors() {
        return this.error;
    }

    public int getContainerType() {
        return this.containerType;
    }

    public DBItem getDBItem() {
        return this.dbItem;
    }

    public DBStashItem getDBStashItem() {
        return this.stashItem;
    }

    public DBItem getDBComponent() {
        return this.dbComponent;
    }

    public DBAffixSet getBonusAffixSet() {
        if (this.dbItem == null) {
            return null;
        }
        return this.dbItem.getBonusAffixSet();
    }

    public DBStashItem getStashItem() {
        return this.stashItem;
    }

    public String getItemID() {
        if (this.stashItem == null) {
            return null;
        }
        return this.stashItem.getItemID();
    }

    public String getItemClass() {
        if (this.dbItem == null) {
            return null;
        }
        return this.dbItem.getItemClass();
    }

    public String getRarity() {
        if (this.stashItem == null) {
            return "Common";
        }
        return this.stashItem.getRarity();
    }

    public String getComponentName() {
        if (this.dbComponent == null) {
            return null;
        }
        String s = this.dbComponent.getName();
        if (this.stashItem.getVar1() < this.dbComponent.getComponentPieces()) {
            s = s + " (" + Integer.toString(this.stashItem.getVar1() + 1) + "/" + Integer.toString(this.dbComponent.getComponentPieces()) + ")";
        }
        return s;
    }

    public String getEnchantmentName() {
        if (this.dbEnchantment == null) {
            return null;
        }
        return this.dbEnchantment.getName();
    }

    public boolean isSoulbound() {
        if (this.stashItem == null) {
            return false;
        }
        return this.stashItem.isSoulbound();
    }

    public boolean isCraftable() {
        if (this.dbItem == null) {
            return false;
        }
        return this.dbItem.isCraftable();
    }

    public boolean isHardcore() {
        if (this.stashItem == null) {
            return false;
        }
        return this.stashItem.isHardcore();
    }

    public boolean isArmor() {
        if (this.dbItem == null) {
            return false;
        }
        return this.dbItem.isArmor();
    }

    public boolean isJewelry() {
        if (this.dbItem == null) {
            return false;
        }
        return this.dbItem.isJewelry();
    }

    public boolean isWeapon() {
        if (this.dbItem == null) {
            return false;
        }
        return this.dbItem.isWeapon();
    }

    public boolean isOffhand() {
        if (this.dbItem == null) {
            return false;
        }
        return this.dbItem.isOffhand();
    }

    public boolean is1HWeapon() {
        if (this.dbItem == null) {
            return false;
        }
        return this.dbItem.is1HWeapon();
    }

    public boolean is2HWeapon() {
        if (this.dbItem == null) {
            return false;
        }
        return this.dbItem.is2HWeapon();
    }

    public boolean isArtifact() {
        if (this.dbItem == null) {
            return false;
        }
        return this.dbItem.isArtifact();
    }

    public boolean isComponent() {
        if (this.dbItem == null) {
            return false;
        }
        return this.dbItem.isComponent();
    }

    public boolean isEnchantment() {
        if (this.dbItem == null) {
            return false;
        }
        return this.dbItem.isEnchantment();
    }

    public boolean isStackable() {
        if (this.stashItem == null) {
            return false;
        }
        return this.stashItem.isStackable();
    }

    public int getDefaultStackSize() {
        if (this.stashItem == null) {
            return 1;
        }
        return this.stashItem.getDefaultStackSize();
    }

    public DBAffix getPrefix() {
        return this.dbPrefix;
    }

    public DBAffix getSuffix() {
        return this.dbSuffix;
    }

    public DBAffix getModifier() {
        return this.dbModifier;
    }

    public DBAffix getCompletionBonus() {
        return this.dbBonus;
    }

    public DBItem getAugment() {
        return this.dbEnchantment;
    }

    public String getSeedHex() {
        if (this.stashItem == null) {
            return null;
        }
        byte[] seed = GDWriter.intToBytes4(this.stashItem.getItemSeed());
        String s = "";
        for (int i = 0; i < seed.length; ++i) {
            byte val = seed[i];
            s = s + this.byteToHex(seed[i]);
        }
        return s;
    }

    public int getVar1() {
        if (this.stashItem == null) {
            return 0;
        }
        return this.stashItem.getVar1();
    }

    public String getVar1Str() {
        if (this.stashItem == null) {
            return null;
        }
        int i = this.getVar1();
        if (i == 0) {
            i = 1;
        }
        return Integer.toString(i);
    }

    public int getStackCount() {
        if (this.stashItem == null) {
            return 0;
        }
        return this.stashItem.getStackCount();
    }

    public String getStackCountStr() {
        if (this.stashItem == null) {
            return null;
        }
        return Integer.toString(this.getStackCount());
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public String getCharName() {
        if (this.stashItem == null) {
            return null;
        }
        return this.stashItem.getCharName();
    }

    public int getStashID() {
        if (this.stashItem == null) {
            return -1;
        }
        return this.stashItem.getStashID();
    }

    public int getItemLevel() {
        if (this.stashItem == null) {
            return 0;
        }
        return this.stashItem.getItemLevel();
    }

    public int getRequiredLevel() {
        if (this.stashItem == null) {
            return 0;
        }
        return this.stashItem.getRequiredlevel();
    }

    public int getRequiredCunning() {
        return this.reqDex;
    }

    public int getRequiredPhysique() {
        return this.reqStr;
    }

    public int getRequiredSpirit() {
        return this.reqInt;
    }

    public Color getBackgroundColor() {
        if (this.dbItem == null) {
            return null;
        }
        Color color = COLOR_BG_COMMON;
        String rarity = this.getRarity();
        if (rarity.equals("Magical")) {
            color = COLOR_BG_MAGICAL;
        }
        if (rarity.equals("Rare")) {
            color = COLOR_BG_RARE;
        }
        if (rarity.equals("Epic")) {
            color = COLOR_BG_EPIC;
        }
        if (rarity.equals("Legendary")) {
            color = COLOR_BG_LEGENDARY;
        }
        if (this.dbItem.isArtifact()) {
            color = COLOR_BG_ARTIFACT;
        }
        if (this.dbItem.isComponent()) {
            color = COLOR_BG_COMPONENT;
        }
        if (this.dbItem.isEnchantment()) {
            color = COLOR_BG_ENCHANTMENT;
        }
        if (this.dbItem.isQuestItem()) {
            color = COLOR_BG_QUEST;
        }
        return color;
    }

    public BufferedImage getFullImage() {
        if (this.dbItem == null) {
            return null;
        }
        BufferedImage img = null;
        img = this.dbItem.getComponentPieces() > 0 && this.getVar1() < this.dbItem.getComponentPieces() ? this.dbItem.getShardImage() : this.dbItem.getImage();
        if (img == null) {
            return null;
        }
        BufferedImage clone = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        Graphics2D g = clone.createGraphics();
        g.drawImage((Image)img, 0, 0, null);
        img = clone;
        BufferedImage overlay = this.getOverlayImage();
        if (overlay != null) {
            int w = img.getWidth();
            int h = img.getHeight();
            int wo = overlay.getWidth();
            int ho = overlay.getHeight();
            g.drawImage((Image)overlay, w - wo - 2, h - ho - 2, null);
        }
        if (this.getVar1() < this.dbItem.getComponentPieces()) {
            String s = this.getVar1Str();
            Font font = UIManager.getDefaults().getFont("Label.font");
            font = font.deriveFont(1, 10.0f);
            g.setFont(font);
            int h = g.getFontMetrics().getAscent();
            int xPos = 4;
            int yPos = h + 2;
            g.setPaint(Color.BLACK);
            g.drawString(s, xPos - 1, yPos - 1);
            g.setPaint(Color.BLACK);
            g.drawString(s, xPos - 1, yPos + 1);
            g.setPaint(Color.BLACK);
            g.drawString(s, xPos + 1, yPos - 1);
            g.setPaint(Color.BLACK);
            g.drawString(s, xPos + 1, yPos + 1);
            g.setPaint(Color.WHITE);
            g.drawString(s, xPos, yPos);
        }
        if (this.getStackCount() > 1) {
            String s = this.getStackCountStr();
            Font font = UIManager.getDefaults().getFont("Label.font");
            font = font.deriveFont(1, 10.0f);
            g.setFont(font);
            int w = g.getFontMetrics().stringWidth(s);
            int h = g.getFontMetrics().getDescent();
            int xPos = img.getWidth() - w - 4;
            int yPos = img.getHeight() - h - 2;
            g.setPaint(Color.BLACK);
            g.drawString(s, xPos - 1, yPos - 1);
            g.setPaint(Color.BLACK);
            g.drawString(s, xPos - 1, yPos + 1);
            g.setPaint(Color.BLACK);
            g.drawString(s, xPos + 1, yPos - 1);
            g.setPaint(Color.BLACK);
            g.drawString(s, xPos + 1, yPos + 1);
            g.setPaint(Color.WHITE);
            g.drawString(s, xPos, yPos);
        }
        return img;
    }

    public BufferedImage getImage() {
        if (this.dbItem == null) {
            return null;
        }
        return this.dbItem.getImage();
    }

    public BufferedImage getOverlayImage() {
        if (this.dbComponent == null) {
            return null;
        }
        BufferedImage img = null;
        img = this.dbComponent.getComponentPieces() > 0 && this.getVar1() < this.dbComponent.getComponentPieces() ? this.dbComponent.getOverlayShard() : this.dbComponent.getOverlayImage();
        return img;
    }

    public ImageIcon getImageIcon() {
        ImageIcon icon = null;
        BufferedImage image = this.getFullImage();
        if (image != null) {
            icon = new ImageIcon(image);
        }
        return icon;
    }

    public int getPlusAllSkills() {
        if (this.dbItem == null) {
            return 0;
        }
        return this.dbItem.getPlusAllSkills();
    }

    public String getMainDamageType() {
        if (this.dbItem == null) {
            return null;
        }
        return this.dbItem.getMainDamageType();
    }

    public String getFullDescription() {
        if (this.dbItem == null) {
            return null;
        }
        ItemInfo info = this.compactBonuses();
        return DetailComposer.getItemText(this, info);
    }

    private String getSlots() {
        if (this.dbItem == null) {
            return "";
        }
        if (!this.dbItem.usesSlots()) {
            return "";
        }
        ItemSlots slots = this.dbItem.getSlots();
        String allSlots = null;
        String singleSlot = null;
        if (slots.usesAllArmor()) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_ARMOR_ALL", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
            slots.clearAllArmor();
        }
        if (slots.usesAllWeapons()) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_WEAPON_ALL", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
            slots.clearAllWeapons();
        }
        if (slots.usesMeleeWeapons()) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_WEAPON_MELEE", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
            slots.clearMeleeWeapons();
        }
        if (slots.uses1HWeapons()) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_WEAPON_ONE_HAND", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
            slots.clear1HWeapons();
        }
        if (slots.uses2HWeapons()) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_WEAPON_TWO_HAND", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
            slots.clear2HWeapons();
        }
        if (slots.usesRangedWeapons()) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_WEAPON_RANGED", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
            slots.clearRangedWeapons();
        }
        if (slots.slotAxe1H) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_WEAPON_AXE", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
        }
        if (slots.slotDagger1H) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_WEAPON_DAGGER", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
        }
        if (slots.slotMace1H) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_WEAPON_MACE", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
        }
        if (slots.slotScepter1H) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_WEAPON_SCEPTER", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
        }
        if (slots.slotSword1H) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_WEAPON_SWORD", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
        }
        if (slots.slotShield) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_WEAPON_SHIELD", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
        }
        if (slots.slotOffhand) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_WEAPON_OFFHAND", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
        }
        if (slots.slotHead) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_ARMOR_HEAD", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
        }
        if (slots.slotShoulders) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_ARMOR_SHOULDERS", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
        }
        if (slots.slotChest) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_ARMOR_CHEST", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
        }
        if (slots.slotHands) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_ARMOR_HANDS", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
        }
        if (slots.slotLegs) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_ARMOR_LEGS", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
        }
        if (slots.slotFeet) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_ARMOR_FEET", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
        }
        if (slots.slotBelt) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_ARMOR_BELT", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
        }
        if (slots.slotRing) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_ARMOR_RING", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
        }
        if (slots.slotAmulet) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_ARMOR_AMULET", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
        }
        if (slots.slotMedal) {
            singleSlot = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SLOT_ARMOR_MEDAL", null);
            allSlots = allSlots == null ? singleSlot : allSlots + ", " + singleSlot;
        }
        if (allSlots == null) {
            return "";
        }
        Object[] args = new Object[]{allSlots};
        allSlots = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_USED_IN", args);
        allSlots = "<br><font color = \"#000000\">" + allSlots + "</font>";
        return allSlots;
    }

    public String getItemCategory() {
        Object[] args;
        String tagRarity = this.determineRarityTag();
        String tagCategory = this.determineCategoryTag();
        String tagItemType = this.determineItemTypeTag();
        if (tagItemType == null) {
            return null;
        }
        String strRarity = null;
        String strCategory = null;
        String strItemType = GDMsgFormatter.format(GDMsgFormatter.rbGD, tagItemType, null);
        if (tagCategory != null) {
            strCategory = GDMsgFormatter.format(GDMsgFormatter.rbGD, tagCategory, null);
        }
        if (tagRarity != null) {
            strRarity = GDMsgFormatter.format(GDMsgFormatter.rbGD, tagRarity, null);
        }
        if (strRarity != null && strCategory != null) {
            args = new Object[]{strRarity, strCategory, strItemType};
            strItemType = GDMsgFormatter.format(GDMsgFormatter.rbGD, "COMB_RARITY_CATEGORY_ITEM", args);
        }
        if (strRarity == null && strCategory != null) {
            args = new Object[]{strCategory, strItemType};
            strItemType = GDMsgFormatter.format(GDMsgFormatter.rbGD, "COMB_CATEGORY_ITEM", args);
        }
        if (strRarity != null && strCategory == null) {
            args = new Object[]{strRarity, strItemType};
            strItemType = GDMsgFormatter.format(GDMsgFormatter.rbGD, "COMB_RARITY_ITEM", args);
        }
        if (this.isSoulbound()) {
            args = new Object[]{strItemType};
            strItemType = GDMsgFormatter.format(GDMsgFormatter.rbGD, "COMB_SOULBOUND_ITEM", args);
        }
        strItemType = "<font color = \"#C0A560\">" + strItemType + "</font>";
        String slots = this.getSlots();
        if (slots != null) {
            strItemType = strItemType + slots;
        }
        return strItemType;
    }

    private Color getRarityColor(String rarity) {
        Color color = COLOR_BLACK;
        if (rarity != null) {
            if (rarity.equals("Magical")) {
                color = COLOR_YELLOW;
            }
            if (rarity.equals("Rare")) {
                color = COLOR_GREEN;
            }
            if (rarity.equals("Epic")) {
                color = COLOR_BLUE;
            }
            if (rarity.equals("Legendary")) {
                color = COLOR_PURPLE;
            }
        }
        return color;
    }

    private Color getRarityColor() {
        Color color = COLOR_BLACK;
        if (this.dbItem != null) {
            String rarity = this.dbItem.getRarity();
            if (rarity != null) {
                color = this.getRarityColor(rarity);
            }
            if (this.dbItem.isQuestItem()) {
                color = COLOR_PURPLE;
            }
        }
        return color;
    }

    private Color getRarityBackgroundColor(String rarity) {
        Color color = COLOR_WHITE;
        if (rarity != null) {
            if (rarity.equals("Magical")) {
                color = COLOR_YELLOW_LIGHT;
            }
            if (rarity.equals("Rare")) {
                color = COLOR_GREEN_LIGHT;
            }
            if (rarity.equals("Epic")) {
                color = COLOR_BLUE_LIGHT;
            }
            if (rarity.equals("Legendary")) {
                color = COLOR_PURPLE_LIGHT;
            }
        }
        return color;
    }

    private Color getRarityBackgroundColor() {
        String rarity = this.getRarity();
        Color color = COLOR_WHITE;
        if (rarity != null) {
            color = this.getRarityBackgroundColor(rarity);
        }
        if (this.dbItem != null && this.dbItem.isQuestItem()) {
            color = COLOR_PURPLE_LIGHT;
        }
        return color;
    }

    private Color getItemColor() {
        String rarity = this.getRarity();
        Color color = COLOR_BLACK;
        if (rarity != null) {
            color = this.getRarityColor(rarity);
        }
        if (this.dbItem != null && this.dbItem.isQuestItem()) {
            color = COLOR_PURPLE;
        }
        return color;
    }

    public boolean isValid(int affixCombi, boolean completionAll) {
        if (this.dbItem == null) {
            return false;
        }
        if (affixCombi == 3) {
            return true;
        }
        boolean validCombo = this.isValidAffixCombo(affixCombi);
        boolean validComponent = this.isValidComponent();
        boolean validEnchantment = this.isValidEnchantment();
        boolean validBonus = this.isValidBonus(completionAll);
        boolean valid = validCombo && validComponent && validEnchantment && validBonus;
        return valid;
    }

    private boolean isValidAffixCombo(int affixCombi) {
        if (this.dbItem == null) {
            return false;
        }
        if (affixCombi == 3) {
            return true;
        }
        List<DBLootTable> tables = DBLootTable.getByItemID(this.dbItem.getItemID());
        if (tables == null) {
            return this.dbPrefix == null && this.dbSuffix == null;
        }
        boolean validCombo = false;
        for (DBLootTable table : tables) {
            boolean foundPrefix = this.dbPrefix == null;
            int rarePrefix = 6;
            boolean foundSuffix = this.dbSuffix == null;
            int rareSuffix = 6;
            List<DBLootTableAffixSetAlloc> affixSets = table.getAffixSetAllocList();
            if (affixSets != null) {
                block1: for (DBLootTableAffixSetAlloc alloc : affixSets) {
                    int type = alloc.getAffixType();
                    List<DBAffixSet.DBEntry> list = alloc.getAffixEntries();
                    if (list == null) continue;
                    if ((type == 1 || type == 3) && this.dbPrefix != null) {
                        for (DBAffixSet.DBEntry entry : list) {
                            if (!entry.getAffixID().equals(this.dbPrefix.getAffixID())) continue;
                            foundPrefix = true;
                            if (type == 1 && rarePrefix > 3) {
                                rarePrefix = 3;
                            }
                            if (type != 3 || rarePrefix <= 4) break;
                            rarePrefix = 4;
                            break;
                        }
                    }
                    if (type != 2 && type != 4 || this.dbSuffix == null) continue;
                    for (DBAffixSet.DBEntry entry : list) {
                        if (!entry.getAffixID().equals(this.dbSuffix.getAffixID())) continue;
                        foundSuffix = true;
                        if (type == 2 && rareSuffix > 3) {
                            rareSuffix = 3;
                        }
                        if (type != 4 || rareSuffix <= 4) continue block1;
                        rareSuffix = 4;
                        continue block1;
                    }
                }
                if (affixCombi == 2 && foundPrefix && foundSuffix) {
                    validCombo = true;
                }
                if (affixCombi == 1) {
                    if (this.dbPrefix != null && this.dbSuffix != null) {
                        if (foundPrefix && foundSuffix) {
                            if (rarePrefix == 3 && rareSuffix == 3) {
                                validCombo = table.isMagicPrefixMagicSuffixAllowed();
                            }
                            if (rarePrefix == 3 && rareSuffix == 4) {
                                validCombo = table.isMagicPrefixRareSuffixAllowed();
                            }
                            if (rarePrefix == 4 && rareSuffix == 3) {
                                validCombo = table.isRarePrefixMagicSuffixAllowed();
                            }
                            if (rarePrefix == 4 && rareSuffix == 4) {
                                validCombo = table.isRarePrefixRareSuffixAllowed();
                            }
                        }
                    } else if (foundPrefix && foundSuffix) {
                        validCombo = true;
                    }
                }
            }
            if (!validCombo) continue;
            break;
        }
        return validCombo;
    }

    private boolean isValidSlotItem(DBItem item) {
        if (this.dbItem == null) {
            return false;
        }
        if (item == null) {
            return true;
        }
        boolean valid = false;
        String itemClass = this.dbItem.getItemClass();
        if (itemClass.equals("ArmorProtective_Head")) {
            valid = item.isSlotHead();
        }
        if (itemClass.equals("ArmorProtective_Shoulders")) {
            valid = item.isSlotShoulders();
        }
        if (itemClass.equals("ArmorProtective_Chest")) {
            valid = item.isSlotChest();
        }
        if (itemClass.equals("ArmorProtective_Hands")) {
            valid = item.isSlotHands();
        }
        if (itemClass.equals("ArmorProtective_Waist")) {
            valid = item.isSlotBelt();
        }
        if (itemClass.equals("ArmorProtective_Legs")) {
            valid = item.isSlotLegs();
        }
        if (itemClass.equals("ArmorProtective_Feet")) {
            valid = item.isSlotFeet();
        }
        if (itemClass.equals("ArmorJewelry_Amulet")) {
            valid = item.isSlotAmulet();
        }
        if (itemClass.equals("ArmorJewelry_Medal")) {
            valid = item.isSlotMedal();
        }
        if (itemClass.equals("ArmorJewelry_Ring")) {
            valid = item.isSlotRing();
        }
        if (itemClass.equals("WeaponArmor_Offhand")) {
            valid = item.isSlotOffhand();
        }
        if (itemClass.equals("WeaponArmor_Shield")) {
            valid = item.isSlotShield();
        }
        if (itemClass.equals("WeaponMelee_Axe")) {
            valid = item.isSlotAxe1H();
        }
        if (itemClass.equals("WeaponMelee_Mace")) {
            valid = item.isSlotMace1H();
        }
        if (itemClass.equals("WeaponMelee_Sword")) {
            valid = item.isSlotSword1H();
        }
        if (itemClass.equals("WeaponMelee_Dagger")) {
            valid = item.isSlotDagger1H();
        }
        if (itemClass.equals("WeaponMelee_Scepter")) {
            valid = item.isSlotScepter1H();
        }
        if (itemClass.equals("WeaponHunting_Ranged1h")) {
            valid = item.isSlotRanged1H();
        }
        if (itemClass.equals("WeaponMelee_Axe2h")) {
            valid = item.isSlotAxe2H();
        }
        if (itemClass.equals("WeaponMelee_Mace2h")) {
            valid = item.isSlotMace2H();
        }
        if (itemClass.equals("WeaponHunting_Spear")) {
            valid = item.isSlotSpear2H();
        }
        if (itemClass.equals("WeaponMagical_Staff")) {
            valid = item.isSlotStaff2H();
        }
        if (itemClass.equals("WeaponMelee_Sword2h")) {
            valid = item.isSlotSword2H();
        }
        if (itemClass.equals("WeaponHunting_Ranged2h")) {
            valid = item.isSlotRanged2H();
        }
        return valid;
    }

    private boolean isValidComponent() {
        return this.isValidSlotItem(this.dbComponent);
    }

    private boolean isValidEnchantment() {
        return this.isValidSlotItem(this.dbEnchantment);
    }

    private boolean isValidBonus(boolean completionAll) {
        if (this.dbItem == null) {
            return false;
        }
        if (this.dbBonus == null) {
            return true;
        }
        if (this.dbComponent == null && !this.isComponent() && !this.isArtifact()) {
            return false;
        }
        if (completionAll) {
            return true;
        }
        DBItem component = null;
        component = this.isComponent() || this.isArtifact() ? this.dbItem : this.dbComponent;
        if (component.getBonusAffixSet() == null) {
            return false;
        }
        List<DBAffixSet.DBEntry> entries = component.getBonusAffixSet().getAffixEntries();
        if (entries == null) {
            return false;
        }
        boolean found = false;
        for (DBAffixSet.DBEntry entry : entries) {
            if (!entry.getAffixID().equals(this.dbBonus.getAffixID())) continue;
            found = true;
            break;
        }
        return found;
    }

    public LabelInfo getItemNameInfo() {
        String dmg;
        if (this.dbItem == null) {
            return null;
        }
        LabelInfo li = new LabelInfo();
        boolean brackets = false;
        li.text = this.parseName();
        if (this.dbItem.getRequiredlevel() != 0) {
            li.text = li.text + " [" + this.dbItem.getRequiredlevel();
            brackets = true;
        }
        if ((dmg = this.dbItem.getMainDamageType()) != null) {
            li.text = brackets ? li.text + ", " + dmg : li.text + " [" + dmg;
            brackets = true;
        }
        if (brackets) {
            li.text = li.text + "]";
        }
        li.foreground = this.getRarityColor();
        return li;
    }

    public LabelInfo getCompleteNameInfo() {
        if (this.stashItem == null) {
            return null;
        }
        LabelInfo li = new LabelInfo();
        li.foreground = this.getItemColor();
        li.background = this.getRarityBackgroundColor();
        li.text = this.stashItem.getCompleteName();
        return li;
    }

    public LabelInfo getPrefixInfo() {
        if (this.dbPrefix == null) {
            return null;
        }
        LabelInfo li = new LabelInfo();
        li.text = this.dbPrefix.getGenderText(this.dbItem.getGenderCode());
        if (this.dbPrefix.getRequiredlevel() != 0) {
            li.text = li.text + " [" + this.dbPrefix.getRequiredlevel() + "]";
        }
        if (this.dbPrefix.getRarity().equals("Magical")) {
            li.foreground = COLOR_YELLOW;
        }
        if (this.dbPrefix.getRarity().equals("Rare")) {
            li.foreground = COLOR_GREEN;
        }
        return li;
    }

    public LabelInfo getSuffixInfo() {
        if (this.dbSuffix == null) {
            return null;
        }
        LabelInfo li = new LabelInfo();
        li.text = this.dbSuffix.getGenderText(this.dbItem.getGenderCode());
        if (this.dbSuffix.getRequiredlevel() != 0) {
            li.text = li.text + " [" + this.dbSuffix.getRequiredlevel() + "]";
        }
        if (this.dbSuffix.getRarity().equals("Magical")) {
            li.foreground = COLOR_YELLOW;
        }
        if (this.dbSuffix.getRarity().equals("Rare")) {
            li.foreground = COLOR_GREEN;
        }
        return li;
    }

    public LabelInfo getModifierInfo() {
        if (this.dbModifier == null) {
            return null;
        }
        LabelInfo li = new LabelInfo();
        li.text = this.dbModifier.getGenderText(this.dbItem.getGenderCode());
        return li;
    }

    public LabelInfo getComponentInfo() {
        if (this.dbComponent == null) {
            return null;
        }
        LabelInfo li = new LabelInfo();
        li.text = this.dbComponent.getName();
        li.foreground = COLOR_COMPONENT;
        return li;
    }

    public LabelInfo getComponentBonusInfo() {
        if (this.dbBonus == null) {
            return null;
        }
        LabelInfo li = new LabelInfo();
        DetailComposer compCompletion = DetailComposer.createComposer(this.stashItem, 1, this.dbBonus.getCharBonus(), this.dbBonus.getDamageList(), this.dbBonus.getSkillBonusList());
        String s = DetailComposer.getComposerBonuses(compCompletion, true, true, true);
        if (s != null) {
            s = "<html>" + s + "</html>";
        }
        li.text = s;
        li.foreground = COLOR_COMPONENT;
        return li;
    }

    public LabelInfo getEnchantmentInfo() {
        if (this.dbEnchantment == null) {
            return null;
        }
        LabelInfo li = new LabelInfo();
        li.text = this.dbEnchantment.getItemName();
        li.foreground = COLOR_ENCHANTMENT;
        return li;
    }

    public LabelInfo getSeedHexInfo() {
        if (this.stashItem == null) {
            return null;
        }
        LabelInfo li = new LabelInfo();
        li.text = this.getSeedHex();
        return li;
    }

    public LabelInfo getItemSetNameInfo() {
        if (this.dbItem == null) {
            return null;
        }
        if (this.dbItem.getItemSetName() == null) {
            return null;
        }
        LabelInfo li = new LabelInfo();
        li.text = this.dbItem.getItemSetName();
        return li;
    }

    public LabelInfo getRequiredLevelInfo() {
        if (this.dbItem == null) {
            return null;
        }
        LabelInfo li = new LabelInfo();
        li.text = Integer.toString(this.getRequiredLevel());
        return li;
    }

    public LabelInfo getCharNameInfo() {
        if (this.stashItem == null) {
            return null;
        }
        LabelInfo li = new LabelInfo();
        li.text = this.getCharName();
        return li;
    }

    public void setContainerType(int containerType) {
        this.containerType = containerType;
        if (containerType > 5) {
            containerType = 0;
        }
        if (containerType == 5) {
            this.attached = 1;
        }
    }

    public void setPrefix(DBAffix affix) {
        this.dbPrefix = affix;
        if (affix == null) {
            this.stashItem.setPrefixID(null);
        } else {
            this.stashItem.setPrefixID(affix.getAffixID());
        }
    }

    public void setSuffix(DBAffix affix) {
        this.dbSuffix = affix;
        if (affix == null) {
            this.stashItem.setSuffixID(null);
        } else {
            this.stashItem.setSuffixID(affix.getAffixID());
        }
    }

    public void setModifier(DBAffix affix) {
        this.dbModifier = affix;
        if (affix == null) {
            this.stashItem.setModifierID(null);
        } else {
            this.stashItem.setModifierID(affix.getAffixID());
        }
    }

    public void setCompletionBonus(DBAffix affix) {
        this.dbBonus = affix;
        if (affix == null) {
            this.stashItem.setCompletionBonusID(null);
        } else {
            this.stashItem.setCompletionBonusID(affix.getAffixID());
        }
    }

    public void setSeedHex(String s) {
        if (s.length() != 8) {
            this.createSeed();
            return;
        }
        byte[] bytes = new byte[4];
        for (int i = 0; i < s.length(); i += 2) {
            byte b;
            char c1 = s.charAt(i);
            char c2 = s.charAt(i + 1);
            byte b1 = this.hexDigitToByte(c1);
            byte b2 = this.hexDigitToByte(c2);
            bytes[i / 2] = b = (byte)(b1 * 16 + b2);
        }
        this.stashItem.setItemSeed(GDReader.getInt(bytes, 0));
    }

    public void setVar1(int var1) {
        if (this.stashItem == null) {
            return;
        }
        int temp = 0;
        if (var1 > 0) {
            temp = var1;
        }
        this.stashItem.setVar1(temp);
    }

    public void setVar1Str(String var1) {
        if (this.stashItem == null) {
            return;
        }
        int i = 0;
        try {
            i = Integer.parseInt(var1);
        }
        catch (NumberFormatException ex) {
            i = 0;
        }
        this.setVar1(i);
    }

    public void setStackCount(int stackCount) {
        if (this.stashItem == null) {
            return;
        }
        this.stashItem.setStackCount(stackCount);
    }

    public void setStackCountStr(String stackCount) {
        if (this.stashItem == null) {
            return;
        }
        int i = 0;
        try {
            i = Integer.parseInt(stackCount);
        }
        catch (NumberFormatException ex) {
            i = 0;
        }
        this.setStackCount(i);
    }

    public void setX(int x) {
        this.x = x;
        this.xPos = x;
    }

    public void setY(int y) {
        this.y = y;
        this.yPos = y;
    }

    public void read() {
        GDLog log = new GDLog();
        this.readNewFormat(4, 0, log);
        this.init();
        this.error = log.containsErrors();
        GDMsgLogger.addLog(log);
        if (!this.error) {
            this.loadData(0);
        }
    }

    private void readNewFormat(int version, int page, GDLog log) {
        switch (version) {
            case 3: {
                this.readNewFormat_V3(page, log);
                break;
            }
            case 4: {
                this.readNewFormat_V4(log);
                break;
            }
            default: {
                this.error = true;
            }
        }
    }

    private void readNewFormat_V3(int page, GDLog log) {
        try {
            this.stashItem.readNewFormat(3);
            this.xPos = GDReader.readEncFloat(true);
            this.x = (int)this.xPos;
            this.yPos = GDReader.readEncFloat(true);
            this.y = (int)this.yPos;
        }
        catch (IOException ex) {
            if (this.stashItem.getItemID() != null) {
                Object[] args = new Object[]{this.filename, this.stashItem.getItemID()};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_ITEM", args);
                log.addError(msg);
            } else {
                Object[] args = new Object[]{this.filename};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_ITEM_UNKNOWN", args);
                log.addError(msg);
            }
            this.error = true;
        }
    }

    private void readNewFormat_V4(GDLog log) {
        try {
            this.stashItem.readNewFormat(4);
            if (this.containerType == 1 || this.containerType == 2) {
                this.xPos = GDReader.readEncFloat(true);
                this.x = (int)this.xPos;
                this.yPos = GDReader.readEncFloat(true);
                this.y = (int)this.yPos;
            }
            if (this.containerType == 3) {
                this.x = GDReader.readEncInt(true);
                this.xPos = this.x;
                this.y = GDReader.readEncInt(true);
                this.yPos = this.y;
            }
            if (this.containerType == 5) {
                this.attached = GDReader.readEncByte();
            }
        }
        catch (IOException ex) {
            if (this.stashItem.getItemID() != null) {
                Object[] args = new Object[]{this.filename, this.stashItem.getItemID()};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_ITEM", args);
                log.addError(msg);
            } else {
                Object[] args = new Object[]{this.filename};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_ITEM_UNKNOWN", args);
                log.addError(msg);
            }
            this.error = true;
        }
    }

    private void readOldFormat(GDLog log) {
        int len = 0;
        try {
            while (len != -1) {
                len = GDReader.readUInt(this.reader);
                if (len == -1) continue;
                String s = GDReader.readString(this.reader, len);
                if (s.equals("stackCount")) {
                    this.stashItem.setStackCount(GDReader.readInt(this.reader));
                }
                if (s.equals("begin_block")) {
                    this.beginBlock = GDReader.readBytes4(this.reader);
                }
                if (s.equals("baseName") && (len = GDReader.readUInt(this.reader)) > 0) {
                    this.stashItem.setItemID(GDReader.readString(this.reader, len));
                }
                if (s.equals("prefixName") && (len = GDReader.readUInt(this.reader)) > 0) {
                    this.stashItem.setPrefixID(GDReader.readString(this.reader, len));
                }
                if (s.equals("suffixName") && (len = GDReader.readUInt(this.reader)) > 0) {
                    this.stashItem.setSuffixID(GDReader.readString(this.reader, len));
                }
                if (s.equals("modifierName") && (len = GDReader.readUInt(this.reader)) > 0) {
                    this.stashItem.setModifierID(GDReader.readString(this.reader, len));
                }
                if (s.equals("relicName") && (len = GDReader.readUInt(this.reader)) > 0) {
                    this.stashItem.setComponentID(GDReader.readString(this.reader, len));
                }
                if (s.equals("relicBonus") && (len = GDReader.readUInt(this.reader)) > 0) {
                    this.stashItem.setCompletionBonusID(GDReader.readString(this.reader, len));
                }
                if (s.equals("seed")) {
                    this.stashItem.setItemSeed(GDReader.readInt(this.reader));
                    if (this.stashItem.getItemSeed() == 0) {
                        Object[] args = new Object[]{this.filename, this.stashItem.getItemID()};
                        String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_NO_SEED", args);
                        GDMsgLogger.addWarning(msg);
                    }
                }
                if (s.equals("relicSeed")) {
                    this.stashItem.setComponentSeed(GDReader.readInt(this.reader));
                }
                if (s.equals("var1")) {
                    this.stashItem.setVar1(GDReader.readUInt(this.reader));
                }
                if (s.equals("velocity")) {
                    int seed = GDReader.readUInt(this.reader);
                    if (this.stashItem.getComponentID() != null && !this.stashItem.getComponentID().isEmpty()) {
                        this.stashItem.setComponentSeed(seed);
                    }
                    GDReader.readUInt(this.reader);
                    GDReader.readUInt(this.reader);
                }
                if (s.equals("owner")) {
                    GDReader.readUInt(this.reader);
                }
                if (s.equals("end_block")) {
                    this.endBlock = GDReader.readBytes4(this.reader);
                }
                if (s.equals("xOffset")) {
                    this.xPos = GDReader.readFloat(this.reader);
                    this.x = (int)this.xPos;
                }
                if (!s.equals("yOffset")) continue;
                this.yPos = GDReader.readFloat(this.reader);
                this.y = (int)this.yPos;
                break;
            }
        }
        catch (IOException ex) {
            if (this.stashItem.getItemID() != null) {
                Object[] args = new Object[]{this.filename, this.stashItem.getItemID()};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_ITEM", args);
                log.addError(msg);
            } else {
                Object[] args = new Object[]{this.filename};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_ITEM_UNKNOWN", args);
                log.addError(msg);
            }
            this.error = true;
        }
    }

    public int getByteSize() {
        int size = this.stashItem.getByteSize();
        if (this.containerType == 1 || this.containerType == 2) {
            size += 4;
            size += 4;
        }
        if (this.containerType == 3 || this.containerType == 4) {
            size += 4;
            size += 4;
        }
        if (this.containerType == 5) {
            ++size;
        }
        return size;
    }

    public void write() throws IOException {
        this.stashItem.write();
        if (this.containerType == 1 || this.containerType == 2) {
            GDWriter.writeFloat(this.xPos);
            GDWriter.writeFloat(this.yPos);
        }
        if (this.containerType == 3 || this.containerType == 4) {
            GDWriter.writeInt(this.x);
            GDWriter.writeInt(this.y);
        }
        if (this.containerType == 5) {
            GDWriter.writeByte(this.attached);
        }
    }

    public void writeOldFormat(FileOutputStream writer, Charset cs) throws IOException {
        writer.write(GDWriter.lengthToBytes4("stackCount"));
        writer.write("stackCount".getBytes(cs));
        writer.write(GDWriter.intToBytes4(this.stashItem.getStackCount()));
        writer.write(GDWriter.lengthToBytes4("begin_block"));
        writer.write("begin_block".getBytes(cs));
        writer.write(this.beginBlock);
        writer.write(GDWriter.lengthToBytes4("baseName"));
        writer.write("baseName".getBytes(cs));
        writer.write(GDWriter.lengthToBytes4(this.stashItem.getItemID()));
        if (this.stashItem.getItemID() != null) {
            writer.write(this.stashItem.getItemID().getBytes(cs));
        }
        writer.write(GDWriter.lengthToBytes4("prefixName"));
        writer.write("prefixName".getBytes(cs));
        writer.write(GDWriter.lengthToBytes4(this.stashItem.getPrefixID()));
        if (this.stashItem.getPrefixID() != null) {
            writer.write(this.stashItem.getPrefixID().getBytes(cs));
        }
        writer.write(GDWriter.lengthToBytes4("suffixName"));
        writer.write("suffixName".getBytes(cs));
        writer.write(GDWriter.lengthToBytes4(this.stashItem.getSuffixID()));
        if (this.stashItem.getSuffixID() != null) {
            writer.write(this.stashItem.getSuffixID().getBytes(cs));
        }
        writer.write(GDWriter.lengthToBytes4("modifierName"));
        writer.write("modifierName".getBytes(cs));
        writer.write(GDWriter.lengthToBytes4(this.stashItem.getModifierID()));
        if (this.stashItem.getModifierID() != null) {
            writer.write(this.stashItem.getModifierID().getBytes(cs));
        }
        writer.write(GDWriter.lengthToBytes4("relicName"));
        writer.write("relicName".getBytes(cs));
        writer.write(GDWriter.lengthToBytes4(this.stashItem.getComponentID()));
        if (this.stashItem.getComponentID() != null) {
            writer.write(this.stashItem.getComponentID().getBytes(cs));
        }
        writer.write(GDWriter.lengthToBytes4("relicBonus"));
        writer.write("relicBonus".getBytes(cs));
        writer.write(GDWriter.lengthToBytes4(this.stashItem.getCompletionBonusID()));
        if (this.stashItem.getCompletionBonusID() != null) {
            writer.write(this.stashItem.getCompletionBonusID().getBytes(cs));
        }
        writer.write(GDWriter.lengthToBytes4("seed"));
        writer.write("seed".getBytes(cs));
        writer.write(GDWriter.intToBytes4(this.stashItem.getItemSeed()));
        writer.write(GDWriter.lengthToBytes4("relicSeed"));
        writer.write("relicSeed".getBytes(cs));
        writer.write(GDWriter.intToBytes4(this.stashItem.getComponentSeed()));
        writer.write(GDWriter.lengthToBytes4("var1"));
        writer.write("var1".getBytes(cs));
        writer.write(GDWriter.intToBytes4(this.stashItem.getVar1()));
        writer.write(GDWriter.lengthToBytes4("end_block"));
        writer.write("end_block".getBytes(cs));
        writer.write(this.endBlock);
        writer.write(GDWriter.lengthToBytes4("xOffset"));
        writer.write("xOffset".getBytes(cs));
        writer.write(GDWriter.floatToBytes4(this.xPos));
        writer.write(GDWriter.lengthToBytes4("yOffset"));
        writer.write("yOffset".getBytes(cs));
        writer.write(GDWriter.floatToBytes4(this.yPos));
    }

    public void refresh() {
        if (this.stashItem != null) {
            GDLog log = new GDLog();
            this.stashItem.fillDependentStats(log);
            this.loadData(0);
            this.error = log.containsMessages();
            if (this.error) {
                GDMsgLogger.addLog(log);
            }
        }
    }

    private String parseName() {
        String name = this.dbItem.getItemName();
        return name;
    }

    private ItemInfo compactBonuses() {
        DBSkill petSkill;
        DBAffix petAffix;
        if (this.dbItem == null) {
            return null;
        }
        ItemInfo info = new ItemInfo();
        if (this.dbItem.getCharBonus() != null) {
            info.itemCharBonus.add(this.dbItem.getCharBonus());
        }
        if (this.dbItem.getDamageList() != null) {
            DBDamage.add(info.itemDamages, this.dbItem, 1, this.dbItem.getDamageList());
        }
        if (this.dbItem.getSkillBonusList() != null) {
            DBSkillBonus.add(info.itemSkillBonuses, this.dbItem.getSkillBonusList());
        }
        if (this.dbItem.getItemSkill() != null) {
            info.itemSkills.add(this.dbItem.getItemSkill());
        }
        if (this.dbItem.getPetBonusSkill() != null) {
            info.petSkills.add(this.dbItem.getPetBonusSkill());
        }
        if (this.dbPrefix != null) {
            if (this.dbPrefix.getCharBonus() != null) {
                info.itemCharBonus.add(this.dbPrefix.getCharBonus());
            }
            if (this.dbPrefix.getDamageList() != null) {
                DBDamage.add(info.itemDamages, this.dbPrefix, 3, this.dbPrefix.getDamageList());
            }
            if (this.dbPrefix.getSkillBonusList() != null) {
                DBSkillBonus.add(info.itemSkillBonuses, this.dbPrefix.getSkillBonusList());
            }
            if (this.dbPrefix.getItemSkill() != null) {
                info.itemSkills.add(this.dbPrefix.getItemSkill());
            }
            if ((petAffix = this.dbPrefix.getPetAffix()) != null) {
                if (petAffix.getCharBonus() != null) {
                    info.petCharBonus.add(petAffix.getCharBonus());
                }
                if (petAffix.getDamageList() != null) {
                    DBDamage.add(info.petDamages, petAffix, 4, petAffix.getDamageList());
                }
            }
            if ((petSkill = this.dbPrefix.getPetSkill()) != null) {
                if (petSkill.getCharBonus() != null) {
                    info.petCharBonus.add(petSkill.getCharBonus());
                }
                if (petSkill.getDamageList() != null) {
                    DBDamage.add(info.petDamages, this.dbPrefix, 4, petSkill.getDamageList());
                }
            }
        }
        if (this.dbSuffix != null) {
            if (this.dbSuffix.getCharBonus() != null) {
                info.itemCharBonus.add(this.dbSuffix.getCharBonus());
            }
            if (this.dbSuffix.getDamageList() != null) {
                DBDamage.add(info.itemDamages, this.dbSuffix, 5, this.dbSuffix.getDamageList());
            }
            if (this.dbSuffix.getSkillBonusList() != null) {
                DBSkillBonus.add(info.itemSkillBonuses, this.dbSuffix.getSkillBonusList());
            }
            if (this.dbSuffix.getItemSkill() != null) {
                info.itemSkills.add(this.dbSuffix.getItemSkill());
            }
            if ((petAffix = this.dbSuffix.getPetAffix()) != null) {
                if (petAffix.getCharBonus() != null) {
                    info.petCharBonus.add(petAffix.getCharBonus());
                }
                if (petAffix.getDamageList() != null) {
                    DBDamage.add(info.petDamages, petAffix, 6, petAffix.getDamageList());
                }
            }
            if ((petSkill = this.dbSuffix.getPetSkill()) != null) {
                if (petSkill.getCharBonus() != null) {
                    info.petCharBonus.add(petSkill.getCharBonus());
                }
                if (petSkill.getDamageList() != null) {
                    DBDamage.add(info.petDamages, this.dbSuffix, 6, petSkill.getDamageList());
                }
            }
        }
        if (this.dbModifier != null) {
            if (this.dbModifier.getCharBonus() != null) {
                info.itemCharBonus.add(this.dbModifier.getCharBonus());
            }
            if (this.dbModifier.getDamageList() != null) {
                DBDamage.add(info.itemDamages, this.dbModifier, 7, this.dbModifier.getDamageList());
            }
            if (this.dbModifier.getSkillBonusList() != null) {
                DBSkillBonus.add(info.itemSkillBonuses, this.dbModifier.getSkillBonusList());
            }
            if (this.dbModifier.getItemSkill() != null) {
                info.itemSkills.add(this.dbModifier.getItemSkill());
            }
        }
        if (this.dbComponent != null) {
            if (this.dbComponent.getCharBonus() != null) {
                info.componentCharBonus.add(this.dbComponent.getCharBonus());
            }
            if (this.dbComponent.getDamageList() != null) {
                DBDamage.add(info.componentDamages, this.dbComponent, 1, this.dbComponent.getDamageList());
            }
            if (this.dbComponent.getSkillBonusList() != null) {
                DBSkillBonus.add(info.componentSkillBonuses, this.dbComponent.getSkillBonusList());
            }
            if (this.dbComponent.getItemSkill() != null) {
                info.componentSkills.add(this.dbComponent.getItemSkill());
            }
        }
        if (this.dbBonus != null) {
            if (this.dbBonus.getCharBonus() != null) {
                info.completionCharBonus.add(this.dbBonus.getCharBonus());
            }
            if (this.dbBonus.getDamageList() != null) {
                DBDamage.add(info.completionDamages, this.dbBonus, 8, this.dbBonus.getDamageList());
            }
            if (this.dbBonus.getSkillBonusList() != null) {
                DBSkillBonus.add(info.completionSkillBonuses, this.dbBonus.getSkillBonusList());
            }
            if (this.dbBonus.getItemSkill() != null) {
                info.completionSkills.add(this.dbBonus.getItemSkill());
            }
        }
        if (this.dbEnchantment != null) {
            if (this.dbEnchantment.getCharBonus() != null) {
                info.enchantmentCharBonus.add(this.dbEnchantment.getCharBonus());
            }
            if (this.dbEnchantment.getDamageList() != null) {
                DBDamage.add(info.enchantmentDamages, this.dbEnchantment, 9, this.dbEnchantment.getDamageList());
            }
        }
        return info;
    }

    private String determineCategoryTag() {
        if (this.dbItem == null) {
            return null;
        }
        String tag = null;
        if (this.dbItem.getArmorClass() != null) {
            if (this.dbItem.getArmorClass().equals("Heavy")) {
                tag = "CATEGORY_ARMOR_HEAVY";
            }
            if (this.dbItem.getArmorClass().equals("Caster")) {
                tag = "CATEGORY_ARMOR_CASTER";
            }
        }
        if (this.dbItem.is1HWeapon()) {
            tag = "CATEGORY_WEAPON_1H";
        }
        if (this.dbItem.is2HWeapon()) {
            tag = "CATEGORY_WEAPON_2H";
        }
        return tag;
    }

    private String determineItemTypeTag() {
        if (this.dbItem == null) {
            return null;
        }
        if (this.dbItem.getItemClass() == null) {
            return null;
        }
        String tag = null;
        if (this.dbItem.getItemClass().equals("ArmorProtective_Head")) {
            tag = "TYPE_ARMOR_HEAD";
        }
        if (this.dbItem.getItemClass().equals("ArmorProtective_Shoulders")) {
            tag = "TYPE_ARMOR_SHOULDERS";
        }
        if (this.dbItem.getItemClass().equals("ArmorProtective_Chest")) {
            tag = "TYPE_ARMOR_CHEST";
        }
        if (this.dbItem.getItemClass().equals("ArmorProtective_Hands")) {
            tag = "TYPE_ARMOR_HANDS";
        }
        if (this.dbItem.getItemClass().equals("ArmorProtective_Legs")) {
            tag = "TYPE_ARMOR_LEGS";
        }
        if (this.dbItem.getItemClass().equals("ArmorProtective_Feet")) {
            tag = "TYPE_ARMOR_FEET";
        }
        if (this.dbItem.getItemClass().equals("ArmorProtective_Waist")) {
            tag = "TYPE_ARMOR_BELT";
        }
        if (this.dbItem.getItemClass().equals("ArmorJewelry_Amulet")) {
            tag = "TYPE_ARMOR_AMULET";
        }
        if (this.dbItem.getItemClass().equals("ArmorJewelry_Medal")) {
            tag = "TYPE_ARMOR_MEDAL";
        }
        if (this.dbItem.getItemClass().equals("ArmorJewelry_Ring")) {
            tag = "TYPE_ARMOR_RING";
        }
        if (this.dbItem.getItemClass().equals("ItemRelic")) {
            tag = "TYPE_ITEM_COMPONENT";
        }
        if (this.dbItem.getItemClass().equals("ItemArtifact")) {
            tag = "TYPE_ITEM_ARTIFACT";
        }
        if (this.dbItem.getItemClass().equals("ItemEnchantment")) {
            tag = "TYPE_ITEM_ENCHANTMENT";
        }
        if (this.dbItem.getItemClass().equals("WeaponArmor_Offhand")) {
            tag = "TYPE_WEAPON_OFFHAND";
        }
        if (this.dbItem.getItemClass().equals("WeaponArmor_Shield")) {
            tag = "TYPE_WEAPON_SHIELD";
        }
        if (this.dbItem.getItemClass().equals("WeaponMelee_Axe")) {
            tag = "TYPE_WEAPON_AXE";
        }
        if (this.dbItem.getItemClass().equals("WeaponMelee_Mace")) {
            tag = "TYPE_WEAPON_MACE";
        }
        if (this.dbItem.getItemClass().equals("WeaponMelee_Sword")) {
            tag = "TYPE_WEAPON_SWORD";
        }
        if (this.dbItem.getItemClass().equals("WeaponMelee_Dagger")) {
            tag = "TYPE_WEAPON_DAGGER";
        }
        if (this.dbItem.getItemClass().equals("WeaponMelee_Scepter")) {
            tag = "TYPE_WEAPON_SCEPTER";
        }
        if (this.dbItem.getItemClass().equals("WeaponHunting_Ranged1h")) {
            tag = "TYPE_WEAPON_RANGED";
        }
        if (this.dbItem.getItemClass().equals("WeaponMelee_Axe2h")) {
            tag = "TYPE_WEAPON_AXE";
        }
        if (this.dbItem.getItemClass().equals("WeaponMelee_Mace2h")) {
            tag = "TYPE_WEAPON_MACE";
        }
        if (this.dbItem.getItemClass().equals("WeaponHunting_Spear")) {
            tag = "TYPE_WEAPON_SPEAR";
        }
        if (this.dbItem.getItemClass().equals("WeaponMagical_Staff")) {
            tag = "TYPE_WEAPON_STAFF";
        }
        if (this.dbItem.getItemClass().equals("WeaponMelee_Sword2h")) {
            tag = "TYPE_WEAPON_SWORD";
        }
        if (this.dbItem.getItemClass().equals("WeaponHunting_Ranged2h")) {
            tag = "TYPE_WEAPON_RANGED";
        }
        return tag;
    }

    public String determineRarityTag() {
        if (this.dbItem == null) {
            return null;
        }
        String tag = null;
        if (this.dbItem.isArtifact()) {
            if (this.dbItem.getArtifactClass() != null) {
                if (this.dbItem.getArtifactClass().equals("Lesser")) {
                    tag = "CATEGORY_ARTIFACT_EMPOWERED";
                }
                if (this.dbItem.getArtifactClass().equals("Greater")) {
                    tag = "CATEGORY_ARTIFACT_TRANSCENDED";
                }
                if (this.dbItem.getArtifactClass().equals("Divine")) {
                    tag = "CATEGORY_ARTIFACT_MYTHICAL";
                }
            }
        } else {
            String rarity = this.getRarity();
            if (rarity != null) {
                if (rarity.equals("Magical")) {
                    tag = "CATEGORY_RARITY_MAGICAL";
                }
                if (rarity.equals("Rare")) {
                    tag = "CATEGORY_RARITY_RARE";
                }
                if (rarity.equals("Epic")) {
                    tag = "CATEGORY_RARITY_EPIC";
                }
                if (rarity.equals("Legendary")) {
                    tag = "CATEGORY_RARITY_LEGENDARY";
                }
            }
        }
        return tag;
    }

    private String byteToHex(byte b) {
        int i = b;
        if (i < 0) {
            i += 256;
        }
        int v1 = i / 16;
        int v2 = i % 16;
        String s = this.intDigitToHex(v1) + this.intDigitToHex(v2);
        return s;
    }

    private String intDigitToHex(int val) {
        String s = null;
        switch (val) {
            case 10: {
                s = "A";
                break;
            }
            case 11: {
                s = "B";
                break;
            }
            case 12: {
                s = "C";
                break;
            }
            case 13: {
                s = "D";
                break;
            }
            case 14: {
                s = "E";
                break;
            }
            case 15: {
                s = "F";
                break;
            }
            default: {
                if (val < 0 || val > 9) break;
                s = Integer.toString(val);
            }
        }
        return s;
    }

    private byte hexDigitToByte(char c) {
        byte b = -1;
        switch (c) {
            case '0': {
                b = 0;
                break;
            }
            case '1': {
                b = 1;
                break;
            }
            case '2': {
                b = 2;
                break;
            }
            case '3': {
                b = 3;
                break;
            }
            case '4': {
                b = 4;
                break;
            }
            case '5': {
                b = 5;
                break;
            }
            case '6': {
                b = 6;
                break;
            }
            case '7': {
                b = 7;
                break;
            }
            case '8': {
                b = 8;
                break;
            }
            case '9': {
                b = 9;
                break;
            }
            case 'A': {
                b = 10;
                break;
            }
            case 'B': {
                b = 11;
                break;
            }
            case 'C': {
                b = 12;
                break;
            }
            case 'D': {
                b = 13;
                break;
            }
            case 'E': {
                b = 14;
                break;
            }
            case 'F': {
                b = 15;
            }
        }
        return b;
    }

    public static int generateSeed() {
        return random.nextInt();
    }

    public void createSeed() {
        this.stashItem.setItemSeed(GDItem.generateSeed());
    }

    public static class LabelInfo {
        public String text;
        public Color foreground = COLOR_BLACK;
        public Color background = COLOR_WHITE;
    }
}

