/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.item;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.file.GDFileSize;
import org.gdstash.file.GDParseException;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.item.GDItem;
import org.gdstash.item.GDStashPage;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDLog;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class GDStash
implements GDFileSize {
    public static final int STASH_TYPE_UNENCRYPTED = 0;
    public static final int STASH_TYPE_ENCRYPTED = 1;
    public static final int STASH_VERSION_UNENCRYPTED = 9;
    public static final int STASH_VERSION_ENCRYPTED = 4;
    public static final String BEGIN_BLOCK = "begin_block";
    public static final String STASH_VERSION = "stashVersion";
    public static final String MOD = "mod";
    public static final String SACK_COUNT = "sackCount";
    public static final String SACK_WIDTH = "sackWidth";
    public static final String SACK_HEIGHT = "sackHeight";
    public static final String NUM_ITEMS = "numItems";
    public static final String STACK_COUNT = "stackCount";
    public static final String BASE_NAME = "baseName";
    public static final String PREFIX_NAME = "prefixName";
    public static final String SUFFIX_NAME = "suffixName";
    public static final String MODIFIER_NAME = "modifierName";
    public static final String RELIC_NAME = "relicName";
    public static final String RELIC_BONUS = "relicBonus";
    public static final String SEED = "seed";
    public static final String RELIC_SEED = "relicSeed";
    public static final String VAR1 = "var1";
    public static final String END_BLOCK = "end_block";
    public static final String X_OFFSET = "xOffset";
    public static final String Y_OFFSET = "yOffset";
    public static final String VELOCITY = "velocity";
    public static final String OWNER = "owner";
    public static final String BEGIN_BYTES = new String(new byte[]{-50, -6, 29, -80});
    public static final String END_BYTES = new String(new byte[]{-34, -64, -83, -34});
    private File file;
    private byte[] beginBlock;
    private int key;
    private int version;
    private String modName;
    private int numSacks;
    private byte[] endBlock;
    private List<GDStashPage> pages;
    private boolean hardcore;
    private boolean itemError = false;
    private boolean pageError = false;
    private boolean stashError = false;
    private boolean changed = false;

    public GDStash(File file) {
        this(file, null);
    }

    public GDStash(File file, GDLog log) {
        this.file = file;
        this.hardcore = false;
        this.pages = new LinkedList<GDStashPage>();
        if (file.getName().toUpperCase(GDConstants.LOCALE_US).endsWith(".GSH")) {
            this.hardcore = true;
        }
        this.read(log);
    }

    public boolean hasItemErrors() {
        return this.itemError;
    }

    public boolean hasPageErrors() {
        return this.pageError;
    }

    public boolean hasStashErrors() {
        return this.stashError;
    }

    public boolean hasChanged() {
        if (this.changed) {
            return true;
        }
        boolean change = false;
        for (GDStashPage page : this.pages) {
            change = change || page.hasChanged();
        }
        return change;
    }

    public int getNumberOfPages() {
        return this.numSacks;
    }

    public List<GDStashPage> getPages() {
        return this.pages;
    }

    public List<GDItem> getItems() {
        LinkedList<GDItem> list = new LinkedList<GDItem>();
        for (GDStashPage page : this.pages) {
            list.addAll(page.getItemList());
        }
        return list;
    }

    public boolean isHardcore() {
        return this.hardcore;
    }

    public String getModName() {
        return this.modName;
    }

    public int getHeight() {
        int h = 16;
        if (this.pages.isEmpty()) {
            return h;
        }
        for (GDStashPage page : this.pages) {
            if (page == null) continue;
            if (h < page.height) {
                h = page.height;
            }
            for (GDItem item : page.items) {
                int y;
                if (item == null || h >= (y = item.getY() + item.getImage().getHeight() / 32)) continue;
                h = y;
            }
        }
        return h;
    }

    public int getWidth() {
        int w = 8;
        if (this.pages.isEmpty()) {
            return w;
        }
        for (GDStashPage page : this.pages) {
            if (page == null) continue;
            if (w < page.width) {
                w = page.width;
            }
            for (GDItem item : page.items) {
                int x;
                if (item == null || w >= (x = item.getX() + item.getImage().getWidth() / 32)) continue;
                w = x;
            }
        }
        return w;
    }

    public File getFile() {
        return this.file;
    }

    public void setModName(String modName) {
        String s = null;
        if (modName != null && !modName.equals("")) {
            s = modName;
        }
        if (this.modName == null) {
            if (s != null) {
                this.changed = true;
                this.modName = s;
            }
        } else if (!this.modName.equals(s)) {
            this.changed = true;
            this.modName = s;
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void read(GDLog log) {
        boolean oldFormat = false;
        String path = null;
        try (BufferedInputStream reader = new BufferedInputStream(new FileInputStream(this.file));){
            path = this.file.getCanonicalPath();
            String s = GDReader.readString(reader, 15);
            s = s.substring(4);
            oldFormat = s.equals(BEGIN_BLOCK);
        }
        catch (FileNotFoundException ex) {
            if (path != null) {
                Object[] args = new Object[]{path};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_NOT_FOUND", args);
                if (log == null) {
                    GDMsgLogger.addError(msg);
                } else {
                    log.addError(msg);
                }
            }
            if (log == null) {
                GDMsgLogger.addError(ex);
            } else {
                log.addError(ex);
            }
            this.stashError = true;
        }
        catch (Exception ex) {
            if (path != null) {
                Object[] args = new Object[]{path};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_READ", args);
                if (log == null) {
                    GDMsgLogger.addError(msg);
                } else {
                    log.addError(msg);
                }
            }
            if (log == null) {
                GDMsgLogger.addError(ex);
            } else {
                log.addError(ex);
            }
            this.stashError = true;
        }
        if (this.stashError) {
            return;
        }
        if (oldFormat) {
            this.readOldFormat();
        } else {
            this.readNewFormat(log);
        }
    }

    private void readNewFormat(GDLog log) {
        String path = null;
        int val = 0;
        try {
            path = this.file.getCanonicalPath();
            GDReader.readEncFileToBuffer(this.file);
            this.key = GDReader.readKey();
            val = GDReader.readEncInt(true);
            if (val != 2) {
                throw new GDParseException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"), 0L);
            }
            GDReader.Block block = new GDReader.Block();
            val = GDReader.readBlockStart(block);
            if (val != 18) {
                throw new GDParseException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"), 0L);
            }
            this.version = GDReader.readEncInt(true);
            if (this.version != 3 && this.version != 4) {
                throw new GDParseException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"), 0L);
            }
            val = GDReader.readEncInt(false);
            if (val != 0) {
                throw new GDParseException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"), 0L);
            }
            this.modName = GDReader.readEncString();
            this.numSacks = GDReader.readEncInt(true);
            this.pages.clear();
            for (int i = 0; i < this.numSacks; ++i) {
                GDStashPage page = new GDStashPage(null, 1, this.version, 8, this.hardcore, path, i, log);
                if (!page.hasPageErrors()) {
                    this.pages.add(page);
                    if (!page.hasItemErrors()) continue;
                    this.itemError = true;
                    continue;
                }
                this.pageError = true;
                this.stashError = true;
                break;
            }
            GDReader.readBlockEnd(block);
        }
        catch (FileNotFoundException ex) {
            if (path != null) {
                Object[] args = new Object[]{path};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_NOT_FOUND", args);
                if (log == null) {
                    GDMsgLogger.addError(msg);
                } else {
                    log.addError(msg);
                }
            }
            if (log == null) {
                GDMsgLogger.addError(ex);
            } else {
                log.addError(ex);
            }
            this.stashError = true;
        }
        catch (Exception ex) {
            if (path != null) {
                Object[] args = new Object[]{path};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_READ", args);
                if (log == null) {
                    GDMsgLogger.addError(msg);
                } else {
                    log.addError(msg);
                }
            }
            if (log == null) {
                GDMsgLogger.addError(ex);
            } else {
                log.addError(ex);
            }
            this.stashError = true;
        }
    }

    private void readOldFormat() {
        String path = null;
        try (BufferedInputStream reader = new BufferedInputStream(new FileInputStream(this.file));){
            int width = 0;
            String s = null;
            path = this.file.getCanonicalPath();
            int len = 0;
            while (len != -1) {
                len = GDReader.readUInt(reader);
                if (len == -1) continue;
                s = GDReader.readString(reader, len);
                if (s.equals(BEGIN_BLOCK)) {
                    this.beginBlock = GDReader.readBytes4(reader);
                }
                if (s.equals(STASH_VERSION)) {
                    this.version = GDReader.readUInt(reader);
                    if (this.version < 7 || this.version > 9) {
                        Object[] args = new Object[]{path, this.version};
                        String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_STASH_VER", args);
                        GDMsgLogger.addError(msg);
                        this.stashError = true;
                    }
                }
                if (s.equals(MOD)) {
                    GDReader.readBytes4(reader);
                }
                if (s.equals(SACK_COUNT)) {
                    this.numSacks = GDReader.readInt(reader);
                    break;
                }
                if (!s.equals(SACK_WIDTH)) continue;
                width = GDReader.readInt(reader);
                this.numSacks = 1;
                break;
            }
            if (!this.stashError) {
                this.pages.clear();
                for (int i = 0; i < this.numSacks; ++i) {
                    GDStashPage page = new GDStashPage(reader, 0, this.version, width, this.hardcore, path, i, null);
                    if (!page.hasPageErrors()) {
                        this.pages.add(page);
                        if (!page.hasItemErrors()) continue;
                        this.itemError = true;
                        continue;
                    }
                    this.pageError = true;
                    this.stashError = true;
                    break;
                }
                if (!this.pageError && (len = GDReader.readUInt(reader)) != -1 && (s = GDReader.readString(reader, len)).equals(END_BLOCK)) {
                    this.endBlock = GDReader.readBytes4(reader);
                }
            }
        }
        catch (FileNotFoundException ex) {
            if (path != null) {
                Object[] args = new Object[]{path};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_NOT_FOUND", args);
                GDMsgLogger.addError(msg);
            }
            GDMsgLogger.addError(ex);
            this.stashError = true;
        }
        catch (Exception ex) {
            if (path != null) {
                Object[] args = new Object[]{path};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_READ", args);
                GDMsgLogger.addError(msg);
            }
            GDMsgLogger.addError(ex);
            this.stashError = true;
        }
    }

    @Override
    public int getByteSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        if (this.modName != null) {
            size += this.modName.length();
        }
        size += 4;
        int count = 0;
        for (GDStashPage page : this.pages) {
            size += page.getByteSize();
            ++count;
        }
        size += 12 * count;
        return size += 4;
    }

    public void createBuffer() throws IOException {
        GDWriter.reserveBuffer(this);
        GDWriter.writeInt(0x55555555);
        GDWriter.writeInt(2);
        GDReader.Block block = new GDReader.Block();
        GDWriter.writeBlockStart(block, 18);
        GDWriter.writeInt(4);
        GDWriter.writeInt(0);
        GDWriter.writeString(this.modName);
        GDWriter.writeInt(this.pages.size());
        for (GDStashPage page : this.pages) {
            page.write();
        }
        GDWriter.writeBlockEnd(block);
    }

    public void write() throws IOException {
        if (!this.hasChanged()) {
            return;
        }
        this.createBuffer();
        String separator = System.getProperty("file.separator");
        String path = this.file.getCanonicalPath();
        int pos = path.lastIndexOf(separator);
        if (pos != -1) {
            path = path.substring(0, pos + 1);
        }
        String tname = "transfer.t";
        if (this.hardcore) {
            tname = "transfer.h";
        }
        File temp = new File(path + "temp_tmp.tmp");
        temp.createNewFile();
        GDWriter.writeBuffer(temp);
        File fCurr = new File(path + tname + String.format("%02d", 0));
        File fNew = null;
        for (int i = 9; i >= 0; --i) {
            fCurr = new File(path + tname + String.format("%02d", i));
            fNew = new File(path + tname + String.format("%02d", i + 1));
            if (!fCurr.exists()) continue;
            if (i == 9) {
                fCurr.delete();
                continue;
            }
            fCurr.renameTo(fNew);
        }
        this.file.renameTo(fCurr);
        temp.renameTo(this.file);
        this.changed = false;
    }

    public void writeOldFormat() throws IOException {
        if (!this.hasChanged()) {
            return;
        }
        String separator = System.getProperty("file.separator");
        String path = this.file.getCanonicalPath();
        int pos = path.lastIndexOf(separator);
        if (pos != -1) {
            path = path.substring(0, pos + 1);
        }
        String tname = "transfer.t";
        if (this.hardcore) {
            tname = "transfer.h";
        }
        File temp = new File(path + "temp_tmp.tmp");
        temp.createNewFile();
        FileOutputStream writer = new FileOutputStream(temp);
        writer.write(GDWriter.lengthToBytes4(BEGIN_BLOCK));
        writer.write(BEGIN_BLOCK.getBytes(GDConstants.CHARSET_STASH));
        writer.write(this.beginBlock);
        writer.write(GDWriter.lengthToBytes4(STASH_VERSION));
        writer.write(STASH_VERSION.getBytes(GDConstants.CHARSET_STASH));
        writer.write(GDWriter.intToBytes4(9));
        writer.write(GDWriter.lengthToBytes4(MOD));
        writer.write(MOD.getBytes(GDConstants.CHARSET_STASH));
        writer.write(GDWriter.intToBytes4(0));
        int i = 0;
        for (GDStashPage page : this.pages) {
            ++i;
        }
        writer.write(GDWriter.lengthToBytes4(SACK_COUNT));
        writer.write(SACK_COUNT.getBytes(GDConstants.CHARSET_STASH));
        writer.write(GDWriter.intToBytes4(i));
        for (GDStashPage page : this.pages) {
            page.writeOldFormat(writer, GDConstants.CHARSET_STASH);
        }
        writer.write(GDWriter.lengthToBytes4(END_BLOCK));
        writer.write(END_BLOCK.getBytes(GDConstants.CHARSET_STASH));
        writer.write(this.endBlock);
        writer.flush();
        writer.close();
        File fCurr = new File(path + tname + String.format("%02d", 0));
        File fNew = null;
        for (int count = 9; count >= 0; --count) {
            fCurr = new File(path + tname + String.format("%02d", count));
            fNew = new File(path + tname + String.format("%02d", count + 1));
            if (!fCurr.exists()) continue;
            if (count == 9) {
                fCurr.delete();
                continue;
            }
            fCurr.renameTo(fNew);
        }
        this.file.renameTo(fCurr);
        temp.renameTo(this.file);
    }
}

