/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui;

import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.DBConfig;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.file.ARCList;
import org.gdstash.file.ARZDecompress;
import org.gdstash.ui.GDDialog;
import org.gdstash.ui.GDProgressDialog;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.select.ItemSetPane;
import org.gdstash.ui.select.StrLenDocFilter;
import org.gdstash.ui.util.GDCharInfoList;
import org.gdstash.ui.util.GDStashInfoList;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDImagePool;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class GDConfigPane
extends JPanel {
    private GDStashFrame frame;
    private TitledBorder brdGeneral;
    private File dirGD;
    private String strGD;
    private JButton btnGD;
    private JLabel lblGD;
    private File dirSave;
    private String strSave;
    private JButton btnSave;
    private JLabel lblSave;
    private File dirExport;
    private String strExport;
    private JButton btnExport;
    private JLabel lblExport;
    private JLabel lblGDLocal;
    private JComboBox<String> cbGDLocal;
    private JLabel lblMod;
    private JComboBox<String> cbMod;
    private JLabel lblLanguage;
    private JComboBox<String> cbLanguage;
    private JLabel lblLookNFeel;
    private JComboBox<String> cbLookNFeel;
    private JLabel lblFontSize;
    private JComboBox<String> cbFontSize;
    private JLabel lblGraphicScale;
    private JComboBox<String> cbGraphicScale;
    private TitledBorder brdRestrict;
    private JCheckBox cbTransSCHC;
    private JCheckBox cbTransSoul;
    private JCheckBox cbCompletionAll;
    private JCheckBox cbBlacksmithAll;
    private JLabel lblDBStashMove;
    private JComboBox<String> cbDBStashMove;
    private TitledBorder brdCombi;
    private ButtonGroup bgCombi;
    private JRadioButton rbCombiValid;
    private JRadioButton rbCombiAllCombos;
    private JRadioButton rbCombiAllAffixes;
    private JButton btnConfig;
    private JButton btnDBImport;
    private JButton btnARZExport;
    private JPanel pnlMain;

    public GDConfigPane(GDStashFrame frame) {
        this.frame = frame;
        this.strGD = GDStashFrame.iniConfig.sectDir.gdPath;
        this.strSave = GDStashFrame.iniConfig.sectDir.savePath;
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        this.pnlMain = this.buildMainPanel();
        JScrollPane scroll = new JScrollPane(this.pnlMain);
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setVerticalGroup(vGroup);
    }

    public void adjustUI() {
        Font fntBorder;
        Font fntTip;
        Font fntCombo;
        Font fntRadio;
        Font fntCheck;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntButton = UIManager.getDefaults().getFont("Button.font");
        if (fntButton == null) {
            fntButton = fntLabel;
        }
        if ((fntCheck = UIManager.getDefaults().getFont("CheckBox.font")) == null) {
            fntCheck = fntLabel;
        }
        if ((fntRadio = UIManager.getDefaults().getFont("RadioButton.font")) == null) {
            fntRadio = fntLabel;
        }
        if ((fntCombo = UIManager.getDefaults().getFont("ComboBox.font")) == null) {
            fntCombo = fntLabel;
        }
        if ((fntTip = UIManager.getDefaults().getFont("ToolTip.font")) == null) {
            fntTip = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntButton = fntButton.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntRadio = fntRadio.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCombo = fntCombo.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntTip = fntTip.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        if (this.brdGeneral == null || this.brdRestrict == null || this.brdCombi == null) {
            Border lowered = BorderFactory.createEtchedBorder(1);
            Border raised = BorderFactory.createEtchedBorder(0);
            CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
            if (this.brdGeneral == null) {
                this.brdGeneral = BorderFactory.createTitledBorder(compound);
            }
            if (this.brdRestrict == null) {
                this.brdRestrict = BorderFactory.createTitledBorder(compound);
            }
            if (this.brdCombi == null) {
                this.brdCombi = BorderFactory.createTitledBorder(compound);
            }
        }
        this.brdGeneral.setTitle(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BRD_GENERAL"));
        this.brdGeneral.setTitleFont(fntBorder);
        this.brdRestrict.setTitle(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BRD_RESTRICT"));
        this.brdRestrict.setTitleFont(fntBorder);
        this.brdCombi.setTitle(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BRD_AFFIX_COMBI"));
        this.brdCombi.setTitleFont(fntBorder);
        if (this.btnConfig == null) {
            this.btnConfig = new JButton();
            this.btnConfig.addActionListener(new ConfigListener());
        }
        this.btnConfig.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_SAVE_SETTINGS"));
        this.btnConfig.setIcon(GDImagePool.iconConfigSettingSave24);
        this.btnConfig.setFont(fntButton);
        if (this.btnDBImport == null) {
            this.btnDBImport = new JButton();
            this.btnDBImport.addActionListener(new DBImportListener());
        }
        this.btnDBImport.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_DB_IMPORT"));
        this.btnDBImport.setIcon(GDImagePool.iconConfigDBImport24);
        this.btnDBImport.setFont(fntButton);
        if (this.btnARZExport == null) {
            this.btnARZExport = new JButton();
            this.btnARZExport.addActionListener(new ARZExportListener());
        }
        this.btnARZExport.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_DB_EXPORT"));
        this.btnARZExport.setIcon(GDImagePool.iconConfigARZExport24);
        this.btnARZExport.setFont(fntButton);
        if (this.btnGD == null) {
            this.btnGD = new JButton();
            this.btnGD.addActionListener(new GDDirListener());
        }
        this.btnGD.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_GD_INSTALL_DIR"));
        this.btnGD.setIcon(GDImagePool.iconBtnDir24);
        this.btnGD.setFont(fntButton);
        if (this.lblGD == null) {
            this.lblGD = new JLabel();
        }
        this.lblGD.setFont(fntLabel);
        if (this.lblMod == null) {
            this.lblMod = new JLabel();
        }
        this.lblMod.setFont(fntLabel);
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.addActionListener(new SaveDirListener());
        }
        this.btnSave.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_GD_SAVE_DIR"));
        this.btnSave.setIcon(GDImagePool.iconBtnDir24);
        this.btnSave.setFont(fntButton);
        if (this.lblSave == null) {
            this.lblSave = new JLabel();
        }
        this.lblSave.setFont(fntLabel);
        if (this.btnExport == null) {
            this.btnExport = new JButton();
            this.btnExport.addActionListener(new ExportDirListener());
        }
        this.btnExport.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_DB_EXPORT_DIR"));
        this.btnExport.setIcon(GDImagePool.iconBtnDir24);
        this.btnExport.setFont(fntButton);
        if (this.lblExport == null) {
            this.lblExport = new JLabel();
        }
        this.lblExport.setFont(fntLabel);
        if (this.lblMod == null) {
            this.lblMod = new JLabel();
        }
        this.lblMod.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_MOD_SEL"));
        this.lblMod.setFont(fntLabel);
        if (this.cbMod == null) {
            this.cbMod = new JComboBox();
            this.cbMod.setModel(this.buildModModel());
            this.cbMod.addActionListener(new ModListener());
        }
        this.cbMod.setFont(fntCombo);
        if (this.lblGDLocal == null) {
            this.lblGDLocal = new JLabel();
        }
        this.lblGDLocal.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_LOCALIZATION"));
        this.lblGDLocal.setFont(fntLabel);
        if (this.cbGDLocal == null) {
            this.cbGDLocal = new JComboBox();
            this.cbGDLocal.setModel(this.buildGDLanguageModel());
            this.cbGDLocal.addActionListener(new LocalizationListener());
        }
        this.cbGDLocal.setFont(fntCombo);
        if (this.lblLanguage == null) {
            this.lblLanguage = new JLabel();
        }
        this.lblLanguage.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_LANG_COUNTRY"));
        this.lblLanguage.setFont(fntLabel);
        if (this.cbLanguage == null) {
            this.cbLanguage = new JComboBox();
            this.cbLanguage.setModel(this.buildLanguageModel());
            this.cbLanguage.addActionListener(new LanguageListener());
        }
        this.cbLanguage.setFont(fntCombo);
        if (this.lblFontSize == null) {
            this.lblFontSize = new JLabel();
        }
        this.lblFontSize.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_FONT_SIZE"));
        this.lblFontSize.setFont(fntLabel);
        if (this.cbFontSize == null) {
            this.cbFontSize = new JComboBox();
            this.cbFontSize.setModel(this.buildFontSizeModel());
            this.cbFontSize.addActionListener(new FontSizeListener());
        }
        this.cbFontSize.setFont(fntCombo);
        if (this.lblGraphicScale == null) {
            this.lblGraphicScale = new JLabel();
        }
        this.lblGraphicScale.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_GRAPHIC_SCALE"));
        this.lblGraphicScale.setFont(fntLabel);
        if (this.cbGraphicScale == null) {
            this.cbGraphicScale = new JComboBox();
            this.cbGraphicScale.setModel(this.buildGraphicScaleModel());
            this.cbGraphicScale.addActionListener(new GraphicScaleListener());
        }
        this.cbGraphicScale.setFont(fntCombo);
        if (this.lblLookNFeel == null) {
            this.lblLookNFeel = new JLabel();
        }
        this.lblLookNFeel.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_LOOK_FEEL"));
        this.lblLookNFeel.setFont(fntLabel);
        if (this.cbLookNFeel == null) {
            this.cbLookNFeel = new JComboBox();
            this.cbLookNFeel.setModel(this.buildLnFModel());
            this.cbLookNFeel.addActionListener(new LookNFeelListener());
        }
        this.cbLookNFeel.setFont(fntCombo);
        if (this.cbTransSCHC == null) {
            this.cbTransSCHC = new JCheckBox();
            this.cbTransSCHC.setSelected(GDStashFrame.iniConfig.sectRestrict.transferSCHC);
            this.cbTransSCHC.addActionListener(new HCSCListener());
        }
        this.cbTransSCHC.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_TRANSFER_SC_HC"));
        this.cbTransSCHC.setFont(fntCheck);
        if (this.cbTransSoul == null) {
            this.cbTransSoul = new JCheckBox();
            this.cbTransSoul.setSelected(GDStashFrame.iniConfig.sectRestrict.transferSoulbound);
            this.cbTransSoul.addActionListener(new SoulboundListener());
        }
        this.cbTransSoul.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_TRANSFER_SOUL"));
        this.cbTransSoul.setFont(fntCheck);
        if (this.cbCompletionAll == null) {
            this.cbCompletionAll = new JCheckBox();
            this.cbCompletionAll.setSelected(GDStashFrame.iniConfig.sectRestrict.completionAll);
            this.cbCompletionAll.addActionListener(new CompletionListener());
        }
        this.cbCompletionAll.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_COMPLETE_ALL"));
        this.cbCompletionAll.setToolTipText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TIP_COMPLETE_ALL"));
        this.cbCompletionAll.setFont(fntCheck);
        if (this.cbBlacksmithAll == null) {
            this.cbBlacksmithAll = new JCheckBox();
            this.cbBlacksmithAll.setSelected(GDStashFrame.iniConfig.sectRestrict.blacksmithAll);
            this.cbBlacksmithAll.addActionListener(new BlacksmithListener());
        }
        this.cbBlacksmithAll.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_BLACKSMITH_ALL"));
        this.cbBlacksmithAll.setFont(fntCheck);
        if (this.rbCombiValid == null) {
            this.rbCombiValid = new JRadioButton();
            this.rbCombiValid.setSelected(GDStashFrame.iniConfig.sectRestrict.affixCombi == 1);
            this.rbCombiValid.addActionListener(new AffixComboListener());
        }
        this.rbCombiValid.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_AFFIX_VALID"));
        this.rbCombiValid.setToolTipText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TIP_AFFIX_VALID"));
        this.rbCombiValid.setFont(fntRadio);
        if (this.rbCombiAllCombos == null) {
            this.rbCombiAllCombos = new JRadioButton();
            this.rbCombiAllCombos.setSelected(GDStashFrame.iniConfig.sectRestrict.affixCombi == 2);
            this.rbCombiAllCombos.addActionListener(new AffixComboListener());
        }
        this.rbCombiAllCombos.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_AFFIX_ALL_COMB"));
        this.rbCombiAllCombos.setToolTipText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TIP_AFFIX_ALL_COMB"));
        this.rbCombiAllCombos.setFont(fntRadio);
        if (this.rbCombiAllAffixes == null) {
            this.rbCombiAllAffixes = new JRadioButton();
            this.rbCombiAllAffixes.setSelected(GDStashFrame.iniConfig.sectRestrict.affixCombi == 3);
            this.rbCombiAllAffixes.addActionListener(new AffixComboListener());
        }
        this.rbCombiAllAffixes.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_AFFIX_ALL_AFFIX"));
        this.rbCombiAllAffixes.setToolTipText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TIP_AFFIX_ALL_AFFIX"));
        this.rbCombiAllAffixes.setFont(fntRadio);
        if (this.lblDBStashMove == null) {
            this.lblDBStashMove = new JLabel();
        }
        this.lblDBStashMove.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_DB_STASH_TRANS"));
        this.lblDBStashMove.setFont(fntLabel);
        if (this.cbDBStashMove == null) {
            this.cbDBStashMove = new JComboBox();
            this.cbDBStashMove.addActionListener(new DBStashMoveListener());
        }
        this.cbDBStashMove.setModel(this.buildDBStashMoveModel());
        this.cbDBStashMove.setFont(fntCombo);
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel pnlConfig = this.buildConfigPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(pnlConfig).addComponent(this.btnConfig).addComponent(this.btnDBImport).addComponent(this.btnARZExport));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(pnlConfig)).addGroup(layout.createParallelGroup().addComponent(this.btnConfig)).addGroup(layout.createParallelGroup().addComponent(this.btnDBImport)).addGroup(layout.createParallelGroup().addComponent(this.btnARZExport));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, pnlConfig, this.btnConfig);
        layout.linkSize(0, pnlConfig, this.btnDBImport);
        layout.linkSize(0, pnlConfig, this.btnARZExport);
        layout.linkSize(1, this.btnConfig, this.btnDBImport);
        layout.linkSize(1, this.btnConfig, this.btnARZExport);
        return panel;
    }

    private JPanel buildConfigPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        JPanel pnlGeneral = this.buildGeneralPanel();
        JPanel pnlRestrict = this.buildRestrictPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(pnlGeneral).addComponent(pnlRestrict));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(pnlGeneral)).addGroup(layout.createParallelGroup().addComponent(pnlRestrict));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, pnlGeneral, pnlRestrict);
        return panel;
    }

    private JPanel buildGeneralPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        this.strGD = GDStashFrame.iniConfig.sectDir.gdPath;
        if (this.strGD == null) {
            this.lblGD.setText("");
        } else {
            this.lblGD.setText(this.strGD);
            this.dirGD = new File(this.strGD);
        }
        this.strSave = GDStashFrame.iniConfig.sectDir.savePath;
        if (this.strSave == null) {
            this.lblSave.setText("");
        } else {
            this.lblSave.setText(this.strSave);
            this.dirSave = new File(this.strSave);
        }
        this.strExport = GDStashFrame.iniConfig.sectDir.exportPath;
        if (this.strExport == null || this.strExport.equals("")) {
            this.strExport = GDConstants.USER_DIR;
        }
        this.lblExport.setText(this.strExport);
        this.dirExport = new File(this.strExport);
        StrLenDocFilter filter = new StrLenDocFilter(2);
        Object doc = null;
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.btnGD).addComponent(this.btnSave).addComponent(this.btnExport).addComponent(this.lblGDLocal).addComponent(this.lblMod).addComponent(this.lblLanguage).addComponent(this.lblLookNFeel).addComponent(this.lblFontSize).addComponent(this.lblGraphicScale)).addGroup(layout.createParallelGroup().addComponent(this.lblGD).addComponent(this.lblSave).addComponent(this.lblExport).addComponent(this.cbGDLocal).addComponent(this.cbMod).addComponent(this.cbLanguage).addComponent(this.cbLookNFeel).addComponent(this.cbFontSize).addComponent(this.cbGraphicScale));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.btnGD).addComponent(this.lblGD)).addGroup(layout.createParallelGroup().addComponent(this.btnSave).addComponent(this.lblSave)).addGroup(layout.createParallelGroup().addComponent(this.btnExport).addComponent(this.lblExport)).addGroup(layout.createParallelGroup().addComponent(this.lblGDLocal).addComponent(this.cbGDLocal)).addGroup(layout.createParallelGroup().addComponent(this.lblMod).addComponent(this.cbMod)).addGroup(layout.createParallelGroup().addComponent(this.lblLanguage).addComponent(this.cbLanguage)).addGroup(layout.createParallelGroup().addComponent(this.lblLookNFeel).addComponent(this.cbLookNFeel)).addGroup(layout.createParallelGroup().addComponent(this.lblFontSize).addComponent(this.cbFontSize)).addGroup(layout.createParallelGroup().addComponent(this.lblGraphicScale).addComponent(this.cbGraphicScale));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.btnGD, this.btnSave);
        layout.linkSize(0, this.btnGD, this.btnExport);
        layout.linkSize(0, this.btnGD, this.lblGDLocal);
        layout.linkSize(0, this.btnGD, this.lblMod);
        layout.linkSize(0, this.btnGD, this.lblLanguage);
        layout.linkSize(0, this.btnGD, this.lblLookNFeel);
        layout.linkSize(0, this.btnGD, this.lblFontSize);
        layout.linkSize(0, this.btnGD, this.lblGraphicScale);
        layout.linkSize(0, this.btnGD, this.lblGD);
        layout.linkSize(0, this.btnGD, this.lblSave);
        layout.linkSize(0, this.btnGD, this.lblExport);
        layout.linkSize(0, this.btnGD, this.cbGDLocal);
        layout.linkSize(0, this.btnGD, this.cbMod);
        layout.linkSize(0, this.btnGD, this.cbLanguage);
        layout.linkSize(0, this.btnGD, this.cbLookNFeel);
        layout.linkSize(0, this.btnGD, this.cbFontSize);
        layout.linkSize(0, this.btnGD, this.cbGraphicScale);
        layout.linkSize(1, this.btnGD, this.btnSave);
        layout.linkSize(1, this.btnGD, this.btnExport);
        layout.linkSize(1, this.btnGD, this.lblGDLocal);
        layout.linkSize(1, this.btnGD, this.lblMod);
        layout.linkSize(1, this.btnGD, this.lblLanguage);
        layout.linkSize(1, this.btnGD, this.lblLookNFeel);
        layout.linkSize(1, this.btnGD, this.lblFontSize);
        layout.linkSize(1, this.btnGD, this.lblGraphicScale);
        layout.linkSize(1, this.btnGD, this.lblGD);
        layout.linkSize(1, this.btnGD, this.lblSave);
        layout.linkSize(1, this.btnGD, this.lblExport);
        layout.linkSize(1, this.btnGD, this.cbGDLocal);
        layout.linkSize(1, this.btnGD, this.cbMod);
        layout.linkSize(1, this.btnGD, this.cbLanguage);
        layout.linkSize(1, this.btnGD, this.cbLookNFeel);
        layout.linkSize(1, this.btnGD, this.cbFontSize);
        layout.linkSize(1, this.btnGD, this.cbGraphicScale);
        panel.setBorder(this.brdGeneral);
        return panel;
    }

    private JPanel buildRestrictPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        JPanel pnlMisc = this.buildMiscRestrictPanel();
        JPanel pnlAffixCombi = this.buildAffixCombiPanel();
        JPanel pnlDBStashMove = this.buildDBStashMovePanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(pnlMisc).addComponent(pnlAffixCombi).addComponent(pnlDBStashMove));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addComponent(pnlMisc).addComponent(pnlAffixCombi).addComponent(pnlDBStashMove);
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, pnlMisc, pnlAffixCombi);
        layout.linkSize(0, pnlMisc, pnlDBStashMove);
        panel.setBorder(this.brdRestrict);
        return panel;
    }

    private JPanel buildMiscRestrictPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbTransSCHC).addComponent(this.cbTransSoul).addComponent(this.cbCompletionAll).addComponent(this.cbBlacksmithAll));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbTransSCHC)).addGroup(layout.createParallelGroup().addComponent(this.cbTransSoul)).addGroup(layout.createParallelGroup().addComponent(this.cbCompletionAll)).addGroup(layout.createParallelGroup().addComponent(this.cbBlacksmithAll));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.cbTransSCHC, this.cbTransSoul);
        layout.linkSize(0, this.cbTransSCHC, this.cbCompletionAll);
        layout.linkSize(0, this.cbTransSCHC, this.cbBlacksmithAll);
        layout.linkSize(1, this.cbTransSCHC, this.cbTransSoul);
        layout.linkSize(1, this.cbTransSCHC, this.cbCompletionAll);
        layout.linkSize(1, this.cbTransSCHC, this.cbBlacksmithAll);
        return panel;
    }

    private JPanel buildAffixCombiPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        this.bgCombi = new ButtonGroup();
        this.bgCombi.add(this.rbCombiValid);
        this.bgCombi.add(this.rbCombiAllCombos);
        this.bgCombi.add(this.rbCombiAllAffixes);
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.rbCombiValid).addComponent(this.rbCombiAllCombos).addComponent(this.rbCombiAllAffixes));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.rbCombiValid)).addGroup(layout.createParallelGroup().addComponent(this.rbCombiAllCombos)).addGroup(layout.createParallelGroup().addComponent(this.rbCombiAllAffixes));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.rbCombiValid, this.rbCombiAllCombos);
        layout.linkSize(0, this.rbCombiValid, this.rbCombiAllAffixes);
        layout.linkSize(1, this.rbCombiValid, this.rbCombiAllCombos);
        layout.linkSize(1, this.rbCombiValid, this.rbCombiAllAffixes);
        panel.setBorder(this.brdCombi);
        return panel;
    }

    private JPanel buildDBStashMovePanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.lblDBStashMove)).addGroup(layout.createParallelGroup().addComponent(this.cbDBStashMove));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.lblDBStashMove).addComponent(this.cbDBStashMove));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.lblDBStashMove, this.cbDBStashMove);
        layout.linkSize(1, this.lblDBStashMove, this.cbDBStashMove);
        return panel;
    }

    private ComboBoxModel<String> buildLnFModel() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < info.length; ++i) {
            String s = info[i].getName();
            model.addElement(s);
        }
        model.setSelectedItem(GDStashFrame.iniConfig.sectUI.lookNFeel);
        return model;
    }

    private ComboBoxModel<String> buildFontSizeModel() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("8");
        model.addElement("10");
        model.addElement("12");
        model.addElement("14");
        model.addElement("16");
        model.addElement("18");
        model.addElement("20");
        model.addElement("24");
        model.setSelectedItem(Integer.toString(GDStashFrame.iniConfig.sectUI.fontSize));
        return model;
    }

    private ComboBoxModel<String> buildGraphicScaleModel() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("50%");
        model.addElement("75%");
        model.addElement("100%");
        model.addElement("125%");
        model.addElement("150%");
        model.addElement("175%");
        model.addElement("200%");
        String s = Integer.toString(GDStashFrame.iniConfig.sectUI.graphicScale) + "%";
        model.setSelectedItem(s);
        return model;
    }

    private ComboBoxModel<String> buildDBStashMoveModel() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        String sCopy = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_DB_TRANS_COPY");
        String sMove = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_DB_TRANS_MOVE");
        model.addElement(sCopy);
        model.addElement(sMove);
        if (GDStashFrame.iniConfig.sectRestrict.dbStashMove) {
            model.setSelectedItem(sMove);
        } else {
            model.setSelectedItem(sCopy);
        }
        return model;
    }

    private ComboBoxModel<String> buildModModel() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("");
        if (this.strGD == null || this.strGD.equals("")) {
            return model;
        }
        File dir = new File(this.strGD + GDConstants.FILE_SEPARATOR + "mods");
        if (!dir.exists()) {
            return model;
        }
        if (!dir.isDirectory()) {
            return model;
        }
        int len = this.strGD.length() + 6;
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            try {
                String s = files[i].getCanonicalPath();
                if (s.length() > len) {
                    s = s.substring(len);
                }
                model.addElement(s);
                continue;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (GDStashFrame.iniConfig.sectHistory.lastMod != null) {
            model.setSelectedItem(GDStashFrame.iniConfig.sectHistory.lastMod);
        }
        return model;
    }

    private ComboBoxModel<String> buildGDLanguageModel() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("");
        if (this.strGD == null || this.strGD.equals("")) {
            return model;
        }
        File dir = new File(this.strGD + GDConstants.FILE_SEPARATOR + "localization");
        if (!dir.exists()) {
            return model;
        }
        if (!dir.isDirectory()) {
            return model;
        }
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].endsWith(".zip")) continue;
            model.addElement(files[i]);
        }
        if (GDStashFrame.dbConfig.gdLocal != null) {
            model.setSelectedItem(GDStashFrame.dbConfig.gdLocal);
        }
        return model;
    }

    private ComboBoxModel<String> buildLanguageModel() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        String defLang = "English";
        model.addElement(defLang);
        File dir = new File(GDConstants.USER_DIR);
        if (!dir.exists()) {
            return model;
        }
        if (!dir.isDirectory()) {
            return model;
        }
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            String lang;
            int pos2;
            int pos1;
            if (!files[i].startsWith("UI") || !files[i].endsWith(".properties") || (pos1 = files[i].indexOf("_")) == -1 || (pos2 = files[i].indexOf(".properties")) == -1 || (lang = files[i].substring(pos1 + 1, pos2)).equals(defLang)) continue;
            model.addElement(lang);
        }
        if (GDStashFrame.iniConfig.sectUI.language != null) {
            String locale = GDStashFrame.iniConfig.sectUI.language;
            model.setSelectedItem(locale);
        } else {
            model.setSelectedItem(defLang);
        }
        return model;
    }

    private String[] getLangCountry() {
        String[] sa = new String[2];
        String s = (String)this.cbLanguage.getSelectedItem();
        int pos = s.indexOf(" [");
        if (pos == -1) {
            sa[0] = s;
            sa[1] = "";
        } else {
            sa[0] = s.substring(0, pos);
            sa[1] = s.substring(pos + 2);
            pos = sa[1].indexOf("]");
            if (pos != -1) {
                sa[1] = sa[1].substring(0, pos);
            }
        }
        return sa;
    }

    private boolean correctDirs() {
        return this.correctInstallDir() && this.correctSaveDir();
    }

    private boolean correctInstallDir() {
        String s = this.strGD + GDConstants.FILE_SEPARATOR + "database" + GDConstants.FILE_SEPARATOR + "database.arz";
        File f = new File(s);
        return f.exists();
    }

    private boolean correctSaveDir() {
        String s1 = this.strSave + GDConstants.FILE_SEPARATOR + "transfer.gst";
        String s2 = this.strSave + GDConstants.FILE_SEPARATOR + "transfer.gsh";
        File f1 = new File(s1);
        File f2 = new File(s2);
        return f1.exists() || f2.exists();
    }

    private String getModDatabase() {
        String mod = (String)this.cbMod.getSelectedItem();
        if (mod == null) {
            return null;
        }
        if (mod.length() == 0) {
            return null;
        }
        String db = null;
        String dir = this.strGD + GDConstants.FILE_SEPARATOR + "mods" + GDConstants.FILE_SEPARATOR + mod + GDConstants.FILE_SEPARATOR + "database";
        File file = new File(dir);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                try {
                    String s = files[i].getCanonicalPath();
                    if (!s.toUpperCase(GDConstants.LOCALE_US).endsWith(".ARZ")) continue;
                    db = s;
                    break;
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        return db;
    }

    private ARCList getImportARCList() {
        String mod = (String)this.cbMod.getSelectedItem();
        String dirMod = null;
        if (mod != null && !mod.isEmpty()) {
            dirMod = this.strGD + GDConstants.FILE_SEPARATOR + "mods" + GDConstants.FILE_SEPARATOR + mod + GDConstants.FILE_SEPARATOR + "resources";
        }
        String[] arcs = new String[]{this.strGD + GDConstants.FILE_SEPARATOR + "resources" + GDConstants.FILE_SEPARATOR + "Items.arc", this.strGD + GDConstants.FILE_SEPARATOR + "resources" + GDConstants.FILE_SEPARATOR + "text_en.arc"};
        if (GDStashFrame.dbConfig.gdLocal != null && !GDStashFrame.dbConfig.gdLocal.equals("")) {
            arcs[1] = this.strGD + GDConstants.FILE_SEPARATOR + "localization" + GDConstants.FILE_SEPARATOR + GDStashFrame.dbConfig.gdLocal;
        }
        ARCList list = new ARCList(dirMod, arcs);
        return list;
    }

    private ARCList getExportARCList() {
        String mod = (String)this.cbMod.getSelectedItem();
        String dirMod = null;
        if (mod != null && !mod.isEmpty()) {
            dirMod = this.strGD + GDConstants.FILE_SEPARATOR + "mods" + GDConstants.FILE_SEPARATOR + mod + GDConstants.FILE_SEPARATOR + "resources";
        }
        String[] arcs = new String[]{this.strGD + GDConstants.FILE_SEPARATOR + "resources" + GDConstants.FILE_SEPARATOR + "Items.arc", this.strGD + GDConstants.FILE_SEPARATOR + "resources" + GDConstants.FILE_SEPARATOR + "text_en.arc", this.strGD + GDConstants.FILE_SEPARATOR + "resources" + GDConstants.FILE_SEPARATOR + "UI.arc", this.strGD + GDConstants.FILE_SEPARATOR + "resources" + GDConstants.FILE_SEPARATOR + "Scripts.arc"};
        if (GDStashFrame.dbConfig.gdLocal != null && !GDStashFrame.dbConfig.gdLocal.equals("")) {
            arcs[1] = this.strGD + GDConstants.FILE_SEPARATOR + "localization" + GDConstants.FILE_SEPARATOR + GDStashFrame.dbConfig.gdLocal;
        }
        ARCList list = new ARCList(dirMod, arcs);
        return list;
    }

    private class ARZExportListener
    implements ActionListener {
        private ARZExportListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GDConfigPane.this.correctDirs()) {
                ARZExportWorker worker = new ARZExportWorker();
                worker.execute();
            } else {
                GDDialog dialog = new GDDialog(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_WRONG_DIR"), 4, GDConfigPane.this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERROR"), true);
                dialog.setVisible(true);
            }
        }
    }

    private class DBImportListener
    implements ActionListener {
        private DBImportListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDStashFrame.dbConfig.gddbInit = false;
            if (GDConfigPane.this.correctDirs()) {
                DBImportWorker worker = new DBImportWorker();
                worker.execute();
            } else {
                GDDialog dialog = new GDDialog(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_WRONG_DIR"), 4, GDConfigPane.this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERROR"), true);
                dialog.setVisible(true);
            }
        }
    }

    private class ConfigListener
    implements ActionListener {
        private ConfigListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GDConfigPane.this.correctDirs()) {
                boolean success = true;
                DBConfig dbConfig = (DBConfig)GDStashFrame.dbConfig.clone();
                dbConfig.gdLocal = (String)GDConfigPane.this.cbGDLocal.getSelectedItem();
                success = DBConfig.setConfigData("0.9.9d", "1.0.2a", dbConfig);
                if (success) {
                    GDStashFrame.dbConfig = dbConfig;
                    success = success && DBConfig.setConfigInit("0.9.9d", "1.0.2a", success);
                    success = success && DBConfig.setVersions("0.9.9d", "1.0.2a");
                }
                GDStashFrame.iniConfig.sectDir.gdPath = GDConfigPane.this.strGD;
                GDStashFrame.iniConfig.sectDir.savePath = GDConfigPane.this.strSave;
                GDStashFrame.iniConfig.sectDir.exportPath = GDConfigPane.this.strExport;
                GDStashFrame.iniConfig.sectUI.language = (String)GDConfigPane.this.cbLanguage.getSelectedItem();
                GDStashFrame.iniConfig.sectRestrict.transferSCHC = GDConfigPane.this.cbTransSCHC.isSelected();
                GDStashFrame.iniConfig.sectRestrict.transferSoulbound = GDConfigPane.this.cbTransSoul.isSelected();
                GDStashFrame.iniConfig.sectRestrict.completionAll = GDConfigPane.this.cbCompletionAll.isSelected();
                GDStashFrame.iniConfig.sectRestrict.blacksmithAll = GDConfigPane.this.cbBlacksmithAll.isSelected();
                GDStashFrame.iniConfig.sectRestrict.affixCombi = 1;
                if (GDConfigPane.this.rbCombiAllCombos.isSelected()) {
                    GDStashFrame.iniConfig.sectRestrict.affixCombi = 2;
                }
                if (GDConfigPane.this.rbCombiAllAffixes.isSelected()) {
                    GDStashFrame.iniConfig.sectRestrict.affixCombi = 3;
                }
                GDStashFrame.iniConfig.sectRestrict.dbStashMove = GDConfigPane.this.cbDBStashMove.getSelectedIndex() == 1;
                GDStashFrame.iniConfig.write();
                GDMsgLogger.showLog(GDConfigPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_SETTINGS_SAVE"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_SETTINGS_SAVE"), true, false);
            } else {
                GDDialog dialog = new GDDialog(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_SPEC_DIRS"), 4, GDConfigPane.this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERROR"), true);
                dialog.setVisible(true);
            }
        }
    }

    private class DBStashMoveListener
    implements ActionListener {
        private DBStashMoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = GDConfigPane.this.cbDBStashMove.getSelectedIndex();
            GDStashFrame.iniConfig.sectRestrict.dbStashMove = i == 1;
        }
    }

    private class AffixComboListener
    implements ActionListener {
        private AffixComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GDConfigPane.this.rbCombiValid.isSelected()) {
                GDStashFrame.iniConfig.sectRestrict.affixCombi = 1;
            }
            if (GDConfigPane.this.rbCombiAllCombos.isSelected()) {
                GDStashFrame.iniConfig.sectRestrict.affixCombi = 2;
            }
            if (GDConfigPane.this.rbCombiAllAffixes.isSelected()) {
                GDStashFrame.iniConfig.sectRestrict.affixCombi = 3;
            }
        }
    }

    private class BlacksmithListener
    implements ActionListener {
        private BlacksmithListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDStashFrame.iniConfig.sectRestrict.blacksmithAll = GDConfigPane.this.cbBlacksmithAll.isSelected();
        }
    }

    private class CompletionListener
    implements ActionListener {
        private CompletionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDStashFrame.iniConfig.sectRestrict.completionAll = GDConfigPane.this.cbCompletionAll.isSelected();
        }
    }

    private class SoulboundListener
    implements ActionListener {
        private SoulboundListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDStashFrame.iniConfig.sectRestrict.transferSoulbound = GDConfigPane.this.cbTransSoul.isSelected();
            if (!GDStashFrame.iniConfig.sectRestrict.transferSoulbound) {
                ((GDConfigPane)GDConfigPane.this).frame.pnlTransfer.clearSelItems();
            }
            GDMsgLogger.showLog(GDConfigPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class HCSCListener
    implements ActionListener {
        private HCSCListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDStashFrame.iniConfig.sectRestrict.transferSCHC = GDConfigPane.this.cbTransSCHC.isSelected();
            if (!GDStashFrame.iniConfig.sectRestrict.transferSCHC) {
                ((GDConfigPane)GDConfigPane.this).frame.pnlTransfer.clearSelItems();
            }
            GDMsgLogger.showLog(GDConfigPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class GraphicScaleListener
    implements ActionListener {
        private GraphicScaleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String s = (String)GDConfigPane.this.cbGraphicScale.getSelectedItem();
            int pos = s.indexOf("%");
            if (pos != -1) {
                s = s.substring(0, pos);
            }
            GDStashFrame.iniConfig.sectUI.graphicScale = Integer.parseInt(s);
            GDStashFrame.setGDLocale(GDConfigPane.this.frame);
            GDMsgLogger.showLog(GDConfigPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class FontSizeListener
    implements ActionListener {
        private FontSizeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDStashFrame.iniConfig.sectUI.fontSize = Integer.parseInt((String)GDConfigPane.this.cbFontSize.getSelectedItem());
            GDImagePool.loadImages();
            GDStashFrame.setGDLocale(GDConfigPane.this.frame);
            GDMsgLogger.showLog(GDConfigPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class LookNFeelListener
    implements ActionListener {
        private LookNFeelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String sLnF = (String)GDConfigPane.this.cbLookNFeel.getSelectedItem();
            try {
                UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
                for (int i = 0; i < info.length; ++i) {
                    if (!info[i].getName().equals(sLnF)) continue;
                    UIManager.setLookAndFeel(info[i].getClassName());
                    SwingUtilities.updateComponentTreeUI(GDConfigPane.this.frame);
                    GDStashFrame.iniConfig.sectUI.lookNFeel = info[i].getName();
                    break;
                }
            }
            catch (Exception ex) {
                JComboBox jComboBox = GDConfigPane.this.cbLookNFeel;
                GDConfigPane.this.frame;
                jComboBox.setSelectedItem(GDStashFrame.iniConfig.sectUI.lookNFeel);
            }
            GDMsgLogger.showLog(GDConfigPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class LanguageListener
    implements ActionListener {
        private LanguageListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDStashFrame.iniConfig.sectUI.language = (String)GDConfigPane.this.cbLanguage.getSelectedItem();
            GDStashFrame.setGDLocale(GDStashFrame.iniConfig.sectUI.language, GDConfigPane.this.frame);
            GDMsgLogger.showLog(GDConfigPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class LocalizationListener
    implements ActionListener {
        private LocalizationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDStashFrame.dbConfig.gdLocal = (String)GDConfigPane.this.cbGDLocal.getSelectedItem();
        }
    }

    private class ModListener
    implements ActionListener {
        private ModListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDStashFrame.iniConfig.sectHistory.lastMod = (String)GDConfigPane.this.cbMod.getSelectedItem();
            GDStashFrame.readDBConfig(GDConfigPane.this.frame);
            boolean exists = false;
            try {
                exists = GDDBUtil.tableExists("GD_ITEM");
            }
            catch (SQLException ex) {
                exists = false;
            }
            if (!exists) {
                GDMsgLogger.clear();
                return;
            }
            GDConfigPane.this.frame.refresh();
            GDMsgLogger.showLog(GDConfigPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "MESSAGES"), 2, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"), false, false);
        }
    }

    private class ExportDirListener
    implements ActionListener {
        private ExportDirListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser(GDConfigPane.this.dirExport);
            chooser.setFileSelectionMode(1);
            chooser.setAcceptAllFileFilterUsed(false);
            if (chooser.showOpenDialog(GDConfigPane.this) == 0) {
                GDConfigPane.this.dirExport = chooser.getSelectedFile();
                try {
                    String s = GDConfigPane.this.dirExport.getCanonicalPath();
                    GDConfigPane.this.strExport = s;
                    GDConfigPane.this.lblExport.setText(GDConfigPane.this.strExport);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            GDMsgLogger.showLog(GDConfigPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class SaveDirListener
    implements ActionListener {
        private SaveDirListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser(GDConfigPane.this.dirSave);
            chooser.setFileSelectionMode(1);
            chooser.setAcceptAllFileFilterUsed(false);
            if (chooser.showOpenDialog(GDConfigPane.this) == 0) {
                GDConfigPane.this.dirSave = chooser.getSelectedFile();
                try {
                    String s = GDConfigPane.this.dirSave.getCanonicalPath();
                    String s1 = s + GDConstants.FILE_SEPARATOR + "transfer.gst";
                    String s2 = s + GDConstants.FILE_SEPARATOR + "transfer.gsh";
                    File f1 = new File(s1);
                    File f2 = new File(s2);
                    if (f1.exists() || f2.exists()) {
                        GDConfigPane.this.strSave = s;
                        GDConfigPane.this.lblSave.setText(GDConfigPane.this.strSave);
                        if (GDStashFrame.dbConfig.gddbInit) {
                            GDStashFrame.iniConfig.sectDir.savePath = GDConfigPane.this.strSave;
                            GDStashInfoList.findStashes(GDConfigPane.this.frame, null, null);
                            ((GDConfigPane)GDConfigPane.this).frame.pnlTransfer.setStashInfo(GDStashInfoList.defaultStash);
                            ((GDConfigPane)GDConfigPane.this).frame.pnlCraft.setStashInfo(GDStashInfoList.defaultStash);
                        }
                    } else {
                        GDDialog dialog = new GDDialog(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_WRONG_DIR"), 4, GDConfigPane.this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERROR"), true);
                        dialog.setVisible(true);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            GDMsgLogger.showLog(GDConfigPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class GDDirListener
    implements ActionListener {
        private GDDirListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser(GDConfigPane.this.dirGD);
            chooser.setFileSelectionMode(1);
            chooser.setAcceptAllFileFilterUsed(false);
            if (chooser.showOpenDialog(GDConfigPane.this) == 0) {
                GDConfigPane.this.dirGD = chooser.getSelectedFile();
                try {
                    String s = GDConfigPane.this.dirGD.getCanonicalPath();
                    String s1 = s + GDConstants.FILE_SEPARATOR + "database" + GDConstants.FILE_SEPARATOR + "database.arz";
                    File f = new File(s1);
                    if (f.exists()) {
                        GDConfigPane.this.strGD = s;
                        GDConfigPane.this.lblGD.setText(GDConfigPane.this.strGD);
                        GDConfigPane.this.cbMod.setModel(GDConfigPane.this.buildModModel());
                        GDConfigPane.this.cbGDLocal.setModel(GDConfigPane.this.buildGDLanguageModel());
                    } else {
                        GDDialog dialog = new GDDialog(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_WRONG_DIR"), 4, GDConfigPane.this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERROR"), true);
                        dialog.setVisible(true);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            GDMsgLogger.showLog(GDConfigPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class ARZExportWorker
    extends SwingWorker<Void, Void> {
        private GDProgressDialog prog;
        private boolean completed;

        public ARZExportWorker() {
            GDConfigPane.this.setCursor(Cursor.getPredefinedCursor(3));
            this.prog = new GDProgressDialog((Frame)GDConfigPane.this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "PROG_EXP_ARCS"));
            this.completed = false;
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("progress")) {
                        int i = (Integer)e.getNewValue();
                        if (i < 30) {
                            ARZExportWorker.this.prog.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "PROG_EXP_ARCS"));
                        }
                        if (i >= 30 && i < 70) {
                            ARZExportWorker.this.prog.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "PROG_DEC_DB_ARZ"));
                        }
                        if (i >= 70) {
                            ARZExportWorker.this.prog.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "PROC_EXP_DB_ARZ"));
                        }
                    }
                }
            });
            this.prog.setVisible(true);
        }

        @Override
        public Void doInBackground() {
            boolean isMod;
            GDMsgLogger.clear();
            this.setProgress(0);
            this.completed = false;
            boolean success = true;
            String db = GDConfigPane.this.getModDatabase();
            boolean bl = isMod = db != null;
            if (!isMod) {
                db = GDConfigPane.this.strGD + GDConstants.FILE_SEPARATOR + "database" + GDConstants.FILE_SEPARATOR + "database.arz";
            }
            GDStashFrame.arcList = GDConfigPane.this.getExportARCList();
            GDStashFrame.arcList.writeFiles(GDConfigPane.this.strExport, !isMod);
            this.setProgress(30);
            ARZDecompress.extractRecords(db, GDConfigPane.this.strExport);
            this.setProgress(90);
            if (GDMsgLogger.errorsInLog()) {
                success = false;
            }
            if (success) {
                this.completed = true;
            }
            return null;
        }

        @Override
        public void done() {
            this.prog.setVisible(false);
            this.prog.dispose();
            if (!this.completed && !GDMsgLogger.errorsInLog()) {
                GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_DB_EXPORT"));
            }
            GDStashFrame.arcList = null;
            ARZDecompress.clear();
            GDConfigPane.this.setCursor(Cursor.getDefaultCursor());
            GDMsgLogger.showLog(GDConfigPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_DB_EXPORT"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_DB_EXPORT"), true, false);
        }
    }

    private class DBImportWorker
    extends SwingWorker<Void, Void> {
        private GDProgressDialog prog;
        private boolean completed;

        public DBImportWorker() {
            GDConfigPane.this.setCursor(Cursor.getPredefinedCursor(3));
            this.prog = new GDProgressDialog((Frame)GDConfigPane.this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "PROG_LOAD_ARCS"));
            this.completed = false;
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("progress")) {
                        int i = (Integer)e.getNewValue();
                        if (i < 20) {
                            DBImportWorker.this.prog.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "PROG_LOAD_ARCS"));
                        }
                        if (i >= 20 && i < 50) {
                            DBImportWorker.this.prog.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "PROG_DEC_DB_ARZ"));
                        }
                        if (i >= 50 && i < 70) {
                            DBImportWorker.this.prog.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "PROC_IMP_DB_ARZ"));
                        }
                        if (i >= 70 && i < 80) {
                            DBImportWorker.this.prog.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "PROC_IMP_MOD"));
                        }
                        if (i >= 80 && i < 90) {
                            DBImportWorker.this.prog.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "PROC_UPD_STASH"));
                        }
                        if (i >= 90) {
                            DBImportWorker.this.prog.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "PROG_LOAD_STASH"));
                        }
                    }
                }
            });
            this.prog.setVisible(true);
        }

        @Override
        public Void doInBackground() {
            GDMsgLogger.clear();
            this.setProgress(0);
            this.completed = false;
            String s = null;
            boolean success = true;
            GDStashFrame.arcList = GDConfigPane.this.getImportARCList();
            GDStashFrame.arcList.decompress();
            if (GDMsgLogger.errorsInLog()) {
                success = false;
            }
            if (success) {
                String order = GDStashFrame.arcList.getTag("tags_items.txt", "tagItemNameOrder");
                boolean bl = success = success && DBConfig.setItemNameOrder("0.9.9d", "1.0.2a", order);
            }
            if (success) {
                this.setProgress(20);
                s = GDConfigPane.this.strGD + GDConstants.FILE_SEPARATOR + "database" + GDConstants.FILE_SEPARATOR + "database.arz";
                ARZDecompress.decompress(s);
                if (GDMsgLogger.errorsInLog()) {
                    success = false;
                }
            }
            if (success) {
                this.setProgress(50);
                success = ARZDecompress.insertData();
            }
            if (success) {
                String db;
                this.setProgress(70);
                String mod = (String)GDConfigPane.this.cbMod.getSelectedItem();
                if (mod != null && mod.length() > 0 && (db = GDConfigPane.this.getModDatabase()) != null) {
                    ARZDecompress.decompress(db);
                    success = ARZDecompress.insertModData();
                }
            }
            if (success) {
                this.setProgress(80);
                success = GDDBData.updateStash();
                if (GDMsgLogger.errorsInLog()) {
                    success = false;
                }
                this.setProgress(90);
                success = success && DBConfig.setGDDBInit("0.9.9d", "1.0.2a", success);
                boolean bl = success = success && DBConfig.setVersions("0.9.9d", "1.0.2a");
            }
            if (success) {
                String msg = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_DB_IMPORT");
                GDMsgLogger.addSuccess(msg);
                GDStashFrame.dbConfig.gddbInit = success;
                ItemSetPane.loadSets();
                if (((GDConfigPane)GDConfigPane.this).frame.pnlTransfer != null) {
                    ((GDConfigPane)GDConfigPane.this).frame.pnlTransfer.updateItemSets();
                }
                if (((GDConfigPane)GDConfigPane.this).frame.pnlCharInventory != null) {
                    ((GDConfigPane)GDConfigPane.this).frame.pnlCharInventory.updateItemSets();
                }
                if (((GDConfigPane)GDConfigPane.this).frame.pnlCraft != null) {
                    ((GDConfigPane)GDConfigPane.this).frame.pnlCraft.updateItemSets();
                }
                if (((GDConfigPane)GDConfigPane.this).frame.pnlCollection != null) {
                    ((GDConfigPane)GDConfigPane.this).frame.pnlCollection.updateItemSets();
                }
                GDStashFrame.initCraftingAffixes();
            }
            if (success) {
                GDStashInfoList.findStashes(GDConfigPane.this.frame, null, null);
                if (((GDConfigPane)GDConfigPane.this).frame.pnlTransfer != null) {
                    ((GDConfigPane)GDConfigPane.this).frame.pnlTransfer.setStash(GDStashInfoList.defaultStash);
                }
                if (((GDConfigPane)GDConfigPane.this).frame.pnlCraft != null) {
                    ((GDConfigPane)GDConfigPane.this).frame.pnlCraft.setStash(GDStashInfoList.defaultStash);
                }
                GDCharInfoList.findChars(GDConfigPane.this.frame, null);
                if (((GDConfigPane)GDConfigPane.this).frame.pnlCharInventory != null) {
                    ((GDConfigPane)GDConfigPane.this).frame.pnlCharInventory.initCharSelection();
                }
                if (((GDConfigPane)GDConfigPane.this).frame.pnlCharEdit != null) {
                    ((GDConfigPane)GDConfigPane.this).frame.pnlCharEdit.initCharSelection();
                }
                GDConfigPane.this.frame.refresh();
                this.completed = true;
            }
            return null;
        }

        @Override
        public void done() {
            this.prog.setVisible(false);
            this.prog.dispose();
            if (!this.completed && !GDMsgLogger.errorsInLog()) {
                GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_DB_IMPORT"));
            }
            GDStashFrame.arcList = null;
            ARZDecompress.clear();
            GDConfigPane.this.setCursor(Cursor.getDefaultCursor());
            GDMsgLogger.showLog(GDConfigPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_DB_IMPORT"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_DB_IMPORT"), true, false);
        }
    }
}

