/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.gdstash.db.DBAffix;
import org.gdstash.db.DBItem;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.item.GDItem;
import org.gdstash.ui.GDFilterDialog;
import org.gdstash.ui.GDItemCraftPane;
import org.gdstash.ui.GDItemNameTablePane;
import org.gdstash.ui.GDSearchDialog;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.GDUIFilter;
import org.gdstash.ui.GDUISearch;
import org.gdstash.ui.GDUITransfer;
import org.gdstash.ui.stash.GDSharedStashPane;
import org.gdstash.ui.util.GDCharInfoList;
import org.gdstash.ui.util.GDStashInfoList;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDImagePool;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class GDCraftPane
extends JPanel
implements GDUITransfer,
GDUISearch,
GDUIFilter {
    private GDStashFrame frame;
    private GDSharedStashPane pnlStash;
    private JButton btnFilter;
    private GDItemCraftPane pnlCraft;
    private JButton btnReload;
    private JButton btnFileSave;
    private GDItemNameTablePane pnlTable;
    private JButton btnSearch;
    private GDStashInfoList.GDStashFileInfo info;
    private GDItem selItem;
    private int location;
    private JPanel pnlMain;
    private GDSearchDialog dlgSearch;
    private GDFilterDialog dlgFilter;

    public GDCraftPane(GDStashInfoList.GDStashFileInfo info, GDStashFrame frame) {
        this.info = info;
        this.frame = frame;
        this.selItem = null;
        this.location = 0;
        this.dlgSearch = null;
        this.dlgFilter = null;
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        this.pnlMain = this.buildMainPanel();
        JScrollPane scroll = new JScrollPane(this.pnlMain);
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setVerticalGroup(vGroup);
    }

    public void adjustUI() {
        Font fntTabbed;
        Font fntCombo;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntButton = UIManager.getDefaults().getFont("Button.font");
        if (fntButton == null) {
            fntButton = fntLabel;
        }
        if ((fntCombo = UIManager.getDefaults().getFont("ComboBox.font")) == null) {
            fntCombo = fntLabel;
        }
        if ((fntTabbed = UIManager.getDefaults().getFont("TabbedPane.font")) == null) {
            fntTabbed = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntButton = fntButton.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCombo = fntCombo.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntTabbed = fntTabbed.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        if (this.btnSearch == null) {
            this.btnSearch = new JButton();
            this.btnSearch.addActionListener(new SearchItemsListener());
        }
        this.btnSearch.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_SEARCH"));
        this.btnSearch.setIcon(GDImagePool.iconBtnSearch24);
        this.btnSearch.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnSearch, "MNC_SEARCH_SECOND");
        if (this.btnFilter == null) {
            this.btnFilter = new JButton();
            this.btnFilter.addActionListener(new FilterAffixListener());
            this.btnFilter.setEnabled(false);
        }
        this.btnFilter.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_FILTER"));
        this.btnFilter.setIcon(GDImagePool.iconBtnFilter24);
        this.btnFilter.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnFilter, "MNC_FILTER");
        if (this.btnFileSave == null) {
            this.btnFileSave = new JButton();
            this.btnFileSave.setEnabled(false);
            this.btnFileSave.addActionListener(new FileSaveActionListener());
        }
        this.btnFileSave.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_STASH_SAVE"));
        this.btnFileSave.setIcon(GDImagePool.iconBtnSave24);
        this.btnFileSave.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnFileSave, "MNC_STASH_SAVE");
        if (this.btnReload == null) {
            this.btnReload = new JButton();
            this.btnReload.addActionListener(new StashReloadActionListener());
        }
        this.btnReload.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_RELOAD"));
        this.btnReload.setIcon(GDImagePool.iconBtnReload24);
        this.btnReload.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnReload, "MNC_RELOAD");
        if (this.pnlCraft == null) {
            this.pnlCraft = new GDItemCraftPane();
        } else {
            this.pnlCraft.adjustUI();
        }
        if (this.pnlTable == null) {
            this.pnlTable = new GDItemNameTablePane(null);
            this.pnlTable.addActionListener(new TableActionListener());
            this.pnlTable.setMinimumSize(new Dimension(300, 200));
            this.pnlTable.setMaximumSize(new Dimension(600, 2000));
        } else {
            this.pnlTable.adjustUI();
        }
        if (this.pnlStash == null) {
            this.pnlStash = new GDSharedStashPane(this.info, this.frame, this);
        } else {
            this.pnlStash.adjustUI();
        }
    }

    public void refresh() {
        if (this.pnlTable != null) {
            this.pnlTable.refresh();
        }
        if (this.pnlCraft != null) {
            this.pnlCraft.refresh();
        }
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel pnlTable = this.buildTablePanel();
        JPanel pnlItemInfo = this.buildInfoPanel();
        JPanel pnlStash = this.buildStashPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(pnlTable)).addGroup(layout.createParallelGroup().addComponent(pnlItemInfo)).addGroup(layout.createParallelGroup().addComponent(pnlStash));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(pnlStash).addComponent(pnlItemInfo).addComponent(pnlTable));
        layout.setVerticalGroup(vGroup);
        return panel;
    }

    private JPanel buildTablePanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.btnSearch).addComponent(this.pnlTable));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.btnSearch)).addGroup(layout.createParallelGroup().addComponent(this.pnlTable));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.btnSearch, this.pnlTable);
        return panel;
    }

    private JPanel buildStashPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.btnFileSave).addComponent(this.btnReload).addComponent(this.pnlStash));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.btnFileSave)).addGroup(layout.createParallelGroup().addComponent(this.btnReload)).addGroup(layout.createParallelGroup().addComponent(this.pnlStash));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.btnFileSave, this.btnReload);
        layout.linkSize(0, this.btnFileSave, this.pnlStash);
        layout.linkSize(1, this.btnFileSave, this.btnReload);
        return panel;
    }

    private JPanel buildInfoPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.btnFilter).addComponent(this.pnlCraft));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.btnFilter)).addGroup(layout.createParallelGroup().addComponent(this.pnlCraft));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.btnFilter, this.pnlCraft);
        return panel;
    }

    public void updateStash() {
        this.pnlStash.layoutStash();
        this.pnlStash.updateModSelection();
    }

    public void updateItemSets() {
        if (this.dlgSearch != null) {
            this.dlgSearch.updateItemSets();
        }
    }

    public void refreshStashSelection() {
        this.pnlStash.refreshStashSelection();
    }

    public void setStashInfo(GDStashInfoList.GDStashFileInfo info) {
        this.info = info;
        if (this.pnlStash != null) {
            this.pnlStash.setStash(info);
        }
    }

    public void refreshStashInfo(GDStashInfoList.GDStashFileInfo info) {
        if (info == null) {
            return;
        }
        if (this.info == null) {
            return;
        }
        if (this.info.fileName.equals(info.fileName)) {
            this.info = info;
            if (this.pnlStash != null) {
                this.pnlStash.setStash(info);
            }
        }
    }

    public boolean updateStashFile() {
        if (this.info == null) {
            return false;
        }
        if (this.info.gdStash == null) {
            return false;
        }
        if (GDStashFrame.iniConfig == null) {
            return false;
        }
        if (GDStashFrame.iniConfig.sectDir.savePath == null) {
            return false;
        }
        try {
            String dir;
            String stashMod = this.info.gdStash.getModName();
            if (stashMod == null) {
                stashMod = "";
            }
            if (stashMod.equals(dir = (dir = this.info.gdStash.getFile().getParentFile().getCanonicalPath()).length() >= GDStashFrame.iniConfig.sectDir.savePath.length() ? dir.substring(GDStashFrame.iniConfig.sectDir.savePath.length()) : "")) {
                return false;
            }
            dir = GDStashFrame.iniConfig.sectDir.savePath;
            if (!dir.endsWith(GDConstants.FILE_SEPARATOR)) {
                dir = dir + GDConstants.FILE_SEPARATOR;
            }
            if (!stashMod.equals("")) {
                dir = dir + stashMod + GDConstants.FILE_SEPARATOR;
            }
            dir = this.info.gdStash.isHardcore() ? dir + "transfer.gsh" : dir + "transfer.gst";
            File file = new File(dir);
            this.info.gdStash.setFile(file);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void setChar(GDCharInfoList.GDCharFileInfo info) {
    }

    @Override
    public void setStash(GDStashInfoList.GDStashFileInfo info) {
        if (this.info == info) {
            return;
        }
        this.info = info;
        this.checkSaveButton();
    }

    @Override
    public int getItemLocation() {
        return this.location;
    }

    @Override
    public GDItem getSelectedItem() {
        return this.selItem;
    }

    @Override
    public void setSelectedItem(GDItem item, int location) {
        if (location == 1) {
            this.pnlTable.clearSelection();
        }
        this.selItem = item;
        this.location = location;
        this.pnlCraft.setItem(item, location);
        this.btnFilter.setEnabled(item != null);
        if (this.pnlCraft.getPrefixes().isEmpty() && this.pnlCraft.getSuffixes().isEmpty()) {
            this.btnFilter.setEnabled(false);
        }
    }

    @Override
    public void transferSelectedItem(int action, int x, int y) {
        switch (action) {
            case 1: {
                GDItem item;
                if (this.location != 1 || (item = this.pnlStash.getSelectedItem()) == null) break;
                this.pnlStash.moveSelectedItem(1, x, y);
                this.btnFileSave.setEnabled(this.info.gdStash.hasChanged());
                break;
            }
            case 4: {
                int i;
                if (this.location != 2) break;
                GDItem clone = this.pnlCraft.getItem().clone();
                String s = this.pnlCraft.getSeed();
                if (s == null) {
                    clone.createSeed();
                } else {
                    clone.setSeedHex(s);
                }
                if (clone.isComponent()) {
                    clone.setVar1(clone.getDBItem().getComponentPieces());
                }
                if ((i = this.pnlCraft.getCount()) > 0) {
                    clone.setStackCount(i);
                }
                this.pnlStash.addItem(clone, 4, x, y);
                this.btnFileSave.setEnabled(this.info.gdStash.hasChanged());
            }
        }
    }

    @Override
    public void checkSaveButton() {
        if (this.info == null) {
            this.btnFileSave.setEnabled(false);
        } else if (this.info.gdStash == null) {
            this.btnFileSave.setEnabled(false);
        } else {
            this.btnFileSave.setEnabled(this.info.gdStash.hasChanged());
        }
    }

    @Override
    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public void search(SelectionCriteria criteria) {
        this.pnlCraft.setItem(null, 0);
        LinkedList<GDItem> items = new LinkedList<GDItem>();
        criteria.noEnemyOnly = true;
        List<DBItem> dbItems = DBItem.getByCriteria(criteria);
        for (DBItem dbi : dbItems) {
            GDItem item = new GDItem(dbi);
            items.add(item);
        }
        this.pnlTable.setItems(items);
        GDMsgLogger.showLog(this, GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_SEARCH"));
    }

    @Override
    public void filter(SelectionCriteria criteria) {
        List<DBAffix> prefixes = this.pnlCraft.getPrefixes();
        List<DBAffix> suffixes = this.pnlCraft.getSuffixes();
        LinkedList<DBAffix> filterPrefixes = new LinkedList<DBAffix>();
        LinkedList<DBAffix> filterSuffixes = new LinkedList<DBAffix>();
        for (DBAffix affix : prefixes) {
            if (!affix.matchesCriteria(criteria)) continue;
            filterPrefixes.add(affix);
        }
        for (DBAffix affix : suffixes) {
            if (!affix.matchesCriteria(criteria)) continue;
            filterSuffixes.add(affix);
        }
        this.pnlCraft.setFilteredPrefixes(filterPrefixes);
        this.pnlCraft.setFilteredSuffixes(filterSuffixes);
    }

    private class SearchItemsListener
    implements ActionListener {
        private SearchItemsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GDCraftPane.this.dlgSearch == null) {
                GDCraftPane.this.dlgSearch = new GDSearchDialog((Frame)GDCraftPane.this.frame, GDCraftPane.this);
            }
            GDCraftPane.this.dlgSearch.setVisible(true);
        }
    }

    private class FilterAffixListener
    implements ActionListener {
        private FilterAffixListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GDCraftPane.this.dlgFilter == null) {
                GDCraftPane.this.dlgFilter = new GDFilterDialog((Frame)GDCraftPane.this.frame, GDCraftPane.this);
            }
            GDCraftPane.this.dlgFilter.setVisible(true);
        }
    }

    private class FileSaveActionListener
    implements ActionListener {
        private FileSaveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (GDCraftPane.this.info == null) {
                return;
            }
            if (((GDCraftPane)GDCraftPane.this).info.gdStash == null) {
                return;
            }
            boolean success = false;
            try {
                boolean update = GDCraftPane.this.updateStashFile();
                ((GDCraftPane)GDCraftPane.this).info.gdStash.write();
                if (update) {
                    GDCraftPane.this.info.setFile(((GDCraftPane)GDCraftPane.this).info.gdStash.getFile());
                    GDStashFrame.iniConfig.sectHistory.lastStash = ((GDCraftPane)GDCraftPane.this).info.fileName;
                    GDCraftPane.this.btnReload.doClick();
                }
                success = true;
            }
            catch (IOException ex) {
                GDMsgLogger.addError(ex);
            }
            if (success) {
                GDCraftPane.this.btnFileSave.setEnabled(((GDCraftPane)GDCraftPane.this).info.gdStash.hasChanged());
            }
            GDMsgLogger.showLog(GDCraftPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_STASH_SAVE"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_STASH_SAVE"));
        }
    }

    private class StashReloadActionListener
    implements ActionListener {
        private StashReloadActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            GDStashInfoList.findStashes(GDCraftPane.this.frame, GDCraftPane.this.info, null);
            if (GDCraftPane.this.info != null) {
                for (GDStashInfoList.GDStashFileInfo si : GDStashInfoList.gdStashFileInfos) {
                    if (!si.fileName.equals(((GDCraftPane)GDCraftPane.this).info.fileName)) continue;
                    GDCraftPane.this.info = si;
                    break;
                }
            }
            if (((GDCraftPane)GDCraftPane.this).frame.pnlTransfer != null) {
                ((GDCraftPane)GDCraftPane.this).frame.pnlTransfer.refreshStashInfo(GDCraftPane.this.info);
            }
            if (((GDCraftPane)GDCraftPane.this).frame.pnlCraft != null) {
                ((GDCraftPane)GDCraftPane.this).frame.pnlCraft.refreshStashInfo(GDCraftPane.this.info);
            }
            GDMsgLogger.showLog(GDCraftPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class TableActionListener
    implements ActionListener {
        private TableActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            GDItem item = GDCraftPane.this.pnlTable.getSelectedItem();
            GDCraftPane.this.setSelectedItem(item, 2);
            GDMsgLogger.showLog(GDCraftPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }
}

