/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDImagePool;
import org.gdstash.util.GDMsgFormatter;

public class GDDialog
extends JDialog {
    public static final int ICON_NONE = 0;
    public static final int ICON_SUCCESS = 1;
    public static final int ICON_INFO = 2;
    public static final int ICON_WARNING = 3;
    public static final int ICON_ERROR = 4;
    private Component owner;
    private JPanel panel;
    private JLabel lblIcon;
    private JLabel lblText;
    private JButton btnClose;

    public GDDialog(String text) {
        this.owner = null;
        this.buildPanel(text, 0);
    }

    public GDDialog(String text, int iconType) {
        this.owner = null;
        this.buildPanel(text, iconType);
    }

    public GDDialog(String text, Frame owner) {
        this(text, 0, owner, "", false);
    }

    public GDDialog(String text, int iconType, Frame owner) {
        this(text, iconType, owner, "", false);
    }

    public GDDialog(String text, Frame owner, boolean modal) {
        this(text, 0, owner, "", modal);
    }

    public GDDialog(String text, int iconType, Frame owner, boolean modal) {
        this(text, iconType, owner, "", modal);
    }

    public GDDialog(String text, Frame owner, String title) {
        this(text, 0, owner, title, false);
    }

    public GDDialog(String text, int iconType, Frame owner, String title) {
        this(text, iconType, owner, title, false);
    }

    public GDDialog(String text, int iconType, Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.owner = owner;
        this.buildPanel(text, iconType);
    }

    protected void buildPanel(String text, int iconType) {
        this.panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        JPanel pnlText = this.buildTextPanel(text, iconType);
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntButton = UIManager.getDefaults().getFont("Button.font");
        if (fntButton == null) {
            fntButton = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntButton = fntButton.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        this.btnClose = new JButton(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_OK"));
        this.btnClose.setFont(fntButton);
        this.btnClose.addActionListener(new CloseActionListener());
        layout = new GroupLayout(this.panel);
        this.panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(pnlText).addComponent(this.btnClose));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(pnlText)).addGroup(layout.createParallelGroup().addComponent(this.btnClose));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, pnlText, this.btnClose);
        this.getContentPane().add(this.panel);
        this.pack();
        this.setLocationRelativeTo(this.owner);
    }

    private JPanel buildTextPanel(String text, int iconType) {
        JPanel panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        this.lblIcon = new JLabel();
        this.setIcon(iconType);
        this.lblIcon.setBorder(compound);
        this.lblText = new JLabel();
        this.lblText.setText(text);
        this.lblText.setVerticalAlignment(0);
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.lblIcon)).addGroup(layout.createParallelGroup().addComponent(this.lblText));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.lblIcon).addComponent(this.lblText));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(1, this.lblIcon, this.lblText);
        return panel;
    }

    private void setIcon(int iconType) {
        switch (iconType) {
            case 1: {
                this.lblIcon.setIcon(GDImagePool.iconMsgSuccess32);
                break;
            }
            case 2: {
                this.lblIcon.setIcon(GDImagePool.iconMsgInfo32);
                break;
            }
            case 3: {
                this.lblIcon.setIcon(GDImagePool.iconMsgWarning32);
                break;
            }
            case 4: {
                this.lblIcon.setIcon(GDImagePool.iconMsgError32);
                break;
            }
            default: {
                this.lblIcon.setIcon(null);
            }
        }
    }

    private class CloseActionListener
    implements ActionListener {
        private CloseActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDDialog.this.setVisible(false);
            GDDialog.this.dispatchEvent(new WindowEvent(GDDialog.this, 201));
        }
    }
}

