/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.GDUIFilter;
import org.gdstash.ui.select.AffixSelectionPane;
import org.gdstash.util.GDImagePool;
import org.gdstash.util.GDLog;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class GDFilterDialog
extends JDialog {
    private Component owner;
    private JButton btnSearch;
    private JButton btnClear;
    private AffixSelectionPane pnlSelect;
    private GDUIFilter uiFilter;
    private JPanel pnlMain;

    public GDFilterDialog(GDUIFilter uiFilter) {
        this(null, uiFilter, true);
    }

    public GDFilterDialog(Frame owner, GDUIFilter uiFilter) {
        this(owner, uiFilter, true);
    }

    public GDFilterDialog(Frame owner, GDUIFilter uiFilter, boolean modal) {
        super(owner, modal);
        this.owner = owner;
        this.uiFilter = uiFilter;
        this.setTitle(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_FILTER"));
        this.pnlMain = this.buildPanel2();
        JScrollPane scroll = new JScrollPane(this.pnlMain);
        this.getContentPane().add(scroll);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private JPanel buildPanel() {
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntButton = UIManager.getDefaults().getFont("Button.font");
        if (fntButton == null) {
            fntButton = fntLabel;
        }
        fntButton = fntButton.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        this.btnSearch = new JButton();
        this.btnSearch.addActionListener(new FilterActionListener());
        this.btnSearch.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_FILTER"));
        this.btnSearch.setIcon(GDImagePool.iconBtnFilter24);
        this.btnSearch.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnSearch, "MNC_FILTER");
        this.btnClear = new JButton();
        this.btnClear.addActionListener(new ClearActionListener());
        this.btnClear.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_CLEAR"));
        this.btnClear.setIcon(GDImagePool.iconBtnTrash24);
        this.btnClear.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnClear, "MNC_CLEAR");
        this.pnlSelect = new AffixSelectionPane();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.btnSearch).addComponent(this.pnlSelect).addComponent(this.btnClear));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.btnSearch)).addGroup(layout.createParallelGroup().addComponent(this.pnlSelect)).addGroup(layout.createParallelGroup().addComponent(this.btnClear));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.btnSearch, this.pnlSelect);
        layout.linkSize(0, this.btnSearch, this.btnClear);
        return panel;
    }

    private JPanel buildPanel2() {
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntButton = UIManager.getDefaults().getFont("Button.font");
        if (fntButton == null) {
            fntButton = fntLabel;
        }
        fntButton = fntButton.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        JPanel pnlButton = this.buildButtonPanel();
        this.pnlSelect = new AffixSelectionPane();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(pnlButton).addComponent(this.pnlSelect));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(pnlButton)).addGroup(layout.createParallelGroup().addComponent(this.pnlSelect));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, pnlButton, this.pnlSelect);
        return panel;
    }

    private JPanel buildButtonPanel() {
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntButton = UIManager.getDefaults().getFont("Button.font");
        if (fntButton == null) {
            fntButton = fntLabel;
        }
        fntButton = fntButton.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        BorderLayout layout = new BorderLayout();
        JPanel panel = new JPanel();
        this.btnSearch = new JButton();
        this.btnSearch.addActionListener(new FilterActionListener());
        this.btnSearch.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_FILTER"));
        this.btnSearch.setIcon(GDImagePool.iconBtnFilter24);
        this.btnSearch.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnSearch, "MNC_FILTER");
        this.btnClear = new JButton();
        this.btnClear.addActionListener(new ClearActionListener());
        this.btnClear.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_CLEAR"));
        this.btnClear.setIcon(GDImagePool.iconItemDelete24);
        this.btnClear.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnClear, "MNC_CLEAR");
        panel.setLayout(layout);
        panel.add((Component)this.btnSearch, "Center");
        panel.add((Component)this.btnClear, "West");
        return panel;
    }

    private class ClearActionListener
    implements ActionListener {
        private ClearActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDFilterDialog.this.pnlSelect.clear();
        }
    }

    private class FilterActionListener
    implements ActionListener {
        private FilterActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDLog log = new GDLog();
            SelectionCriteria criteria = new SelectionCriteria();
            GDFilterDialog.this.pnlSelect.addCriteria(criteria);
            criteria.checkCriteria(log);
            if (log.containsErrors()) {
                GDMsgLogger.addLog(log);
                GDMsgLogger.showLog(GDFilterDialog.this, GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_FILTER"));
                return;
            }
            GDFilterDialog.this.setCursor(Cursor.getPredefinedCursor(3));
            if (GDFilterDialog.this.uiFilter != null) {
                GDFilterDialog.this.uiFilter.filter(criteria);
            }
            GDFilterDialog.this.setVisible(false);
            GDFilterDialog.this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

