/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDImagePool;

public class GDFlexDialog
extends JDialog {
    private Component owner;
    private JPanel panel;
    private JLabel lblImage;
    private JLabel lblIcon;
    private JLabel lblText;
    private JButton[] buttons;
    private int[] i;

    public static int showDialog(String text, JButton[] buttons) {
        int[] i = new int[]{-1};
        GDFlexDialog dialog = new GDFlexDialog(text, buttons, null, "", 0, false, i);
        dialog.setVisible(true);
        return i[0];
    }

    public static int showDialog(String text, JButton[] buttons, Frame owner) {
        int[] i = new int[]{-1};
        GDFlexDialog dialog = new GDFlexDialog(text, buttons, owner, "", 0, false, i);
        dialog.setVisible(true);
        return i[0];
    }

    public static int showDialog(String text, JButton[] buttons, int iconType, Frame owner) {
        int[] i = new int[]{-1};
        GDFlexDialog dialog = new GDFlexDialog(text, buttons, owner, "", iconType, false, i);
        dialog.setVisible(true);
        return i[0];
    }

    public static int showDialog(String text, JButton[] buttons, Frame owner, boolean modal) {
        int[] i = new int[]{-1};
        GDFlexDialog dialog = new GDFlexDialog(text, buttons, owner, "", 0, modal, i);
        dialog.setVisible(true);
        return i[0];
    }

    public static int showDialog(String text, JButton[] buttons, int iconType, Frame owner, boolean modal) {
        int[] i = new int[]{-1};
        GDFlexDialog dialog = new GDFlexDialog(text, buttons, owner, "", iconType, modal, i);
        dialog.setVisible(true);
        return i[0];
    }

    public static int showDialog(String text, JButton[] buttons, Frame owner, String title) {
        int[] i = new int[]{-1};
        GDFlexDialog dialog = new GDFlexDialog(text, buttons, owner, title, 0, false, i);
        dialog.setVisible(true);
        return i[0];
    }

    public static int showDialog(String text, JButton[] buttons, int iconType, Frame owner, String title) {
        int[] i = new int[]{-1};
        GDFlexDialog dialog = new GDFlexDialog(text, buttons, owner, title, iconType, false, i);
        dialog.setVisible(true);
        return i[0];
    }

    private GDFlexDialog(String text, JButton[] buttons, Frame owner, String title, int iconType, boolean modal, int[] i) {
        super(owner, title, modal);
        this.owner = owner;
        this.buttons = buttons;
        this.i = i;
        this.buildPanel(text, iconType);
    }

    protected void buildPanel(String text, int iconType) {
        this.panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        this.lblImage = new JLabel();
        this.lblImage.setIcon(GDImagePool.iconLogo460x215);
        this.lblImage.setBorder(compound);
        this.lblImage.setHorizontalAlignment(0);
        JPanel pnlText = this.buildTextPanel(text, iconType);
        JPanel pnlButton = this.buildButtonPanel();
        layout = new GroupLayout(this.panel);
        this.panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.lblImage).addComponent(pnlText).addComponent(pnlButton));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.lblImage)).addGroup(layout.createParallelGroup().addComponent(pnlText)).addGroup(layout.createParallelGroup().addComponent(pnlButton));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.lblImage, pnlText);
        layout.linkSize(0, this.lblImage, pnlButton);
        this.getContentPane().add(this.panel);
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.setIconImage(GDImagePool.iconLogo64x64.getImage());
    }

    private JPanel buildButtonPanel() {
        int i;
        JPanel panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntButton = UIManager.getDefaults().getFont("Button.font");
        if (fntButton == null) {
            fntButton = fntLabel;
        }
        fntButton = fntButton.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        vGroup = layout.createSequentialGroup();
        GroupLayout.ParallelGroup pg = layout.createParallelGroup();
        for (i = 0; i < this.buttons.length; ++i) {
            if (this.buttons[i] == null) continue;
            this.buttons[i].setFont(fntButton);
            this.buttons[i].setPreferredSize(new Dimension(430 / this.buttons.length, fntButton.getSize() * 2));
            this.buttons[i].addActionListener(new CloseActionListener());
            hGroup.addGroup(layout.createParallelGroup().addComponent(this.buttons[i]));
            pg.addComponent(this.buttons[i]);
        }
        vGroup.addGroup(pg);
        layout.setHorizontalGroup(hGroup);
        layout.setVerticalGroup(vGroup);
        for (i = 1; i < this.buttons.length; ++i) {
            if (this.buttons[i] == null) continue;
            layout.linkSize(0, this.buttons[0], this.buttons[i]);
        }
        return panel;
    }

    private JPanel buildTextPanel(String text, int iconType) {
        JPanel panel = new JPanel();
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        panel.setBorder(compound);
        if (iconType != 0) {
            this.lblIcon = new JLabel();
            this.setIcon(iconType);
            this.lblIcon.setBorder(compound);
        }
        this.lblText = new JLabel();
        this.lblText.setText(text);
        this.lblText.setVerticalAlignment(0);
        this.lblText.setFont(fntLabel);
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        if (iconType == 0) {
            hGroup.addGroup(layout.createParallelGroup().addComponent(this.lblText));
        } else {
            hGroup.addGroup(layout.createParallelGroup().addComponent(this.lblIcon)).addGroup(layout.createParallelGroup().addComponent(this.lblText));
        }
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        if (iconType == 0) {
            vGroup.addGroup(layout.createParallelGroup().addComponent(this.lblText));
        } else {
            vGroup.addGroup(layout.createParallelGroup().addComponent(this.lblIcon).addComponent(this.lblText));
        }
        layout.setVerticalGroup(vGroup);
        if (iconType != 0) {
            layout.linkSize(1, this.lblIcon, this.lblText);
        }
        return panel;
    }

    private void setIcon(int iconType) {
        switch (iconType) {
            case 1: {
                this.lblIcon.setIcon(GDImagePool.iconMsgSuccess32);
                break;
            }
            case 2: {
                this.lblIcon.setIcon(GDImagePool.iconMsgInfo32);
                break;
            }
            case 3: {
                this.lblIcon.setIcon(GDImagePool.iconMsgWarning32);
                break;
            }
            case 4: {
                this.lblIcon.setIcon(GDImagePool.iconMsgError32);
                break;
            }
            default: {
                this.lblIcon.setIcon(null);
            }
        }
    }

    private class CloseActionListener
    implements ActionListener {
        private CloseActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton btn = (JButton)e.getSource();
            for (int i = 0; i < GDFlexDialog.this.buttons.length; ++i) {
                if (GDFlexDialog.this.buttons[i] != btn) continue;
                ((GDFlexDialog)GDFlexDialog.this).i[0] = i;
                break;
            }
            GDFlexDialog.this.setVisible(false);
            GDFlexDialog.this.dispatchEvent(new WindowEvent(GDFlexDialog.this, 201));
        }
    }
}

