/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DocumentFilter;
import org.gdstash.db.DBAffix;
import org.gdstash.db.DBAffixSet;
import org.gdstash.db.DBLootTable;
import org.gdstash.db.DBLootTableAffixSetAlloc;
import org.gdstash.db.DBLootTableSet;
import org.gdstash.item.GDItem;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.WideComboBox;
import org.gdstash.ui.select.HexLenDocFilter;
import org.gdstash.ui.select.IntLenDocFilter;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class GDItemCraftPane
extends JPanel {
    private JLabel lblImage;
    private JLabel lblName;
    private JLabel lblPrefix;
    private JLabel lblSuffix;
    private JLabel lblModifier;
    private JLabel lblCompletion;
    private JLabel lblSeed;
    private JLabel lblCount;
    private JLabel txtName;
    private JComboBox<DBAffix> cbPrefix;
    private JComboBox<DBAffix> cbSuffix;
    private JComboBox<DBAffix> cbModifier;
    private JComboBox<DBAffix> cbCompletion;
    private JFormattedTextField ftSeed;
    private JFormattedTextField ftCount;
    private List<DBAffix> allPrefixes = new LinkedList<DBAffix>();
    private List<DBAffix> allSuffixes = new LinkedList<DBAffix>();
    private List<DBAffix> filterPrefixes = new LinkedList<DBAffix>();
    private List<DBAffix> filterSuffixes = new LinkedList<DBAffix>();
    private List<AffixPermit> permits;
    private boolean skipCombo = false;
    private DefaultComboBoxModel<DBAffix> dmPrefix;
    private DefaultComboBoxModel<DBAffix> dmSuffix;
    private DefaultComboBoxModel<DBAffix> dmModifier;
    private DefaultComboBoxModel<DBAffix> dmModifierCelestial;
    private DefaultComboBoxModel<DBAffix> dmCompletion;
    private JLabel txtDescription;
    private GDItem item;

    public GDItemCraftPane() {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        JPanel panel = this.buildInfoPanel();
        this.lblImage = new JLabel();
        this.lblImage.setBorder(compound);
        this.lblImage.setHorizontalAlignment(0);
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.lblImage).addComponent(panel).addComponent(this.txtDescription));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.lblImage)).addGroup(layout.createParallelGroup().addComponent(panel)).addGroup(layout.createParallelGroup().addComponent(this.txtDescription));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, panel, this.lblImage);
        layout.linkSize(0, panel, this.txtDescription);
    }

    public void adjustUI() {
        AbstractDocument doc;
        DocumentFilter filter;
        Font fntFText;
        int size = 12;
        if (GDStashFrame.iniConfig != null) {
            size = GDStashFrame.iniConfig.sectUI.fontSize;
        }
        Dimension dimMax = new Dimension(50 * size, 2 * size);
        Dimension dimCBMax = new Dimension(50 * size, 4 * size);
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCombo = UIManager.getDefaults().getFont("ComboBox.font");
        if (fntCombo == null) {
            fntCombo = fntLabel;
        }
        if ((fntFText = UIManager.getDefaults().getFont("FormattedTextField.font")) == null) {
            fntFText = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)size);
        fntCombo = fntCombo.deriveFont((float)size);
        fntFText = fntFText.deriveFont((float)size);
        CompoundBorder compound = null;
        if (this.txtName == null || this.txtDescription == null) {
            Border lowered = BorderFactory.createEtchedBorder(1);
            Border raised = BorderFactory.createEtchedBorder(0);
            compound = BorderFactory.createCompoundBorder(raised, lowered);
        }
        if (this.lblName == null) {
            this.lblName = new JLabel();
        }
        this.lblName.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_NAME"));
        this.lblName.setFont(fntLabel);
        if (this.txtName == null) {
            this.txtName = new JLabel();
            this.txtName.setBorder(compound);
        }
        this.txtName.setFont(fntLabel);
        this.txtName.setPreferredSize(dimMax);
        this.txtName.setMaximumSize(dimMax);
        if (this.lblPrefix == null) {
            this.lblPrefix = new JLabel();
        }
        this.lblPrefix.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_PREFIX"));
        this.lblPrefix.setFont(fntLabel);
        if (this.cbPrefix == null) {
            this.cbPrefix = new WideComboBox<DBAffix>();
            this.cbPrefix.setMaximumRowCount(25);
            this.cbPrefix.addActionListener(new ComboBoxActionListener());
        }
        this.cbPrefix.setFont(fntCombo);
        this.cbPrefix.setPreferredSize(dimCBMax);
        this.cbPrefix.setMaximumSize(dimCBMax);
        if (this.lblSuffix == null) {
            this.lblSuffix = new JLabel();
        }
        this.lblSuffix.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_SUFFIX"));
        this.lblSuffix.setFont(fntLabel);
        if (this.cbSuffix == null) {
            this.cbSuffix = new WideComboBox<DBAffix>();
            this.cbSuffix.setMaximumRowCount(25);
            this.cbSuffix.addActionListener(new ComboBoxActionListener());
        }
        this.cbSuffix.setFont(fntCombo);
        this.cbSuffix.setPreferredSize(dimCBMax);
        this.cbSuffix.setMaximumSize(dimCBMax);
        if (this.lblModifier == null) {
            this.lblModifier = new JLabel();
        }
        this.lblModifier.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_MODIFIER"));
        this.lblModifier.setFont(fntLabel);
        if (this.cbModifier == null) {
            this.cbModifier = new WideComboBox<DBAffix>();
            this.cbModifier.addActionListener(new ComboBoxActionListener());
        }
        this.cbModifier.setFont(fntCombo);
        if (this.lblCompletion == null) {
            this.lblCompletion = new JLabel();
        }
        this.lblCompletion.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_COMPLETION"));
        this.lblCompletion.setFont(fntLabel);
        if (this.cbCompletion == null) {
            this.cbCompletion = new WideComboBox<DBAffix>();
            this.cbCompletion.addActionListener(new ComboBoxActionListener());
        }
        this.cbCompletion.setFont(fntCombo);
        if (this.lblSeed == null) {
            this.lblSeed = new JLabel();
        }
        this.lblSeed.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_SEED"));
        this.lblSeed.setFont(fntLabel);
        if (this.ftSeed == null) {
            this.ftSeed = new JFormattedTextField();
            filter = new HexLenDocFilter(8);
            doc = (AbstractDocument)this.ftSeed.getDocument();
            doc.setDocumentFilter(filter);
        }
        this.ftSeed.setFont(fntFText);
        if (this.lblCount == null) {
            this.lblCount = new JLabel();
        }
        this.lblCount.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_COUNT"));
        this.lblCount.setFont(fntLabel);
        if (this.ftCount == null) {
            this.ftCount = new JFormattedTextField();
            filter = new IntLenDocFilter(4);
            doc = (AbstractDocument)this.ftCount.getDocument();
            doc.setDocumentFilter(filter);
        }
        this.ftCount.setFont(fntFText);
        if (this.txtDescription == null) {
            this.txtDescription = new JLabel();
            this.txtDescription.setBorder(compound);
        }
        this.txtDescription.setFont(fntLabel);
    }

    public void refresh() {
        this.setItem(null, 0);
    }

    private JPanel buildInfoPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.lblName).addComponent(this.lblPrefix).addComponent(this.lblSuffix).addComponent(this.lblModifier).addComponent(this.lblCompletion).addComponent(this.lblSeed).addComponent(this.lblCount)).addGroup(layout.createParallelGroup().addComponent(this.txtName).addComponent(this.cbPrefix).addComponent(this.cbSuffix).addComponent(this.cbModifier).addComponent(this.cbCompletion).addComponent(this.ftSeed).addComponent(this.ftCount));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.lblName).addComponent(this.txtName)).addGroup(layout.createParallelGroup().addComponent(this.lblPrefix).addComponent(this.cbPrefix)).addGroup(layout.createParallelGroup().addComponent(this.lblSuffix).addComponent(this.cbSuffix)).addGroup(layout.createParallelGroup().addComponent(this.lblModifier).addComponent(this.cbModifier)).addGroup(layout.createParallelGroup().addComponent(this.lblCompletion).addComponent(this.cbCompletion)).addGroup(layout.createParallelGroup().addComponent(this.lblSeed).addComponent(this.ftSeed)).addGroup(layout.createParallelGroup().addComponent(this.lblCount).addComponent(this.ftCount));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.lblName, this.lblPrefix);
        layout.linkSize(0, this.lblName, this.lblSuffix);
        layout.linkSize(0, this.lblName, this.lblModifier);
        layout.linkSize(0, this.lblName, this.lblCompletion);
        layout.linkSize(0, this.lblName, this.lblSeed);
        layout.linkSize(0, this.lblName, this.lblCount);
        layout.linkSize(0, this.txtName, this.cbPrefix);
        layout.linkSize(0, this.txtName, this.cbSuffix);
        layout.linkSize(0, this.txtName, this.cbModifier);
        layout.linkSize(0, this.txtName, this.cbCompletion);
        layout.linkSize(0, this.txtName, this.ftSeed);
        layout.linkSize(0, this.txtName, this.ftCount);
        layout.linkSize(1, this.lblName, this.txtName);
        layout.linkSize(1, this.lblPrefix, this.cbPrefix);
        layout.linkSize(1, this.lblSuffix, this.cbSuffix);
        layout.linkSize(1, this.lblModifier, this.cbModifier);
        layout.linkSize(1, this.lblCompletion, this.cbCompletion);
        layout.linkSize(1, this.lblSeed, this.ftSeed);
        layout.linkSize(1, this.lblCount, this.ftCount);
        return panel;
    }

    private void setInfo(GDItem.LabelInfo info, JLabel label) {
        if (info == null) {
            label.setText("");
        } else {
            label.setForeground(info.foreground);
            label.setText(info.text);
        }
    }

    public void setNameInfo(GDItem.LabelInfo info) {
        this.setInfo(info, this.txtName);
    }

    public void setImage(Icon icon) {
        this.lblImage.setIcon(icon);
    }

    public void setItem(GDItem item, int location) {
        this.item = item == null ? null : item.clone();
        this.initItemInfo(location);
    }

    private void initItemInfo(int location) {
        if (this.item == null) {
            GDItem.LabelInfo li = new GDItem.LabelInfo();
            li.text = "";
            this.setImage(null);
            this.setNameInfo(li);
            this.cbPrefix.removeAllItems();
            this.cbPrefix.setEnabled(false);
            this.cbSuffix.removeAllItems();
            this.cbSuffix.setEnabled(false);
            this.cbModifier.removeAllItems();
            this.cbModifier.setEnabled(false);
            this.cbCompletion.removeAllItems();
            this.cbCompletion.setEnabled(false);
            this.ftSeed.setText(null);
            this.ftCount.setText(null);
        } else {
            this.setImage(this.item.getImageIcon());
            this.setNameInfo(this.item.getItemNameInfo());
            this.fillCombos(this.item);
            GDMsgLogger.showLog(this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
            this.cbPrefix.setModel(this.dmPrefix);
            this.cbSuffix.setModel(this.dmSuffix);
            if (this.item.isCraftable() || GDStashFrame.iniConfig.sectRestrict.blacksmithAll) {
                this.cbModifier.setModel(this.dmModifier);
            } else if (this.item.getRarity().equals("Legendary")) {
                this.cbModifier.setModel(this.dmModifierCelestial);
            } else {
                this.cbModifier.removeAllItems();
            }
            this.cbCompletion.setModel(this.dmCompletion);
            if (location == 1) {
                this.cbPrefix.setEnabled(false);
                this.cbSuffix.setEnabled(false);
                this.cbModifier.setEnabled(false);
                this.cbCompletion.setEnabled(false);
                this.ftSeed.setText(this.item.getSeedHex());
                this.ftCount.setText(this.item.getStackCountStr());
                this.ftSeed.setEditable(false);
                this.ftCount.setEditable(false);
            } else {
                this.cbPrefix.setEnabled(this.dmPrefix.getSize() > 1);
                this.cbSuffix.setEnabled(this.dmSuffix.getSize() > 1);
                if (this.item.isCraftable() || GDStashFrame.iniConfig.sectRestrict.blacksmithAll) {
                    this.cbModifier.setEnabled(this.dmModifier.getSize() > 1);
                } else if (this.item.getRarity().equals("Legendary")) {
                    this.cbModifier.setEnabled(this.dmModifierCelestial.getSize() > 1);
                } else {
                    this.cbModifier.setEnabled(false);
                }
                this.cbCompletion.setEnabled(this.dmCompletion.getSize() > 1);
                this.ftSeed.setText(null);
                this.ftCount.setText(null);
                this.ftSeed.setEditable(true);
                this.ftCount.setEditable(true);
            }
        }
        this.updateDescription();
    }

    private void updateDescription() {
        String s = null;
        s = this.item == null ? "" : this.item.getFullDescription();
        this.txtDescription.setText(s);
    }

    private void fillCombos(GDItem item) {
        this.dmPrefix = new DefaultComboBoxModel();
        this.dmSuffix = new DefaultComboBoxModel();
        this.dmModifier = new DefaultComboBoxModel();
        this.dmModifierCelestial = new DefaultComboBoxModel();
        this.dmCompletion = new DefaultComboBoxModel();
        this.dmPrefix.addElement(null);
        this.dmSuffix.addElement(null);
        this.dmModifier.addElement(null);
        this.dmModifierCelestial.addElement(null);
        this.dmCompletion.addElement(null);
        this.dmPrefix.setSelectedItem(null);
        this.dmSuffix.setSelectedItem(null);
        this.dmModifier.setSelectedItem(null);
        this.dmModifierCelestial.setSelectedItem(null);
        this.dmCompletion.setSelectedItem(null);
        if (item.getItemID() == null) {
            return;
        }
        if (item.isArmor() || item.isJewelry() || item.isWeapon()) {
            this.dmModifier = GDStashFrame.getModifier();
            this.dmModifierCelestial = GDStashFrame.getCelestialModifier();
            this.dmModifier.setSelectedItem(null);
            this.dmModifierCelestial.setSelectedItem(null);
        }
        List<DBLootTable> lootTables = DBLootTable.getByItemID(item.getItemID());
        List<DBAffixSet> affixSets = GDItemCraftPane.extractAffixSets(lootTables);
        if ((item.isComponent() || item.isArtifact()) && item.getBonusAffixSet() != null) {
            affixSets.add(item.getBonusAffixSet());
        }
        List<DBAffix> affixAll = GDItemCraftPane.extractAffixes(affixSets);
        Collections.sort(affixAll, new DBAffix.StringComparator());
        this.allPrefixes.clear();
        this.allSuffixes.clear();
        this.filterPrefixes.clear();
        this.filterSuffixes.clear();
        this.permits = GDItemCraftPane.determinePermits(affixAll, lootTables);
        for (DBAffix affix : affixAll) {
            if (affix == null) continue;
            if (affix.getAffixType() == 1) {
                this.allPrefixes.add(affix);
                this.filterPrefixes.add(affix);
            }
            if (affix.getAffixType() == 2) {
                this.allSuffixes.add(affix);
                this.filterSuffixes.add(affix);
            }
            if (affix.getAffixType() != 4 || !item.isArtifact()) continue;
            this.dmCompletion.addElement(affix);
        }
        this.fillPrefixCombo();
        this.fillSuffixCombo();
        if (item.getPrefix() != null) {
            this.dmPrefix.setSelectedItem(item.getPrefix());
        }
        if (item.getSuffix() != null) {
            this.dmSuffix.setSelectedItem(item.getSuffix());
        }
        if (item.getModifier() != null) {
            this.dmModifier.setSelectedItem(item.getModifier());
        }
        if (item.getCompletionBonus() != null) {
            this.dmCompletion.setSelectedItem(item.getCompletionBonus());
        }
    }

    private void fillPrefixCombo() {
        List<DBAffix> currPrefixes = GDItemCraftPane.determinePermittedAffixes(this.item.getSuffix(), this.filterPrefixes, this.permits);
        this.skipCombo = true;
        this.dmPrefix.setSelectedItem(null);
        this.dmPrefix.removeAllElements();
        this.dmPrefix.addElement(null);
        boolean found = false;
        DBAffix prefix = this.item.getPrefix();
        for (DBAffix affix : currPrefixes) {
            this.dmPrefix.addElement(affix);
            if (prefix == null || !prefix.getAffixID().equals(affix.getAffixID())) continue;
            found = true;
        }
        if (found) {
            this.dmPrefix.setSelectedItem(this.item.getPrefix());
            this.skipCombo = false;
        } else {
            this.skipCombo = false;
            this.item.setPrefix(null);
        }
    }

    private void fillSuffixCombo() {
        List<DBAffix> currSuffixes = GDItemCraftPane.determinePermittedAffixes(this.item.getPrefix(), this.filterSuffixes, this.permits);
        this.skipCombo = true;
        this.dmSuffix.setSelectedItem(null);
        this.dmSuffix.removeAllElements();
        this.dmSuffix.addElement(null);
        boolean found = false;
        DBAffix suffix = this.item.getSuffix();
        for (DBAffix affix : currSuffixes) {
            this.dmSuffix.addElement(affix);
            if (suffix == null || !suffix.getAffixID().equals(affix.getAffixID())) continue;
            found = true;
        }
        if (found) {
            this.dmSuffix.setSelectedItem(this.item.getSuffix());
            this.skipCombo = false;
        } else {
            this.skipCombo = false;
            this.item.setSuffix(null);
        }
    }

    private static List<AffixPermit> determinePermits(List<DBAffix> affixes, List<DBLootTable> tables) {
        LinkedList<AffixPermit> permits = new LinkedList<AffixPermit>();
        if (GDStashFrame.iniConfig.sectRestrict.affixCombi == 3 || GDStashFrame.iniConfig.sectRestrict.affixCombi == 2) {
            return permits;
        }
        for (DBAffix affix : affixes) {
            if (affix.getAffixType() != 1 && affix.getAffixType() != 2) continue;
            AffixPermit permit = new AffixPermit();
            permit.affix = affix;
            for (DBLootTable table : tables) {
                boolean allAllowed = false;
                List<DBLootTableAffixSetAlloc> allocs = table.getAffixSetAllocList();
                for (DBLootTableAffixSetAlloc alloc : allocs) {
                    List<DBAffixSet.DBEntry> entries = alloc.getAffixEntries();
                    if (entries == null) continue;
                    for (DBAffixSet.DBEntry entry : entries) {
                        if (!entry.getAffixID().equals(affix.getAffixID())) continue;
                        if (table.isMagicPrefixMagicSuffixAllowed()) {
                            permit.nPre_nSuf = true;
                        }
                        if (table.isMagicPrefixRareSuffixAllowed()) {
                            permit.nPre_rSuf = true;
                        }
                        if (table.isRarePrefixMagicSuffixAllowed()) {
                            permit.rPre_nSuf = true;
                        }
                        if (table.isRarePrefixRareSuffixAllowed()) {
                            permit.rPre_rSuf = true;
                        }
                        if (!permit.nPre_nSuf || !permit.nPre_rSuf || !permit.rPre_nSuf || !permit.rPre_rSuf) break;
                        allAllowed = true;
                        break;
                    }
                    if (!allAllowed) continue;
                    break;
                }
                if (!allAllowed) continue;
                break;
            }
            permits.add(permit);
        }
        return permits;
    }

    private static List<DBAffix> determinePermittedAffixes(DBAffix affix, List<DBAffix> affixes, List<AffixPermit> permits) {
        if (GDStashFrame.iniConfig.sectRestrict.affixCombi == 3 || GDStashFrame.iniConfig.sectRestrict.affixCombi == 2) {
            return affixes;
        }
        if (affix == null) {
            return affixes;
        }
        LinkedList<DBAffix> permitted = new LinkedList<DBAffix>();
        for (AffixPermit permit : permits) {
            if (!permit.affix.getAffixID().equals(affix.getAffixID())) continue;
            if (affix.getRarity().equals("Magical")) {
                if (permit.nPre_rSuf) {
                    for (DBAffix a : affixes) {
                        if (!a.getRarity().equals("Rare")) continue;
                        permitted.add(a);
                    }
                }
                if (permit.nPre_nSuf) {
                    for (DBAffix a : affixes) {
                        if (!a.getRarity().equals("Magical")) continue;
                        permitted.add(a);
                    }
                }
            }
            if (affix.getRarity().equals("Rare")) {
                if (permit.rPre_rSuf) {
                    for (DBAffix a : affixes) {
                        if (!a.getRarity().equals("Rare")) continue;
                        permitted.add(a);
                    }
                }
                if (permit.rPre_nSuf) {
                    for (DBAffix a : affixes) {
                        if (!a.getRarity().equals("Magical")) continue;
                        permitted.add(a);
                    }
                }
            }
            if (affix.getRarity().equals("Epic") && permit.nPre_nSuf) {
                for (DBAffix a : affixes) {
                    if (!a.getRarity().equals("Epic")) continue;
                    permitted.add(a);
                }
            }
            if (!affix.getRarity().equals("Legendary") || !permit.nPre_nSuf) continue;
            for (DBAffix a : affixes) {
                if (!a.getRarity().equals("Legendary")) continue;
                permitted.add(a);
            }
        }
        return permitted;
    }

    public static List<DBLootTableSet> extractTableSets(List<DBLootTable> tables) {
        LinkedList<DBLootTableSet> setAll = new LinkedList<DBLootTableSet>();
        if (tables == null) {
            return setAll;
        }
        for (DBLootTable table : tables) {
            List<DBLootTableSet> sets;
            if (table.getAffixSetAllocList() == null || (sets = DBLootTableSet.getByTableID(table.getTableID())) == null) continue;
            for (DBLootTableSet set : sets) {
                if (set == null) continue;
                boolean found = false;
                for (DBLootTableSet ts : setAll) {
                    if (!ts.getTableSetID().equals(set.getTableSetID())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                setAll.add(set);
            }
        }
        return setAll;
    }

    public static List<DBAffixSet> extractAffixSets(List<DBLootTable> tables) {
        LinkedList<DBAffixSet> setAll = new LinkedList<DBAffixSet>();
        if (tables == null) {
            return setAll;
        }
        for (DBLootTable table : tables) {
            List<DBAffixSet> sets;
            if (table.getAffixSetAllocList() == null || (sets = DBAffixSet.getByAffixSetIDs(table.getAffixSetIDs())) == null) continue;
            for (DBAffixSet set : sets) {
                if (set == null) continue;
                boolean found = false;
                for (DBAffixSet as : setAll) {
                    if (!as.getAffixSetID().equals(set.getAffixSetID())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                setAll.add(set);
            }
        }
        return setAll;
    }

    public static List<DBAffix> extractAffixes(List<DBAffixSet> sets) {
        List<DBAffix> affixAll = new LinkedList<DBAffix>();
        if (GDStashFrame.iniConfig != null && GDStashFrame.iniConfig.sectRestrict.affixCombi == 3) {
            affixAll = DBAffix.getFullAffixList();
            return affixAll;
        }
        if (sets == null) {
            return affixAll;
        }
        for (DBAffixSet set : sets) {
            if (set == null || set.getAffixEntries() == null) continue;
            for (DBAffixSet.DBEntry entry : set.getAffixEntries()) {
                DBAffix affix2;
                if (entry == null) continue;
                boolean found = false;
                for (DBAffix affix2 : affixAll) {
                    if (!affix2.getAffixID().equals(entry.getAffixID())) continue;
                    found = true;
                    break;
                }
                if (found || (affix2 = DBAffix.get(entry.getAffixID())) == null) continue;
                affixAll.add(affix2);
            }
        }
        return affixAll;
    }

    public List<DBAffix> getPrefixes() {
        return this.allPrefixes;
    }

    public void setFilteredPrefixes(List<DBAffix> prefixes) {
        this.filterPrefixes = prefixes;
        this.skipCombo = true;
        DBAffix prefix = (DBAffix)this.dmPrefix.getSelectedItem();
        boolean found = false;
        this.dmPrefix.setSelectedItem(null);
        this.dmPrefix.removeAllElements();
        this.dmPrefix.addElement(null);
        for (DBAffix affix : this.filterPrefixes) {
            this.dmPrefix.addElement(affix);
            if (prefix == null || !prefix.getAffixID().equals(affix.getAffixID())) continue;
            found = true;
        }
        if (found) {
            this.dmPrefix.setSelectedItem(prefix);
            this.skipCombo = false;
        } else {
            this.dmPrefix.addElement(prefix);
            this.dmPrefix.setSelectedItem(prefix);
            this.skipCombo = false;
        }
    }

    public List<DBAffix> getSuffixes() {
        return this.allSuffixes;
    }

    public void setFilteredSuffixes(List<DBAffix> suffixes) {
        this.filterSuffixes = suffixes;
        this.skipCombo = true;
        DBAffix suffix = (DBAffix)this.dmSuffix.getSelectedItem();
        boolean found = false;
        this.dmSuffix.setSelectedItem(null);
        this.dmSuffix.removeAllElements();
        this.dmSuffix.addElement(null);
        for (DBAffix affix : this.filterSuffixes) {
            this.dmSuffix.addElement(affix);
            if (suffix == null || !suffix.getAffixID().equals(affix.getAffixID())) continue;
            found = true;
        }
        if (found) {
            this.dmSuffix.setSelectedItem(suffix);
            this.skipCombo = false;
        } else {
            this.dmSuffix.addElement(suffix);
            this.dmSuffix.setSelectedItem(suffix);
            this.skipCombo = false;
        }
    }

    public GDItem getItem() {
        return this.item;
    }

    public String getSeed() {
        String s = this.ftSeed.getText();
        s = s.length() != 8 ? null : s.toUpperCase(GDConstants.LOCALE_US);
        return s;
    }

    public int getCount() {
        String s = this.ftCount.getText();
        if (s == null) {
            return 0;
        }
        if (s.isEmpty()) {
            return 0;
        }
        int i = 0;
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            i = 0;
        }
        return i;
    }

    private class ComboBoxActionListener
    implements ActionListener {
        private ComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GDItemCraftPane.this.item == null) {
                return;
            }
            if (GDItemCraftPane.this.skipCombo) {
                return;
            }
            DBAffix affix = null;
            JComboBox cb = (JComboBox)e.getSource();
            int i = cb.getSelectedIndex();
            if (i > 0) {
                affix = (DBAffix)cb.getItemAt(i);
            }
            if (cb == GDItemCraftPane.this.cbPrefix) {
                GDItemCraftPane.this.item.setPrefix(affix);
                GDItemCraftPane.this.fillSuffixCombo();
            }
            if (cb == GDItemCraftPane.this.cbSuffix) {
                GDItemCraftPane.this.item.setSuffix(affix);
                GDItemCraftPane.this.fillPrefixCombo();
            }
            if (cb == GDItemCraftPane.this.cbModifier) {
                GDItemCraftPane.this.item.setModifier(affix);
            }
            if (cb == GDItemCraftPane.this.cbCompletion) {
                GDItemCraftPane.this.item.setCompletionBonus(affix);
            }
            GDItemCraftPane.this.updateDescription();
            GDMsgLogger.showLog(GDItemCraftPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private static class AffixPermit {
        public DBAffix affix = null;
        public boolean nPre_nSuf = false;
        public boolean nPre_rSuf = false;
        public boolean rPre_nSuf = false;
        public boolean rPre_rSuf = false;
    }
}

