/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui;

import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.gdstash.item.GDItem;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;

public class GDItemInfoPane
extends JPanel {
    private JLabel lblImage;
    private JLabel lblFullName;
    private JLabel lblSet;
    private JLabel lblSeed;
    private JLabel txtFullName;
    private JLabel txtSet;
    private JLabel txtSeed;
    private JLabel txtDescription;

    public GDItemInfoPane() {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        JPanel panel = this.buildInfoPanel();
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.lblImage).addComponent(this.txtDescription).addComponent(panel));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.lblImage)).addGroup(layout.createParallelGroup().addComponent(panel)).addGroup(layout.createParallelGroup().addComponent(this.txtDescription));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, panel, this.lblImage);
        layout.linkSize(0, panel, this.txtDescription);
    }

    public void setWidth(int w) {
        int i;
        int size = 12;
        if (GDStashFrame.iniConfig != null) {
            size = GDStashFrame.iniConfig.sectUI.fontSize;
        }
        if ((i = w - 4 * size) < size) {
            i = size;
        }
        Dimension dimMax = new Dimension(i, 2 * size);
        this.txtFullName.setPreferredSize(dimMax);
        this.txtFullName.setMaximumSize(dimMax);
        this.invalidate();
        this.doLayout();
        this.repaint();
    }

    public void adjustUI() {
        int size = 12;
        if (GDStashFrame.iniConfig != null) {
            size = GDStashFrame.iniConfig.sectUI.fontSize;
        }
        Dimension dimMax = new Dimension(37 * size, 2 * size);
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        fntLabel = fntLabel.deriveFont((float)size);
        CompoundBorder compound = null;
        if (this.txtFullName == null || this.txtSet == null || this.txtSeed == null) {
            Border lowered = BorderFactory.createEtchedBorder(1);
            Border raised = BorderFactory.createEtchedBorder(0);
            compound = BorderFactory.createCompoundBorder(raised, lowered);
        }
        if (this.lblImage == null) {
            this.lblImage = new JLabel();
            this.lblImage.setBorder(compound);
            this.lblImage.setHorizontalAlignment(0);
        }
        if (this.lblFullName == null) {
            this.lblFullName = new JLabel();
        }
        this.lblFullName.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_NAME"));
        this.lblFullName.setFont(fntLabel);
        if (this.txtFullName == null) {
            this.txtFullName = new JLabel();
            this.txtFullName.setBorder(compound);
        }
        this.txtFullName.setFont(fntLabel);
        this.txtFullName.setPreferredSize(dimMax);
        this.txtFullName.setMaximumSize(dimMax);
        if (this.lblSet == null) {
            this.lblSet = new JLabel();
        }
        this.lblSet.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_SET"));
        this.lblSet.setFont(fntLabel);
        if (this.txtSet == null) {
            this.txtSet = new JLabel();
            this.txtSet.setBorder(compound);
        }
        this.txtSet.setFont(fntLabel);
        if (this.lblSeed == null) {
            this.lblSeed = new JLabel();
        }
        this.lblSeed.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_SEED"));
        this.lblSeed.setFont(fntLabel);
        if (this.txtSeed == null) {
            this.txtSeed = new JLabel();
            this.txtSeed.setBorder(compound);
        }
        this.txtSeed.setFont(fntLabel);
        if (this.txtDescription == null) {
            this.txtDescription = new JLabel();
            this.txtDescription.setBorder(compound);
        }
        this.txtDescription.setFont(fntLabel);
    }

    public void refresh() {
        this.setItemInfo(null);
    }

    private JPanel buildInfoPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.lblFullName).addComponent(this.lblSet).addComponent(this.lblSeed)).addGroup(layout.createParallelGroup().addComponent(this.txtFullName).addComponent(this.txtSet).addComponent(this.txtSeed));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.lblFullName).addComponent(this.txtFullName)).addGroup(layout.createParallelGroup().addComponent(this.lblSet).addComponent(this.txtSet)).addGroup(layout.createParallelGroup().addComponent(this.lblSeed).addComponent(this.txtSeed));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.lblFullName, this.lblSet);
        layout.linkSize(0, this.lblFullName, this.lblSeed);
        layout.linkSize(0, this.txtFullName, this.txtSet);
        layout.linkSize(0, this.txtFullName, this.txtSeed);
        layout.linkSize(1, this.lblFullName, this.txtFullName);
        layout.linkSize(1, this.lblSet, this.txtSet);
        layout.linkSize(1, this.lblSeed, this.txtSeed);
        return panel;
    }

    private void setInfo(GDItem.LabelInfo info, JLabel label) {
        if (info == null) {
            label.setText("");
        } else {
            label.setForeground(info.foreground);
            label.setText(info.text);
        }
    }

    public void setFullNameInfo(GDItem.LabelInfo info) {
        this.setInfo(info, this.txtFullName);
    }

    public void setSetInfo(GDItem.LabelInfo info) {
        this.setInfo(info, this.txtSet);
    }

    public void setSeedInfo(GDItem.LabelInfo info) {
        this.setInfo(info, this.txtSeed);
    }

    public void setDescription(String text) {
        this.txtDescription.setText(text);
    }

    public void setImage(Icon icon) {
        this.lblImage.setIcon(icon);
    }

    public void setItemInfo(GDItem item) {
        if (item == null) {
            GDItem.LabelInfo li = new GDItem.LabelInfo();
            li.text = "";
            this.setImage(null);
            this.setFullNameInfo(li);
            this.setSetInfo(li);
            this.setSeedInfo(li);
            this.setDescription("");
        } else {
            this.setImage(item.getImageIcon());
            this.setFullNameInfo(item.getCompleteNameInfo());
            this.setSetInfo(item.getItemSetNameInfo());
            this.setSeedInfo(item.getSeedHexInfo());
            String s = item.getFullDescription();
            this.setDescription(s);
        }
    }
}

