/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import org.gdstash.item.GDItem;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.table.GDItemNameSorter;
import org.gdstash.ui.table.GDItemNameTableModel;

public class GDItemNameTablePane
extends JPanel {
    private List<GDItem> data;
    private GDItemNameTableModel model;
    private JTable table;
    private GDItem selItem = null;
    private List<ActionListener> listeners = new LinkedList<ActionListener>();

    public GDItemNameTablePane(List<GDItem> list) {
        this.data = list;
        this.init();
    }

    public void adjustUI() {
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntTable = UIManager.getDefaults().getFont("TableHeader.font");
        if (fntTable == null) {
            fntTable = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntTable = fntTable.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        if (this.table == null) {
            this.table = new JTable();
            this.table.getSelectionModel().addListSelectionListener(new GDListListener());
            this.table.setSelectionMode(0);
            this.table.addMouseMotionListener(new HoverListener());
            GDItemNameSorter sorter = new GDItemNameSorter();
            this.table.setRowSorter(sorter);
            this.table.getTableHeader().addMouseListener(new SortListener());
            this.setItems(null);
        }
        this.table.getTableHeader().setFont(fntTable);
        this.table.setFont(fntLabel);
        int height = -1;
        if (this.data != null) {
            for (GDItem item : this.data) {
                BufferedImage img = item.getImage();
                if (img == null || img.getHeight() <= height) continue;
                height = img.getHeight();
            }
        }
        if (height == -1) {
            height = 12;
        }
        if (height != -1) {
            height = height * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
            this.table.setRowHeight(height);
        }
        GDItemNameTableModel model = (GDItemNameTableModel)this.table.getModel();
        model.adjustUI();
        this.updateTableColumns();
    }

    public void refresh() {
        if (this.table != null) {
            this.setItems(null);
        }
    }

    private void init() {
        this.adjustUI();
        this.setItems(this.data);
        JScrollPane scroll = new JScrollPane(this.table);
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setVerticalGroup(vGroup);
    }

    private void updateTableColumns() {
        this.table.getColumnModel().getColumn(1).setCellRenderer(new GDItemTableCellRenderer());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new GDItemTableCellRenderer());
        int scale = 100;
        int size = 12;
        if (GDStashFrame.iniConfig != null) {
            scale = GDStashFrame.iniConfig.sectUI.graphicScale;
            size = GDStashFrame.iniConfig.sectUI.fontSize;
        }
        this.table.getColumnModel().getColumn(0).setPreferredWidth(120 * scale / 100);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(42 * size);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(6 * size);
    }

    public void setItems(List<GDItem> list) {
        this.data = list;
        if (this.data != null) {
            Collections.sort(this.data);
        }
        int height = -1;
        if (this.data != null) {
            for (GDItem item : this.data) {
                BufferedImage img = item.getImage();
                if (img == null || img.getHeight() <= height) continue;
                height = img.getHeight();
            }
        }
        if (height == -1) {
            height = 12;
        }
        this.model = new GDItemNameTableModel(this.data);
        this.table.setModel(this.model);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this.table);
        GDItemNameSorter sorter = new GDItemNameSorter(this.model);
        this.table.setRowSorter(sorter);
        Rectangle rect = this.table.getVisibleRect();
        rect.setLocation(0, 0);
        this.table.scrollRectToVisible(rect);
        if (height != -1) {
            height = height * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
            this.table.setRowHeight(height);
        }
        this.updateTableColumns();
    }

    public void updateItem(GDItem item) {
        if (item == null) {
            this.deleteItem();
            return;
        }
        int pos = this.table.getSelectedRow();
        if (pos == -1) {
            return;
        }
        GDItemNameTableModel model = (GDItemNameTableModel)this.table.getModel();
        model.updateRow(pos, item);
        ListSelectionModel lsm = this.table.getSelectionModel();
        int rows = model.getRowCount();
        if (rows > 0) {
            if (rows <= pos) {
                pos = rows - 1;
            }
            lsm.setSelectionInterval(pos, pos);
            GDItem gdi = model.getItem(pos);
            this.setSelectedItem(gdi);
        } else {
            this.table.clearSelection();
            this.selItem = null;
        }
    }

    public void deleteItem() {
        int pos = this.table.getSelectedRow();
        if (pos == -1) {
            return;
        }
        GDItemNameTableModel model = (GDItemNameTableModel)this.table.getModel();
        model.removeRow(pos);
        ListSelectionModel lsm = this.table.getSelectionModel();
        int rows = model.getRowCount();
        if (rows > 0) {
            if (rows <= pos) {
                pos = rows - 1;
            }
            lsm.setSelectionInterval(pos, pos);
            GDItem item = model.getItem(pos);
            this.setSelectedItem(item);
        } else {
            this.table.clearSelection();
            this.selItem = null;
        }
    }

    public void clearSelection() {
        this.table.clearSelection();
    }

    public GDItem getSelectedItem() {
        return this.selItem;
    }

    private void setSelectedItem(GDItem item) {
        this.selItem = item;
        if (this.selItem != null && item.isStackable()) {
            this.selItem = this.selItem.clone();
            this.selItem.setStackCount(this.selItem.getDefaultStackSize());
        }
        this.fireActionEvent();
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        Iterator<ActionListener> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ActionListener l = iter.next();
            if (listener != l) continue;
            iter.remove();
        }
    }

    private void fireActionEvent() {
        ActionEvent ev = new ActionEvent(this, 1001, null);
        for (ActionListener l : this.listeners) {
            l.actionPerformed(ev);
        }
    }

    private class HoverListener
    extends MouseMotionAdapter {
        private int currRow = -1;

        private HoverListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(e.getPoint());
            if (col != 0) {
                return;
            }
            int row = table.rowAtPoint(e.getPoint());
            if (row > -1 && row < table.getRowCount() && this.currRow != row) {
                this.currRow = row;
                table.getSelectionModel().setSelectionInterval(row, row);
            }
        }
    }

    private class SortListener
    extends MouseAdapter {
        private SortListener() {
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            int idx = GDItemNameTablePane.this.table.getColumnModel().getColumnIndexAtX(ev.getX());
            GDItemNameSorter sorter = (GDItemNameSorter)GDItemNameTablePane.this.table.getRowSorter();
            sorter.sort();
        }
    }

    private class GDListListener
    implements ListSelectionListener {
        private GDListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel model = (ListSelectionModel)e.getSource();
            if (model.getValueIsAdjusting()) {
                return;
            }
            if (model.isSelectionEmpty()) {
                GDItemNameTablePane.this.setSelectedItem(null);
                return;
            }
            int min = e.getFirstIndex();
            int max = e.getLastIndex();
            int sel = -1;
            for (int i = min; i <= max; ++i) {
                if (!model.isSelectedIndex(i)) continue;
                sel = i;
                break;
            }
            GDItemNameTablePane.this.setSelectedItem(GDItemNameTablePane.this.model.getItem(sel));
        }
    }

    private class GDItemTableCellRenderer
    extends DefaultTableCellRenderer {
        private GDItemTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (col < 1) {
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            }
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            GDItemNameTableModel model = (GDItemNameTableModel)table.getModel();
            label.setForeground(model.getCellTextColor(row, col));
            return label;
        }
    }
}

