/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.gdstash.db.DBAffix;
import org.gdstash.db.DBAffixSet;
import org.gdstash.db.DBConfig;
import org.gdstash.db.DBEngineGame;
import org.gdstash.db.DBEnginePlayer;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.file.ARCDecompress;
import org.gdstash.file.ARCList;
import org.gdstash.file.IniConfig;
import org.gdstash.item.GDStash;
import org.gdstash.ui.GDCollectionPane;
import org.gdstash.ui.GDConfigPane;
import org.gdstash.ui.GDCraftPane;
import org.gdstash.ui.GDFlexDialog;
import org.gdstash.ui.GDItemCraftPane;
import org.gdstash.ui.GDLogoDialog;
import org.gdstash.ui.GDMassImportPane;
import org.gdstash.ui.GDSplashScreen;
import org.gdstash.ui.GDTabbedPane;
import org.gdstash.ui.GDTransferPane;
import org.gdstash.ui.character.GDCharEditPane;
import org.gdstash.ui.character.GDCharInventoryPane;
import org.gdstash.ui.util.GDCharInfoList;
import org.gdstash.ui.util.GDStashInfoList;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDImagePool;
import org.gdstash.util.GDLog;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class GDStashFrame
extends JFrame {
    public static final boolean debug = false;
    public static final boolean canCraft = true;
    public static final boolean canSave = true;
    public static final boolean extraItemTypes = false;
    private static final boolean logInfo = false;
    public static final boolean logDetail = false;
    private static List<String> logList;
    public static final String PROGRAM_VERSION = "v1.0.3a";
    public static final String CONFIG_VERSION = "0.9.9d";
    public static final String GDDB_VERSION = "1.0.2a";
    public static DBConfig dbConfig;
    public static IniConfig iniConfig;
    public static DBEngineGame engineGame;
    public static DBEnginePlayer enginePlayer;
    public static ARCList arcList;
    private static DefaultComboBoxModel<DBAffix> dmModifier;
    private static DefaultComboBoxModel<DBAffix> dmModifierCelestial;
    public static GDSplashScreen splash;
    private GDTabbedPane pnlTabbed;
    public GDTransferPane pnlTransfer = new GDTransferPane(GDStashInfoList.defaultStash, this);
    public GDCharInventoryPane pnlCharInventory = new GDCharInventoryPane(this);
    public GDCraftPane pnlCraft = new GDCraftPane(GDStashInfoList.defaultStash, this);
    public GDCharEditPane pnlCharEdit = new GDCharEditPane(this);
    public GDCollectionPane pnlCollection = new GDCollectionPane(this);
    public GDMassImportPane pnlMassImport = new GDMassImportPane(this);
    public GDConfigPane pnlConfig = new GDConfigPane(this);

    public static void initCraftingAffixes() {
        if (iniConfig == null) {
            return;
        }
        if (GDStashFrame.iniConfig.sectHistory == null) {
            return;
        }
        if (GDDBData.doesExist(GDStashFrame.iniConfig.sectHistory.lastMod)) {
            boolean exists = false;
            try {
                if (GDDBUtil.tableExists("GD_AFFIXSET")) {
                    exists = true;
                }
            }
            catch (SQLException ex) {
                exists = false;
            }
            if (exists) {
                List<DBAffixSet> sets = DBAffixSet.getCraftingAffixes();
                List<DBAffix> affixes = GDItemCraftPane.extractAffixes(sets);
                Collections.sort(affixes, new DBAffix.StringComparator());
                dmModifier = new DefaultComboBoxModel();
                dmModifierCelestial = new DefaultComboBoxModel();
                dmModifier.addElement(null);
                dmModifierCelestial.addElement(null);
                for (DBAffix affix : affixes) {
                    if (affix == null || affix.getAffixType() != 3) continue;
                    dmModifier.addElement(affix);
                    if (!affix.getAffixID().equals("records/items/lootaffixes/crafting/ac02_healthregen.dbr") && !affix.getAffixID().equals("records/items/lootaffixes/crafting/ad08_da.dbr") && !affix.getAffixID().equals("records/items/lootaffixes/crafting/ao14_oa.dbr")) continue;
                    dmModifierCelestial.addElement(affix);
                }
            }
        }
    }

    public static void readDBConfig(Frame frame) {
        GDLogoDialog dialog;
        DBConfig config;
        boolean exists = false;
        try {
            exists = GDDBUtil.tableExists("INFO_CONFIG");
        }
        catch (SQLException ex) {
            exists = false;
            GDMsgLogger.clear();
        }
        if (!exists) {
            try {
                GDDBData.createConfigTables();
            }
            catch (SQLException ex) {
                GDMsgLogger.addError(ex);
                while (ex.getNextException() != null) {
                    ex = ex.getNextException();
                    GDMsgLogger.addError(ex);
                }
                return;
            }
        }
        if ((config = DBConfig.get()) == null) {
            dbConfig = new DBConfig();
        } else {
            dbConfig = config;
            if (!CONFIG_VERSION.equals(config.configVer)) {
                GDStashFrame.dbConfig.configInit = false;
                GDStashFrame.dbConfig.configVer = CONFIG_VERSION;
            }
            if (!GDDB_VERSION.equals(config.gddbVer)) {
                GDStashFrame.dbConfig.gddbInit = false;
                GDStashFrame.dbConfig.gddbVer = GDDB_VERSION;
            }
        }
        if (!GDStashFrame.dbConfig.configInit && !GDStashFrame.dbConfig.gddbInit) {
            dialog = new GDLogoDialog(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_CONFIG_IMPORT"), 2, frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "INFORMATION"), true);
            dialog.setVisible(true);
        } else {
            if (!GDStashFrame.dbConfig.configInit) {
                dialog = new GDLogoDialog(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_CONFIGURE_PROG"), 2, frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "INFORMATION"), true);
                dialog.setVisible(true);
            }
            if (!GDStashFrame.dbConfig.gddbInit) {
                dialog = new GDLogoDialog(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_IMPORT_DB"), 2, frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "INFORMATION"), true);
                dialog.setVisible(true);
            }
        }
        if (!GDStashFrame.dbConfig.gddbInit) {
            return;
        }
        engineGame = DBEngineGame.get();
        DBEnginePlayer player = DBEnginePlayer.get();
        enginePlayer = player == null ? new DBEnginePlayer() : player;
    }

    public static DefaultComboBoxModel<DBAffix> getModifier() {
        DefaultComboBoxModel<DBAffix> model = new DefaultComboBoxModel<DBAffix>();
        for (int i = 0; i < dmModifier.getSize(); ++i) {
            DBAffix affix = dmModifier.getElementAt(i);
            model.addElement(affix);
        }
        return model;
    }

    public static DefaultComboBoxModel<DBAffix> getCelestialModifier() {
        DefaultComboBoxModel<DBAffix> model = new DefaultComboBoxModel<DBAffix>();
        for (int i = 0; i < dmModifierCelestial.getSize(); ++i) {
            DBAffix affix = dmModifierCelestial.getElementAt(i);
            model.addElement(affix);
        }
        return model;
    }

    public static void setGDLocale(String language, GDStashFrame frame) {
        GDMsgFormatter.setGDLocale(language);
        GDStashFrame.setGDLocale(frame);
    }

    private static void changeFontRecursive(Container root, int fontSize) {
        for (Component c : root.getComponents()) {
            Font font = c.getFont();
            font = font.deriveFont((float)fontSize);
            c.setFont(font);
            if (!(c instanceof Container)) continue;
            GDStashFrame.changeFontRecursive((Container)c, fontSize);
        }
    }

    public static void setGDLocale(GDStashFrame frame) {
        if (iniConfig != null) {
            GDStashFrame.setApplicationFont(GDStashFrame.iniConfig.sectUI.fontSize);
        }
        if (frame != null) {
            frame.adjustUI();
        }
    }

    public static void setMnemonic(AbstractButton ab, String tag) {
        String s = GDMsgFormatter.getString(GDMsgFormatter.rbUI, tag);
        if (s == null) {
            return;
        }
        if (s.isEmpty()) {
            return;
        }
        char c = s.charAt(0);
        switch (c) {
            case 'A': {
                ab.setMnemonic(65);
                break;
            }
            case 'B': {
                ab.setMnemonic(66);
                break;
            }
            case 'C': {
                ab.setMnemonic(67);
                break;
            }
            case 'D': {
                ab.setMnemonic(68);
                break;
            }
            case 'E': {
                ab.setMnemonic(69);
                break;
            }
            case 'F': {
                ab.setMnemonic(70);
                break;
            }
            case 'G': {
                ab.setMnemonic(71);
                break;
            }
            case 'H': {
                ab.setMnemonic(72);
                break;
            }
            case 'I': {
                ab.setMnemonic(73);
                break;
            }
            case 'J': {
                ab.setMnemonic(74);
                break;
            }
            case 'K': {
                ab.setMnemonic(75);
                break;
            }
            case 'L': {
                ab.setMnemonic(76);
                break;
            }
            case 'M': {
                ab.setMnemonic(77);
                break;
            }
            case 'N': {
                ab.setMnemonic(78);
                break;
            }
            case 'O': {
                ab.setMnemonic(79);
                break;
            }
            case 'P': {
                ab.setMnemonic(80);
                break;
            }
            case 'Q': {
                ab.setMnemonic(81);
                break;
            }
            case 'R': {
                ab.setMnemonic(82);
                break;
            }
            case 'S': {
                ab.setMnemonic(83);
                break;
            }
            case 'T': {
                ab.setMnemonic(84);
                break;
            }
            case 'U': {
                ab.setMnemonic(85);
                break;
            }
            case 'V': {
                ab.setMnemonic(86);
                break;
            }
            case 'W': {
                ab.setMnemonic(87);
                break;
            }
            case 'X': {
                ab.setMnemonic(88);
                break;
            }
            case 'Y': {
                ab.setMnemonic(89);
                break;
            }
            case 'Z': {
                ab.setMnemonic(90);
            }
        }
    }

    public static void messageToList(String str) {
    }

    public static void listToLog() {
    }

    public static void setApplicationFont(float size) {
        Enumeration enumer = UIManager.getDefaults().keys();
        while (enumer.hasMoreElements()) {
            Object key = enumer.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof Font)) continue;
            Font font = (Font)value;
            font = font.deriveFont(size);
            UIManager.put(key, font);
        }
    }

    public static void renameCharDir(File fDirOld, File fDirNew, GDStashFrame frame) {
        if (GDCharInfoList.gdCharFileInfos == null) {
            return;
        }
        for (GDCharInfoList.GDCharFileInfo info : GDCharInfoList.gdCharFileInfos) {
            File fDir;
            if (info.charFile == null || (fDir = info.charFile.getParentFile()) == null || !fDir.equals(fDirOld)) continue;
            try {
                File f;
                String name = info.charFile.getName();
                String s = fDirNew.getCanonicalPath() + GDConstants.FILE_SEPARATOR + name;
                info.charFile = f = new File(s);
                if (info.gdChar != null) {
                    info.gdChar.setFileDir(fDirNew);
                }
                GDCharInfoList.adjustCharInfo(info);
            }
            catch (IOException ex) {
                GDMsgLogger.addError(ex);
            }
        }
    }

    public GDStashFrame() {
        super("Grim Dawn Stash v1.0.3a");
        this.pnlTabbed = new GDTabbedPane(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new GDCloseWindowListener());
        this.addWindowStateListener(new GDWindowListener());
        this.addComponentListener(new GDResizeListener());
        if (splash != null) {
            splash.setVisible(false);
            splash.dispose();
            splash = null;
        }
        this.setIconImage(GDImagePool.iconLogo64x64.getImage());
        this.add(this.pnlTabbed);
    }

    private void adjustUI() {
        if (this.pnlTransfer != null) {
            this.pnlTransfer.adjustUI();
        }
        if (this.pnlCharInventory != null) {
            this.pnlCharInventory.adjustUI();
        }
        if (this.pnlCraft != null) {
            this.pnlCraft.adjustUI();
        }
        if (this.pnlCharEdit != null) {
            this.pnlCharEdit.adjustUI();
        }
        if (this.pnlMassImport != null) {
            this.pnlMassImport.adjustUI();
        }
        if (this.pnlCollection != null) {
            this.pnlCollection.adjustUI();
        }
        if (this.pnlConfig != null) {
            this.pnlConfig.adjustUI();
        }
        if (this.pnlTabbed != null) {
            this.pnlTabbed.adjustUI();
        }
    }

    public void refresh() {
        GDDBData.clearBuffers();
        if (this.pnlTransfer != null) {
            this.pnlTransfer.refresh();
        }
        if (this.pnlCharInventory != null) {
            this.pnlCharInventory.refresh();
        }
        if (this.pnlCraft != null) {
            this.pnlCraft.refresh();
        }
        if (this.pnlCharEdit != null) {
            this.pnlCharEdit.refresh();
        }
    }

    private void readStash(String filename) {
        if (GDStashFrame.iniConfig.sectDir.savePath == null) {
            return;
        }
        if (!GDStashFrame.dbConfig.gddbInit) {
            return;
        }
        if (filename == null) {
            return;
        }
        for (GDStashInfoList.GDStashFileInfo info : GDStashInfoList.gdStashFileInfos) {
            if (!filename.equals(info.fileName)) continue;
            if (info.gdStash == null) {
                File f = new File(filename);
                if (!f.exists()) continue;
                info.gdStash = new GDStash(f);
                if (!info.gdStash.hasStashErrors()) continue;
                info.gdStash = null;
                continue;
            }
            info.gdStash.read(null);
            if (!info.gdStash.hasStashErrors()) continue;
            info.gdStash = null;
        }
    }

    public void readStash(boolean showLog) {
        this.readStash(GDStashFrame.iniConfig.sectHistory.lastStash);
        if (showLog) {
            GDMsgLogger.showLog(this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_STASH_LOAD"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_STASH_LOAD"));
        }
    }

    private static void test() {
        String filename = "C:\\GOG Games\\Grim Dawn\\resources\\Items.arc";
        System.out.println(new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Timestamp(System.currentTimeMillis())));
        ARCDecompress arc = new ARCDecompress(filename);
        arc.writeFiles("C:\\extracted", "arc");
        System.out.println(new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Timestamp(System.currentTimeMillis())));
        ARCDecompress arc2 = new ARCDecompress(filename);
        arc2.writeFiles("C:\\extracted", "arc2");
        System.out.println(new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Timestamp(System.currentTimeMillis())));
        System.exit(0);
    }

    public static void main(String[] args) {
        GDStashFrame frame = null;
        try {
            UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
            for (int i = 0; i < info.length; ++i) {
                if (!info[i].getName().equals(GDStashFrame.iniConfig.sectUI.lookNFeel)) continue;
                UIManager.setLookAndFeel(info[i].getClassName());
                break;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (GDStashFrame.iniConfig.sectRestrict.affixCombi == 3) {
                DBAffix.fillBuffer();
            }
            frame = new GDStashFrame();
            frame.setLocation(GDStashFrame.iniConfig.sectWindow.x, GDStashFrame.iniConfig.sectWindow.y);
            if (GDStashFrame.iniConfig.sectWindow.maximized) {
                frame.setExtendedState(frame.getExtendedState() | 6);
            } else {
                frame.setSize(GDStashFrame.iniConfig.sectWindow.w, GDStashFrame.iniConfig.sectWindow.h);
            }
            frame.setVisible(true);
            GDMsgLogger.showLog(frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "MESSAGES"), 2, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"), false, false);
        }
        catch (Exception ex) {
            if (frame == null) {
                String s = null;
                s = ex.getMessage() == null || ex.getMessage().isEmpty() ? ex.toString() : ex.getMessage();
                if (s == null) {
                    s = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_UNEXPECTED");
                }
                JOptionPane.showMessageDialog(null, s, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERROR"), 0);
                System.exit(1);
            }
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_EXCEPTION"));
            GDMsgLogger.addError(ex);
            GDMsgLogger.showLog(frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCCESS"), 3, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERROR"));
            System.exit(1);
        }
    }

    static {
        dbConfig = null;
        iniConfig = null;
        engineGame = null;
        enginePlayer = null;
        GDStashFrame.setGDLocale("English", null);
        iniConfig = IniConfig.get();
        GDImagePool.loadLogos();
        GDImagePool.loadImages();
        try {
            GDDBData.createConfigTables();
        }
        catch (SQLException ex) {
            System.out.println(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_INIT_DB"));
            System.out.println(ex.getMessage());
            while (ex.getNextException() != null) {
                ex = ex.getNextException();
                System.out.println(ex.getMessage());
            }
            System.exit(1);
        }
        GDStashFrame.readDBConfig(null);
        GDStashFrame.setGDLocale(GDStashFrame.iniConfig.sectUI.language, null);
        GDLog logStash = new GDLog();
        GDStashInfoList.findStashes(null, null, logStash);
        GDCharInfoList.findChars(null, null);
        splash = GDStashFrame.dbConfig.configInit && GDStashFrame.dbConfig.gddbInit ? new GDSplashScreen() : null;
        GDImagePool.loadTiles();
        try {
            Class.forName("com.jgoodies.looks.plastic.PlasticLookAndFeel", false, ClassLoader.getSystemClassLoader());
            UIManager.installLookAndFeel("Plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel");
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        try {
            Class.forName("com.jgoodies.looks.plastic.PlasticXPLookAndFeel", false, ClassLoader.getSystemClassLoader());
            UIManager.installLookAndFeel("Plastic XP", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        try {
            Class.forName("com.jgoodies.looks.plastic.Plastic3DLookAndFeel", false, ClassLoader.getSystemClassLoader());
            UIManager.installLookAndFeel("Plastic 3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        try {
            Class.forName("com.seaglasslookandfeel.SeaGlassLookAndFeel", false, ClassLoader.getSystemClassLoader());
            UIManager.installLookAndFeel("SeaGlass", "com.seaglasslookandfeel.SeaGlassLookAndFeel");
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        try {
            Class.forName("ch.randelshofer.quaqua.QuaquaLookAndFeel", false, ClassLoader.getSystemClassLoader());
            UIManager.installLookAndFeel("Quaga", "ch.randelshofer.quaqua.QuaquaLookAndFeel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        GDStashFrame.initCraftingAffixes();
        GDMsgLogger.clear();
        if (logStash.containsMessages()) {
            logStash.addWarning(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_STASH_ITEMS_REMOVED"));
            GDMsgLogger.addLog(logStash);
        }
    }

    private class GDResizeListener
    extends ComponentAdapter {
        private GDResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            boolean maximized;
            JFrame frame = (JFrame)e.getComponent();
            boolean bl = maximized = (frame.getExtendedState() & 6) == 6;
            if (!maximized) {
                GDStashFrame.iniConfig.sectWindow.x = frame.getX();
                GDStashFrame.iniConfig.sectWindow.y = frame.getY();
                GDStashFrame.iniConfig.sectWindow.w = frame.getWidth();
                GDStashFrame.iniConfig.sectWindow.h = frame.getHeight();
            }
        }
    }

    private class GDWindowListener
    implements WindowStateListener {
        private GDWindowListener() {
        }

        @Override
        public void windowStateChanged(WindowEvent e) {
            if (e.getNewState() == 0) {
                Window w = e.getWindow();
                w.setLocation(GDStashFrame.iniConfig.sectWindow.x, GDStashFrame.iniConfig.sectWindow.y);
                w.setSize(GDStashFrame.iniConfig.sectWindow.w, GDStashFrame.iniConfig.sectWindow.h);
            }
        }
    }

    private class GDCloseWindowListener
    extends WindowAdapter {
        private GDCloseWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            boolean stashChanges = false;
            boolean charChanges = false;
            if (GDStashInfoList.gdStashFileInfos != null) {
                for (GDStashInfoList.GDStashFileInfo gDStashFileInfo : GDStashInfoList.gdStashFileInfos) {
                    if (gDStashFileInfo.gdStash == null || !gDStashFileInfo.gdStash.hasChanged()) continue;
                    stashChanges = true;
                    break;
                }
            }
            if (GDCharInfoList.gdCharFileInfos != null) {
                for (GDCharInfoList.GDCharFileInfo gDCharFileInfo : GDCharInfoList.gdCharFileInfos) {
                    if (gDCharFileInfo.gdChar == null || !gDCharFileInfo.gdChar.hasChanged()) continue;
                    charChanges = true;
                    break;
                }
            }
            if (stashChanges || charChanges) {
                int i = 0;
                JButton[] jButtonArray = new JButton[]{new JButton(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_SAVE"), GDImagePool.iconBtnSave24), new JButton(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_QUIT"), GDImagePool.iconBtnCancel24)};
                String tag = null;
                tag = stashChanges && charChanges ? "TXT_SAVE_CHANGES_ALL" : (stashChanges ? "TXT_SAVE_CHANGES_STASH" : "TXT_SAVE_CHANGES_CHAR");
                i = GDFlexDialog.showDialog(GDMsgFormatter.getString(GDMsgFormatter.rbUI, tag), jButtonArray, 2, null, true);
                if (i == -1) {
                    return;
                }
                if (i == 0) {
                    boolean success = true;
                    if (stashChanges && GDStashInfoList.gdStashFileInfos != null) {
                        for (GDStashInfoList.GDStashFileInfo gDStashFileInfo : GDStashInfoList.gdStashFileInfos) {
                            if (gDStashFileInfo.gdStash == null || !gDStashFileInfo.gdStash.hasChanged()) continue;
                            try {
                                gDStashFileInfo.gdStash.write();
                            }
                            catch (Exception ex) {
                                GDMsgLogger.addError(ex);
                                success = false;
                            }
                        }
                    }
                    if (charChanges && GDCharInfoList.gdCharFileInfos != null) {
                        for (GDCharInfoList.GDCharFileInfo gDCharFileInfo : GDCharInfoList.gdCharFileInfos) {
                            if (gDCharFileInfo.gdChar == null || !gDCharFileInfo.gdChar.hasChanged()) continue;
                            try {
                                gDCharFileInfo.gdChar.write();
                            }
                            catch (Exception ex) {
                                GDMsgLogger.addError(ex);
                                success = false;
                            }
                        }
                    }
                    if (!success) {
                        GDMsgLogger.showLog(GDStashFrame.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCCESS"), 3, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERROR"));
                        return;
                    }
                }
            }
            GDStashFrame frame = (GDStashFrame)e.getSource();
            boolean bl = GDStashFrame.iniConfig.sectWindow.maximized = (frame.getExtendedState() & 6) == 6;
            if (!GDStashFrame.iniConfig.sectWindow.maximized) {
                GDStashFrame.iniConfig.sectWindow.x = frame.getX();
                GDStashFrame.iniConfig.sectWindow.y = frame.getY();
                GDStashFrame.iniConfig.sectWindow.w = frame.getWidth();
                GDStashFrame.iniConfig.sectWindow.h = frame.getHeight();
            }
            iniConfig.writeWindowSection();
            frame.setDefaultCloseOperation(3);
        }
    }
}

