/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.gdstash.db.DBStashItem;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.item.GDItem;
import org.gdstash.ui.GDItemInfoPane;
import org.gdstash.ui.GDItemNameTablePane;
import org.gdstash.ui.GDSearchDialog;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.GDUISearch;
import org.gdstash.ui.GDUITransfer;
import org.gdstash.ui.stash.GDContainerMapPane;
import org.gdstash.ui.stash.GDSharedStashPane;
import org.gdstash.ui.util.GDCharInfoList;
import org.gdstash.ui.util.GDStashInfoList;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDImagePool;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class GDTransferPane
extends JPanel
implements GDUITransfer,
GDUISearch {
    private static final int STASHTYPE_UNKNOWN = 0;
    private static final int STASHTYPE_SOFTCORE = 1;
    private static final int STASHTYPE_HARDCORE = 2;
    private GDStashFrame frame;
    private GDSharedStashPane pnlStash;
    private GDItemInfoPane pnlInfo;
    private JButton btnDBCopy;
    private JButton btnDBMove;
    private JButton btnDBDel;
    private JButton btnStashDel;
    private JButton btnPageCopy;
    private JButton btnPageMove;
    private JButton btnPageDel;
    private JButton btnReload;
    private JButton btnFileSave;
    private GDItemNameTablePane pnlTable;
    private JButton btnSearch;
    private GDStashInfoList.GDStashFileInfo info;
    private GDItem selItem;
    private int location;
    private JPanel pnlMain;
    private GDSearchDialog dlgSearch;
    private int stashType;

    public GDTransferPane(GDStashInfoList.GDStashFileInfo info, GDStashFrame frame) {
        this.info = info;
        this.frame = frame;
        this.determineStashType();
        this.selItem = null;
        this.location = 0;
        this.dlgSearch = null;
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        this.pnlMain = this.buildMainPanel();
        JScrollPane scroll = new JScrollPane(this.pnlMain);
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setVerticalGroup(vGroup);
    }

    public void adjustUI() {
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntButton = UIManager.getDefaults().getFont("Button.font");
        if (fntButton == null) {
            fntButton = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntButton = fntButton.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        if (this.btnFileSave == null) {
            this.btnFileSave = new JButton();
            this.btnFileSave.setEnabled(false);
            this.btnFileSave.addActionListener(new FileSaveActionListener());
        }
        this.btnFileSave.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_STASH_SAVE"));
        this.btnFileSave.setIcon(GDImagePool.iconBtnSave24);
        this.btnFileSave.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnFileSave, "MNC_STASH_SAVE");
        if (this.btnDBDel == null) {
            this.btnDBDel = new JButton();
            this.btnDBDel.setEnabled(false);
            this.btnDBDel.addActionListener(new DBDelActionListener());
        }
        this.btnDBDel.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_ITEM_DEL_DB"));
        this.btnDBDel.setIcon(GDImagePool.iconDBDelete24);
        this.btnDBDel.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnDBDel, "MNC_ITEM_DEL_DB");
        if (this.btnDBCopy == null) {
            this.btnDBCopy = new JButton();
            this.btnDBCopy.setEnabled(false);
            this.btnDBCopy.addActionListener(new DBCopyActionListener());
        }
        this.btnDBCopy.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_ITEM_COPY_DB"));
        this.btnDBCopy.setIcon(GDImagePool.iconItemCopy24);
        this.btnDBCopy.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnDBCopy, "MNC_ITEM_COPY_DB");
        if (this.btnDBMove == null) {
            this.btnDBMove = new JButton();
            this.btnDBMove.setEnabled(false);
            this.btnDBMove.addActionListener(new DBMoveActionListener());
        }
        this.btnDBMove.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_ITEM_MOVE_DB"));
        this.btnDBMove.setIcon(GDImagePool.iconItemMove24);
        this.btnDBMove.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnDBMove, "MNC_ITEM_MOVE_DB");
        if (this.btnPageCopy == null) {
            this.btnPageCopy = new JButton();
            this.btnPageCopy.setEnabled(true);
            this.btnPageCopy.addActionListener(new PageCopyActionListener());
        }
        this.btnPageCopy.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_PAGE_COPY_DB"));
        this.btnPageCopy.setIcon(GDImagePool.iconPageCopy24);
        this.btnPageCopy.setFont(fntButton);
        if (this.btnPageMove == null) {
            this.btnPageMove = new JButton();
            this.btnPageMove.setEnabled(true);
            this.btnPageMove.addActionListener(new PageMoveActionListener());
        }
        this.btnPageMove.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_PAGE_MOVE_DB"));
        this.btnPageMove.setIcon(GDImagePool.iconPageMove24);
        this.btnPageMove.setFont(fntButton);
        if (this.btnStashDel == null) {
            this.btnStashDel = new JButton();
            this.btnStashDel.setEnabled(false);
            this.btnStashDel.addActionListener(new StashDelActionListener());
        }
        this.btnStashDel.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_ITEM_DEL_STASH"));
        this.btnStashDel.setIcon(GDImagePool.iconItemDelete24);
        this.btnStashDel.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnStashDel, "MNC_ITEM_DEL_STASH");
        if (this.btnPageDel == null) {
            this.btnPageDel = new JButton();
            this.btnPageDel.setEnabled(true);
            this.btnPageDel.addActionListener(new PageDelActionListener());
        }
        this.btnPageDel.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_PAGE_DEL"));
        this.btnPageDel.setIcon(GDImagePool.iconPageDelete24);
        this.btnPageDel.setFont(fntButton);
        if (this.btnSearch == null) {
            this.btnSearch = new JButton();
            this.btnSearch.addActionListener(new SearchItemsListener());
        }
        this.btnSearch.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_SEARCH"));
        this.btnSearch.setIcon(GDImagePool.iconBtnSearch24);
        this.btnSearch.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnSearch, "MNC_SEARCH_SECOND");
        if (this.btnReload == null) {
            this.btnReload = new JButton();
            this.btnReload.addActionListener(new StashReloadActionListener());
        }
        this.btnReload.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_RELOAD"));
        this.btnReload.setIcon(GDImagePool.iconBtnReload24);
        this.btnReload.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnReload, "MNC_RELOAD");
        if (this.pnlInfo == null) {
            this.pnlInfo = new GDItemInfoPane();
        }
        this.pnlInfo.adjustUI();
        if (this.pnlTable == null) {
            this.pnlTable = new GDItemNameTablePane(null);
            this.pnlTable.addActionListener(new TableActionListener());
            this.pnlTable.setMinimumSize(new Dimension(300, 200));
            this.pnlTable.setMaximumSize(new Dimension(600, 2000));
        } else {
            this.pnlTable.adjustUI();
        }
        if (this.pnlStash == null) {
            this.pnlStash = new GDSharedStashPane(this.info, this.frame, this);
        } else {
            this.pnlStash.adjustUI();
        }
    }

    public void refresh() {
        if (this.pnlTable != null) {
            this.pnlTable.refresh();
        }
        if (this.pnlInfo != null) {
            this.pnlInfo.refresh();
        }
        if (this.pnlStash != null) {
            this.pnlStash.refresh();
        }
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel pnlTable = this.buildTablePanel();
        JPanel pnlItemInfo = this.buildInfoPanel();
        JPanel pnlStash = this.buildStashPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(pnlTable)).addGroup(layout.createParallelGroup().addComponent(pnlItemInfo)).addGroup(layout.createParallelGroup().addComponent(pnlStash));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(pnlTable).addComponent(pnlItemInfo).addComponent(pnlStash));
        layout.setVerticalGroup(vGroup);
        return panel;
    }

    private JPanel buildTablePanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.btnSearch).addComponent(this.pnlTable));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.btnSearch)).addGroup(layout.createParallelGroup().addComponent(this.pnlTable));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.btnSearch, this.pnlTable);
        return panel;
    }

    private JPanel buildStashPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.btnReload).addComponent(this.pnlStash));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.btnReload)).addGroup(layout.createParallelGroup().addComponent(this.pnlStash));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.btnReload, this.pnlStash);
        return panel;
    }

    private JPanel buildInfoPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        JPanel pnlButton = this.buildButtonPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.btnFileSave).addComponent(pnlButton).addComponent(this.pnlInfo));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.btnFileSave)).addGroup(layout.createParallelGroup().addComponent(pnlButton)).addGroup(layout.createParallelGroup().addComponent(this.pnlInfo));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.btnFileSave, pnlButton);
        layout.linkSize(0, this.btnFileSave, this.pnlInfo);
        return panel;
    }

    private JPanel buildButtonPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.btnDBCopy).addComponent(this.btnDBMove).addComponent(this.btnStashDel).addComponent(this.btnDBDel)).addGroup(layout.createParallelGroup().addComponent(this.btnPageCopy).addComponent(this.btnPageMove).addComponent(this.btnPageDel));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.btnDBCopy).addComponent(this.btnPageCopy)).addGroup(layout.createParallelGroup().addComponent(this.btnDBMove).addComponent(this.btnPageMove)).addGroup(layout.createParallelGroup().addComponent(this.btnStashDel).addComponent(this.btnPageDel)).addGroup(layout.createParallelGroup().addComponent(this.btnDBDel));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.btnDBCopy, this.btnDBMove);
        layout.linkSize(0, this.btnDBCopy, this.btnStashDel);
        layout.linkSize(0, this.btnDBCopy, this.btnDBDel);
        layout.linkSize(0, this.btnDBCopy, this.btnPageCopy);
        layout.linkSize(0, this.btnDBCopy, this.btnPageMove);
        layout.linkSize(0, this.btnDBCopy, this.btnPageDel);
        layout.linkSize(1, this.btnDBCopy, this.btnDBMove);
        layout.linkSize(1, this.btnDBCopy, this.btnStashDel);
        layout.linkSize(1, this.btnDBCopy, this.btnDBDel);
        layout.linkSize(1, this.btnDBCopy, this.btnPageCopy);
        layout.linkSize(1, this.btnDBCopy, this.btnPageMove);
        layout.linkSize(1, this.btnDBCopy, this.btnPageDel);
        return panel;
    }

    private JPanel buildButtonGridPanel() {
        GridLayout layout = null;
        JPanel panel = new JPanel();
        layout = new GridLayout(4, 2, 10, 10);
        panel.setLayout(layout);
        panel.add(this.btnDBCopy);
        panel.add(this.btnPageCopy);
        panel.add(this.btnDBMove);
        panel.add(this.btnPageMove);
        panel.add(this.btnStashDel);
        panel.add(this.btnPageDel);
        panel.add(this.btnDBDel);
        return panel;
    }

    private void determineStashType() {
        this.stashType = 0;
        if (this.info != null && this.info.gdStash != null) {
            this.stashType = this.info.gdStash.isHardcore() ? 2 : 1;
        }
    }

    public void clearSelItems() {
        this.pnlInfo.setItemInfo(null);
        this.pnlTable.setItems(null);
    }

    public void updateStash() {
        this.pnlStash.layoutStash();
        this.pnlStash.updateModSelection();
    }

    public void updateItemSets() {
        if (this.dlgSearch != null) {
            this.dlgSearch.updateItemSets();
        }
    }

    public void refreshStashSelection() {
        this.pnlStash.refreshStashSelection();
    }

    public void setStashInfo(GDStashInfoList.GDStashFileInfo info) {
        this.info = info;
        if (this.pnlStash != null) {
            this.pnlStash.setStash(info);
        }
    }

    public void refreshStashInfo(GDStashInfoList.GDStashFileInfo info) {
        if (info == null) {
            return;
        }
        if (this.info == null) {
            return;
        }
        if (this.info.fileName.equals(info.fileName)) {
            this.info = info;
            if (this.pnlStash != null) {
                this.pnlStash.setStash(info);
            }
        }
    }

    public boolean updateStashFile() {
        if (this.info == null) {
            return false;
        }
        if (this.info.gdStash == null) {
            return false;
        }
        if (GDStashFrame.iniConfig == null) {
            return false;
        }
        if (GDStashFrame.iniConfig.sectDir.savePath == null) {
            return false;
        }
        try {
            String dir;
            String stashMod = this.info.gdStash.getModName();
            if (stashMod == null) {
                stashMod = "";
            }
            if (stashMod.equals(dir = (dir = this.info.gdStash.getFile().getParentFile().getCanonicalPath()).length() >= GDStashFrame.iniConfig.sectDir.savePath.length() ? dir.substring(GDStashFrame.iniConfig.sectDir.savePath.length()) : "")) {
                return false;
            }
            dir = GDStashFrame.iniConfig.sectDir.savePath;
            if (!dir.endsWith(GDConstants.FILE_SEPARATOR)) {
                dir = dir + GDConstants.FILE_SEPARATOR;
            }
            if (!stashMod.equals("")) {
                dir = dir + stashMod + GDConstants.FILE_SEPARATOR;
            }
            dir = this.info.gdStash.isHardcore() ? dir + "transfer.gsh" : dir + "transfer.gst";
            File file = new File(dir);
            this.info.gdStash.setFile(file);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void setChar(GDCharInfoList.GDCharFileInfo info) {
    }

    @Override
    public void setStash(GDStashInfoList.GDStashFileInfo info) {
        if (this.info == info) {
            return;
        }
        this.info = info;
        int oldStashType = this.stashType;
        this.determineStashType();
        if (!GDStashFrame.iniConfig.sectRestrict.transferSCHC && oldStashType != 0 && oldStashType != this.stashType) {
            this.pnlTable.setItems(null);
        }
        this.checkSaveButton();
    }

    @Override
    public int getItemLocation() {
        return this.location;
    }

    @Override
    public GDItem getSelectedItem() {
        return this.selItem;
    }

    @Override
    public void setSelectedItem(GDItem item, int location) {
        if (location == 1) {
            this.pnlTable.clearSelection();
        }
        this.selItem = item;
        this.location = location;
        this.pnlInfo.setItemInfo(item);
        switch (location) {
            case 1: {
                this.btnDBCopy.setEnabled(item != null);
                this.btnDBMove.setEnabled(item != null);
                this.btnStashDel.setEnabled(item != null);
                this.btnDBDel.setEnabled(false);
                this.btnPageCopy.setEnabled(true);
                this.btnPageMove.setEnabled(true);
                this.btnPageDel.setEnabled(true);
                break;
            }
            case 2: {
                this.btnDBCopy.setEnabled(false);
                this.btnDBMove.setEnabled(false);
                this.btnStashDel.setEnabled(false);
                this.btnDBDel.setEnabled(item != null);
                this.btnPageCopy.setEnabled(false);
                this.btnPageMove.setEnabled(false);
                this.btnPageDel.setEnabled(false);
                break;
            }
            default: {
                this.btnDBCopy.setEnabled(false);
                this.btnDBMove.setEnabled(false);
                this.btnStashDel.setEnabled(false);
                this.btnDBDel.setEnabled(false);
                this.btnPageCopy.setEnabled(true);
                this.btnPageMove.setEnabled(true);
                this.btnPageDel.setEnabled(true);
            }
        }
    }

    @Override
    public void transferSelectedItem(int action, int x, int y) {
        switch (action) {
            case 1: {
                GDItem item;
                if (this.location != 1 || (item = this.pnlStash.getSelectedItem()) == null) break;
                this.pnlStash.moveSelectedItem(1, x, y);
                this.btnFileSave.setEnabled(this.info.gdStash.hasChanged());
                break;
            }
            case 2: {
                if (this.location != 1) break;
                boolean success = DBStashItem.storeItem(this.selItem);
                if (success) {
                    this.setSelectedItem(null, 0);
                }
                GDMsgLogger.showLog(this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_ITEM_STORED"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_ITEM_STORED"));
                break;
            }
            case 3: {
                if (this.location != 1) break;
                boolean success = DBStashItem.storeItem(this.selItem);
                if (success) {
                    this.pnlStash.deleteSelectedItem(3);
                    this.setSelectedItem(null, 0);
                    this.btnFileSave.setEnabled(this.info.gdStash.hasChanged());
                }
                GDMsgLogger.showLog(this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_ITEM_STORED"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_ITEM_STORED"));
                break;
            }
            case 4: {
                if (this.location != 2) break;
                boolean success = this.pnlStash.addItem(this.selItem, 4, x, y);
                if (success && GDStashFrame.iniConfig.sectRestrict.dbStashMove) {
                    this.transferSelectedItem(5, x, y);
                }
                this.btnFileSave.setEnabled(this.info.gdStash.hasChanged());
                break;
            }
            case 5: {
                if (this.location != 2) break;
                boolean success = DBStashItem.delete(this.selItem);
                if (success) {
                    if (this.selItem.isStackable()) {
                        GDItem item = DBStashItem.getStack(this.selItem);
                        this.pnlTable.updateItem(item);
                    } else {
                        this.pnlTable.deleteItem();
                    }
                    this.setSelectedItem(this.pnlTable.getSelectedItem(), 2);
                }
                GDMsgLogger.showLog(this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_ITEM_DELETED"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_ITEM_DELETED"));
                break;
            }
            case 6: {
                GDItem item;
                if (this.location != 1 || (item = this.getSelectedItem()) == null) break;
                this.pnlStash.deleteSelectedItem(6);
                this.setSelectedItem(null, 0);
                this.btnFileSave.setEnabled(this.info.gdStash.hasChanged());
                break;
            }
            case 7: {
                if (this.location != 1 && this.location != 0) break;
                GDContainerMapPane page = this.pnlStash.getCurrentPage();
                if (page == null) {
                    return;
                }
                List<GDItem> items = page.getItemList(7);
                for (GDItem item : items) {
                    DBStashItem.storeItem(item);
                }
                GDMsgLogger.showLog(this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_ITEM_STORED"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_ITEM_STORED"));
                break;
            }
            case 8: {
                if (this.location != 1 && this.location != 0) break;
                GDContainerMapPane page = this.pnlStash.getCurrentPage();
                if (page == null) {
                    return;
                }
                List<GDItem> items = page.getItemList(8);
                for (GDItem item : items) {
                    boolean success = DBStashItem.storeItem(item);
                    if (!success) continue;
                    page.deleteItem(item, 8, false);
                }
                page.layoutContainers();
                this.setSelectedItem(null, 0);
                this.btnFileSave.setEnabled(this.info.gdStash.hasChanged());
                GDMsgLogger.showLog(this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_ITEM_STORED"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_ITEM_STORED"));
                break;
            }
            case 9: {
                if (this.location != 1 && this.location != 0) break;
                GDContainerMapPane page = this.pnlStash.getCurrentPage();
                if (page == null) {
                    return;
                }
                List<GDItem> items = page.getItemList(9);
                for (GDItem item : items) {
                    page.deleteItem(item, 9, false);
                }
                page.layoutContainers();
                this.setSelectedItem(null, 0);
                this.btnFileSave.setEnabled(this.info.gdStash.hasChanged());
                GDMsgLogger.showLog(this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_ITEM_DELETED"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_ITEM_DELETED"));
            }
        }
    }

    @Override
    public void checkSaveButton() {
        if (this.info == null) {
            this.btnFileSave.setEnabled(false);
        } else if (this.info.gdStash == null) {
            this.btnFileSave.setEnabled(false);
        } else {
            this.btnFileSave.setEnabled(this.info.gdStash.hasChanged());
        }
    }

    @Override
    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public void search(SelectionCriteria criteria) {
        if (this.info == null) {
            return;
        }
        if (this.info.gdStash == null) {
            return;
        }
        boolean hardcore = this.info.gdStash.isHardcore();
        criteria.noEnemyOnly = true;
        List<GDItem> items = DBStashItem.getGDItemByCriteria(criteria, hardcore, "");
        this.pnlTable.setItems(items);
        GDMsgLogger.showLog(this, GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_SEARCH"));
    }

    private class SearchItemsListener
    implements ActionListener {
        private SearchItemsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GDTransferPane.this.dlgSearch == null) {
                GDTransferPane.this.dlgSearch = new GDSearchDialog((Frame)GDTransferPane.this.frame, GDTransferPane.this);
            }
            GDTransferPane.this.dlgSearch.setVisible(true);
        }
    }

    private class FileSaveActionListener
    implements ActionListener {
        private FileSaveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (GDTransferPane.this.info == null) {
                return;
            }
            if (((GDTransferPane)GDTransferPane.this).info.gdStash == null) {
                return;
            }
            boolean success = false;
            try {
                boolean update = GDTransferPane.this.updateStashFile();
                ((GDTransferPane)GDTransferPane.this).info.gdStash.write();
                if (update) {
                    GDTransferPane.this.info.setFile(((GDTransferPane)GDTransferPane.this).info.gdStash.getFile());
                    GDStashFrame.iniConfig.sectHistory.lastStash = ((GDTransferPane)GDTransferPane.this).info.fileName;
                    GDTransferPane.this.btnReload.doClick();
                }
                success = true;
            }
            catch (IOException ex) {
                GDMsgLogger.addError(ex);
            }
            if (success) {
                GDTransferPane.this.btnFileSave.setEnabled(((GDTransferPane)GDTransferPane.this).info.gdStash.hasChanged());
            }
            GDMsgLogger.showLog(GDTransferPane.this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_STASH_SAVE"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_STASH_SAVE"));
        }
    }

    private class PageDelActionListener
    implements ActionListener {
        private PageDelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (GDTransferPane.this.pnlStash.getCurrentPage() == null) {
                return;
            }
            GDTransferPane.this.transferSelectedItem(9, 0, 0);
            GDMsgLogger.showLog(GDTransferPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class StashDelActionListener
    implements ActionListener {
        private StashDelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            GDTransferPane.this.transferSelectedItem(6, 0, 0);
            GDMsgLogger.showLog(GDTransferPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class PageMoveActionListener
    implements ActionListener {
        private PageMoveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (GDTransferPane.this.pnlStash.getCurrentPage() == null) {
                return;
            }
            GDTransferPane.this.transferSelectedItem(8, 0, 0);
            GDMsgLogger.showLog(GDTransferPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class PageCopyActionListener
    implements ActionListener {
        private PageCopyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (GDTransferPane.this.pnlStash.getCurrentPage() == null) {
                return;
            }
            GDTransferPane.this.transferSelectedItem(7, 0, 0);
            GDMsgLogger.showLog(GDTransferPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class DBMoveActionListener
    implements ActionListener {
        private DBMoveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            GDItem item = GDTransferPane.this.getSelectedItem();
            if (item == null) {
                return;
            }
            GDTransferPane.this.transferSelectedItem(3, 0, 0);
            GDMsgLogger.showLog(GDTransferPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class DBCopyActionListener
    implements ActionListener {
        private DBCopyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            GDItem item = GDTransferPane.this.getSelectedItem();
            if (item == null) {
                return;
            }
            GDTransferPane.this.transferSelectedItem(2, 0, 0);
            GDMsgLogger.showLog(GDTransferPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class DBDelActionListener
    implements ActionListener {
        private DBDelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            GDItem item = GDTransferPane.this.pnlTable.getSelectedItem();
            if (item == null) {
                return;
            }
            GDTransferPane.this.transferSelectedItem(5, 0, 0);
            GDMsgLogger.showLog(GDTransferPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class StashReloadActionListener
    implements ActionListener {
        private StashReloadActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            GDStashInfoList.findStashes(GDTransferPane.this.frame, GDTransferPane.this.info, null);
            if (GDTransferPane.this.info != null) {
                for (GDStashInfoList.GDStashFileInfo si : GDStashInfoList.gdStashFileInfos) {
                    if (!si.fileName.equals(((GDTransferPane)GDTransferPane.this).info.fileName)) continue;
                    GDTransferPane.this.info = si;
                    break;
                }
            }
            if (((GDTransferPane)GDTransferPane.this).frame.pnlTransfer != null) {
                ((GDTransferPane)GDTransferPane.this).frame.pnlTransfer.refreshStashInfo(GDTransferPane.this.info);
            }
            if (((GDTransferPane)GDTransferPane.this).frame.pnlCraft != null) {
                ((GDTransferPane)GDTransferPane.this).frame.pnlCraft.refreshStashInfo(GDTransferPane.this.info);
            }
            GDMsgLogger.showLog(GDTransferPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "MESSAGES"), 2, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"), false, false);
        }
    }

    private class TableActionListener
    implements ActionListener {
        private TableActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            GDItem item = GDTransferPane.this.pnlTable.getSelectedItem();
            GDTransferPane.this.setSelectedItem(item, 2);
            GDMsgLogger.showLog(GDTransferPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }
}

