/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.character;

import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DocumentFilter;
import org.gdstash.character.GDChar;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.select.CharLenDocFilter;
import org.gdstash.ui.select.IntLenDocFilter;
import org.gdstash.util.GDMsgFormatter;

public class GDCharDataPane
extends JPanel {
    public static final int SEL_SEX_FEMALE = 0;
    public static final int SEL_SEX_MALE = 1;
    public static final int SEL_DIFFICULTY_NORMAL = 0;
    public static final int SEL_DIFFICULTY_ELITE = 1;
    public static final int SEL_DIFFICULTY_ULTIMATE = 2;
    private static String[] sexes = null;
    private static String[] difficulties = null;
    private JLabel lblCharName;
    private JLabel lblMod;
    private JLabel lblSex;
    private JLabel lblHardcore;
    private JLabel lblDeaths;
    private JLabel lblMaxDifficulty;
    private JLabel lblExperience;
    private JLabel lblLevel;
    private JLabel lblMoney;
    private JFormattedTextField ftCharName;
    private JCheckBox cbMod;
    private JComboBox<String> cbSex;
    private JCheckBox cbHardcore;
    private JTextField ftDeaths;
    private JComboBox<String> cbMaxDifficulty;
    private JTextField ftExperience;
    private JTextField ftLevel;
    private JTextField ftMoney;
    private JPanel pnlMain;

    public GDCharDataPane() {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.lblCharName).addComponent(this.lblMod).addComponent(this.lblSex).addComponent(this.lblHardcore).addComponent(this.lblDeaths).addComponent(this.lblMaxDifficulty).addComponent(this.lblExperience).addComponent(this.lblLevel).addComponent(this.lblMoney)).addGroup(layout.createParallelGroup().addComponent(this.ftCharName).addComponent(this.cbMod).addComponent(this.cbSex).addComponent(this.cbHardcore).addComponent(this.ftDeaths).addComponent(this.cbMaxDifficulty).addComponent(this.ftExperience).addComponent(this.ftLevel).addComponent(this.ftMoney));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.lblCharName).addComponent(this.ftCharName)).addGroup(layout.createParallelGroup().addComponent(this.lblMod).addComponent(this.cbMod)).addGroup(layout.createParallelGroup().addComponent(this.lblSex).addComponent(this.cbSex)).addGroup(layout.createParallelGroup().addComponent(this.lblHardcore).addComponent(this.cbHardcore)).addGroup(layout.createParallelGroup().addComponent(this.lblDeaths).addComponent(this.ftDeaths)).addGroup(layout.createParallelGroup().addComponent(this.lblMaxDifficulty).addComponent(this.cbMaxDifficulty)).addGroup(layout.createParallelGroup().addComponent(this.lblExperience).addComponent(this.ftExperience)).addGroup(layout.createParallelGroup().addComponent(this.lblLevel).addComponent(this.ftLevel)).addGroup(layout.createParallelGroup().addComponent(this.lblMoney).addComponent(this.ftMoney));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.lblCharName, this.lblMod);
        layout.linkSize(0, this.lblCharName, this.lblSex);
        layout.linkSize(0, this.lblCharName, this.lblHardcore);
        layout.linkSize(0, this.lblCharName, this.lblDeaths);
        layout.linkSize(0, this.lblCharName, this.lblMaxDifficulty);
        layout.linkSize(0, this.lblCharName, this.lblExperience);
        layout.linkSize(0, this.lblCharName, this.lblLevel);
        layout.linkSize(0, this.lblCharName, this.lblMoney);
        layout.linkSize(0, this.lblCharName, this.ftCharName);
        layout.linkSize(0, this.lblCharName, this.cbMod);
        layout.linkSize(0, this.lblCharName, this.cbSex);
        layout.linkSize(0, this.lblCharName, this.cbHardcore);
        layout.linkSize(0, this.lblCharName, this.ftDeaths);
        layout.linkSize(0, this.lblCharName, this.cbMaxDifficulty);
        layout.linkSize(0, this.lblCharName, this.ftExperience);
        layout.linkSize(0, this.lblCharName, this.ftLevel);
        layout.linkSize(0, this.lblCharName, this.ftMoney);
        layout.linkSize(1, this.lblCharName, this.lblMod);
        layout.linkSize(1, this.lblCharName, this.lblSex);
        layout.linkSize(1, this.lblCharName, this.lblHardcore);
        layout.linkSize(1, this.lblCharName, this.lblDeaths);
        layout.linkSize(1, this.lblCharName, this.lblMaxDifficulty);
        layout.linkSize(1, this.lblCharName, this.lblExperience);
        layout.linkSize(1, this.lblCharName, this.lblLevel);
        layout.linkSize(1, this.lblCharName, this.lblMoney);
        layout.linkSize(1, this.lblCharName, this.ftCharName);
        layout.linkSize(1, this.lblCharName, this.cbMod);
        layout.linkSize(1, this.lblCharName, this.cbSex);
        layout.linkSize(1, this.lblCharName, this.cbHardcore);
        layout.linkSize(1, this.lblCharName, this.ftDeaths);
        layout.linkSize(1, this.lblCharName, this.cbMaxDifficulty);
        layout.linkSize(1, this.lblCharName, this.ftExperience);
        layout.linkSize(1, this.lblCharName, this.ftLevel);
        layout.linkSize(1, this.lblCharName, this.ftMoney);
    }

    public void adjustUI() {
        AbstractDocument doc;
        DocumentFilter filter;
        Font fntBorder;
        Font fntFText;
        Font fntCombo;
        Font fntCheck;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntButton = UIManager.getDefaults().getFont("Button.font");
        if (fntButton == null) {
            fntButton = fntLabel;
        }
        if ((fntCheck = UIManager.getDefaults().getFont("CheckBox.font")) == null) {
            fntCheck = fntLabel;
        }
        if ((fntCombo = UIManager.getDefaults().getFont("ComboBox.font")) == null) {
            fntCombo = fntLabel;
        }
        if ((fntFText = UIManager.getDefaults().getFont("FormattedTextField.font")) == null) {
            fntFText = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntButton = fntButton.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCombo = fntCombo.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntFText = fntFText.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_CHAR_DATA"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.lblCharName == null) {
            this.lblCharName = new JLabel();
        }
        this.lblCharName.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_CHAR_NAME"));
        this.lblCharName.setFont(fntLabel);
        if (this.ftCharName == null) {
            this.ftCharName = new JFormattedTextField();
            filter = new CharLenDocFilter(30);
            doc = (AbstractDocument)this.ftCharName.getDocument();
            doc.setDocumentFilter(filter);
        }
        this.ftCharName.setFont(fntFText);
        if (this.lblMod == null) {
            this.lblMod = new JLabel();
        }
        this.lblMod.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_CHAR_MODDED"));
        this.lblMod.setFont(fntLabel);
        if (this.cbMod == null) {
            this.cbMod = new JCheckBox();
        }
        this.cbMod.setFont(fntCheck);
        if (this.lblSex == null) {
            this.lblSex = new JLabel();
        }
        this.lblSex.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_CHAR_SEX"));
        this.lblSex.setFont(fntLabel);
        if (this.cbSex == null) {
            this.cbSex = new JComboBox<String>(sexes);
        }
        this.cbSex.setFont(fntCombo);
        this.cbSex.setMaximumSize(new Dimension(1000, 3 * GDStashFrame.iniConfig.sectUI.fontSize));
        if (this.lblHardcore == null) {
            this.lblHardcore = new JLabel();
        }
        this.lblHardcore.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_CHAR_HARDCORE"));
        this.lblHardcore.setFont(fntLabel);
        if (this.cbHardcore == null) {
            this.cbHardcore = new JCheckBox();
        }
        this.cbHardcore.setFont(fntCheck);
        if (this.lblDeaths == null) {
            this.lblDeaths = new JLabel();
        }
        this.lblDeaths.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_CHAR_STAT_DEATHS"));
        this.lblDeaths.setFont(fntLabel);
        if (this.ftDeaths == null) {
            this.ftDeaths = new JFormattedTextField();
            filter = new IntLenDocFilter(4);
            doc = (AbstractDocument)this.ftDeaths.getDocument();
            doc.setDocumentFilter(filter);
        }
        this.ftDeaths.setFont(fntFText);
        if (this.lblMaxDifficulty == null) {
            this.lblMaxDifficulty = new JLabel();
        }
        this.lblMaxDifficulty.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_CHAR_DIFFICULTY_MAX"));
        this.lblMaxDifficulty.setFont(fntLabel);
        if (this.cbMaxDifficulty == null) {
            this.cbMaxDifficulty = new JComboBox<String>(difficulties);
        }
        this.cbMaxDifficulty.setFont(fntCombo);
        this.cbMaxDifficulty.setMaximumSize(new Dimension(1000, 3 * GDStashFrame.iniConfig.sectUI.fontSize));
        if (this.lblExperience == null) {
            this.lblExperience = new JLabel();
        }
        this.lblExperience.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_CHAR_EXPERIENCE"));
        this.lblExperience.setFont(fntLabel);
        if (this.ftExperience == null) {
            this.ftExperience = new JFormattedTextField();
            filter = new IntLenDocFilter(8);
            doc = (AbstractDocument)this.ftExperience.getDocument();
            doc.setDocumentFilter(filter);
        }
        this.ftExperience.setFont(fntFText);
        if (this.lblLevel == null) {
            this.lblLevel = new JLabel();
        }
        this.lblLevel.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_CHAR_LEVEL"));
        this.lblLevel.setFont(fntLabel);
        if (this.ftLevel == null) {
            this.ftLevel = new JFormattedTextField();
            filter = new IntLenDocFilter(3);
            doc = (AbstractDocument)this.ftLevel.getDocument();
            doc.setDocumentFilter(filter);
        }
        this.ftLevel.setFont(fntFText);
        if (this.lblMoney == null) {
            this.lblMoney = new JLabel();
        }
        this.lblMoney.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_CHAR_MONEY"));
        this.lblMoney.setFont(fntLabel);
        if (this.ftMoney == null) {
            this.ftMoney = new JFormattedTextField();
            filter = new IntLenDocFilter(9);
            doc = (AbstractDocument)this.ftMoney.getDocument();
            doc.setDocumentFilter(filter);
        }
        this.ftMoney.setFont(fntFText);
    }

    public void setChar(GDChar gdc) {
        if (gdc == null) {
            this.ftCharName.setText("");
            this.cbMod.setSelected(false);
            this.cbSex.setSelectedIndex(1);
            this.cbHardcore.setSelected(false);
            this.ftDeaths.setText("0");
            this.cbMaxDifficulty.setSelectedIndex(0);
            this.ftExperience.setText("0");
            this.ftLevel.setText("0");
            this.ftMoney.setText("0");
        } else {
            this.ftCharName.setText(gdc.getCharName());
            this.cbMod.setSelected(!gdc.isInMainQuest());
            this.cbSex.setSelectedIndex(gdc.getSex());
            this.cbHardcore.setSelected(gdc.isHardcore());
            this.ftDeaths.setText(Integer.toString(gdc.getDeaths()));
            this.cbMaxDifficulty.setSelectedIndex(gdc.getGreatestDifficulty());
            this.ftExperience.setText(Integer.toString(gdc.getExperience()));
            this.ftLevel.setText(Integer.toString(gdc.getLevel()));
            this.ftMoney.setText(Integer.toString(gdc.getMoney()));
        }
    }

    public void updateChar(GDChar gdc) {
        if (gdc == null) {
            return;
        }
        gdc.setCharName(this.ftCharName.getText());
        gdc.setInMainQuest(!this.cbMod.isSelected());
        gdc.setSex((byte)this.cbSex.getSelectedIndex());
        gdc.setHardcore(this.cbHardcore.isSelected());
        gdc.setDeaths(Integer.parseInt(this.ftDeaths.getText()));
        gdc.setGreatestDifficulty((byte)this.cbMaxDifficulty.getSelectedIndex());
        gdc.setExperience(Integer.parseInt(this.ftExperience.getText()));
        gdc.setLevel(Integer.parseInt(this.ftLevel.getText()));
        gdc.setMoney(Integer.parseInt(this.ftMoney.getText()));
    }

    public String getCharName() {
        return this.ftCharName.getText();
    }

    static {
        sexes = new String[2];
        GDCharDataPane.sexes[0] = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_CHAR_SEX_FEMALE");
        GDCharDataPane.sexes[1] = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_CHAR_SEX_MALE");
        difficulties = new String[3];
        GDCharDataPane.difficulties[0] = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_DIFF_NORMAL");
        GDCharDataPane.difficulties[1] = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_DIFF_ELITE");
        GDCharDataPane.difficulties[2] = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_DIFF_ULTIMATE");
    }
}

