/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.character;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.gdstash.character.GDChar;
import org.gdstash.ui.GDLogoDialog;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.character.GDCharFactionPane;
import org.gdstash.ui.character.GDCharRiftTabbedPane;
import org.gdstash.ui.character.GDCharShrineTabbedPane;
import org.gdstash.ui.character.GDCharStatEditPane;
import org.gdstash.ui.util.GDCharInfoList;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDImagePool;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class GDCharEditPane
extends JPanel {
    private GDStashFrame frame;
    private GDCharStatEditPane pnlEdit;
    private GDCharFactionPane pnlFactions;
    private GDCharRiftTabbedPane pnlRifts;
    private GDCharShrineTabbedPane pnlShrines;
    private JButton btnReload;
    private JComboBox<String> cbSelChar;
    private JButton btnFileSave;
    private JPanel pnlMain;
    private GDCharInfoList.GDCharFileInfo info;

    public GDCharEditPane(GDStashFrame frame) {
        this.frame = frame;
        this.adjustUI();
        this.setChar(null);
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        this.pnlMain = this.buildMainPanel();
        JScrollPane scroll = new JScrollPane(this.pnlMain);
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setVerticalGroup(vGroup);
    }

    public void adjustUI() {
        Font fntCombo;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntButton = UIManager.getDefaults().getFont("Button.font");
        if (fntButton == null) {
            fntButton = fntLabel;
        }
        if ((fntCombo = UIManager.getDefaults().getFont("ComboBox.font")) == null) {
            fntCombo = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntButton = fntButton.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCombo = fntCombo.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        GDCharInfoList.adjustCharInfos(null, null);
        if (this.pnlEdit == null) {
            this.pnlEdit = new GDCharStatEditPane();
        } else {
            this.pnlEdit.adjustUI();
        }
        if (this.pnlFactions == null) {
            this.pnlFactions = new GDCharFactionPane();
        } else {
            this.pnlFactions.adjustUI();
        }
        if (this.pnlRifts == null) {
            this.pnlRifts = new GDCharRiftTabbedPane();
        } else {
            this.pnlRifts.adjustUI();
        }
        if (this.pnlShrines == null) {
            this.pnlShrines = new GDCharShrineTabbedPane();
        } else {
            this.pnlShrines.adjustUI();
        }
        if (this.btnReload == null) {
            this.btnReload = new JButton();
            this.btnReload.addActionListener(new ReloadActionListener());
        }
        this.btnReload.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_RELOAD"));
        this.btnReload.setIcon(GDImagePool.iconBtnReload24);
        this.btnReload.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnReload, "MNC_RELOAD");
        if (this.cbSelChar == null) {
            this.cbSelChar = new JComboBox();
            this.cbSelChar.addActionListener(new CharSelectActionListener());
        }
        int idx = this.cbSelChar.getSelectedIndex();
        this.cbSelChar.removeAllItems();
        String[] entries = GDCharInfoList.getCharInfos();
        for (int i = 0; i < entries.length; ++i) {
            this.cbSelChar.addItem(entries[i]);
        }
        if (idx != -1) {
            this.cbSelChar.setSelectedIndex(idx);
        }
        this.cbSelChar.setFont(fntCombo);
        this.cbSelChar.setMaximumSize(new Dimension(1000, 3 * GDStashFrame.iniConfig.sectUI.fontSize));
        if (this.btnFileSave == null) {
            this.btnFileSave = new JButton();
            this.btnFileSave.addActionListener(new FileSaveActionListener());
        }
        this.btnFileSave.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_CHAR_SAVE"));
        this.btnFileSave.setIcon(GDImagePool.iconBtnSave24);
        this.btnFileSave.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnFileSave, "MNC_CHAR_SAVE");
    }

    public void refresh() {
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel();
        JPanel pnlEdit = this.buildEditPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(pnlEdit).addComponent(this.pnlFactions)).addGroup(layout.createParallelGroup().addComponent(this.pnlRifts).addComponent(this.pnlShrines));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(pnlEdit).addComponent(this.pnlRifts)).addGroup(layout.createParallelGroup().addComponent(this.pnlFactions).addComponent(this.pnlShrines));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, pnlEdit, this.pnlFactions);
        layout.linkSize(0, this.pnlRifts, this.pnlShrines);
        layout.linkSize(1, pnlEdit, this.pnlRifts);
        layout.linkSize(1, this.pnlFactions, this.pnlShrines);
        return panel;
    }

    private JPanel buildMainEditPanel() {
        JPanel panel = new JPanel();
        JPanel pnlEdit = this.buildEditPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(pnlEdit).addComponent(this.pnlFactions));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(pnlEdit)).addGroup(layout.createParallelGroup().addComponent(this.pnlFactions));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, pnlEdit, this.pnlFactions);
        return panel;
    }

    private JPanel buildEditPanel() {
        JPanel panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.btnReload).addComponent(this.cbSelChar).addComponent(this.pnlEdit).addComponent(this.btnFileSave));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.btnReload)).addGroup(layout.createParallelGroup().addComponent(this.cbSelChar)).addGroup(layout.createParallelGroup().addComponent(this.pnlEdit)).addGroup(layout.createParallelGroup().addComponent(this.btnFileSave));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.btnReload, this.cbSelChar);
        layout.linkSize(0, this.btnReload, this.pnlEdit);
        layout.linkSize(0, this.btnReload, this.btnFileSave);
        layout.linkSize(1, this.btnReload, this.cbSelChar);
        layout.linkSize(1, this.btnReload, this.btnFileSave);
        return panel;
    }

    private JPanel buildRiftShrinePanel() {
        JPanel panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlRifts).addComponent(this.pnlShrines));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlRifts)).addGroup(layout.createParallelGroup().addComponent(this.pnlShrines));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.pnlRifts, this.pnlShrines);
        return panel;
    }

    public void initCharSelection() {
        this.cbSelChar.removeAllItems();
        this.cbSelChar.addItem("");
        for (GDCharInfoList.GDCharFileInfo info : GDCharInfoList.gdCharFileInfos) {
            this.cbSelChar.addItem(info.charInfo);
        }
    }

    public void refreshCharSelection() {
        File file = null;
        if (this.info != null) {
            file = this.info.charFile;
        }
        this.cbSelChar.removeAllItems();
        this.cbSelChar.addItem("");
        GDCharInfoList.GDCharFileInfo selInfo = null;
        int idx = -1;
        int i = 1;
        for (GDCharInfoList.GDCharFileInfo info : GDCharInfoList.gdCharFileInfos) {
            this.cbSelChar.addItem(info.charInfo);
            if (info.charFile.equals(file)) {
                selInfo = info;
                idx = i;
            }
            ++i;
        }
        if (idx == -1) {
            this.setChar(null);
        } else {
            this.cbSelChar.setSelectedIndex(idx);
        }
    }

    public void refreshCharInfo(GDCharInfoList.GDCharFileInfo info) {
        if (info == null) {
            return;
        }
        if (this.info == null) {
            return;
        }
        if (this.info.fileName.equals(info.fileName)) {
            this.info = info;
            this.setChar(info);
        }
    }

    public void setChar(GDCharInfoList.GDCharFileInfo info) {
        this.info = info;
        if (info == null) {
            this.pnlEdit.setChar(null);
            this.pnlFactions.setChar(null);
            this.pnlRifts.setChar(null);
            this.pnlShrines.setChar(null);
        } else {
            this.pnlEdit.setChar(info.gdChar);
            this.pnlFactions.setChar(info.gdChar);
            this.pnlRifts.setChar(info.gdChar);
            this.pnlShrines.setChar(info.gdChar);
        }
    }

    public void updateChar() {
        if (this.info == null) {
            return;
        }
        if (this.info.gdChar == null) {
            return;
        }
        this.pnlEdit.updateChar(this.info.gdChar);
        this.pnlFactions.updateChar(this.info.gdChar);
        this.pnlRifts.updateChar(this.info.gdChar);
        this.pnlShrines.updateChar(this.info.gdChar);
    }

    private class FileSaveActionListener
    implements ActionListener {
        private FileSaveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (GDCharEditPane.this.info == null) {
                return;
            }
            if (((GDCharEditPane)GDCharEditPane.this).info.charFile == null) {
                return;
            }
            if (((GDCharEditPane)GDCharEditPane.this).info.gdChar == null) {
                return;
            }
            String origName = ((GDCharEditPane)GDCharEditPane.this).info.gdChar.getCharName();
            String newName = GDCharEditPane.this.pnlEdit.getCharName();
            if (origName != null && newName != null && !origName.equals(newName)) {
                try {
                    File fDirOrig = ((GDCharEditPane)GDCharEditPane.this).info.charFile.getParentFile();
                    String dirOrig = fDirOrig.getCanonicalPath();
                    int pos = dirOrig.lastIndexOf(GDConstants.FILE_SEPARATOR);
                    if (pos != -1) {
                        String name = dirOrig.substring(pos + 2);
                        String dirNew = dirOrig.substring(0, pos + 1);
                        File fDirNew = new File(dirNew = dirNew + "_" + newName);
                        if (fDirNew.exists()) {
                            GDLogoDialog dialog = new GDLogoDialog(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_CHAR_EXISTS"), 4, GDCharEditPane.this.frame);
                            dialog.setVisible(true);
                            return;
                        }
                    }
                }
                catch (IOException ex) {
                    GDMsgLogger.addError(ex);
                }
            }
            GDCharEditPane.this.updateChar();
            boolean success = false;
            try {
                File fDirOrig;
                String dirOrig;
                int pos;
                ((GDCharEditPane)GDCharEditPane.this).info.gdChar.write();
                String charName = ((GDCharEditPane)GDCharEditPane.this).info.gdChar.getCharName();
                if (charName != null && !charName.isEmpty() && (pos = (dirOrig = (fDirOrig = ((GDCharEditPane)GDCharEditPane.this).info.charFile.getParentFile()).getCanonicalPath()).lastIndexOf(GDConstants.FILE_SEPARATOR)) != -1) {
                    String name = dirOrig.substring(pos + 2);
                    String dirNew = dirOrig.substring(0, pos + 1);
                    if (!name.equals(charName)) {
                        dirNew = dirNew + "_" + charName;
                        File fDirNew = new File(dirNew);
                        fDirOrig.renameTo(fDirNew);
                        GDStashFrame.renameCharDir(fDirOrig, fDirNew, GDCharEditPane.this.frame);
                    }
                }
                success = true;
            }
            catch (IOException ex) {
                GDMsgLogger.addError(ex);
            }
            GDMsgLogger.showLog(GDCharEditPane.this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_CHAR_SAVE"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_CHAR_SAVE"), true);
        }
    }

    private class CharSelectActionListener
    implements ActionListener {
        private CharSelectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            int idx = GDCharEditPane.this.cbSelChar.getSelectedIndex();
            if (idx == -1) {
                return;
            }
            if (idx == 0) {
                GDCharEditPane.this.setChar(null);
                return;
            }
            int i = 1;
            for (GDCharInfoList.GDCharFileInfo info : GDCharInfoList.gdCharFileInfos) {
                if (i == idx) {
                    if (info.gdChar == null) {
                        info.gdChar = new GDChar(info.charFile);
                        info.gdChar.read();
                    }
                    if (info.gdChar.hasErrors()) {
                        info.gdChar = null;
                    }
                    if (info.gdChar != null) {
                        info.gdChar.getMasteryInfo();
                    }
                    GDCharEditPane.this.setChar(info);
                    break;
                }
                ++i;
            }
            GDMsgLogger.showLog(GDCharEditPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class ReloadActionListener
    implements ActionListener {
        private ReloadActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            GDCharInfoList.findChars(GDCharEditPane.this.frame, GDCharEditPane.this.info);
            if (GDCharEditPane.this.info != null) {
                for (GDCharInfoList.GDCharFileInfo ci : GDCharInfoList.gdCharFileInfos) {
                    if (!ci.fileName.equals(((GDCharEditPane)GDCharEditPane.this).info.fileName)) continue;
                    GDCharEditPane.this.info = ci;
                    break;
                }
            }
            if (((GDCharEditPane)GDCharEditPane.this).frame.pnlCharInventory != null) {
                ((GDCharEditPane)GDCharEditPane.this).frame.pnlCharInventory.refreshCharInfo(GDCharEditPane.this.info);
            }
            if (((GDCharEditPane)GDCharEditPane.this).frame.pnlCharEdit != null) {
                ((GDCharEditPane)GDCharEditPane.this).frame.pnlCharEdit.refreshCharInfo(GDCharEditPane.this.info);
            }
            GDMsgLogger.showLog(GDCharEditPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }
}

