/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.character;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.character.GDChar;
import org.gdstash.character.GDCharFactionList;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;

public class GDCharFactionPane
extends JPanel {
    private static final int TYPE_REPUTATION_ALL = 1;
    private static final int TYPE_REPUTATION_POSITIVE = 2;
    private static final int TYPE_REPUTATION_NEGATIVE = 3;
    private static final int[] minReputationLevels = new int[]{-20000, -8000, -1500, -1, 0, 1, 1500, 5000, 10000, 25000};
    private static String[] factionNegative;
    private static String[] factionPositive;
    private static String[] factionAll;
    private JLabel lblSurvivors;
    private JLabel lblRovers;
    private JLabel lblHomestead;
    private JLabel lblBlackLegion;
    private JLabel lblDeathsVigil;
    private JLabel lblKymonsChosen;
    private JLabel lblOutcast;
    private JLabel lblUndead;
    private JLabel lblAetherials;
    private JLabel lblChthonians;
    private JLabel lblOutlaws;
    private JComboBox<String> cbSurvivors;
    private JComboBox<String> cbRovers;
    private JComboBox<String> cbHomestead;
    private JComboBox<String> cbBlackLegion;
    private JComboBox<String> cbDeathsVigil;
    private JComboBox<String> cbKymonsChosen;
    private JComboBox<String> cbOutcast;
    private JComboBox<String> cbUndead;
    private JComboBox<String> cbAetherials;
    private JComboBox<String> cbChthonians;
    private JComboBox<String> cbOutlaws;
    private int[] reputations = new int[GDCharFactionList.FACTIONS.length];
    private int[] reputationTypes;
    private JComboBox[] cbReputations;
    private boolean skipListener;

    public GDCharFactionPane() {
        this.adjustUI();
        this.cbReputations = new JComboBox[GDCharFactionList.FACTIONS.length];
        this.cbReputations[0] = this.cbSurvivors;
        this.cbReputations[1] = this.cbRovers;
        this.cbReputations[2] = this.cbHomestead;
        this.cbReputations[3] = this.cbBlackLegion;
        this.cbReputations[4] = this.cbDeathsVigil;
        this.cbReputations[5] = this.cbKymonsChosen;
        this.cbReputations[6] = this.cbOutcast;
        this.cbReputations[7] = this.cbUndead;
        this.cbReputations[8] = this.cbAetherials;
        this.cbReputations[9] = this.cbChthonians;
        this.cbReputations[10] = this.cbOutlaws;
        this.reputationTypes = new int[GDCharFactionList.FACTIONS.length];
        this.reputationTypes[0] = 2;
        this.reputationTypes[1] = 2;
        this.reputationTypes[2] = 2;
        this.reputationTypes[3] = 2;
        this.reputationTypes[4] = 1;
        this.reputationTypes[5] = 1;
        this.reputationTypes[6] = 1;
        this.reputationTypes[7] = 3;
        this.reputationTypes[8] = 3;
        this.reputationTypes[9] = 3;
        this.reputationTypes[10] = 3;
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.lblSurvivors).addComponent(this.lblRovers).addComponent(this.lblHomestead).addComponent(this.lblBlackLegion).addComponent(this.lblDeathsVigil).addComponent(this.lblKymonsChosen).addComponent(this.lblOutcast).addComponent(this.lblUndead).addComponent(this.lblAetherials).addComponent(this.lblChthonians).addComponent(this.lblOutlaws)).addGroup(layout.createParallelGroup().addComponent(this.cbSurvivors).addComponent(this.cbRovers).addComponent(this.cbHomestead).addComponent(this.cbBlackLegion).addComponent(this.cbDeathsVigil).addComponent(this.cbKymonsChosen).addComponent(this.cbOutcast).addComponent(this.cbUndead).addComponent(this.cbAetherials).addComponent(this.cbChthonians).addComponent(this.cbOutlaws));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.lblSurvivors).addComponent(this.cbSurvivors)).addGroup(layout.createParallelGroup().addComponent(this.lblRovers).addComponent(this.cbRovers)).addGroup(layout.createParallelGroup().addComponent(this.lblHomestead).addComponent(this.cbHomestead)).addGroup(layout.createParallelGroup().addComponent(this.lblBlackLegion).addComponent(this.cbBlackLegion)).addGroup(layout.createParallelGroup().addComponent(this.lblDeathsVigil).addComponent(this.cbDeathsVigil)).addGroup(layout.createParallelGroup().addComponent(this.lblKymonsChosen).addComponent(this.cbKymonsChosen)).addGroup(layout.createParallelGroup().addComponent(this.lblOutcast).addComponent(this.cbOutcast)).addGroup(layout.createParallelGroup().addComponent(this.lblUndead).addComponent(this.cbUndead)).addGroup(layout.createParallelGroup().addComponent(this.lblAetherials).addComponent(this.cbAetherials)).addGroup(layout.createParallelGroup().addComponent(this.lblChthonians).addComponent(this.cbChthonians)).addGroup(layout.createParallelGroup().addComponent(this.lblOutlaws).addComponent(this.cbOutlaws));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.lblSurvivors, this.lblRovers);
        layout.linkSize(0, this.lblSurvivors, this.lblHomestead);
        layout.linkSize(0, this.lblSurvivors, this.lblBlackLegion);
        layout.linkSize(0, this.lblSurvivors, this.lblDeathsVigil);
        layout.linkSize(0, this.lblSurvivors, this.lblKymonsChosen);
        layout.linkSize(0, this.lblSurvivors, this.lblOutcast);
        layout.linkSize(0, this.lblSurvivors, this.lblUndead);
        layout.linkSize(0, this.lblSurvivors, this.lblAetherials);
        layout.linkSize(0, this.lblSurvivors, this.lblChthonians);
        layout.linkSize(0, this.lblSurvivors, this.lblOutlaws);
        layout.linkSize(0, this.lblSurvivors, this.cbSurvivors);
        layout.linkSize(0, this.lblSurvivors, this.cbRovers);
        layout.linkSize(0, this.lblSurvivors, this.cbHomestead);
        layout.linkSize(0, this.lblSurvivors, this.cbBlackLegion);
        layout.linkSize(0, this.lblSurvivors, this.cbDeathsVigil);
        layout.linkSize(0, this.lblSurvivors, this.cbKymonsChosen);
        layout.linkSize(0, this.lblSurvivors, this.cbOutcast);
        layout.linkSize(0, this.lblSurvivors, this.cbUndead);
        layout.linkSize(0, this.lblSurvivors, this.cbAetherials);
        layout.linkSize(0, this.lblSurvivors, this.cbChthonians);
        layout.linkSize(0, this.lblSurvivors, this.cbOutlaws);
        layout.linkSize(1, this.lblSurvivors, this.lblRovers);
        layout.linkSize(1, this.lblSurvivors, this.lblHomestead);
        layout.linkSize(1, this.lblSurvivors, this.lblBlackLegion);
        layout.linkSize(1, this.lblSurvivors, this.lblDeathsVigil);
        layout.linkSize(1, this.lblSurvivors, this.lblKymonsChosen);
        layout.linkSize(1, this.lblSurvivors, this.lblOutcast);
        layout.linkSize(1, this.lblSurvivors, this.lblUndead);
        layout.linkSize(1, this.lblSurvivors, this.lblAetherials);
        layout.linkSize(1, this.lblSurvivors, this.lblChthonians);
        layout.linkSize(1, this.lblSurvivors, this.lblOutlaws);
        layout.linkSize(1, this.lblSurvivors, this.cbSurvivors);
        layout.linkSize(1, this.lblSurvivors, this.cbRovers);
        layout.linkSize(1, this.lblSurvivors, this.cbHomestead);
        layout.linkSize(1, this.lblSurvivors, this.cbBlackLegion);
        layout.linkSize(1, this.lblSurvivors, this.cbDeathsVigil);
        layout.linkSize(1, this.lblSurvivors, this.cbKymonsChosen);
        layout.linkSize(1, this.lblSurvivors, this.cbOutcast);
        layout.linkSize(1, this.lblSurvivors, this.cbUndead);
        layout.linkSize(1, this.lblSurvivors, this.cbAetherials);
        layout.linkSize(1, this.lblSurvivors, this.cbChthonians);
        layout.linkSize(1, this.lblSurvivors, this.cbOutlaws);
    }

    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCombo = UIManager.getDefaults().getFont("ComboBox.font");
        if (fntCombo == null) {
            fntCombo = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCombo = fntCombo.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_FACTIONS"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.lblSurvivors == null) {
            this.lblSurvivors = new JLabel();
        }
        this.lblSurvivors.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "FACTION_DEVILS_CROSSING"));
        this.lblSurvivors.setFont(fntLabel);
        if (this.lblRovers == null) {
            this.lblRovers = new JLabel();
        }
        this.lblRovers.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "FACTION_ROVERS"));
        this.lblRovers.setFont(fntLabel);
        if (this.lblHomestead == null) {
            this.lblHomestead = new JLabel();
        }
        this.lblHomestead.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "FACTION_HOMESTEAD"));
        this.lblHomestead.setFont(fntLabel);
        if (this.lblBlackLegion == null) {
            this.lblBlackLegion = new JLabel();
        }
        this.lblBlackLegion.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "FACTION_BLACK_LEGION"));
        this.lblBlackLegion.setFont(fntLabel);
        if (this.lblDeathsVigil == null) {
            this.lblDeathsVigil = new JLabel();
        }
        this.lblDeathsVigil.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "FACTION_DEATHS_VIGIL"));
        this.lblDeathsVigil.setFont(fntLabel);
        if (this.lblKymonsChosen == null) {
            this.lblKymonsChosen = new JLabel();
        }
        this.lblKymonsChosen.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "FACTION_KYMONS_CHOSEN"));
        this.lblKymonsChosen.setFont(fntLabel);
        if (this.lblOutcast == null) {
            this.lblOutcast = new JLabel();
        }
        this.lblOutcast.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "FACTION_OUTCAST"));
        this.lblOutcast.setFont(fntLabel);
        if (this.lblUndead == null) {
            this.lblUndead = new JLabel();
        }
        this.lblUndead.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "FACTION_UNDEAD"));
        this.lblUndead.setFont(fntLabel);
        if (this.lblAetherials == null) {
            this.lblAetherials = new JLabel();
        }
        this.lblAetherials.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "FACTION_AETHERIALS"));
        this.lblAetherials.setFont(fntLabel);
        if (this.lblChthonians == null) {
            this.lblChthonians = new JLabel();
        }
        this.lblChthonians.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "FACTION_CHTHONIANS"));
        this.lblChthonians.setFont(fntLabel);
        if (this.lblOutlaws == null) {
            this.lblOutlaws = new JLabel();
        }
        this.lblOutlaws.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "FACTION_CRONLEYS_GANG"));
        this.lblOutlaws.setFont(fntLabel);
        if (this.cbSurvivors == null) {
            this.cbSurvivors = new JComboBox<String>(factionPositive);
            this.cbSurvivors.addActionListener(new ReputationListener());
        }
        this.cbSurvivors.setFont(fntCombo);
        if (this.cbRovers == null) {
            this.cbRovers = new JComboBox<String>(factionPositive);
            this.cbRovers.addActionListener(new ReputationListener());
        }
        this.cbRovers.setFont(fntCombo);
        if (this.cbHomestead == null) {
            this.cbHomestead = new JComboBox<String>(factionPositive);
            this.cbHomestead.addActionListener(new ReputationListener());
        }
        this.cbHomestead.setFont(fntCombo);
        if (this.cbBlackLegion == null) {
            this.cbBlackLegion = new JComboBox<String>(factionPositive);
            this.cbBlackLegion.addActionListener(new ReputationListener());
        }
        this.cbBlackLegion.setFont(fntCombo);
        if (this.cbDeathsVigil == null) {
            this.cbDeathsVigil = new JComboBox<String>(factionAll);
            this.cbDeathsVigil.addActionListener(new ReputationListener());
        }
        this.cbDeathsVigil.setFont(fntCombo);
        if (this.cbKymonsChosen == null) {
            this.cbKymonsChosen = new JComboBox<String>(factionAll);
            this.cbKymonsChosen.addActionListener(new ReputationListener());
        }
        this.cbKymonsChosen.setFont(fntCombo);
        if (this.cbOutcast == null) {
            this.cbOutcast = new JComboBox<String>(factionAll);
            this.cbOutcast.addActionListener(new ReputationListener());
        }
        this.cbOutcast.setFont(fntCombo);
        if (this.cbUndead == null) {
            this.cbUndead = new JComboBox<String>(factionNegative);
            this.cbUndead.addActionListener(new ReputationListener());
        }
        this.cbUndead.setFont(fntCombo);
        if (this.cbAetherials == null) {
            this.cbAetherials = new JComboBox<String>(factionNegative);
            this.cbAetherials.addActionListener(new ReputationListener());
        }
        this.cbAetherials.setFont(fntCombo);
        if (this.cbChthonians == null) {
            this.cbChthonians = new JComboBox<String>(factionNegative);
            this.cbChthonians.addActionListener(new ReputationListener());
        }
        this.cbChthonians.setFont(fntCombo);
        if (this.cbOutlaws == null) {
            this.cbOutlaws = new JComboBox<String>(factionNegative);
            this.cbOutlaws.addActionListener(new ReputationListener());
        }
        this.cbOutlaws.setFont(fntCombo);
    }

    private void fillReputation(JComboBox cb) {
        int index = cb.getSelectedIndex();
        for (int i = 0; i < this.cbReputations.length; ++i) {
            if (cb != this.cbReputations[i]) continue;
            switch (this.reputationTypes[i]) {
                case 1: {
                    this.reputations[i] = this.getReputationAll(index);
                    break;
                }
                case 2: {
                    this.reputations[i] = this.getReputationPositive(index);
                    break;
                }
                case 3: {
                    this.reputations[i] = this.getReputationNegative(index);
                }
            }
            return;
        }
    }

    private int getReputationAll(int index) {
        return minReputationLevels[index];
    }

    private int getReputationNegative(int index) {
        return minReputationLevels[4 - index];
    }

    private int getReputationPositive(int index) {
        return minReputationLevels[index + 4];
    }

    private void setReputationAll(JComboBox cb, int reputation) {
        int i;
        for (i = 0; i < 4; ++i) {
            if (reputation > minReputationLevels[i]) continue;
            cb.setSelectedIndex(i);
            return;
        }
        for (i = 9; i > 4; --i) {
            if (reputation < minReputationLevels[i]) continue;
            cb.setSelectedIndex(i);
            return;
        }
        cb.setSelectedIndex(4);
    }

    private void setReputationNegative(JComboBox cb, int reputation) {
        for (int i = 0; i < 4; ++i) {
            if (reputation > minReputationLevels[i]) continue;
            cb.setSelectedIndex(4 - i);
            return;
        }
        cb.setSelectedIndex(0);
    }

    private void setReputationPositive(JComboBox cb, int reputation) {
        for (int i = 9; i > 4; --i) {
            if (reputation < minReputationLevels[i]) continue;
            cb.setSelectedIndex(i - 4);
            return;
        }
        cb.setSelectedIndex(0);
    }

    public void setChar(GDChar gdc) {
        this.skipListener = true;
        if (gdc == null) {
            for (int i = 0; i < this.reputations.length; ++i) {
                this.reputations[i] = 0;
            }
        } else {
            this.reputations = gdc.getFactionReputations();
        }
        this.setReputationPositive(this.cbSurvivors, this.reputations[0]);
        this.setReputationPositive(this.cbRovers, this.reputations[1]);
        this.setReputationPositive(this.cbHomestead, this.reputations[2]);
        this.setReputationPositive(this.cbBlackLegion, this.reputations[3]);
        this.setReputationAll(this.cbDeathsVigil, this.reputations[4]);
        this.setReputationAll(this.cbKymonsChosen, this.reputations[5]);
        this.setReputationAll(this.cbOutcast, this.reputations[6]);
        this.setReputationNegative(this.cbUndead, this.reputations[7]);
        this.setReputationNegative(this.cbAetherials, this.reputations[8]);
        this.setReputationNegative(this.cbChthonians, this.reputations[9]);
        this.setReputationNegative(this.cbOutlaws, this.reputations[10]);
        this.skipListener = false;
    }

    public void updateChar(GDChar gdc) {
        if (gdc == null) {
            return;
        }
        gdc.setFactionReputations(this.reputations);
    }

    static {
        factionAll = new String[10];
        GDCharFactionPane.factionAll[0] = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "FACTION_STATUS_NEMESIS");
        GDCharFactionPane.factionAll[1] = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "FACTION_STATUS_HATED");
        GDCharFactionPane.factionAll[2] = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "FACTION_STATUS_DESPISED");
        GDCharFactionPane.factionAll[3] = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "FACTION_STATUS_HOSTILE");
        GDCharFactionPane.factionAll[4] = "";
        GDCharFactionPane.factionAll[5] = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "FACTION_STATUS_TOLERATED");
        GDCharFactionPane.factionAll[6] = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "FACTION_STATUS_FRIENDLY");
        GDCharFactionPane.factionAll[7] = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "FACTION_STATUS_RESPECTED");
        GDCharFactionPane.factionAll[8] = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "FACTION_STATUS_HONORED");
        GDCharFactionPane.factionAll[9] = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "FACTION_STATUS_REVERED");
        factionNegative = new String[5];
        GDCharFactionPane.factionNegative[0] = factionAll[4];
        GDCharFactionPane.factionNegative[1] = factionAll[3];
        GDCharFactionPane.factionNegative[2] = factionAll[2];
        GDCharFactionPane.factionNegative[3] = factionAll[1];
        GDCharFactionPane.factionNegative[4] = factionAll[0];
        factionPositive = new String[6];
        GDCharFactionPane.factionPositive[0] = factionAll[4];
        GDCharFactionPane.factionPositive[1] = factionAll[5];
        GDCharFactionPane.factionPositive[2] = factionAll[6];
        GDCharFactionPane.factionPositive[3] = factionAll[7];
        GDCharFactionPane.factionPositive[4] = factionAll[8];
        GDCharFactionPane.factionPositive[5] = factionAll[9];
    }

    private class ReputationListener
    implements ActionListener {
        private ReputationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GDCharFactionPane.this.skipListener) {
                return;
            }
            JComboBox source = (JComboBox)e.getSource();
            GDCharFactionPane.this.fillReputation(source);
        }
    }
}

