/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.character;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.gdstash.db.DBStashItem;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.item.GDItem;
import org.gdstash.ui.GDItemInfoPane;
import org.gdstash.ui.GDItemNameTablePane;
import org.gdstash.ui.GDSearchDialog;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.GDUISearch;
import org.gdstash.ui.GDUITransfer;
import org.gdstash.ui.stash.GDCharStashPane;
import org.gdstash.ui.stash.GDContainerMapPane;
import org.gdstash.ui.util.GDCharInfoList;
import org.gdstash.ui.util.GDStashInfoList;
import org.gdstash.util.GDImagePool;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class GDCharInventoryPane
extends JPanel
implements GDUITransfer,
GDUISearch {
    private GDStashFrame frame;
    private GDCharStashPane pnlStash;
    private GDItemInfoPane pnlInfo;
    private JButton btnDBCopy;
    private JButton btnDBMove;
    private JButton btnDBDel;
    private JButton btnStashDel;
    private JButton btnPageCopy;
    private JButton btnPageMove;
    private JButton btnPageDel;
    private JButton btnReload;
    private JButton btnFileSave;
    private GDItemNameTablePane pnlTable;
    private JButton btnSearch;
    private GDCharInfoList.GDCharFileInfo info;
    private GDItem selItem;
    private int location;
    private JPanel pnlMain;
    private GDSearchDialog dlgSearch;

    public GDCharInventoryPane(GDStashFrame frame) {
        this.frame = frame;
        this.selItem = null;
        this.location = 0;
        this.dlgSearch = null;
        this.adjustUI();
        this.pnlMain = this.buildMainPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JScrollPane scroll = new JScrollPane(this.pnlMain);
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setVerticalGroup(vGroup);
    }

    public void adjustUI() {
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntButton = UIManager.getDefaults().getFont("Button.font");
        if (fntButton == null) {
            fntButton = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntButton = fntButton.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        GDCharInfoList.adjustCharInfos(null, null);
        if (this.btnFileSave == null) {
            this.btnFileSave = new JButton();
            this.btnFileSave.addActionListener(new FileSaveActionListener());
        }
        this.btnFileSave.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_CHAR_SAVE"));
        this.btnFileSave.setIcon(GDImagePool.iconBtnSave24);
        this.btnFileSave.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnFileSave, "MNC_CHAR_SAVE");
        if (this.btnDBDel == null) {
            this.btnDBDel = new JButton();
            this.btnDBDel.setEnabled(false);
            this.btnDBDel.addActionListener(new DBDelActionListener());
        }
        this.btnDBDel.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_ITEM_DEL_DB"));
        this.btnDBDel.setIcon(GDImagePool.iconDBDelete24);
        this.btnDBDel.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnDBDel, "MNC_ITEM_DEL_DB");
        if (this.btnDBCopy == null) {
            this.btnDBCopy = new JButton();
            this.btnDBCopy.setEnabled(false);
            this.btnDBCopy.addActionListener(new DBCopyActionListener());
        }
        this.btnDBCopy.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_ITEM_COPY_DB"));
        this.btnDBCopy.setIcon(GDImagePool.iconItemCopy24);
        this.btnDBCopy.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnDBCopy, "MNC_ITEM_COPY_DB");
        if (this.btnDBMove == null) {
            this.btnDBMove = new JButton();
            this.btnDBMove.setEnabled(false);
            this.btnDBMove.addActionListener(new DBMoveActionListener());
        }
        this.btnDBMove.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_ITEM_MOVE_DB"));
        this.btnDBMove.setIcon(GDImagePool.iconItemMove24);
        this.btnDBMove.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnDBMove, "MNC_ITEM_MOVE_DB");
        if (this.btnPageCopy == null) {
            this.btnPageCopy = new JButton();
            this.btnPageCopy.setEnabled(true);
            this.btnPageCopy.addActionListener(new PageCopyActionListener());
        }
        this.btnPageCopy.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_PAGE_COPY_DB"));
        this.btnPageCopy.setIcon(GDImagePool.iconPageCopy24);
        this.btnPageCopy.setFont(fntButton);
        if (this.btnPageMove == null) {
            this.btnPageMove = new JButton();
            this.btnPageMove.setEnabled(true);
            this.btnPageMove.addActionListener(new PageMoveActionListener());
        }
        this.btnPageMove.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_PAGE_MOVE_DB"));
        this.btnPageMove.setIcon(GDImagePool.iconPageMove24);
        this.btnPageMove.setFont(fntButton);
        if (this.btnStashDel == null) {
            this.btnStashDel = new JButton();
            this.btnStashDel.setEnabled(false);
            this.btnStashDel.addActionListener(new StashDelActionListener());
        }
        this.btnStashDel.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_ITEM_DEL_CHAR"));
        this.btnStashDel.setIcon(GDImagePool.iconItemDelete24);
        this.btnStashDel.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnStashDel, "MNC_ITEM_DEL_CHAR");
        if (this.btnPageDel == null) {
            this.btnPageDel = new JButton();
            this.btnPageDel.setEnabled(true);
            this.btnPageDel.addActionListener(new PageDelActionListener());
        }
        this.btnPageDel.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_PAGE_DEL"));
        this.btnPageDel.setIcon(GDImagePool.iconPageDelete24);
        this.btnPageDel.setFont(fntButton);
        if (this.btnSearch == null) {
            this.btnSearch = new JButton();
            this.btnSearch.addActionListener(new SearchItemsListener());
        }
        this.btnSearch.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_SEARCH"));
        this.btnSearch.setIcon(GDImagePool.iconBtnSearch24);
        this.btnSearch.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnSearch, "MNC_SEARCH_SECOND");
        if (this.btnReload == null) {
            this.btnReload = new JButton();
            this.btnReload.addActionListener(new ReloadActionListener());
        }
        this.btnReload.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_RELOAD"));
        this.btnReload.setIcon(GDImagePool.iconBtnReload24);
        this.btnReload.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnReload, "MNC_RELOAD");
        if (this.pnlInfo == null) {
            this.pnlInfo = new GDItemInfoPane();
        }
        this.pnlInfo.adjustUI();
        if (this.pnlTable == null) {
            this.pnlTable = new GDItemNameTablePane(null);
            this.pnlTable.addActionListener(new TableActionListener());
            this.pnlTable.setMinimumSize(new Dimension(300, 200));
            this.pnlTable.setMaximumSize(new Dimension(600, 2000));
        } else {
            this.pnlTable.adjustUI();
        }
        if (this.pnlStash == null) {
            this.pnlStash = new GDCharStashPane(this.frame, this);
        } else {
            this.pnlStash.adjustUI();
        }
    }

    public void refresh() {
        if (this.pnlTable != null) {
            this.pnlTable.refresh();
        }
        if (this.pnlInfo != null) {
            this.pnlInfo.refresh();
        }
        if (this.pnlStash != null) {
            this.pnlStash.refresh();
        }
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel pnlTable = this.buildTablePanel();
        JPanel pnlItemInfo = this.buildInfoPanel();
        JPanel pnlStash = this.buildStashPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(pnlTable)).addGroup(layout.createParallelGroup().addComponent(pnlItemInfo)).addGroup(layout.createParallelGroup().addComponent(pnlStash));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(pnlTable).addComponent(pnlItemInfo).addComponent(pnlStash));
        layout.setVerticalGroup(vGroup);
        return panel;
    }

    private JPanel buildTablePanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.btnSearch).addComponent(this.pnlTable));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.btnSearch)).addGroup(layout.createParallelGroup().addComponent(this.pnlTable));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.btnSearch, this.pnlTable);
        return panel;
    }

    private JPanel buildStashPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.btnReload).addComponent(this.pnlStash));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.btnReload)).addGroup(layout.createParallelGroup().addComponent(this.pnlStash));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.btnReload, this.pnlStash);
        return panel;
    }

    private JPanel buildInfoPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        JPanel pnlButton = this.buildButtonPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.btnFileSave).addComponent(pnlButton).addComponent(this.pnlInfo));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.btnFileSave)).addGroup(layout.createParallelGroup().addComponent(pnlButton)).addGroup(layout.createParallelGroup().addComponent(this.pnlInfo));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.btnFileSave, pnlButton);
        layout.linkSize(0, this.btnFileSave, this.pnlInfo);
        return panel;
    }

    private JPanel buildButtonPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.btnDBCopy).addComponent(this.btnDBMove).addComponent(this.btnStashDel).addComponent(this.btnDBDel)).addGroup(layout.createParallelGroup().addComponent(this.btnPageCopy).addComponent(this.btnPageMove).addComponent(this.btnPageDel));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.btnDBCopy).addComponent(this.btnPageCopy)).addGroup(layout.createParallelGroup().addComponent(this.btnDBMove).addComponent(this.btnPageMove)).addGroup(layout.createParallelGroup().addComponent(this.btnStashDel).addComponent(this.btnPageDel)).addGroup(layout.createParallelGroup().addComponent(this.btnDBDel));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.btnDBCopy, this.btnDBMove);
        layout.linkSize(0, this.btnDBCopy, this.btnStashDel);
        layout.linkSize(0, this.btnDBCopy, this.btnDBDel);
        layout.linkSize(0, this.btnDBCopy, this.btnPageCopy);
        layout.linkSize(0, this.btnDBCopy, this.btnPageMove);
        layout.linkSize(0, this.btnDBCopy, this.btnPageDel);
        layout.linkSize(1, this.btnDBCopy, this.btnDBMove);
        layout.linkSize(1, this.btnDBCopy, this.btnStashDel);
        layout.linkSize(1, this.btnDBCopy, this.btnDBDel);
        layout.linkSize(1, this.btnDBCopy, this.btnPageCopy);
        layout.linkSize(1, this.btnDBCopy, this.btnPageMove);
        layout.linkSize(1, this.btnDBCopy, this.btnPageDel);
        return panel;
    }

    @Override
    public void checkSaveButton() {
        if (this.info == null) {
            this.btnFileSave.setEnabled(false);
        } else if (this.info.gdChar == null) {
            this.btnFileSave.setEnabled(false);
        } else {
            this.btnFileSave.setEnabled(this.info.gdChar.hasChanged());
        }
    }

    public void updateItemSets() {
        if (this.dlgSearch != null) {
            this.dlgSearch.updateItemSets();
        }
    }

    public void initCharSelection() {
        if (this.pnlStash != null) {
            this.pnlStash.initCharSelection();
        }
    }

    public void refreshCharSelection() {
        this.pnlStash.refreshCharSelection();
    }

    public void refreshCharInfo(GDCharInfoList.GDCharFileInfo info) {
        if (info == null) {
            return;
        }
        if (this.info == null) {
            return;
        }
        if (this.info.fileName.equals(info.fileName)) {
            this.info = info;
            if (this.pnlStash != null) {
                this.pnlStash.setChar(info);
            }
        }
    }

    public void renameCharDir(File fDirOld, File fDirNew) {
        if (this.pnlStash != null) {
            this.pnlStash.renameCharDir(fDirOld, fDirNew);
        }
    }

    @Override
    public void setChar(GDCharInfoList.GDCharFileInfo info) {
        if (this.info == info) {
            return;
        }
        this.info = info;
        if (!GDStashFrame.iniConfig.sectRestrict.transferSoulbound) {
            this.pnlTable.setItems(null);
        }
        this.checkSaveButton();
    }

    @Override
    public void setStash(GDStashInfoList.GDStashFileInfo info) {
    }

    @Override
    public int getItemLocation() {
        return this.location;
    }

    @Override
    public GDItem getSelectedItem() {
        return this.selItem;
    }

    @Override
    public void setSelectedItem(GDItem item, int location) {
        if (location == 1) {
            this.pnlTable.clearSelection();
        }
        this.selItem = item;
        this.location = location;
        this.pnlInfo.setItemInfo(item);
        switch (location) {
            case 1: {
                this.btnDBCopy.setEnabled(item != null);
                this.btnDBMove.setEnabled(item != null && item.getContainerType() != 5);
                this.btnStashDel.setEnabled(item != null && item.getContainerType() != 5);
                this.btnDBDel.setEnabled(false);
                this.btnPageCopy.setEnabled(true);
                this.btnPageMove.setEnabled(true);
                this.btnPageDel.setEnabled(true);
                break;
            }
            case 2: {
                this.btnDBCopy.setEnabled(false);
                this.btnDBMove.setEnabled(false);
                this.btnStashDel.setEnabled(false);
                this.btnDBDel.setEnabled(item != null);
                this.btnPageCopy.setEnabled(false);
                this.btnPageMove.setEnabled(false);
                this.btnPageDel.setEnabled(false);
                break;
            }
            default: {
                this.btnDBCopy.setEnabled(false);
                this.btnDBMove.setEnabled(false);
                this.btnStashDel.setEnabled(false);
                this.btnDBDel.setEnabled(false);
                this.btnPageCopy.setEnabled(true);
                this.btnPageMove.setEnabled(true);
                this.btnPageDel.setEnabled(true);
            }
        }
    }

    @Override
    public void transferSelectedItem(int action, int x, int y) {
        switch (action) {
            case 1: {
                GDItem item;
                if (this.location != 1 || (item = this.pnlStash.getSelectedItem()) == null) break;
                this.pnlStash.moveSelectedItem(1, x, y);
                this.btnFileSave.setEnabled(this.info.gdChar.hasChanged());
                break;
            }
            case 2: {
                if (this.location != 1) break;
                boolean success = DBStashItem.storeItem(this.selItem);
                if (success) {
                    this.setSelectedItem(null, 0);
                }
                GDMsgLogger.showLog(this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_ITEM_STORED"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_ITEM_STORED"));
                break;
            }
            case 3: {
                if (this.location != 1) break;
                boolean success = DBStashItem.storeItem(this.selItem);
                if (success) {
                    this.pnlStash.deleteSelectedItem(3);
                    this.setSelectedItem(null, 0);
                    this.btnFileSave.setEnabled(this.info.gdChar.hasChanged());
                }
                GDMsgLogger.showLog(this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_ITEM_STORED"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_ITEM_STORED"));
                break;
            }
            case 4: {
                if (this.location != 2) break;
                boolean success = this.pnlStash.addItem(this.selItem, 4, x, y);
                if (success && GDStashFrame.iniConfig.sectRestrict.dbStashMove) {
                    this.transferSelectedItem(5, x, y);
                }
                this.btnFileSave.setEnabled(this.info.gdChar.hasChanged());
                break;
            }
            case 5: {
                if (this.location != 2) break;
                boolean success = DBStashItem.delete(this.selItem);
                if (success) {
                    if (this.selItem.isStackable()) {
                        GDItem item = DBStashItem.getStack(this.selItem);
                        this.pnlTable.updateItem(item);
                    } else {
                        this.pnlTable.deleteItem();
                    }
                    this.setSelectedItem(this.pnlTable.getSelectedItem(), 2);
                }
                GDMsgLogger.showLog(this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_ITEM_DELETED"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_ITEM_DELETED"));
                break;
            }
            case 6: {
                GDItem item;
                if (this.location != 1 || (item = this.getSelectedItem()) == null) break;
                this.pnlStash.deleteSelectedItem(6);
                this.setSelectedItem(null, 0);
                this.btnFileSave.setEnabled(this.info.gdChar.hasChanged());
                break;
            }
            case 7: {
                if (this.location != 1 && this.location != 0) break;
                GDContainerMapPane page = this.pnlStash.getCurrentPage();
                if (page == null) {
                    return;
                }
                List<GDItem> items = page.getItemList(7);
                for (GDItem item : items) {
                    DBStashItem.storeItem(item);
                }
                GDMsgLogger.showLog(this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_ITEM_STORED"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_ITEM_STORED"));
                break;
            }
            case 8: {
                if (this.location != 1 && this.location != 0) break;
                GDContainerMapPane page = this.pnlStash.getCurrentPage();
                if (page == null) {
                    return;
                }
                List<GDItem> items = page.getItemList(8);
                for (GDItem item : items) {
                    boolean success = DBStashItem.storeItem(item);
                    if (!success) continue;
                    page.deleteItem(item, 8, false);
                }
                page.layoutContainers();
                this.setSelectedItem(null, 0);
                this.btnFileSave.setEnabled(this.info.gdChar.hasChanged());
                GDMsgLogger.showLog(this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_ITEM_STORED"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_ITEM_STORED"));
                break;
            }
            case 9: {
                if (this.location != 1 && this.location != 0) break;
                GDContainerMapPane page = this.pnlStash.getCurrentPage();
                if (page == null) {
                    return;
                }
                List<GDItem> items = page.getItemList(9);
                for (GDItem item : items) {
                    page.deleteItem(item, 9, false);
                }
                page.layoutContainers();
                this.setSelectedItem(null, 0);
                this.btnFileSave.setEnabled(this.info.gdChar.hasChanged());
                GDMsgLogger.showLog(this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_ITEM_DELETED"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_ITEM_DELETED"));
            }
        }
    }

    @Override
    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public void search(SelectionCriteria criteria) {
        if (this.info == null) {
            return;
        }
        if (this.info.gdChar == null) {
            return;
        }
        criteria.noEnemyOnly = true;
        List<GDItem> items = DBStashItem.getGDItemByCriteria(criteria, this.info.gdChar.isHardcore(), this.info.gdChar.getCharName());
        this.pnlTable.setItems(items);
        GDMsgLogger.showLog(this, GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_SEARCH"));
    }

    private class SearchItemsListener
    implements ActionListener {
        private SearchItemsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GDCharInventoryPane.this.dlgSearch == null) {
                GDCharInventoryPane.this.dlgSearch = new GDSearchDialog((Frame)GDCharInventoryPane.this.frame, GDCharInventoryPane.this);
            }
            GDCharInventoryPane.this.dlgSearch.setVisible(true);
        }
    }

    private class FileSaveActionListener
    implements ActionListener {
        private FileSaveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (GDCharInventoryPane.this.info == null) {
                return;
            }
            if (((GDCharInventoryPane)GDCharInventoryPane.this).info.gdChar == null) {
                return;
            }
            boolean success = false;
            try {
                ((GDCharInventoryPane)GDCharInventoryPane.this).info.gdChar.write();
                success = true;
            }
            catch (IOException ex) {
                GDMsgLogger.addError(ex);
            }
            if (success) {
                GDCharInventoryPane.this.checkSaveButton();
            }
            GDMsgLogger.showLog(GDCharInventoryPane.this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_CHAR_SAVE"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_CHAR_SAVE"), true);
        }
    }

    private class PageDelActionListener
    implements ActionListener {
        private PageDelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (GDCharInventoryPane.this.pnlStash.getCurrentPage() == null) {
                return;
            }
            GDCharInventoryPane.this.transferSelectedItem(9, 0, 0);
            GDMsgLogger.showLog(GDCharInventoryPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class StashDelActionListener
    implements ActionListener {
        private StashDelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            GDCharInventoryPane.this.transferSelectedItem(6, 0, 0);
            GDMsgLogger.showLog(GDCharInventoryPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class PageMoveActionListener
    implements ActionListener {
        private PageMoveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (GDCharInventoryPane.this.pnlStash.getCurrentPage() == null) {
                return;
            }
            GDCharInventoryPane.this.transferSelectedItem(8, 0, 0);
            GDMsgLogger.showLog(GDCharInventoryPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class PageCopyActionListener
    implements ActionListener {
        private PageCopyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (GDCharInventoryPane.this.pnlStash.getCurrentPage() == null) {
                return;
            }
            GDCharInventoryPane.this.transferSelectedItem(7, 0, 0);
            GDMsgLogger.showLog(GDCharInventoryPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class DBMoveActionListener
    implements ActionListener {
        private DBMoveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            GDItem item = GDCharInventoryPane.this.getSelectedItem();
            if (item == null) {
                return;
            }
            GDCharInventoryPane.this.transferSelectedItem(3, 0, 0);
            GDMsgLogger.showLog(GDCharInventoryPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class DBCopyActionListener
    implements ActionListener {
        private DBCopyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            GDItem item = GDCharInventoryPane.this.getSelectedItem();
            if (item == null) {
                return;
            }
            GDCharInventoryPane.this.transferSelectedItem(2, 0, 0);
            GDMsgLogger.showLog(GDCharInventoryPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class DBDelActionListener
    implements ActionListener {
        private DBDelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            GDItem item = GDCharInventoryPane.this.pnlTable.getSelectedItem();
            if (item == null) {
                return;
            }
            GDCharInventoryPane.this.transferSelectedItem(5, 0, 0);
            GDMsgLogger.showLog(GDCharInventoryPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class ReloadActionListener
    implements ActionListener {
        private ReloadActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            GDCharInfoList.findChars(GDCharInventoryPane.this.frame, GDCharInventoryPane.this.info);
            if (GDCharInventoryPane.this.info != null) {
                for (GDCharInfoList.GDCharFileInfo ci : GDCharInfoList.gdCharFileInfos) {
                    if (!ci.fileName.equals(((GDCharInventoryPane)GDCharInventoryPane.this).info.fileName)) continue;
                    GDCharInventoryPane.this.info = ci;
                    break;
                }
            }
            if (((GDCharInventoryPane)GDCharInventoryPane.this).frame.pnlCharInventory != null) {
                ((GDCharInventoryPane)GDCharInventoryPane.this).frame.pnlCharInventory.refreshCharInfo(GDCharInventoryPane.this.info);
            }
            if (((GDCharInventoryPane)GDCharInventoryPane.this).frame.pnlCharEdit != null) {
                ((GDCharInventoryPane)GDCharInventoryPane.this).frame.pnlCharEdit.refreshCharInfo(GDCharInventoryPane.this.info);
            }
            GDMsgLogger.showLog(GDCharInventoryPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class TableActionListener
    implements ActionListener {
        private TableActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            GDItem item = GDCharInventoryPane.this.pnlTable.getSelectedItem();
            GDCharInventoryPane.this.setSelectedItem(item, 2);
            GDMsgLogger.showLog(GDCharInventoryPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }
}

