/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.character;

import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.AbstractDocument;
import org.gdstash.character.GDChar;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.select.IntLenDocFilter;
import org.gdstash.util.GDMsgFormatter;

public class GDCharPointPane
extends JPanel {
    private JLabel lblStatPoints;
    private JLabel lblSkillPoints;
    private JLabel lblDevotionPoints;
    private JLabel lblSkillReclaimPoints;
    private JLabel lblDevotionReclaimPoints;
    private JLabel lblMastery1Points;
    private JLabel lblMastery2Points;
    private JTextField ftStatPoints;
    private JTextField ftSkillPoints;
    private JTextField ftDevotionPoints;
    private JTextField ftSkillReclaimPoints;
    private JTextField ftDevotionReclaimPoints;
    private JTextField ftMastery1Points;
    private JTextField ftMastery2Points;
    private GDChar.MasteryInfo[] infos;

    public GDCharPointPane() {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.lblStatPoints).addComponent(this.lblSkillPoints).addComponent(this.lblDevotionPoints).addComponent(this.lblSkillReclaimPoints).addComponent(this.lblDevotionReclaimPoints).addComponent(this.lblMastery1Points).addComponent(this.lblMastery2Points)).addGroup(layout.createParallelGroup().addComponent(this.ftStatPoints).addComponent(this.ftSkillPoints).addComponent(this.ftDevotionPoints).addComponent(this.ftSkillReclaimPoints).addComponent(this.ftDevotionReclaimPoints).addComponent(this.ftMastery1Points).addComponent(this.ftMastery2Points));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.lblStatPoints).addComponent(this.ftStatPoints)).addGroup(layout.createParallelGroup().addComponent(this.lblSkillPoints).addComponent(this.ftSkillPoints)).addGroup(layout.createParallelGroup().addComponent(this.lblDevotionPoints).addComponent(this.ftDevotionPoints)).addGroup(layout.createParallelGroup().addComponent(this.lblSkillReclaimPoints).addComponent(this.ftSkillReclaimPoints)).addGroup(layout.createParallelGroup().addComponent(this.lblDevotionReclaimPoints).addComponent(this.ftDevotionReclaimPoints)).addGroup(layout.createParallelGroup().addComponent(this.lblMastery1Points).addComponent(this.ftMastery1Points)).addGroup(layout.createParallelGroup().addComponent(this.lblMastery2Points).addComponent(this.ftMastery2Points));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.lblStatPoints, this.lblSkillPoints);
        layout.linkSize(0, this.lblStatPoints, this.lblDevotionPoints);
        layout.linkSize(0, this.lblStatPoints, this.lblSkillReclaimPoints);
        layout.linkSize(0, this.lblStatPoints, this.lblDevotionReclaimPoints);
        layout.linkSize(0, this.lblStatPoints, this.lblMastery1Points);
        layout.linkSize(0, this.lblStatPoints, this.lblMastery2Points);
        layout.linkSize(0, this.ftStatPoints, this.ftSkillPoints);
        layout.linkSize(0, this.ftStatPoints, this.ftDevotionPoints);
        layout.linkSize(0, this.ftStatPoints, this.ftSkillReclaimPoints);
        layout.linkSize(0, this.ftStatPoints, this.ftDevotionReclaimPoints);
        layout.linkSize(0, this.ftStatPoints, this.ftMastery1Points);
        layout.linkSize(0, this.ftStatPoints, this.ftMastery2Points);
        layout.linkSize(1, this.lblStatPoints, this.lblSkillPoints);
        layout.linkSize(1, this.lblStatPoints, this.lblDevotionPoints);
        layout.linkSize(1, this.lblStatPoints, this.lblSkillReclaimPoints);
        layout.linkSize(1, this.lblStatPoints, this.lblDevotionReclaimPoints);
        layout.linkSize(1, this.lblStatPoints, this.lblMastery1Points);
        layout.linkSize(1, this.lblStatPoints, this.lblMastery2Points);
        layout.linkSize(1, this.lblStatPoints, this.ftStatPoints);
        layout.linkSize(1, this.lblStatPoints, this.ftSkillPoints);
        layout.linkSize(1, this.lblStatPoints, this.ftDevotionPoints);
        layout.linkSize(1, this.lblStatPoints, this.ftSkillReclaimPoints);
        layout.linkSize(1, this.lblStatPoints, this.ftDevotionReclaimPoints);
        layout.linkSize(1, this.lblStatPoints, this.ftMastery1Points);
        layout.linkSize(1, this.lblStatPoints, this.ftMastery2Points);
    }

    public void adjustUI() {
        String s;
        Object[] args;
        AbstractDocument doc;
        IntLenDocFilter filter;
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntFText = UIManager.getDefaults().getFont("FormattedTextField.font");
        if (fntFText == null) {
            fntFText = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntFText = fntFText.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_CHAR_POINTS"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.lblStatPoints == null) {
            this.lblStatPoints = new JLabel();
        }
        this.lblStatPoints.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_CHAR_POINTS_STAT"));
        this.lblStatPoints.setFont(fntLabel);
        if (this.ftStatPoints == null) {
            this.ftStatPoints = new JFormattedTextField();
            filter = new IntLenDocFilter(3);
            doc = (AbstractDocument)this.ftStatPoints.getDocument();
            doc.setDocumentFilter(filter);
        }
        this.ftStatPoints.setPreferredSize(new Dimension(GDStashFrame.iniConfig.sectUI.fontSize * 4, GDStashFrame.iniConfig.sectUI.fontSize * 2));
        this.ftStatPoints.setFont(fntFText);
        if (this.lblSkillPoints == null) {
            this.lblSkillPoints = new JLabel();
        }
        this.lblSkillPoints.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_CHAR_POINTS_SKILL"));
        this.lblSkillPoints.setFont(fntLabel);
        if (this.ftSkillPoints == null) {
            this.ftSkillPoints = new JFormattedTextField();
            filter = new IntLenDocFilter(3);
            doc = (AbstractDocument)this.ftSkillPoints.getDocument();
            doc.setDocumentFilter(filter);
        }
        this.ftSkillPoints.setFont(fntFText);
        if (this.lblDevotionPoints == null) {
            this.lblDevotionPoints = new JLabel();
        }
        this.lblDevotionPoints.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_CHAR_POINTS_DEVOTION"));
        this.lblDevotionPoints.setFont(fntLabel);
        if (this.ftDevotionPoints == null) {
            this.ftDevotionPoints = new JFormattedTextField();
            filter = new IntLenDocFilter(3);
            doc = (AbstractDocument)this.ftDevotionPoints.getDocument();
            doc.setDocumentFilter(filter);
        }
        this.ftDevotionPoints.setFont(fntFText);
        if (this.lblSkillReclaimPoints == null) {
            this.lblSkillReclaimPoints = new JLabel();
        }
        this.lblSkillReclaimPoints.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_CHAR_POINTS_SKILL_REC"));
        this.lblSkillReclaimPoints.setFont(fntLabel);
        if (this.ftSkillReclaimPoints == null) {
            this.ftSkillReclaimPoints = new JFormattedTextField();
            filter = new IntLenDocFilter(3);
            doc = (AbstractDocument)this.ftSkillReclaimPoints.getDocument();
            doc.setDocumentFilter(filter);
        }
        this.ftSkillReclaimPoints.setFont(fntFText);
        if (this.lblDevotionReclaimPoints == null) {
            this.lblDevotionReclaimPoints = new JLabel();
        }
        this.lblDevotionReclaimPoints.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_CHAR_POINTS_DEVOTION_REC"));
        this.lblDevotionReclaimPoints.setFont(fntLabel);
        if (this.ftDevotionReclaimPoints == null) {
            this.ftDevotionReclaimPoints = new JFormattedTextField();
            filter = new IntLenDocFilter(3);
            doc = (AbstractDocument)this.ftDevotionReclaimPoints.getDocument();
            doc.setDocumentFilter(filter);
        }
        this.ftDevotionReclaimPoints.setFont(fntFText);
        if (this.lblDevotionReclaimPoints == null) {
            this.lblDevotionReclaimPoints = new JLabel();
        }
        this.lblDevotionReclaimPoints.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_CHAR_POINTS_DEVOTION_REC"));
        this.lblDevotionReclaimPoints.setFont(fntLabel);
        if (this.ftDevotionReclaimPoints == null) {
            this.ftDevotionReclaimPoints = new JFormattedTextField();
            filter = new IntLenDocFilter(3);
            doc = (AbstractDocument)this.ftDevotionReclaimPoints.getDocument();
            doc.setDocumentFilter(filter);
        }
        this.ftDevotionReclaimPoints.setFont(fntFText);
        if (this.lblMastery1Points == null) {
            this.lblMastery1Points = new JLabel();
        }
        if (this.infos == null) {
            this.lblMastery1Points.setText("");
        } else if (this.infos.length >= 1) {
            args = new Object[]{this.infos[0].name};
            s = GDMsgFormatter.format(GDMsgFormatter.rbUI, "TXT_CHAR_MASTERY_POINTS", args);
            this.lblMastery1Points.setText(s);
        }
        this.lblMastery1Points.setFont(fntLabel);
        if (this.ftMastery1Points == null) {
            this.ftMastery1Points = new JFormattedTextField();
            filter = new IntLenDocFilter(2);
            doc = (AbstractDocument)this.ftMastery1Points.getDocument();
            doc.setDocumentFilter(filter);
        }
        this.ftMastery1Points.setFont(fntFText);
        if (this.lblMastery2Points == null) {
            this.lblMastery2Points = new JLabel();
        }
        if (this.infos == null) {
            this.lblMastery2Points.setText("");
        } else if (this.infos.length == 1) {
            this.lblMastery2Points.setText("");
        } else {
            args = new Object[]{this.infos[1].name};
            s = GDMsgFormatter.format(GDMsgFormatter.rbUI, "TXT_CHAR_MASTERY_POINTS", args);
            this.lblMastery2Points.setText(s);
        }
        this.lblMastery2Points.setFont(fntLabel);
        if (this.ftMastery2Points == null) {
            this.ftMastery2Points = new JFormattedTextField();
            filter = new IntLenDocFilter(2);
            doc = (AbstractDocument)this.ftMastery2Points.getDocument();
            doc.setDocumentFilter(filter);
        }
        this.ftMastery2Points.setFont(fntFText);
    }

    public void setChar(GDChar gdc) {
        if (gdc == null) {
            this.ftStatPoints.setText("0");
            this.ftSkillPoints.setText("0");
            this.ftDevotionPoints.setText("0");
            this.ftSkillReclaimPoints.setText("0");
            this.ftDevotionReclaimPoints.setText("0");
            this.lblMastery1Points.setText("");
            this.lblMastery2Points.setText("");
            this.ftMastery1Points.setText("0");
            this.ftMastery2Points.setText("0");
        } else {
            this.ftStatPoints.setText(Integer.toString(gdc.getStatPoints()));
            this.ftSkillPoints.setText(Integer.toString(gdc.getSkillPoints()));
            this.ftDevotionPoints.setText(Integer.toString(gdc.getDevotionPoints()));
            this.ftSkillReclaimPoints.setText(Integer.toString(gdc.getSkillReclaimPoints()));
            this.ftDevotionReclaimPoints.setText(Integer.toString(gdc.getDevotionReclaimPoints()));
            this.infos = gdc.getMasteryInfo();
            if (this.infos == null) {
                this.lblMastery1Points.setText("");
                this.ftMastery1Points.setText("0");
                this.lblMastery2Points.setText("");
                this.ftMastery2Points.setText("0");
            } else if (this.infos.length == 1) {
                Object[] args = new Object[]{this.infos[0].name};
                String s = GDMsgFormatter.format(GDMsgFormatter.rbUI, "TXT_CHAR_MASTERY_POINTS", args);
                this.lblMastery1Points.setText(s);
                this.ftMastery1Points.setText(Integer.toString(this.infos[0].points));
                this.lblMastery2Points.setText("");
                this.ftMastery2Points.setText("0");
            } else {
                Object[] args1 = new Object[]{this.infos[0].name};
                String s1 = GDMsgFormatter.format(GDMsgFormatter.rbUI, "TXT_CHAR_MASTERY_POINTS", args1);
                this.lblMastery1Points.setText(s1);
                this.ftMastery1Points.setText(Integer.toString(this.infos[0].points));
                Object[] args2 = new Object[]{this.infos[1].name};
                String s2 = GDMsgFormatter.format(GDMsgFormatter.rbUI, "TXT_CHAR_MASTERY_POINTS", args2);
                this.lblMastery2Points.setText(s2);
                this.ftMastery2Points.setText(Integer.toString(this.infos[1].points));
            }
        }
    }

    public void updateChar(GDChar gdc) {
        if (gdc == null) {
            return;
        }
        gdc.setStatPoints(Integer.parseInt(this.ftStatPoints.getText()));
        gdc.setSkillPoints(Integer.parseInt(this.ftSkillPoints.getText()));
        gdc.setDevotionPoints(Integer.parseInt(this.ftDevotionPoints.getText()));
        gdc.setSkillReclaimPoints(Integer.parseInt(this.ftSkillReclaimPoints.getText()));
        gdc.setDevotionReclaimPoints(Integer.parseInt(this.ftDevotionReclaimPoints.getText()));
        if (this.infos != null) {
            if (this.infos.length >= 1) {
                this.infos[0].points = Integer.parseInt(this.ftMastery1Points.getText());
            }
            if (this.infos.length >= 2) {
                this.infos[1].points = Integer.parseInt(this.ftMastery2Points.getText());
            }
        }
        gdc.setMasteryInfo(this.infos);
    }

    public int getStatPoints() {
        int val = 0;
        try {
            val = Integer.parseInt(this.ftStatPoints.getText());
        }
        catch (NumberFormatException ex) {
            val = 0;
        }
        return val;
    }

    public void setStatPoints(int points) {
        this.ftStatPoints.setText(Integer.toString(points));
    }
}

