/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.character;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.character.GDChar;
import org.gdstash.character.GDCharRespawnList;
import org.gdstash.character.GDCharUID;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;

public class GDCharRespawnPane
extends JPanel {
    public static final int SEL_SPAWN_NONE = 0;
    public static final int SEL_SPAWN_DEVILS_CROSSING = 1;
    public static final int SEL_SPAWN_HOMESTAEAD = 2;
    public static final int SEL_SPAWN_FORT_IKON = 3;
    private static String[] spawnPoints = null;
    private JComboBox cbRespawn;
    private int difficulty;
    private boolean changed;

    public GDCharRespawnPane(int difficulty) {
        this.difficulty = difficulty;
        this.changed = false;
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbRespawn));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbRespawn));
        layout.setVerticalGroup(vGroup);
    }

    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCombo = UIManager.getDefaults().getFont("ComboBox.font");
        if (fntCombo == null) {
            fntCombo = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCombo = fntCombo.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SPAWN_POINT"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbRespawn == null) {
            this.cbRespawn = new JComboBox<String>(spawnPoints);
            this.cbRespawn.addActionListener(new ChangeActionListener());
        }
        this.cbRespawn.setFont(fntCombo);
        this.cbRespawn.setMaximumSize(new Dimension(1000, 3 * GDStashFrame.iniConfig.sectUI.fontSize));
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public GDCharUID getSpawnPoint() {
        int idx = this.cbRespawn.getSelectedIndex();
        GDCharUID spawn = null;
        switch (idx) {
            case 1: {
                spawn = GDCharRespawnList.UID_SPAWN_DEVILS_CROSSING;
                break;
            }
            case 2: {
                spawn = GDCharRespawnList.UID_SPAWN_HOMESTEAD;
                break;
            }
            case 3: {
                spawn = GDCharRespawnList.UID_SPAWN_FORT_IKON;
            }
        }
        return spawn;
    }

    public void setChar(GDChar gdc) {
        this.changed = false;
        GDCharUID uid = null;
        if (gdc != null) {
            uid = gdc.getRespawnPoint(this.difficulty);
        }
        if (uid == null) {
            this.cbRespawn.setSelectedIndex(0);
        } else {
            if (uid.equals(GDCharRespawnList.UID_SPAWN_DEVILS_CROSSING)) {
                this.cbRespawn.setSelectedIndex(1);
            }
            if (uid.equals(GDCharRespawnList.UID_SPAWN_HOMESTEAD)) {
                this.cbRespawn.setSelectedIndex(2);
            }
            if (uid.equals(GDCharRespawnList.UID_SPAWN_FORT_IKON)) {
                this.cbRespawn.setSelectedIndex(3);
            }
        }
    }

    public void updateChar(GDChar gdc) {
        if (gdc == null) {
            return;
        }
        if (!this.changed) {
            return;
        }
        GDCharUID spawn = this.getSpawnPoint();
        if (spawn != null) {
            gdc.setRespawnPoint(this.difficulty, spawn);
        }
        this.changed = false;
    }

    static {
        spawnPoints = new String[4];
        GDCharRespawnPane.spawnPoints[0] = "";
        GDCharRespawnPane.spawnPoints[1] = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SPAWN_DEVILS_CROSSING");
        GDCharRespawnPane.spawnPoints[2] = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SPAWN_HOMESTEAD");
        GDCharRespawnPane.spawnPoints[3] = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SPAWN_FORT_IKON");
    }

    private class ChangeActionListener
    implements ActionListener {
        private ChangeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDCharRespawnPane.this.changed = true;
        }
    }
}

