/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.character;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.character.GDChar;
import org.gdstash.character.GDCharTeleportList;
import org.gdstash.character.GDCharUID;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;

public class GDCharRiftAct4Pane
extends JPanel {
    private JCheckBox cbAsterkarnMountains;
    private JCheckBox cbAsterkarnRoad;
    private JCheckBox cbAsterkarnValley;
    private JCheckBox cbFortIkon;
    private JCheckBox cbGatesOfNecropolis;
    private JCheckBox cbNecropolisInterior;
    private int difficulty;
    private boolean changed;

    public GDCharRiftAct4Pane(int difficulty, int direction) {
        this.difficulty = difficulty;
        this.changed = false;
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbAsterkarnMountains).addComponent(this.cbAsterkarnRoad).addComponent(this.cbAsterkarnValley).addComponent(this.cbFortIkon).addComponent(this.cbGatesOfNecropolis).addComponent(this.cbNecropolisInterior));
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbAsterkarnMountains)).addGroup(layout.createParallelGroup().addComponent(this.cbAsterkarnRoad)).addGroup(layout.createParallelGroup().addComponent(this.cbAsterkarnValley)).addGroup(layout.createParallelGroup().addComponent(this.cbFortIkon)).addGroup(layout.createParallelGroup().addComponent(this.cbGatesOfNecropolis)).addGroup(layout.createParallelGroup().addComponent(this.cbNecropolisInterior));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(0, this.cbAsterkarnMountains, this.cbAsterkarnRoad);
        layout.linkSize(0, this.cbAsterkarnMountains, this.cbAsterkarnValley);
        layout.linkSize(0, this.cbAsterkarnMountains, this.cbFortIkon);
        layout.linkSize(0, this.cbAsterkarnMountains, this.cbGatesOfNecropolis);
        layout.linkSize(0, this.cbAsterkarnMountains, this.cbNecropolisInterior);
        layout.linkSize(1, this.cbAsterkarnMountains, this.cbAsterkarnRoad);
        layout.linkSize(1, this.cbAsterkarnMountains, this.cbAsterkarnValley);
        layout.linkSize(1, this.cbAsterkarnMountains, this.cbFortIkon);
        layout.linkSize(1, this.cbAsterkarnMountains, this.cbGatesOfNecropolis);
        layout.linkSize(1, this.cbAsterkarnMountains, this.cbNecropolisInterior);
    }

    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCheck = UIManager.getDefaults().getFont("CheckBox.font");
        if (fntCheck == null) {
            fntCheck = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_ACT4"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbAsterkarnMountains == null) {
            this.cbAsterkarnMountains = new JCheckBox();
            this.cbAsterkarnMountains.addActionListener(new ChangeActionListener());
        }
        this.cbAsterkarnMountains.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_04_ASTERKARN_MOUNTAINS"));
        this.cbAsterkarnMountains.setFont(fntCheck);
        if (this.cbAsterkarnRoad == null) {
            this.cbAsterkarnRoad = new JCheckBox();
            this.cbAsterkarnRoad.addActionListener(new ChangeActionListener());
        }
        this.cbAsterkarnRoad.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_04_ASTERKARN_ROAD"));
        this.cbAsterkarnRoad.setFont(fntCheck);
        if (this.cbAsterkarnValley == null) {
            this.cbAsterkarnValley = new JCheckBox();
            this.cbAsterkarnValley.addActionListener(new ChangeActionListener());
        }
        this.cbAsterkarnValley.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_04_ASTERKARN_VALLEY"));
        this.cbAsterkarnValley.setFont(fntCheck);
        if (this.cbFortIkon == null) {
            this.cbFortIkon = new JCheckBox();
            this.cbFortIkon.addActionListener(new ChangeActionListener());
        }
        this.cbFortIkon.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_04_FORT_IKON"));
        this.cbFortIkon.setFont(fntCheck);
        if (this.cbGatesOfNecropolis == null) {
            this.cbGatesOfNecropolis = new JCheckBox();
            this.cbGatesOfNecropolis.addActionListener(new ChangeActionListener());
        }
        this.cbGatesOfNecropolis.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_04_GATES_OF_NECROPOLIS"));
        this.cbGatesOfNecropolis.setFont(fntCheck);
        if (this.cbNecropolisInterior == null) {
            this.cbNecropolisInterior = new JCheckBox();
            this.cbNecropolisInterior.addActionListener(new ChangeActionListener());
        }
        this.cbNecropolisInterior.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_04_NECROPOLIS_INTERIOR"));
        this.cbNecropolisInterior.setFont(fntCheck);
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void setSelectged(boolean selected) {
        this.cbAsterkarnMountains.setSelected(selected);
        this.cbAsterkarnRoad.setSelected(selected);
        this.cbAsterkarnValley.setSelected(selected);
        this.cbFortIkon.setSelected(selected);
        this.cbGatesOfNecropolis.setSelected(selected);
        this.cbNecropolisInterior.setSelected(selected);
    }

    public List<GDCharUID> getRiftList() {
        LinkedList<GDCharUID> list = new LinkedList<GDCharUID>();
        if (this.cbAsterkarnMountains.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_04_ASTERKARN_MOUNTAINS);
        }
        if (this.cbAsterkarnRoad.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_04_ASTERKARN_ROAD);
        }
        if (this.cbAsterkarnValley.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_04_ASTERKARN_VALLEY);
        }
        if (this.cbFortIkon.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_04_FORT_IKON);
        }
        if (this.cbGatesOfNecropolis.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_04_GATES_OF_NECROPOLIS);
        }
        if (this.cbNecropolisInterior.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_04_NECROPOLIS_INTERIOR);
        }
        return list;
    }

    public void setChar(GDChar gdc) {
        this.setSelectged(false);
        this.changed = false;
        if (gdc == null) {
            return;
        }
        List<GDCharUID> list = gdc.getRiftList(this.difficulty);
        for (GDCharUID uid : list) {
            if (uid.equals(GDCharTeleportList.UID_RIFT_04_ASTERKARN_MOUNTAINS)) {
                this.cbAsterkarnMountains.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_04_ASTERKARN_ROAD)) {
                this.cbAsterkarnRoad.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_04_ASTERKARN_VALLEY)) {
                this.cbAsterkarnValley.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_04_FORT_IKON)) {
                this.cbFortIkon.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_04_GATES_OF_NECROPOLIS)) {
                this.cbGatesOfNecropolis.setSelected(true);
            }
            if (!uid.equals(GDCharTeleportList.UID_RIFT_04_NECROPOLIS_INTERIOR)) continue;
            this.cbNecropolisInterior.setSelected(true);
        }
    }

    private class ChangeActionListener
    implements ActionListener {
        private ChangeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDCharRiftAct4Pane.this.changed = true;
        }
    }
}

