/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.character;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.character.GDChar;
import org.gdstash.character.GDCharShrineList;
import org.gdstash.character.GDCharUID;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;

public class GDCharShrineAct2Pane
extends JPanel {
    private JCheckBox cbSpinedCove;
    private JCheckBox cbRockyCoast;
    private JCheckBox cbCronleysHideout;
    private JCheckBox cbOldArkovia;
    private JCheckBox cbArkovianUndercity;
    private JCheckBox cbBrokenHills;
    private JCheckBox cbStepsOfTorment;
    private int difficulty;
    private boolean changed;

    public GDCharShrineAct2Pane(int difficulty, int direction) {
        this.difficulty = difficulty;
        this.changed = false;
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbSpinedCove).addComponent(this.cbRockyCoast).addComponent(this.cbCronleysHideout).addComponent(this.cbOldArkovia).addComponent(this.cbArkovianUndercity).addComponent(this.cbBrokenHills).addComponent(this.cbStepsOfTorment));
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbSpinedCove)).addGroup(layout.createParallelGroup().addComponent(this.cbRockyCoast)).addGroup(layout.createParallelGroup().addComponent(this.cbCronleysHideout)).addGroup(layout.createParallelGroup().addComponent(this.cbOldArkovia)).addGroup(layout.createParallelGroup().addComponent(this.cbArkovianUndercity)).addGroup(layout.createParallelGroup().addComponent(this.cbBrokenHills)).addGroup(layout.createParallelGroup().addComponent(this.cbStepsOfTorment));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(0, this.cbSpinedCove, this.cbRockyCoast);
        layout.linkSize(0, this.cbSpinedCove, this.cbCronleysHideout);
        layout.linkSize(0, this.cbSpinedCove, this.cbOldArkovia);
        layout.linkSize(0, this.cbSpinedCove, this.cbArkovianUndercity);
        layout.linkSize(0, this.cbSpinedCove, this.cbBrokenHills);
        layout.linkSize(0, this.cbSpinedCove, this.cbStepsOfTorment);
        layout.linkSize(1, this.cbSpinedCove, this.cbRockyCoast);
        layout.linkSize(1, this.cbSpinedCove, this.cbCronleysHideout);
        layout.linkSize(1, this.cbSpinedCove, this.cbOldArkovia);
        layout.linkSize(1, this.cbSpinedCove, this.cbArkovianUndercity);
        layout.linkSize(1, this.cbSpinedCove, this.cbBrokenHills);
        layout.linkSize(1, this.cbSpinedCove, this.cbStepsOfTorment);
    }

    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCheck = UIManager.getDefaults().getFont("CheckBox.font");
        if (fntCheck == null) {
            fntCheck = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_ACT2"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbSpinedCove == null) {
            this.cbSpinedCove = new JCheckBox();
            if (this.difficulty > 1) {
                this.cbSpinedCove.setEnabled(false);
            } else {
                this.cbSpinedCove.addActionListener(new ChangeActionListener());
            }
        }
        this.cbSpinedCove.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_02_SPINED_COVE"));
        this.cbSpinedCove.setFont(fntCheck);
        if (this.cbRockyCoast == null) {
            this.cbRockyCoast = new JCheckBox();
            if (this.difficulty > 1) {
                this.cbRockyCoast.setEnabled(false);
            } else {
                this.cbRockyCoast.addActionListener(new ChangeActionListener());
            }
        }
        this.cbRockyCoast.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_02_ROCKY_COAST"));
        this.cbRockyCoast.setFont(fntCheck);
        if (this.cbCronleysHideout == null) {
            this.cbCronleysHideout = new JCheckBox();
            this.cbCronleysHideout.addActionListener(new ChangeActionListener());
        }
        this.cbCronleysHideout.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_02_CRONLEYS_HIDEOUT"));
        this.cbCronleysHideout.setFont(fntCheck);
        if (this.cbOldArkovia == null) {
            this.cbOldArkovia = new JCheckBox();
            if (this.difficulty > 0) {
                this.cbOldArkovia.setEnabled(false);
            } else {
                this.cbOldArkovia.addActionListener(new ChangeActionListener());
            }
        }
        this.cbOldArkovia.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_02_OLD_ARKOVIA"));
        this.cbOldArkovia.setFont(fntCheck);
        if (this.cbArkovianUndercity == null) {
            this.cbArkovianUndercity = new JCheckBox();
            this.cbArkovianUndercity.addActionListener(new ChangeActionListener());
        }
        this.cbArkovianUndercity.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_02_ARKOVIAN_UNDERCITY"));
        this.cbArkovianUndercity.setFont(fntCheck);
        if (this.cbBrokenHills == null) {
            this.cbBrokenHills = new JCheckBox();
            if (this.difficulty > 0) {
                this.cbBrokenHills.setEnabled(false);
            } else {
                this.cbBrokenHills.addActionListener(new ChangeActionListener());
            }
        }
        this.cbBrokenHills.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_02_BROKEN_HILLS"));
        this.cbBrokenHills.setFont(fntCheck);
        if (this.cbStepsOfTorment == null) {
            this.cbStepsOfTorment = new JCheckBox();
            this.cbStepsOfTorment.addActionListener(new ChangeActionListener());
        }
        this.cbStepsOfTorment.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_02_STEPS_OF_TORMENT"));
        this.cbStepsOfTorment.setFont(fntCheck);
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void setSelectged(boolean selected) {
        this.cbSpinedCove.setSelected(selected);
        this.cbRockyCoast.setSelected(selected);
        this.cbCronleysHideout.setSelected(selected);
        this.cbOldArkovia.setSelected(selected);
        this.cbArkovianUndercity.setSelected(selected);
        this.cbBrokenHills.setSelected(selected);
        this.cbStepsOfTorment.setSelected(selected);
    }

    public List<GDCharUID> getShrineList() {
        LinkedList<GDCharUID> list = new LinkedList<GDCharUID>();
        if (this.cbSpinedCove.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_02_SPINED_COVE);
        }
        if (this.cbRockyCoast.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_02_ROCKY_COAST);
        }
        if (this.cbCronleysHideout.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_02_CRONLEYS_HIDEOUT);
        }
        if (this.cbOldArkovia.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_02_OLD_ARKOVIA);
        }
        if (this.cbArkovianUndercity.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_02_ARKOVIAN_UNDERCITY);
        }
        if (this.cbBrokenHills.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_02_BROKEN_HILLS);
        }
        if (this.cbStepsOfTorment.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_02_STEPS_OF_TORMENT);
        }
        return list;
    }

    public void setChar(GDChar gdc) {
        this.setSelectged(false);
        this.changed = false;
        if (gdc == null) {
            return;
        }
        List<GDCharUID> list = gdc.getRestoredShrinesList(this.difficulty);
        for (GDCharUID uid : list) {
            if (uid.equals(GDCharShrineList.UID_SHRINE_02_SPINED_COVE)) {
                this.cbSpinedCove.setSelected(true);
            }
            if (uid.equals(GDCharShrineList.UID_SHRINE_02_ROCKY_COAST)) {
                this.cbRockyCoast.setSelected(true);
            }
            if (uid.equals(GDCharShrineList.UID_SHRINE_02_CRONLEYS_HIDEOUT)) {
                this.cbCronleysHideout.setSelected(true);
            }
            if (uid.equals(GDCharShrineList.UID_SHRINE_02_OLD_ARKOVIA)) {
                this.cbOldArkovia.setSelected(true);
            }
            if (uid.equals(GDCharShrineList.UID_SHRINE_02_ARKOVIAN_UNDERCITY)) {
                this.cbArkovianUndercity.setSelected(true);
            }
            if (uid.equals(GDCharShrineList.UID_SHRINE_02_BROKEN_HILLS)) {
                this.cbBrokenHills.setSelected(true);
            }
            if (!uid.equals(GDCharShrineList.UID_SHRINE_02_STEPS_OF_TORMENT)) continue;
            this.cbStepsOfTorment.setSelected(true);
        }
    }

    private class ChangeActionListener
    implements ActionListener {
        private ChangeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDCharShrineAct2Pane.this.changed = true;
        }
    }
}

