/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.character;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.character.GDChar;
import org.gdstash.character.GDCharShrineList;
import org.gdstash.character.GDCharUID;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;

public class GDCharShrineAct4Pane
extends JPanel {
    private JCheckBox cbAsterkarnValley;
    private JCheckBox cbMogdrogensShrine;
    private JCheckBox cbTombOfTheDamned;
    private JCheckBox cbGatesOfNecropolis;
    private JCheckBox cbBlackSepulcher;
    private JCheckBox cbBastionOfChaos;
    private JCheckBox cbSanctumOfTheImmortal;
    private int difficulty;
    private boolean changed;

    public GDCharShrineAct4Pane(int difficulty, int direction) {
        this.difficulty = difficulty;
        this.changed = false;
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbAsterkarnValley).addComponent(this.cbMogdrogensShrine).addComponent(this.cbTombOfTheDamned).addComponent(this.cbGatesOfNecropolis).addComponent(this.cbBlackSepulcher).addComponent(this.cbBastionOfChaos).addComponent(this.cbSanctumOfTheImmortal));
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbAsterkarnValley)).addGroup(layout.createParallelGroup().addComponent(this.cbMogdrogensShrine)).addGroup(layout.createParallelGroup().addComponent(this.cbTombOfTheDamned)).addGroup(layout.createParallelGroup().addComponent(this.cbGatesOfNecropolis)).addGroup(layout.createParallelGroup().addComponent(this.cbBlackSepulcher)).addGroup(layout.createParallelGroup().addComponent(this.cbBastionOfChaos)).addGroup(layout.createParallelGroup().addComponent(this.cbSanctumOfTheImmortal));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(0, this.cbAsterkarnValley, this.cbMogdrogensShrine);
        layout.linkSize(0, this.cbAsterkarnValley, this.cbTombOfTheDamned);
        layout.linkSize(0, this.cbAsterkarnValley, this.cbGatesOfNecropolis);
        layout.linkSize(0, this.cbAsterkarnValley, this.cbBlackSepulcher);
        layout.linkSize(0, this.cbAsterkarnValley, this.cbBastionOfChaos);
        layout.linkSize(0, this.cbAsterkarnValley, this.cbSanctumOfTheImmortal);
        layout.linkSize(1, this.cbAsterkarnValley, this.cbMogdrogensShrine);
        layout.linkSize(1, this.cbAsterkarnValley, this.cbTombOfTheDamned);
        layout.linkSize(1, this.cbAsterkarnValley, this.cbGatesOfNecropolis);
        layout.linkSize(1, this.cbAsterkarnValley, this.cbBlackSepulcher);
        layout.linkSize(1, this.cbAsterkarnValley, this.cbBastionOfChaos);
        layout.linkSize(1, this.cbAsterkarnValley, this.cbSanctumOfTheImmortal);
    }

    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCheck = UIManager.getDefaults().getFont("CheckBox.font");
        if (fntCheck == null) {
            fntCheck = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_ACT4"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbAsterkarnValley == null) {
            this.cbAsterkarnValley = new JCheckBox();
            if (this.difficulty > 0) {
                this.cbAsterkarnValley.setEnabled(false);
            } else {
                this.cbAsterkarnValley.addActionListener(new ChangeActionListener());
            }
        }
        this.cbAsterkarnValley.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_04_ASTERKARN_VALLEY"));
        this.cbAsterkarnValley.setFont(fntCheck);
        if (this.cbMogdrogensShrine == null) {
            this.cbMogdrogensShrine = new JCheckBox();
            this.cbMogdrogensShrine.addActionListener(new ChangeActionListener());
        }
        this.cbMogdrogensShrine.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_04_MOGDROGENS_SHRINE"));
        this.cbMogdrogensShrine.setFont(fntCheck);
        if (this.cbTombOfTheDamned == null) {
            this.cbTombOfTheDamned = new JCheckBox();
            this.cbTombOfTheDamned.addActionListener(new ChangeActionListener());
        }
        this.cbTombOfTheDamned.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_04_TOMB_OF_THE_DAMNED"));
        this.cbTombOfTheDamned.setFont(fntCheck);
        if (this.cbGatesOfNecropolis == null) {
            this.cbGatesOfNecropolis = new JCheckBox();
            if (this.difficulty > 0) {
                this.cbGatesOfNecropolis.setEnabled(false);
            } else {
                this.cbGatesOfNecropolis.addActionListener(new ChangeActionListener());
            }
        }
        this.cbGatesOfNecropolis.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_04_GATES_OF_NECROPOLIS"));
        this.cbGatesOfNecropolis.setFont(fntCheck);
        if (this.cbBlackSepulcher == null) {
            this.cbBlackSepulcher = new JCheckBox();
            this.cbBlackSepulcher.addActionListener(new ChangeActionListener());
        }
        this.cbBlackSepulcher.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_04_BLACK_SEPULCHER"));
        this.cbBlackSepulcher.setFont(fntCheck);
        if (this.cbBastionOfChaos == null) {
            this.cbBastionOfChaos = new JCheckBox();
            this.cbBastionOfChaos.addActionListener(new ChangeActionListener());
        }
        this.cbBastionOfChaos.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_04_BASTION_OF_CHAOS"));
        this.cbBastionOfChaos.setFont(fntCheck);
        if (this.cbSanctumOfTheImmortal == null) {
            this.cbSanctumOfTheImmortal = new JCheckBox();
            if (this.difficulty != 2) {
                this.cbSanctumOfTheImmortal.setEnabled(false);
            } else {
                this.cbSanctumOfTheImmortal.addActionListener(new ChangeActionListener());
            }
        }
        this.cbSanctumOfTheImmortal.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_04_SANCTUM_OF_THE_IMMORTAL"));
        this.cbSanctumOfTheImmortal.setFont(fntCheck);
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void setSelectged(boolean selected) {
        this.cbAsterkarnValley.setSelected(selected);
        this.cbMogdrogensShrine.setSelected(selected);
        this.cbTombOfTheDamned.setSelected(selected);
        this.cbGatesOfNecropolis.setSelected(selected);
        this.cbBlackSepulcher.setSelected(selected);
        this.cbBastionOfChaos.setSelected(selected);
        this.cbSanctumOfTheImmortal.setSelected(selected);
    }

    public List<GDCharUID> getShrineList() {
        LinkedList<GDCharUID> list = new LinkedList<GDCharUID>();
        if (this.cbAsterkarnValley.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_04_ASTERKARN_VALLEY);
        }
        if (this.cbMogdrogensShrine.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_04_MOGDROGENS_SHRINE);
        }
        if (this.cbTombOfTheDamned.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_04_TOMB_OF_THE_DAMNED);
        }
        if (this.cbGatesOfNecropolis.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_04_GATES_OF_NECROPOLIS);
        }
        if (this.cbBlackSepulcher.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_04_BLACK_SEPULCHER);
        }
        if (this.cbBastionOfChaos.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_04_BASTION_OF_CHAOS);
        }
        if (this.cbSanctumOfTheImmortal.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_04_SANCTUM_OF_THE_IMMORTAL);
        }
        return list;
    }

    public void setChar(GDChar gdc) {
        this.setSelectged(false);
        this.changed = false;
        if (gdc == null) {
            return;
        }
        List<GDCharUID> list = gdc.getRestoredShrinesList(this.difficulty);
        for (GDCharUID uid : list) {
            if (uid.equals(GDCharShrineList.UID_SHRINE_04_ASTERKARN_VALLEY)) {
                this.cbAsterkarnValley.setSelected(true);
            }
            if (uid.equals(GDCharShrineList.UID_SHRINE_04_MOGDROGENS_SHRINE)) {
                this.cbMogdrogensShrine.setSelected(true);
            }
            if (uid.equals(GDCharShrineList.UID_SHRINE_04_TOMB_OF_THE_DAMNED)) {
                this.cbTombOfTheDamned.setSelected(true);
            }
            if (uid.equals(GDCharShrineList.UID_SHRINE_04_GATES_OF_NECROPOLIS)) {
                this.cbGatesOfNecropolis.setSelected(true);
            }
            if (uid.equals(GDCharShrineList.UID_SHRINE_04_BLACK_SEPULCHER)) {
                this.cbBlackSepulcher.setSelected(true);
            }
            if (uid.equals(GDCharShrineList.UID_SHRINE_04_BASTION_OF_CHAOS)) {
                this.cbBastionOfChaos.setSelected(true);
            }
            if (!uid.equals(GDCharShrineList.UID_SHRINE_04_SANCTUM_OF_THE_IMMORTAL)) continue;
            this.cbSanctumOfTheImmortal.setSelected(true);
        }
    }

    private class ChangeActionListener
    implements ActionListener {
        private ChangeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDCharShrineAct4Pane.this.changed = true;
        }
    }
}

