/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;

public class AffixRarityPane
extends JPanel {
    private JCheckBox cbMagical;
    private JCheckBox cbRare;

    public AffixRarityPane(int direction) {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbMagical).addComponent(this.cbRare));
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbMagical)).addGroup(layout.createParallelGroup().addComponent(this.cbRare));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(0, this.cbMagical, this.cbRare);
        layout.linkSize(1, this.cbMagical, this.cbRare);
    }

    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCheck = UIManager.getDefaults().getFont("CheckBox.font");
        if (fntCheck == null) {
            fntCheck = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RARITY_AFFIX"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbMagical == null) {
            this.cbMagical = new JCheckBox();
        }
        this.cbMagical.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "RARITY_AFFIX_MAGICAL"));
        this.cbMagical.setFont(fntCheck);
        if (this.cbRare == null) {
            this.cbRare = new JCheckBox();
        }
        this.cbRare.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "RARITY_AFFIX_RARE"));
        this.cbRare.setFont(fntCheck);
    }

    public void clear() {
        this.cbMagical.setSelected(false);
        this.cbRare.setSelected(false);
    }

    public void addCriteria(SelectionCriteria criteria) {
        if (this.cbMagical.isSelected()) {
            criteria.itemRarity.add("Magical");
        }
        if (this.cbRare.isSelected()) {
            criteria.itemRarity.add("Rare");
        }
    }
}

