/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;

public class ArmorTypePane
extends JPanel {
    private JCheckBox cbHead;
    private JCheckBox cbShoulders;
    private JCheckBox cbChest;
    private JCheckBox cbHands;
    private JCheckBox cbLegs;
    private JCheckBox cbFeet;
    private JCheckBox cbBelt;
    private JCheckBox cbAmulet;
    private JCheckBox cbRing;
    private JCheckBox cbMedal;

    public ArmorTypePane() {
        this(1);
    }

    public ArmorTypePane(int direction) {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbHead).addComponent(this.cbShoulders).addComponent(this.cbChest).addComponent(this.cbHands).addComponent(this.cbLegs).addComponent(this.cbFeet).addComponent(this.cbBelt).addComponent(this.cbAmulet).addComponent(this.cbRing).addComponent(this.cbMedal));
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbHead)).addGroup(layout.createParallelGroup().addComponent(this.cbShoulders)).addGroup(layout.createParallelGroup().addComponent(this.cbChest)).addGroup(layout.createParallelGroup().addComponent(this.cbHands)).addGroup(layout.createParallelGroup().addComponent(this.cbLegs)).addGroup(layout.createParallelGroup().addComponent(this.cbFeet)).addGroup(layout.createParallelGroup().addComponent(this.cbBelt)).addGroup(layout.createParallelGroup().addComponent(this.cbAmulet)).addGroup(layout.createParallelGroup().addComponent(this.cbRing)).addGroup(layout.createParallelGroup().addComponent(this.cbMedal));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(0, this.cbHead, this.cbShoulders);
        layout.linkSize(0, this.cbHead, this.cbChest);
        layout.linkSize(0, this.cbHead, this.cbHands);
        layout.linkSize(0, this.cbHead, this.cbLegs);
        layout.linkSize(0, this.cbHead, this.cbFeet);
        layout.linkSize(0, this.cbHead, this.cbBelt);
        layout.linkSize(0, this.cbHead, this.cbAmulet);
        layout.linkSize(0, this.cbHead, this.cbRing);
        layout.linkSize(0, this.cbHead, this.cbMedal);
        layout.linkSize(1, this.cbHead, this.cbShoulders);
        layout.linkSize(1, this.cbHead, this.cbChest);
        layout.linkSize(1, this.cbHead, this.cbHands);
        layout.linkSize(1, this.cbHead, this.cbLegs);
        layout.linkSize(1, this.cbHead, this.cbFeet);
        layout.linkSize(1, this.cbHead, this.cbBelt);
        layout.linkSize(1, this.cbHead, this.cbAmulet);
        layout.linkSize(1, this.cbHead, this.cbRing);
        layout.linkSize(1, this.cbHead, this.cbMedal);
    }

    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCheck = UIManager.getDefaults().getFont("CheckBox.font");
        if (fntCheck == null) {
            fntCheck = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_TYPE_ARMOR"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbHead == null) {
            this.cbHead = new JCheckBox();
        }
        this.cbHead.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TYPE_ARMOR_HEAD"));
        this.cbHead.setFont(fntCheck);
        if (this.cbShoulders == null) {
            this.cbShoulders = new JCheckBox();
        }
        this.cbShoulders.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TYPE_ARMOR_SHOULDERS"));
        this.cbShoulders.setFont(fntCheck);
        if (this.cbChest == null) {
            this.cbChest = new JCheckBox();
        }
        this.cbChest.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TYPE_ARMOR_CHEST"));
        this.cbChest.setFont(fntCheck);
        if (this.cbHands == null) {
            this.cbHands = new JCheckBox();
        }
        this.cbHands.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TYPE_ARMOR_HANDS"));
        this.cbHands.setFont(fntCheck);
        if (this.cbLegs == null) {
            this.cbLegs = new JCheckBox();
        }
        this.cbLegs.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TYPE_ARMOR_LEGS"));
        this.cbLegs.setFont(fntCheck);
        if (this.cbFeet == null) {
            this.cbFeet = new JCheckBox();
        }
        this.cbFeet.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TYPE_ARMOR_FEET"));
        this.cbFeet.setFont(fntCheck);
        if (this.cbBelt == null) {
            this.cbBelt = new JCheckBox();
        }
        this.cbBelt.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TYPE_ARMOR_BELT"));
        this.cbBelt.setFont(fntCheck);
        if (this.cbAmulet == null) {
            this.cbAmulet = new JCheckBox();
        }
        this.cbAmulet.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TYPE_ARMOR_AMULET"));
        this.cbAmulet.setFont(fntCheck);
        if (this.cbRing == null) {
            this.cbRing = new JCheckBox();
        }
        this.cbRing.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TYPE_ARMOR_RING"));
        this.cbRing.setFont(fntCheck);
        if (this.cbMedal == null) {
            this.cbMedal = new JCheckBox();
        }
        this.cbMedal.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TYPE_ARMOR_MEDAL"));
        this.cbMedal.setFont(fntCheck);
    }

    public void setSelection(int sel) {
        this.clear();
        switch (sel) {
            case 0: {
                break;
            }
            case 1: {
                this.cbHead.setSelected(true);
                this.cbShoulders.setSelected(true);
                this.cbChest.setSelected(true);
                this.cbHands.setSelected(true);
                this.cbLegs.setSelected(true);
                this.cbFeet.setSelected(true);
                this.cbBelt.setSelected(true);
                this.cbAmulet.setSelected(true);
                this.cbRing.setSelected(true);
                this.cbMedal.setSelected(true);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.cbHead.setSelected(true);
                this.cbShoulders.setSelected(true);
                this.cbChest.setSelected(true);
                this.cbHands.setSelected(true);
                this.cbLegs.setSelected(true);
                this.cbFeet.setSelected(true);
                this.cbBelt.setSelected(true);
                this.cbAmulet.setSelected(true);
                this.cbRing.setSelected(true);
                this.cbMedal.setSelected(true);
                break;
            }
            case 4: {
                this.cbHead.setSelected(true);
                this.cbShoulders.setSelected(true);
                this.cbChest.setSelected(true);
                this.cbHands.setSelected(true);
                this.cbLegs.setSelected(true);
                this.cbFeet.setSelected(true);
                break;
            }
            case 5: {
                this.cbBelt.setSelected(true);
                this.cbAmulet.setSelected(true);
                this.cbRing.setSelected(true);
                this.cbMedal.setSelected(true);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
        }
    }

    public void clear() {
        this.cbHead.setSelected(false);
        this.cbShoulders.setSelected(false);
        this.cbChest.setSelected(false);
        this.cbHands.setSelected(false);
        this.cbLegs.setSelected(false);
        this.cbFeet.setSelected(false);
        this.cbBelt.setSelected(false);
        this.cbAmulet.setSelected(false);
        this.cbRing.setSelected(false);
        this.cbMedal.setSelected(false);
    }

    public void addCriteria(SelectionCriteria criteria) {
        if (this.cbHead.isSelected()) {
            criteria.itemClass.add("ArmorProtective_Head");
        }
        if (this.cbShoulders.isSelected()) {
            criteria.itemClass.add("ArmorProtective_Shoulders");
        }
        if (this.cbChest.isSelected()) {
            criteria.itemClass.add("ArmorProtective_Chest");
        }
        if (this.cbHands.isSelected()) {
            criteria.itemClass.add("ArmorProtective_Hands");
        }
        if (this.cbLegs.isSelected()) {
            criteria.itemClass.add("ArmorProtective_Legs");
        }
        if (this.cbFeet.isSelected()) {
            criteria.itemClass.add("ArmorProtective_Feet");
        }
        if (this.cbBelt.isSelected()) {
            criteria.itemClass.add("ArmorProtective_Waist");
        }
        if (this.cbAmulet.isSelected()) {
            criteria.itemClass.add("ArmorJewelry_Amulet");
        }
        if (this.cbRing.isSelected()) {
            criteria.itemClass.add("ArmorJewelry_Ring");
        }
        if (this.cbMedal.isSelected()) {
            criteria.itemClass.add("ArmorJewelry_Medal");
        }
    }

    public void addComponentCriteria(SelectionCriteria criteria) {
        criteria.slotHead = this.cbHead.isSelected();
        criteria.slotShoulders = this.cbShoulders.isSelected();
        criteria.slotChest = this.cbChest.isSelected();
        criteria.slotHands = this.cbHands.isSelected();
        criteria.slotLegs = this.cbLegs.isSelected();
        criteria.slotFeet = this.cbFeet.isSelected();
        criteria.slotBelt = this.cbBelt.isSelected();
        criteria.slotAmulet = this.cbAmulet.isSelected();
        criteria.slotRing = this.cbRing.isSelected();
        criteria.slotMedal = this.cbMedal.isSelected();
    }
}

