/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;

public class ArtifactRarityPane
extends JPanel {
    private JCheckBox cbLesser;
    private JCheckBox cbGreater;
    private JCheckBox cbDivine;

    public ArtifactRarityPane(int direction) {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbLesser).addComponent(this.cbGreater).addComponent(this.cbDivine));
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbLesser)).addGroup(layout.createParallelGroup().addComponent(this.cbGreater)).addGroup(layout.createParallelGroup().addComponent(this.cbDivine));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(0, this.cbLesser, this.cbGreater);
        layout.linkSize(0, this.cbLesser, this.cbDivine);
        layout.linkSize(1, this.cbLesser, this.cbGreater);
        layout.linkSize(1, this.cbLesser, this.cbDivine);
    }

    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCheck = UIManager.getDefaults().getFont("CheckBox.font");
        if (fntCheck == null) {
            fntCheck = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RARITY_ARTIFACT"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbLesser == null) {
            this.cbLesser = new JCheckBox();
        }
        this.cbLesser.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "RARITY_ARTIFACT_LESSER"));
        this.cbLesser.setFont(fntCheck);
        if (this.cbGreater == null) {
            this.cbGreater = new JCheckBox();
        }
        this.cbGreater.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "RARITY_ARTIFACT_GREATER"));
        this.cbGreater.setFont(fntCheck);
        if (this.cbDivine == null) {
            this.cbDivine = new JCheckBox();
        }
        this.cbDivine.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "RARITY_ARTIFACT_DIVINE"));
        this.cbDivine.setFont(fntCheck);
    }

    public void clear() {
        this.cbLesser.setSelected(false);
        this.cbGreater.setSelected(false);
        this.cbDivine.setSelected(false);
    }

    public void addCriteria(SelectionCriteria criteria) {
        if (this.cbLesser.isSelected()) {
            criteria.artifactClass.add("Lesser");
        }
        if (this.cbGreater.isSelected()) {
            criteria.artifactClass.add("Greater");
        }
        if (this.cbDivine.isSelected()) {
            criteria.artifactClass.add("Divine");
        }
    }
}

