/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;

public class AttribFlatPane
extends JPanel {
    private JCheckBox cbPhysique;
    private JCheckBox cbCunning;
    private JCheckBox cbSpirit;
    private JCheckBox cbDefense;
    private JCheckBox cbOffense;
    private JCheckBox cbHealth;
    private JCheckBox cbHealthRegen;
    private JCheckBox cbEnergyRegen;

    public AttribFlatPane(int direction) {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbPhysique).addComponent(this.cbCunning).addComponent(this.cbSpirit).addComponent(this.cbDefense).addComponent(this.cbOffense).addComponent(this.cbHealth).addComponent(this.cbHealthRegen).addComponent(this.cbEnergyRegen));
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbPhysique)).addGroup(layout.createParallelGroup().addComponent(this.cbCunning)).addGroup(layout.createParallelGroup().addComponent(this.cbSpirit)).addGroup(layout.createParallelGroup().addComponent(this.cbDefense)).addGroup(layout.createParallelGroup().addComponent(this.cbOffense)).addGroup(layout.createParallelGroup().addComponent(this.cbHealth)).addGroup(layout.createParallelGroup().addComponent(this.cbHealthRegen)).addGroup(layout.createParallelGroup().addComponent(this.cbEnergyRegen));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(0, this.cbPhysique, this.cbCunning);
        layout.linkSize(0, this.cbPhysique, this.cbSpirit);
        layout.linkSize(0, this.cbPhysique, this.cbDefense);
        layout.linkSize(0, this.cbPhysique, this.cbOffense);
        layout.linkSize(0, this.cbPhysique, this.cbHealth);
        layout.linkSize(0, this.cbPhysique, this.cbHealthRegen);
        layout.linkSize(0, this.cbPhysique, this.cbEnergyRegen);
        layout.linkSize(1, this.cbPhysique, this.cbCunning);
        layout.linkSize(1, this.cbPhysique, this.cbSpirit);
        layout.linkSize(1, this.cbPhysique, this.cbDefense);
        layout.linkSize(1, this.cbPhysique, this.cbOffense);
        layout.linkSize(1, this.cbPhysique, this.cbHealth);
        layout.linkSize(1, this.cbPhysique, this.cbHealthRegen);
        layout.linkSize(1, this.cbPhysique, this.cbEnergyRegen);
    }

    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCheck = UIManager.getDefaults().getFont("CheckBox.font");
        if (fntCheck == null) {
            fntCheck = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_ATTRIB_ABS"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbPhysique == null) {
            this.cbPhysique = new JCheckBox();
        }
        this.cbPhysique.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_PHYSIQUE"));
        this.cbPhysique.setFont(fntCheck);
        if (this.cbCunning == null) {
            this.cbCunning = new JCheckBox();
        }
        this.cbCunning.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_CUNNING"));
        this.cbCunning.setFont(fntCheck);
        if (this.cbSpirit == null) {
            this.cbSpirit = new JCheckBox();
        }
        this.cbSpirit.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_SPIRIT"));
        this.cbSpirit.setFont(fntCheck);
        if (this.cbDefense == null) {
            this.cbDefense = new JCheckBox();
        }
        this.cbDefense.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_DEF_ABIL"));
        this.cbDefense.setFont(fntCheck);
        if (this.cbOffense == null) {
            this.cbOffense = new JCheckBox();
        }
        this.cbOffense.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_OFF_ABIL"));
        this.cbOffense.setFont(fntCheck);
        if (this.cbHealth == null) {
            this.cbHealth = new JCheckBox();
        }
        this.cbHealth.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_HEALTH"));
        this.cbHealth.setFont(fntCheck);
        if (this.cbHealthRegen == null) {
            this.cbHealthRegen = new JCheckBox();
        }
        this.cbHealthRegen.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_REGEN_HEALTH"));
        this.cbHealthRegen.setFont(fntCheck);
        if (this.cbEnergyRegen == null) {
            this.cbEnergyRegen = new JCheckBox();
        }
        this.cbEnergyRegen.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_REGEN_ENERGY"));
        this.cbEnergyRegen.setFont(fntCheck);
    }

    public void clear() {
        this.cbCunning.setSelected(false);
        this.cbPhysique.setSelected(false);
        this.cbSpirit.setSelected(false);
        this.cbDefense.setSelected(false);
        this.cbOffense.setSelected(false);
        this.cbHealth.setSelected(false);
        this.cbHealthRegen.setSelected(false);
        this.cbEnergyRegen.setSelected(false);
    }

    public void addCriteria(SelectionCriteria criteria) {
        criteria.statFlat.physique = this.cbPhysique.isSelected();
        criteria.statFlat.cunning = this.cbCunning.isSelected();
        criteria.statFlat.spirit = this.cbSpirit.isSelected();
        criteria.statFlat.defense = this.cbDefense.isSelected();
        criteria.statFlat.offense = this.cbOffense.isSelected();
        criteria.statFlat.health = this.cbHealth.isSelected();
        criteria.statFlat.healthRegen = this.cbHealthRegen.isSelected();
        criteria.statFlat.energyRegen = this.cbEnergyRegen.isSelected();
    }
}

