/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;

public class DamageFlatPercPane
extends JPanel {
    private JCheckBox cbFlat;
    private JCheckBox cbRPerc;

    public DamageFlatPercPane(int direction) {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbFlat).addComponent(this.cbRPerc));
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbFlat)).addGroup(layout.createParallelGroup().addComponent(this.cbRPerc));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(0, this.cbFlat, this.cbRPerc);
        layout.linkSize(1, this.cbFlat, this.cbRPerc);
    }

    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCheck = UIManager.getDefaults().getFont("CheckBox.font");
        if (fntCheck == null) {
            fntCheck = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_DAMAGE"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbFlat == null) {
            this.cbFlat = new JCheckBox();
        }
        this.cbFlat.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "DAMAGE_FLAT"));
        this.cbFlat.setFont(fntCheck);
        if (this.cbRPerc == null) {
            this.cbRPerc = new JCheckBox();
        }
        this.cbRPerc.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "DAMAGE_PERCENT"));
        this.cbRPerc.setFont(fntCheck);
    }

    public void clear() {
        this.cbFlat.setSelected(false);
        this.cbRPerc.setSelected(false);
    }

    public void addCriteria(SelectionCriteria criteria) {
        criteria.dmgFlat = this.cbFlat.isSelected();
        criteria.dmgPercentage = this.cbRPerc.isSelected();
    }
}

