/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;

public class DamageSpecialPane
extends JPanel {
    private JCheckBox cbTotal;
    private JCheckBox cbCritical;
    private JCheckBox cbLifeLeech;
    private JCheckBox cbReflect;
    private JCheckBox cbAttackSpeed;
    private JCheckBox cbTotalSpeed;
    private JCheckBox cbDefenseAbil;
    private JCheckBox cbOffenseAbil;
    private JCheckBox cbPetBonus;

    public DamageSpecialPane() {
        this(1);
    }

    public DamageSpecialPane(int direction) {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbTotal).addComponent(this.cbCritical).addComponent(this.cbLifeLeech).addComponent(this.cbReflect).addComponent(this.cbAttackSpeed).addComponent(this.cbTotalSpeed).addComponent(this.cbDefenseAbil).addComponent(this.cbOffenseAbil).addComponent(this.cbPetBonus));
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbTotal)).addGroup(layout.createParallelGroup().addComponent(this.cbCritical)).addGroup(layout.createParallelGroup().addComponent(this.cbLifeLeech)).addGroup(layout.createParallelGroup().addComponent(this.cbReflect)).addGroup(layout.createParallelGroup().addComponent(this.cbAttackSpeed)).addGroup(layout.createParallelGroup().addComponent(this.cbTotalSpeed)).addGroup(layout.createParallelGroup().addComponent(this.cbDefenseAbil)).addGroup(layout.createParallelGroup().addComponent(this.cbOffenseAbil)).addGroup(layout.createParallelGroup().addComponent(this.cbPetBonus));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(0, this.cbTotal, this.cbLifeLeech);
        layout.linkSize(0, this.cbTotal, this.cbLifeLeech);
        layout.linkSize(0, this.cbTotal, this.cbReflect);
        layout.linkSize(0, this.cbTotal, this.cbAttackSpeed);
        layout.linkSize(0, this.cbTotal, this.cbTotalSpeed);
        layout.linkSize(0, this.cbTotal, this.cbDefenseAbil);
        layout.linkSize(0, this.cbTotal, this.cbOffenseAbil);
        layout.linkSize(0, this.cbTotal, this.cbPetBonus);
        layout.linkSize(1, this.cbTotal, this.cbCritical);
        layout.linkSize(1, this.cbTotal, this.cbLifeLeech);
        layout.linkSize(1, this.cbTotal, this.cbReflect);
        layout.linkSize(1, this.cbTotal, this.cbAttackSpeed);
        layout.linkSize(1, this.cbTotal, this.cbTotalSpeed);
        layout.linkSize(1, this.cbTotal, this.cbDefenseAbil);
        layout.linkSize(1, this.cbTotal, this.cbOffenseAbil);
        layout.linkSize(1, this.cbTotal, this.cbPetBonus);
    }

    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCheck = UIManager.getDefaults().getFont("CheckBox.font");
        if (fntCheck == null) {
            fntCheck = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_DMG_SPECIAL"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbTotal == null) {
            this.cbTotal = new JCheckBox();
        }
        this.cbTotal.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "DMGTYPE_TOTAL"));
        this.cbTotal.setFont(fntCheck);
        if (this.cbCritical == null) {
            this.cbCritical = new JCheckBox();
        }
        this.cbCritical.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "DMGTYPE_CRITICAL"));
        this.cbCritical.setFont(fntCheck);
        if (this.cbLifeLeech == null) {
            this.cbLifeLeech = new JCheckBox();
        }
        this.cbLifeLeech.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "DMGTYPE_LIFELEECH"));
        this.cbLifeLeech.setFont(fntCheck);
        if (this.cbReflect == null) {
            this.cbReflect = new JCheckBox();
        }
        this.cbReflect.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "DMGTYPE_REFLECT"));
        this.cbReflect.setFont(fntCheck);
        if (this.cbAttackSpeed == null) {
            this.cbAttackSpeed = new JCheckBox();
        }
        this.cbAttackSpeed.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "DMGTYPE_SLOW_ATTACK"));
        this.cbAttackSpeed.setFont(fntCheck);
        if (this.cbTotalSpeed == null) {
            this.cbTotalSpeed = new JCheckBox();
        }
        this.cbTotalSpeed.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "DMGTYPE_SLOW_TOTAL"));
        this.cbTotalSpeed.setFont(fntCheck);
        if (this.cbDefenseAbil == null) {
            this.cbDefenseAbil = new JCheckBox();
        }
        this.cbDefenseAbil.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "DMGTYPE_SLOW_DA"));
        this.cbDefenseAbil.setFont(fntCheck);
        if (this.cbOffenseAbil == null) {
            this.cbOffenseAbil = new JCheckBox();
        }
        this.cbOffenseAbil.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "DMGTYPE_SLOW_OA"));
        this.cbOffenseAbil.setFont(fntCheck);
        if (this.cbPetBonus == null) {
            this.cbPetBonus = new JCheckBox();
        }
        this.cbPetBonus.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "DMGTYPE_PET_BONUS"));
        this.cbPetBonus.setFont(fntCheck);
    }

    public void clear() {
        this.cbTotal.setSelected(false);
        this.cbCritical.setSelected(false);
        this.cbLifeLeech.setSelected(false);
        this.cbReflect.setSelected(false);
        this.cbAttackSpeed.setSelected(false);
        this.cbTotalSpeed.setSelected(false);
        this.cbDefenseAbil.setSelected(false);
        this.cbOffenseAbil.setSelected(false);
        this.cbPetBonus.setSelected(false);
    }

    public void addCriteria(SelectionCriteria criteria) {
        if (this.cbTotal.isSelected()) {
            criteria.dmgType.add(301);
        }
        if (this.cbCritical.isSelected()) {
            criteria.dmgType.add(302);
        }
        if (this.cbLifeLeech.isSelected()) {
            criteria.dmgType.add(303);
        }
        if (this.cbReflect.isSelected()) {
            criteria.dmgType.add(304);
        }
        if (this.cbAttackSpeed.isSelected()) {
            criteria.dmgType.add(305);
        }
        if (this.cbTotalSpeed.isSelected()) {
            criteria.dmgType.add(306);
        }
        if (this.cbDefenseAbil.isSelected()) {
            criteria.dmgType.add(307);
        }
        if (this.cbOffenseAbil.isSelected()) {
            criteria.dmgType.add(308);
        }
        criteria.petBonus = this.cbPetBonus.isSelected();
    }
}

