/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;

public class ItemNamePane
extends JPanel {
    private JLabel lblItemName;
    private JTextField tfItemName;

    public ItemNamePane() {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.lblItemName)).addGroup(layout.createParallelGroup().addComponent(this.tfItemName));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.lblItemName).addComponent(this.tfItemName));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(1, this.lblItemName, this.tfItemName);
    }

    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntText = UIManager.getDefaults().getFont("TextField.font");
        if (fntText == null) {
            fntText = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntText = fntText.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_ITEM_NAME"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.lblItemName == null) {
            this.lblItemName = new JLabel();
        }
        this.lblItemName.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_ITEM_NAME"));
        this.lblItemName.setFont(fntLabel);
        if (this.tfItemName == null) {
            this.tfItemName = new JTextField();
        }
        this.tfItemName.setFont(fntText);
    }

    public void clear() {
        this.tfItemName.setText("");
    }

    public void addCriteria(SelectionCriteria criteria) {
        String s = null;
        boolean i = false;
        s = this.tfItemName.getText();
        if (s != null && !s.isEmpty()) {
            int pos = s.indexOf("*");
            while (pos != -1) {
                s = s.substring(0, pos) + "%" + s.substring(pos + 1);
                pos = s.indexOf("*");
            }
        }
        if (!s.startsWith("%")) {
            s = "%" + s;
        }
        if (!s.endsWith("%")) {
            s = s + "%";
        }
        criteria.itemName = s;
    }
}

