/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;

public class ItemRarityPane
extends JPanel {
    private JCheckBox cbCommon;
    private JCheckBox cbMagical;
    private JCheckBox cbRare;
    private JCheckBox cbEpic;
    private JCheckBox cbLegendary;

    public ItemRarityPane(int direction) {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbCommon).addComponent(this.cbMagical).addComponent(this.cbRare).addComponent(this.cbEpic).addComponent(this.cbLegendary));
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbCommon)).addGroup(layout.createParallelGroup().addComponent(this.cbMagical)).addGroup(layout.createParallelGroup().addComponent(this.cbRare)).addGroup(layout.createParallelGroup().addComponent(this.cbEpic)).addGroup(layout.createParallelGroup().addComponent(this.cbLegendary));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(0, this.cbCommon, this.cbMagical);
        layout.linkSize(0, this.cbCommon, this.cbRare);
        layout.linkSize(0, this.cbCommon, this.cbEpic);
        layout.linkSize(0, this.cbCommon, this.cbLegendary);
        layout.linkSize(1, this.cbCommon, this.cbMagical);
        layout.linkSize(1, this.cbCommon, this.cbRare);
        layout.linkSize(1, this.cbCommon, this.cbEpic);
        layout.linkSize(1, this.cbCommon, this.cbLegendary);
    }

    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCheck = UIManager.getDefaults().getFont("CheckBox.font");
        if (fntCheck == null) {
            fntCheck = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RARITY_ITEM"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbCommon == null) {
            this.cbCommon = new JCheckBox();
        }
        this.cbCommon.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "RARITY_ITEM_COMMON"));
        this.cbCommon.setFont(fntCheck);
        if (this.cbMagical == null) {
            this.cbMagical = new JCheckBox();
        }
        this.cbMagical.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "RARITY_ITEM_MAGICAL"));
        this.cbMagical.setFont(fntCheck);
        if (this.cbRare == null) {
            this.cbRare = new JCheckBox();
        }
        this.cbRare.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "RARITY_ITEM_RARE"));
        this.cbRare.setFont(fntCheck);
        if (this.cbEpic == null) {
            this.cbEpic = new JCheckBox();
        }
        this.cbEpic.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "RARITY_ITEM_EPIC"));
        this.cbEpic.setFont(fntCheck);
        if (this.cbLegendary == null) {
            this.cbLegendary = new JCheckBox();
        }
        this.cbLegendary.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "RARITY_ITEM_LEGENDARY"));
        this.cbLegendary.setFont(fntCheck);
    }

    public void clear() {
        this.cbCommon.setSelected(false);
        this.cbMagical.setSelected(false);
        this.cbRare.setSelected(false);
        this.cbEpic.setSelected(false);
        this.cbLegendary.setSelected(false);
    }

    public void addCriteria(SelectionCriteria criteria) {
        if (this.cbCommon.isSelected()) {
            criteria.itemRarity.add("Common");
        }
        if (this.cbMagical.isSelected()) {
            criteria.itemRarity.add("Magical");
        }
        if (this.cbRare.isSelected()) {
            criteria.itemRarity.add("Rare");
        }
        if (this.cbEpic.isSelected()) {
            criteria.itemRarity.add("Epic");
        }
        if (this.cbLegendary.isSelected()) {
            criteria.itemRarity.add("Legendary");
        }
    }
}

