/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.select.ArmorTypePane;
import org.gdstash.ui.select.MiscTypePane;
import org.gdstash.ui.select.WeaponTypePane;
import org.gdstash.util.GDMsgFormatter;

public class ItemTypePane
extends JPanel {
    public static final int SEL_NONE = 0;
    public static final int SEL_ITEM_ALL = 1;
    public static final int SEL_WEAPON_ALL = 2;
    public static final int SEL_ARMOR_JEWEL_ALL = 3;
    public static final int SEL_ARMOR_ALL = 4;
    public static final int SEL_JEWEL_ALL = 5;
    public static final int SEL_WEAPON_MELEE = 6;
    public static final int SEL_WEAPON_MELEE_1H = 7;
    public static final int SEL_WEAPON_MELEE_2H = 8;
    public static final int SEL_WEAPON_CASTER = 9;
    public static final int SEL_WEAPON_RANGED = 10;
    private static String[] selections = null;
    private JComboBox<String> cbSelection;
    private WeaponTypePane pnlWeaponTypes;
    private ArmorTypePane pnlArmorTypes;
    private MiscTypePane pnlMiscTypes;

    public ItemTypePane() {
        this.adjustUI();
        JPanel pnlTypes = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(pnlTypes);
        pnlTypes.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlWeaponTypes)).addGroup(layout.createParallelGroup().addComponent(this.pnlArmorTypes)).addGroup(layout.createParallelGroup().addComponent(this.pnlMiscTypes));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlWeaponTypes).addComponent(this.pnlArmorTypes).addComponent(this.pnlMiscTypes));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.pnlWeaponTypes, this.pnlArmorTypes);
        layout.linkSize(0, this.pnlWeaponTypes, this.pnlMiscTypes);
        layout.linkSize(1, this.pnlWeaponTypes, this.pnlArmorTypes);
        layout.linkSize(1, this.pnlWeaponTypes, this.pnlMiscTypes);
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbSelection).addComponent(pnlTypes));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbSelection)).addGroup(layout.createParallelGroup().addComponent(pnlTypes));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.cbSelection, pnlTypes);
    }

    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCombo = UIManager.getDefaults().getFont("ComboBox.font");
        if (fntCombo == null) {
            fntCombo = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCombo = fntCombo.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_ITEM_INFO"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbSelection == null) {
            this.cbSelection = new JComboBox<String>(selections);
            this.cbSelection.addActionListener(new SelectionActionListener());
        }
        this.cbSelection.setFont(fntCombo);
        this.cbSelection.setMaximumSize(new Dimension(1000, 3 * GDStashFrame.iniConfig.sectUI.fontSize));
        if (this.pnlWeaponTypes == null) {
            this.pnlWeaponTypes = new WeaponTypePane();
        } else {
            this.pnlWeaponTypes.adjustUI();
        }
        if (this.pnlArmorTypes == null) {
            this.pnlArmorTypes = new ArmorTypePane();
        } else {
            this.pnlArmorTypes.adjustUI();
        }
        if (this.pnlMiscTypes == null) {
            this.pnlMiscTypes = new MiscTypePane();
        } else {
            this.pnlMiscTypes.adjustUI();
        }
    }

    public void clear() {
        this.pnlWeaponTypes.clear();
        this.pnlArmorTypes.clear();
        this.pnlMiscTypes.clear();
    }

    public void addCriteria(SelectionCriteria criteria) {
        this.pnlWeaponTypes.addCriteria(criteria);
        this.pnlArmorTypes.addCriteria(criteria);
        this.pnlMiscTypes.addCriteria(criteria);
        criteria.selMode = SelectionCriteria.SELECTION_MODE_ITEM;
    }

    static {
        selections = new String[11];
        ItemTypePane.selections[0] = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_NONE");
        ItemTypePane.selections[1] = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_ITEM_ALL");
        ItemTypePane.selections[2] = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_WEAPON_ALL");
        ItemTypePane.selections[3] = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_ARMOR_JEWEL_ALL");
        ItemTypePane.selections[4] = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_ARMOR_ALL");
        ItemTypePane.selections[5] = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_JEWEL_ALL");
        ItemTypePane.selections[6] = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_WEAPON_MELEE");
        ItemTypePane.selections[7] = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_WEAPON_MELEE_1H");
        ItemTypePane.selections[8] = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_WEAPON_MELEE_2H");
        ItemTypePane.selections[9] = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_WEAPON_CASTER");
        ItemTypePane.selections[10] = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_WEAPON_RANGED");
    }

    private class SelectionActionListener
    implements ActionListener {
        private SelectionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            int i = cb.getSelectedIndex();
            if (i == -1) {
                return;
            }
            ItemTypePane.this.pnlWeaponTypes.setSelection(i);
            ItemTypePane.this.pnlArmorTypes.setSelection(i);
            ItemTypePane.this.pnlMiscTypes.setSelection(i);
        }
    }
}

