/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;

public class MiscTypePane
extends JPanel {
    private JCheckBox cbComponent;
    private JCheckBox cbEnchantment;
    private JCheckBox cbArtifact;
    private JCheckBox cbFormula;
    private JCheckBox cbPotion;
    private JCheckBox cbScroll;
    private JCheckBox cbFaction;
    private JCheckBox cbNote;
    private JCheckBox cbQuest;
    private JCheckBox cbUseableSkill;

    public MiscTypePane() {
        this(1);
    }

    public MiscTypePane(int direction) {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        GroupLayout.ParallelGroup pg = layout.createParallelGroup();
        pg = pg.addComponent(this.cbComponent).addComponent(this.cbEnchantment).addComponent(this.cbArtifact).addComponent(this.cbFormula).addComponent(this.cbPotion).addComponent(this.cbScroll).addComponent(this.cbFaction).addComponent(this.cbNote).addComponent(this.cbQuest);
        hGroup.addGroup(pg);
        vGroup = layout.createSequentialGroup();
        vGroup = vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbComponent)).addGroup(layout.createParallelGroup().addComponent(this.cbEnchantment)).addGroup(layout.createParallelGroup().addComponent(this.cbArtifact)).addGroup(layout.createParallelGroup().addComponent(this.cbFormula)).addGroup(layout.createParallelGroup().addComponent(this.cbPotion)).addGroup(layout.createParallelGroup().addComponent(this.cbScroll)).addGroup(layout.createParallelGroup().addComponent(this.cbFaction)).addGroup(layout.createParallelGroup().addComponent(this.cbNote)).addGroup(layout.createParallelGroup().addComponent(this.cbQuest));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(0, this.cbComponent, this.cbEnchantment);
        layout.linkSize(0, this.cbComponent, this.cbArtifact);
        layout.linkSize(0, this.cbComponent, this.cbFormula);
        layout.linkSize(0, this.cbComponent, this.cbPotion);
        layout.linkSize(0, this.cbComponent, this.cbScroll);
        layout.linkSize(0, this.cbComponent, this.cbFaction);
        layout.linkSize(0, this.cbComponent, this.cbNote);
        layout.linkSize(0, this.cbComponent, this.cbQuest);
        layout.linkSize(1, this.cbComponent, this.cbEnchantment);
        layout.linkSize(1, this.cbComponent, this.cbArtifact);
        layout.linkSize(1, this.cbComponent, this.cbFormula);
        layout.linkSize(1, this.cbComponent, this.cbPotion);
        layout.linkSize(1, this.cbComponent, this.cbScroll);
        layout.linkSize(1, this.cbComponent, this.cbFaction);
        layout.linkSize(1, this.cbComponent, this.cbNote);
        layout.linkSize(1, this.cbComponent, this.cbQuest);
    }

    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCheck = UIManager.getDefaults().getFont("CheckBox.font");
        if (fntCheck == null) {
            fntCheck = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_TYPE_ITEM_MISC"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbComponent == null) {
            this.cbComponent = new JCheckBox();
        }
        this.cbComponent.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TYPE_ITEM_COMPONENT"));
        this.cbComponent.setFont(fntCheck);
        if (this.cbEnchantment == null) {
            this.cbEnchantment = new JCheckBox();
        }
        this.cbEnchantment.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TYPE_ITEM_ENCHANTMENT"));
        this.cbEnchantment.setFont(fntCheck);
        if (this.cbArtifact == null) {
            this.cbArtifact = new JCheckBox();
        }
        this.cbArtifact.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TYPE_ITEM_ARTIFACT"));
        this.cbArtifact.setFont(fntCheck);
        if (this.cbFormula == null) {
            this.cbFormula = new JCheckBox();
        }
        this.cbFormula.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TYPE_ITEM_BLUEPRINT"));
        this.cbFormula.setFont(fntCheck);
        if (this.cbPotion == null) {
            this.cbPotion = new JCheckBox();
        }
        this.cbPotion.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TYPE_ITEM_POTION"));
        this.cbPotion.setFont(fntCheck);
        if (this.cbScroll == null) {
            this.cbScroll = new JCheckBox();
        }
        this.cbScroll.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TYPE_ITEM_SCROLL"));
        this.cbScroll.setFont(fntCheck);
        if (this.cbFaction == null) {
            this.cbFaction = new JCheckBox();
        }
        this.cbFaction.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TYPE_ITEM_FACTION"));
        this.cbFaction.setFont(fntCheck);
        if (this.cbNote == null) {
            this.cbNote = new JCheckBox();
        }
        this.cbNote.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TYPE_ITEM_NOTE"));
        this.cbNote.setFont(fntCheck);
        if (this.cbQuest == null) {
            this.cbQuest = new JCheckBox();
        }
        this.cbQuest.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TYPE_ITEM_QUEST"));
        this.cbQuest.setFont(fntCheck);
        if (this.cbUseableSkill == null) {
            this.cbUseableSkill = new JCheckBox();
        }
        this.cbUseableSkill.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TYPE_ITEM_USEABLE_SKILL"));
        this.cbUseableSkill.setFont(fntCheck);
    }

    public void setSelection(int sel) {
        this.clear();
        switch (sel) {
            case 0: {
                break;
            }
            case 1: {
                this.cbComponent.setSelected(true);
                this.cbEnchantment.setSelected(true);
                this.cbArtifact.setSelected(true);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
        }
    }

    public void clear() {
        this.cbComponent.setSelected(false);
        this.cbEnchantment.setSelected(false);
        this.cbArtifact.setSelected(false);
        this.cbFormula.setSelected(false);
        this.cbPotion.setSelected(false);
        this.cbScroll.setSelected(false);
        this.cbFaction.setSelected(false);
        this.cbNote.setSelected(false);
        this.cbQuest.setSelected(false);
        this.cbUseableSkill.setSelected(false);
    }

    public void addCriteria(SelectionCriteria criteria) {
        if (this.cbComponent.isSelected()) {
            criteria.itemClass.add("ItemRelic");
        }
        if (this.cbEnchantment.isSelected()) {
            criteria.itemClass.add("ItemEnchantment");
        }
        if (this.cbArtifact.isSelected()) {
            criteria.itemClass.add("ItemArtifact");
        }
        if (this.cbFormula.isSelected()) {
            criteria.itemClass.add("ItemArtifactFormula");
        }
        if (this.cbPotion.isSelected()) {
            criteria.itemClass.add("OneShot_PotionHealth");
            criteria.itemClass.add("OneShot_PotionMana");
            criteria.itemClass.add("ItemDevotionReset");
        }
        if (this.cbScroll.isSelected()) {
            criteria.itemClass.add("OneShot_Scroll");
        }
        if (this.cbFaction.isSelected()) {
            criteria.itemClass.add("ItemFactionBooster");
            criteria.itemClass.add("ItemFactionWarrant");
            criteria.itemClass.add("ItemDifficultyUnlock");
        }
        if (this.cbNote.isSelected()) {
            criteria.itemClass.add("ItemNote");
        }
        if (this.cbQuest.isSelected()) {
            criteria.itemClass.add("QuestItem");
        }
        if (this.cbUseableSkill.isSelected()) {
            criteria.itemClass.add("Kickstarter");
        }
    }
}

