/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.stash;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import org.gdstash.character.GDChar;
import org.gdstash.character.GDCharInventorySack;
import org.gdstash.item.GDItem;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.GDUITransfer;
import org.gdstash.ui.stash.GDContainerMapPane;
import org.gdstash.ui.stash.GDContainerPane;
import org.gdstash.ui.stash.GDEquippedContainerPane;
import org.gdstash.ui.stash.GDUIInventory;
import org.gdstash.ui.util.GDCharInfoList;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDImagePool;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class GDCharStashPane
extends JPanel
implements GDUIInventory {
    public static final int OFFSET_X_STASH_CHAR = 117;
    public static final int OFFSET_Y_STASH_CHAR = 99;
    private static final int OFFSET_X_EQUIPPED_CHAR = 19;
    private static final int OFFSET_Y_EQUIPPED_CHAR = 33;
    private static final int OFFSET_X_INVENTORY_CHAR = 86;
    private static final int OFFSET_Y_INVENTORY_CHAR = 485;
    private static final int OFFSET_X_BAG_1_CHAR = 15;
    private static final int OFFSET_Y_BAG_1_CHAR = 0;
    private static final int OFFSET_X_BAG_2_CHAR = 287;
    private static final int OFFSET_Y_BAG_2_CHAR = 0;
    private static final int OFFSET_X_BAG_3_CHAR = 15;
    private static final int OFFSET_Y_BAG_3_CHAR = 261;
    private static final int OFFSET_X_BAG_4_CHAR = 287;
    private static final int OFFSET_Y_BAG_4_CHAR = 261;
    private static final int OFFSET_X_BAG_5_CHAR = 15;
    private static final int OFFSET_Y_BAG_5_CHAR = 521;
    private GDStashFrame frame;
    private JTabbedPane tabPages;
    private GDContainerMapPane[] pnlPages;
    private JComboBox<String> cbSelChar;
    private GDCharInfoList.GDCharFileInfo info;
    private GDItem selItem;
    private GDContainerMapPane selPage;
    private JPanel pnlMain;
    private GDUITransfer uiTransfer;

    public GDCharStashPane(GDStashFrame frame, GDUITransfer uiTransfer) {
        this.frame = frame;
        this.uiTransfer = uiTransfer;
        this.pnlPages = new GDContainerMapPane[3];
        this.selItem = null;
        this.selPage = null;
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        this.pnlMain = this.buildMainPanel();
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlMain));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlMain));
        layout.setVerticalGroup(vGroup);
    }

    public void adjustUI() {
        Font fntTabbed;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCombo = UIManager.getDefaults().getFont("ComboBox.font");
        if (fntCombo == null) {
            fntCombo = fntLabel;
        }
        if ((fntTabbed = UIManager.getDefaults().getFont("TabbedPane.font")) == null) {
            fntTabbed = fntLabel;
        }
        fntCombo = fntCombo.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntTabbed = fntTabbed.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        if (this.pnlPages[0] == null) {
            this.pnlPages[0] = new GDContainerMapPane(this, this.uiTransfer, GDImagePool.imgCharBackground);
            GDContainerPane container = new GDContainerPane(2, 117, 99, this.frame, this, this.uiTransfer);
            if (this.info != null && this.info.gdChar != null) {
                container.setContainer(this.info.gdChar.getStash());
            }
            this.pnlPages[0].addContainer(container);
        }
        if (this.pnlPages[1] == null) {
            this.pnlPages[1] = new GDContainerMapPane(this, this.uiTransfer, GDImagePool.imgCharBackground);
            GDEquippedContainerPane container1 = new GDEquippedContainerPane(19, 33, this.frame, this, this.uiTransfer);
            GDContainerPane container2 = new GDContainerPane(3, 86, 485, this.frame, this, this.uiTransfer);
            if (this.info != null && this.info.gdChar != null) {
                container1.setContainer(this.info.gdChar.getEquipment());
                container2.setContainer(this.info.gdChar.getInventory());
            }
            this.pnlPages[1].addContainer(container1);
            this.pnlPages[1].addContainer(container2);
        }
        if (this.pnlPages[2] == null) {
            this.pnlPages[2] = new GDContainerMapPane(this, this.uiTransfer, GDImagePool.imgCharBackground);
            if (this.info == null) {
                this.buildBagContainer(null);
            } else {
                this.buildBagContainer(this.info.gdChar);
            }
        }
        if (this.tabPages == null) {
            this.tabPages = new JTabbedPane();
            this.tabPages.setTabPlacement(1);
        }
        this.tabPages.removeAll();
        this.tabPages.add(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_CHAR_STASH"), this.pnlPages[0]);
        this.tabPages.add(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_CHAR_INVENTORY"), this.pnlPages[1]);
        this.tabPages.add(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_CHAR_BAGS"), this.pnlPages[2]);
        this.tabPages.setFont(fntTabbed);
        this.tabPages.setMaximumSize(new Dimension(this.pnlPages[0].getPreferredWidth(), this.pnlPages[0].getPreferredHeight() + 20));
        if (this.cbSelChar == null) {
            this.cbSelChar = new JComboBox();
            this.cbSelChar.addActionListener(new CharSelectActionListener());
        }
        int idx = this.cbSelChar.getSelectedIndex();
        this.cbSelChar.removeAllItems();
        String[] entries = GDCharInfoList.getCharInfos();
        for (int i = 0; i < entries.length; ++i) {
            this.cbSelChar.addItem(entries[i]);
        }
        if (idx != -1) {
            this.cbSelChar.setSelectedIndex(idx);
        }
        this.cbSelChar.setFont(fntCombo);
        this.cbSelChar.setMaximumSize(new Dimension(1000, 3 * GDStashFrame.iniConfig.sectUI.fontSize));
    }

    @Override
    public void refresh() {
        if (this.pnlPages[0] != null) {
            this.pnlPages[0].refresh();
        }
        if (this.pnlPages[1] != null) {
            this.pnlPages[1].refresh();
        }
        if (this.pnlPages[2] != null) {
            this.pnlPages[2].refresh();
        }
    }

    private JPanel buildMainPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        this.layoutStash();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbSelChar).addComponent(this.tabPages));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbSelChar)).addGroup(layout.createParallelGroup().addComponent(this.tabPages));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.cbSelChar, this.tabPages);
        return panel;
    }

    public void initCharSelection() {
        this.cbSelChar.removeAllItems();
        this.cbSelChar.addItem("");
        for (GDCharInfoList.GDCharFileInfo info : GDCharInfoList.gdCharFileInfos) {
            this.cbSelChar.addItem(info.charInfo);
        }
    }

    public void refreshCharSelection() {
        File file = null;
        if (this.info != null) {
            file = this.info.charFile;
        }
        this.cbSelChar.removeAllItems();
        this.cbSelChar.addItem("");
        GDCharInfoList.GDCharFileInfo selInfo = null;
        int idx = -1;
        int i = 1;
        for (GDCharInfoList.GDCharFileInfo info : GDCharInfoList.gdCharFileInfos) {
            this.cbSelChar.addItem(info.charInfo);
            if (info.charFile.equals(file)) {
                selInfo = info;
                idx = i;
            }
            ++i;
        }
        if (idx == -1) {
            this.setChar(null);
        } else {
            this.cbSelChar.setSelectedIndex(idx);
        }
    }

    public void renameCharDir(File fDirOld, File fDirNew) {
        if (this.info == null) {
            return;
        }
        if (this.info.charFile == null) {
            return;
        }
        File fDir = this.info.charFile.getParentFile();
        if (fDir == null) {
            return;
        }
        if (fDir.equals(fDirOld)) {
            try {
                File f;
                String name = this.info.charFile.getName();
                String dir = fDirNew.getCanonicalPath() + GDConstants.FILE_SEPARATOR + name;
                this.info.charFile = f = new File(dir);
                if (this.info.gdChar != null) {
                    this.info.gdChar.setFileDir(fDirNew);
                }
                this.setChar(this.info);
            }
            catch (IOException ex) {
                GDMsgLogger.addError(ex);
            }
        }
    }

    public void setChar(GDCharInfoList.GDCharFileInfo info) {
        this.info = info;
        this.uiTransfer.setChar(info);
        GDChar gdc = null;
        if (info != null) {
            gdc = info.gdChar;
        }
        if (gdc == null) {
            GDImagePool.buildCharStash(10, 18);
        } else {
            GDImagePool.buildCharStash(gdc.getStashWidth(), gdc.getStashHeight());
        }
        for (int i = 0; i < this.pnlPages.length; ++i) {
            this.pnlPages[i].setBGImage(GDImagePool.getCharStashBG());
        }
        this.layoutStash();
    }

    public GDContainerMapPane getCurrentPage() {
        int index = this.tabPages.getSelectedIndex();
        return this.pnlPages[index];
    }

    public void layoutStash() {
        if (this.tabPages == null) {
            return;
        }
        this.pnlPages[0].clearContainers();
        GDContainerPane container = new GDContainerPane(2, 117, 99, this.frame, this, this.uiTransfer);
        if (this.info != null && this.info.gdChar != null) {
            container.setContainer(this.info.gdChar.getStash());
        }
        this.pnlPages[0].addContainer(container);
        this.pnlPages[1].clearContainers();
        GDEquippedContainerPane container1 = new GDEquippedContainerPane(19, 33, this.frame, this, this.uiTransfer);
        GDContainerPane container2 = new GDContainerPane(3, 86, 485, this.frame, this, this.uiTransfer);
        if (this.info != null && this.info.gdChar != null) {
            container1.setContainer(this.info.gdChar.getEquipment());
            container2.setContainer(this.info.gdChar.getInventory());
        }
        this.pnlPages[1].addContainer(container1);
        this.pnlPages[1].addContainer(container2);
        if (this.info == null) {
            this.buildBagContainer(null);
        } else {
            this.buildBagContainer(this.info.gdChar);
        }
        this.tabPages.removeAll();
        this.tabPages.add(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_CHAR_STASH"), this.pnlPages[0]);
        this.tabPages.add(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_CHAR_INVENTORY"), this.pnlPages[1]);
        this.tabPages.add(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_CHAR_BAGS"), this.pnlPages[2]);
    }

    private void buildBagContainer(GDChar gdc) {
        List<GDCharInventorySack> sacks = null;
        sacks = gdc == null ? new LinkedList<GDCharInventorySack>() : gdc.getBags();
        this.pnlPages[2].clearContainers();
        int i = 0;
        int x = 0;
        int y = 0;
        for (GDCharInventorySack sack : sacks) {
            switch (i) {
                case 0: {
                    x = 15;
                    y = 0;
                    break;
                }
                case 1: {
                    x = 287;
                    y = 0;
                    break;
                }
                case 2: {
                    x = 15;
                    y = 261;
                    break;
                }
                case 3: {
                    x = 287;
                    y = 261;
                    break;
                }
                case 4: {
                    x = 15;
                    y = 521;
                }
            }
            GDContainerPane container = new GDContainerPane(4, x, y, this.frame, this, this.uiTransfer);
            container.setContainer(sack);
            this.pnlPages[2].addContainer(container);
            ++i;
        }
        while (i <= 4) {
            switch (i) {
                case 0: {
                    x = 15;
                    y = 0;
                    break;
                }
                case 1: {
                    x = 287;
                    y = 0;
                    break;
                }
                case 2: {
                    x = 15;
                    y = 261;
                    break;
                }
                case 3: {
                    x = 287;
                    y = 261;
                    break;
                }
                case 4: {
                    x = 15;
                    y = 521;
                }
            }
            GDContainerPane container = new GDContainerPane(4, x, y, this.frame, this, this.uiTransfer);
            container.setContainer(null);
            this.pnlPages[2].addContainer(container);
            ++i;
        }
    }

    public void deleteSelectedItem(int action) {
        if (this.selItem == null) {
            return;
        }
        this.selPage.deleteItem(this.selItem, action, true);
        this.setSelectedItem(null);
    }

    public void moveSelectedItem(int action, int x, int y) {
        GDItem clone;
        if (this.selItem == null) {
            return;
        }
        GDContainerMapPane page = this.getCurrentPage();
        boolean success = page.addItem(clone = this.selItem.clone(), action, x, y);
        if (success && (success = this.selPage.deleteItem(this.selItem, action, true))) {
            this.selItem = clone;
            this.selPage = page;
        }
    }

    @Override
    public GDItem getSelectedItem() {
        return this.selItem;
    }

    @Override
    public void setSelectedItem(GDItem item) {
        this.selItem = item;
        if (item == null) {
            this.selPage = null;
        } else {
            this.selPage = this.getCurrentPage();
            this.selPage.layoutContainers();
        }
        this.uiTransfer.setSelectedItem(item, 1);
    }

    public boolean addItem(GDItem item, int action, int x, int y) {
        if (item == null) {
            return false;
        }
        GDContainerMapPane page = this.getCurrentPage();
        return page.addItem(item.clone(), action, x, y);
    }

    private class CharSelectActionListener
    implements ActionListener {
        private CharSelectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            int idx = GDCharStashPane.this.cbSelChar.getSelectedIndex();
            if (idx == -1) {
                return;
            }
            if (idx == 0) {
                GDCharStashPane.this.setChar(null);
                return;
            }
            int i = 1;
            for (GDCharInfoList.GDCharFileInfo info : GDCharInfoList.gdCharFileInfos) {
                if (i == idx) {
                    if (info.gdChar == null) {
                        info.gdChar = new GDChar(info.charFile);
                        info.gdChar.read();
                    }
                    if (info.gdChar.hasErrors()) {
                        info.gdChar = null;
                    }
                    GDCharStashPane.this.setChar(info);
                    break;
                }
                ++i;
            }
            GDMsgLogger.showLog(GDCharStashPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }
}

