/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.stash;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.gdstash.file.DDSLoader;
import org.gdstash.item.GDItem;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.GDUITransfer;
import org.gdstash.ui.stash.GDUIContainer;
import org.gdstash.ui.stash.GDUIInventory;
import org.gdstash.ui.stash.GDUIMultiContainer;
import org.gdstash.util.GDImagePool;

public class GDContainerMapPane
extends JPanel
implements GDUIMultiContainer {
    private static final Color COLOR_RED = Color.RED;
    private static final Color COLOR_DARK_RED = new Color(127, 0, 0);
    private static final Color COLOR_WHITE = Color.WHITE;
    private static final Color COLOR_GREEN = new Color(83, 255, 40);
    private BufferedImage bgImage;
    private GDUIInventory uiInventory;
    private GDUITransfer uiTransfer;
    private List<GDUIContainer> containers;
    private GDUIContainer selContainer;

    public GDContainerMapPane() {
        this(null, null, GDImagePool.imgCharBackground);
    }

    public GDContainerMapPane(GDUIInventory uiInventory, GDUITransfer uiTransfer, BufferedImage bgImage) {
        this.uiInventory = uiInventory;
        this.uiTransfer = uiTransfer;
        this.bgImage = bgImage;
        this.containers = new LinkedList<GDUIContainer>();
        this.addMouseListener(new GDMouseListener());
        this.addMouseMotionListener(new GDMouseListener());
    }

    public void setBGImage(BufferedImage bgImage) {
        this.bgImage = bgImage;
    }

    private GDUIContainer findSelectedContainer(MouseEvent e) {
        return this.findSelectedContainer(e.getX(), e.getY());
    }

    private GDUIContainer findSelectedContainer(int xCoord, int yCoord) {
        if (this.containers == null) {
            return null;
        }
        int x = xCoord;
        int y = yCoord;
        GDUIContainer container2 = null;
        for (GDUIContainer container2 : this.containers) {
            int xp = container2.getXOffset();
            int yp = container2.getYOffset();
            int w = container2.getWidth();
            int h = container2.getHeight();
            if (GDStashFrame.iniConfig.sectUI.graphicScale != 100) {
                xp = xp * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
                yp = yp * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
            }
            if (xp <= x && xp + w >= x && yp <= y && yp + h >= y) break;
            container2 = null;
        }
        return container2;
    }

    private void notifyPages(MouseEvent e) {
        if (this.containers != null) {
            for (GDUIContainer container : this.containers) {
                container.dispatchEvent(e);
            }
        }
    }

    @Override
    public void clearContainers() {
        this.containers.clear();
    }

    @Override
    public void addContainer(GDUIContainer container) {
        if (container == null) {
            return;
        }
        this.containers.add(container);
        this.layoutContainers();
    }

    @Override
    public void layoutContainers() {
        this.repaint();
    }

    @Override
    public boolean addItem(GDItem item, int action, int xCoord, int yCoord) {
        boolean added = false;
        GDUIContainer container = this.findSelectedContainer(xCoord, yCoord);
        if (container != null) {
            added = container.addItem(item, action, xCoord, yCoord);
            this.layoutContainers();
        }
        return added;
    }

    @Override
    public boolean deleteItem(GDItem item, int action, boolean update) {
        if (item == null) {
            return true;
        }
        if (this.containers == null) {
            return false;
        }
        boolean deleted = false;
        for (GDUIContainer container : this.containers) {
            if (!container.deleteItem(item, action, update)) continue;
            deleted = true;
            break;
        }
        if (update) {
            this.layoutContainers();
        }
        return deleted;
    }

    @Override
    public boolean hasChanged() {
        if (this.containers == null) {
            return false;
        }
        boolean hasChanged = false;
        if (this.containers != null) {
            for (GDUIContainer container : this.containers) {
                if (!container.hasChanged()) continue;
                hasChanged = true;
                break;
            }
        }
        return hasChanged;
    }

    @Override
    public List<GDItem> getItemList(int action) {
        LinkedList<GDItem> listAll = new LinkedList<GDItem>();
        if (this.containers == null) {
            return listAll;
        }
        for (GDUIContainer container : this.containers) {
            List<GDItem> list = container.getItemList(action);
            if (list == null) continue;
            listAll.addAll(list);
        }
        return listAll;
    }

    @Override
    public void refresh() {
        if (this.containers != null) {
            for (GDUIContainer container : this.containers) {
                container.refresh();
            }
            this.layoutContainers();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.drawGraphics(), 0, 0, null);
    }

    @Override
    public Dimension getPreferredSize() {
        int w = this.bgImage.getWidth() * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
        int h = this.bgImage.getHeight() * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
        return new Dimension(w, h);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getPreferredWidth() {
        return (int)this.getPreferredSize().getWidth();
    }

    public int getPreferredHeight() {
        return (int)this.getPreferredSize().getHeight();
    }

    private BufferedImage drawGraphics() {
        BufferedImage image = new BufferedImage(this.bgImage.getWidth(), this.bgImage.getHeight(), this.bgImage.getType());
        Graphics2D g = image.createGraphics();
        g.drawImage((Image)this.bgImage, 0, 0, null);
        GDUIContainer container2 = null;
        if (this.containers != null) {
            for (GDUIContainer container2 : this.containers) {
                BufferedImage img = container2.drawGraphics();
                g.drawImage((Image)img, container2.getXOffset(), container2.getYOffset(), null);
            }
        }
        if (GDStashFrame.iniConfig.sectUI.graphicScale != 100) {
            int w = image.getWidth() * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
            int h = image.getHeight() * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
            image = DDSLoader.getScaledImage(image, w, h);
        }
        return image;
    }

    private class GDMouseListener
    extends MouseInputAdapter {
        private GDMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (GDContainerMapPane.this.containers == null) {
                return;
            }
            GDContainerMapPane.this.selContainer = GDContainerMapPane.this.findSelectedContainer(e);
            GDContainerMapPane.this.notifyPages(e);
            GDContainerMapPane.this.layoutContainers();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (GDContainerMapPane.this.containers == null) {
                return;
            }
            GDContainerMapPane.this.selContainer = GDContainerMapPane.this.findSelectedContainer(e);
            GDContainerMapPane.this.notifyPages(e);
            GDContainerMapPane.this.layoutContainers();
        }
    }
}

