/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.table;

import java.util.Comparator;
import javax.swing.table.TableRowSorter;
import org.gdstash.ui.table.GDItemCollectionRow;
import org.gdstash.ui.table.GDItemCollectionTableModel;

public class GDItemCollectionSorter
extends TableRowSorter<GDItemCollectionTableModel> {
    public static final int SORTORDER_DEFAULT = 0;
    public static final int SORTORDER_NAME = 1;
    public static final int SORTORDER_NAME_REV = 2;
    public static final int SORTORDER_LEVEL = 3;
    public static final int SORTORDER_LEVEL_REV = 4;
    private static final Comparator<GDItemCollectionRow> COMP_NAME = new NameComparator();
    private static final Comparator<GDItemCollectionRow> COMP_NAME_REV = new NameReverseComparator();
    private static final Comparator<GDItemCollectionRow> COMP_LEVEL = new LevelComparator();
    private static final Comparator<GDItemCollectionRow> COMP_LEVEL_REV = new LevelReverseComparator();
    private int sortOrder;

    public GDItemCollectionSorter() {
        this(null);
    }

    public GDItemCollectionSorter(GDItemCollectionTableModel model) {
        this.setModel(model);
    }

    @Override
    public void setModel(GDItemCollectionTableModel m) {
        super.setModel(m);
        if (m != null) {
            this.setSortable(0, false);
            this.sortOrder = 0;
        }
    }

    @Override
    public void toggleSortOrder(int column) {
        if (column == 1) {
            this.sortOrder = this.sortOrder == 1 ? 2 : 1;
        }
        if (column == 2) {
            this.sortOrder = this.sortOrder == 3 ? 4 : 3;
        }
    }

    @Override
    public void sort() {
        GDItemCollectionTableModel model = (GDItemCollectionTableModel)this.getModel();
        if (this.sortOrder == 1) {
            model.sort(COMP_NAME);
        }
        if (this.sortOrder == 2) {
            model.sort(COMP_NAME_REV);
        }
        if (this.sortOrder == 3) {
            model.sort(COMP_LEVEL);
        }
        if (this.sortOrder == 4) {
            model.sort(COMP_LEVEL_REV);
        }
    }

    private static class LevelReverseComparator
    implements Comparator<GDItemCollectionRow> {
        private LevelReverseComparator() {
        }

        @Override
        public int compare(GDItemCollectionRow ir1, GDItemCollectionRow ir2) {
            int iLvl2;
            int iLvl1 = Integer.parseInt(ir1.level.text);
            int iLevel = iLvl1 - (iLvl2 = Integer.parseInt(ir2.level.text));
            if (iLevel != 0) {
                return -iLevel;
            }
            return ir1.name.text.compareTo(ir2.name.text);
        }
    }

    private static class LevelComparator
    implements Comparator<GDItemCollectionRow> {
        private LevelComparator() {
        }

        @Override
        public int compare(GDItemCollectionRow ir1, GDItemCollectionRow ir2) {
            int iLvl2;
            int iLvl1 = Integer.parseInt(ir1.level.text);
            int iLevel = iLvl1 - (iLvl2 = Integer.parseInt(ir2.level.text));
            if (iLevel != 0) {
                return iLevel;
            }
            return ir1.name.text.compareTo(ir2.name.text);
        }
    }

    private static class NameReverseComparator
    implements Comparator<GDItemCollectionRow> {
        private NameReverseComparator() {
        }

        @Override
        public int compare(GDItemCollectionRow ir1, GDItemCollectionRow ir2) {
            int iName = ir1.name.text.compareTo(ir2.name.text);
            if (iName != 0) {
                return -iName;
            }
            return ir1.level.text.compareTo(ir2.level.text);
        }
    }

    public static class NameComparator
    implements Comparator<GDItemCollectionRow> {
        @Override
        public int compare(GDItemCollectionRow ir1, GDItemCollectionRow ir2) {
            int iName = ir1.name.text.compareTo(ir2.name.text);
            if (iName != 0) {
                return iName;
            }
            return ir1.level.text.compareTo(ir2.level.text);
        }
    }
}

