/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.table;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.table.DefaultTableModel;
import org.gdstash.file.DDSLoader;
import org.gdstash.item.GDItem;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.table.GDItemNameRow;

public class GDItemNameTableModel
extends DefaultTableModel {
    private List<GDItem> data;
    private GDItemNameRow[] rows;
    private Comparator<GDItemNameRow> comparator;

    public GDItemNameTableModel(List<GDItem> data) {
        this.data = data;
        this.comparator = null;
        this.adjustUI();
    }

    public void adjustUI() {
        GDItemNameRow.updateColumnNames();
        this.setColumnIdentifiers(GDItemNameRow.columnNames);
        this.setData(this.data);
    }

    public void setData(List<GDItem> data) {
        this.data = data;
        this.rows = null;
        if (data == null) {
            return;
        }
        int size = data.size();
        this.rows = new GDItemNameRow[size];
        GDItem.LabelInfo liEmpty = new GDItem.LabelInfo();
        liEmpty.text = "";
        int i = 0;
        GDItem.LabelInfo li = null;
        Iterator<GDItem> iter = data.iterator();
        while (iter.hasNext()) {
            this.rows[i] = new GDItemNameRow();
            GDItem item = iter.next();
            BufferedImage img = item.getFullImage();
            this.rows[i].item = item;
            if (img != null) {
                if (GDStashFrame.iniConfig.sectUI.graphicScale != 100) {
                    int w = img.getWidth() * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
                    int h = img.getHeight() * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
                    img = DDSLoader.getScaledImage(img, w, h);
                }
                this.rows[i].icon = new ImageIcon(img);
            }
            if ((li = item.getCompleteNameInfo()) == null) {
                li = liEmpty;
            }
            this.rows[i].name = li;
            li = item.getRequiredLevelInfo();
            if (li == null) {
                li = liEmpty;
            }
            this.rows[i].level = li;
            ++i;
        }
        if (this.comparator != null) {
            Arrays.sort(this.rows, this.comparator);
        }
        this.fireTableDataChanged();
    }

    public void updateRow(int row, GDItem item) {
        if (this.data == null) {
            return;
        }
        this.data.set(row, item);
        this.setData(this.data);
    }

    @Override
    public void removeRow(int row) {
        if (row < 0) {
            return;
        }
        GDItem item = this.rows[row].item;
        this.data.remove(item);
        this.setData(this.data);
    }

    @Override
    public int getRowCount() {
        if (this.rows == null) {
            return 0;
        }
        return this.rows.length;
    }

    @Override
    public int getColumnCount() {
        return GDItemNameRow.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return GDItemNameRow.columnNames[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.rows == null) {
            return null;
        }
        if (column == 0) {
            return this.rows[row].icon;
        }
        if (column == 1) {
            return this.rows[row].name.text;
        }
        if (column == 2) {
            return this.rows[row].level.text;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (!this.isCellEditable(row, column)) {
            return;
        }
        if (column == 0) {
            this.rows[row].icon = (ImageIcon)value;
        }
        if (column == 1) {
            this.rows[row].name.text = (String)value;
        }
        if (column == 2) {
            this.rows[row].level.text = (String)value;
        }
    }

    public Class getColumnClass(int column) {
        return GDItemNameRow.COLUMN_CLASSES[column];
    }

    public String getCellText(int row, int column) {
        if (column == 1) {
            return this.rows[row].name.text;
        }
        if (column == 2) {
            return this.rows[row].level.text;
        }
        return "";
    }

    public Color getCellTextColor(int row, int column) {
        if (column == 1) {
            return this.rows[row].name.foreground;
        }
        if (column == 2) {
            return this.rows[row].level.foreground;
        }
        return Color.BLACK;
    }

    public Color getCellBackgroundColor(int row, int column) {
        if (column == 1) {
            return this.rows[row].name.background;
        }
        if (column == 2) {
            return this.rows[row].name.background;
        }
        return Color.WHITE;
    }

    public GDItem getItem(int row) {
        if (row < 0) {
            return null;
        }
        if (row > this.rows.length) {
            return null;
        }
        return this.rows[row].item;
    }

    public void sort(Comparator<GDItemNameRow> comp) {
        if (comp == null) {
            return;
        }
        this.comparator = comp;
        if (this.rows == null) {
            return;
        }
        Arrays.sort(this.rows, this.comparator);
    }
}

