/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.table;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.table.DefaultTableModel;
import org.gdstash.file.DDSLoader;
import org.gdstash.item.GDItem;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.table.GDMassImportRow;
import org.gdstash.util.GDImagePool;

public class GDMassImportTableModel
extends DefaultTableModel {
    private List<GDItem> data;
    public GDMassImportRow[] rows;

    public GDMassImportTableModel(List<GDItem> data) {
        this.adjustUI();
        this.setData(data);
    }

    public void adjustUI() {
        GDMassImportRow.updateColumnNames();
        this.setColumnIdentifiers(GDMassImportRow.columnNames);
        this.setData(this.data);
    }

    public void setData(List<GDItem> data) {
        this.data = data;
        this.rows = null;
        if (data == null) {
            return;
        }
        int size = data.size();
        this.rows = new GDMassImportRow[size];
        GDItem.LabelInfo liEmpty = new GDItem.LabelInfo();
        liEmpty.text = "";
        int i = 0;
        GDItem.LabelInfo li = null;
        Iterator<GDItem> iter = data.iterator();
        while (iter.hasNext()) {
            GDItem item;
            this.rows[i] = new GDMassImportRow();
            this.rows[i].item = item = iter.next();
            this.rows[i].selected = false;
            this.rows[i].valid = item.isValid(GDStashFrame.iniConfig.sectRestrict.affixCombi, GDStashFrame.iniConfig.sectRestrict.completionAll);
            this.rows[i].validIcon = this.rows[i].valid ? GDImagePool.iconBtnOk24 : GDImagePool.iconBtnCancel24;
            BufferedImage img = item.getImage();
            if (img != null) {
                if (GDStashFrame.iniConfig.sectUI.graphicScale != 100) {
                    int w = img.getWidth() * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
                    int h = img.getHeight() * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
                    img = DDSLoader.getScaledImage(img, w, h);
                }
                this.rows[i].icon = new ImageIcon(img);
            }
            if ((li = item.getCompleteNameInfo()) == null) {
                li = liEmpty;
            }
            this.rows[i].name = li;
            li = item.getRequiredLevelInfo();
            if (li == null) {
                li = liEmpty;
            }
            this.rows[i].level = li;
            li = item.getPrefixInfo();
            if (li == null) {
                li = liEmpty;
            }
            this.rows[i].prefix = li;
            li = item.getSuffixInfo();
            if (li == null) {
                li = liEmpty;
            }
            this.rows[i].suffix = li;
            li = item.getModifierInfo();
            if (li == null) {
                li = liEmpty;
            }
            this.rows[i].modifier = li;
            li = item.getComponentInfo();
            if (li == null) {
                li = liEmpty;
            }
            this.rows[i].component = li;
            li = item.getComponentBonusInfo();
            if (li == null) {
                li = liEmpty;
            }
            this.rows[i].bonus = li;
            li = item.getEnchantmentInfo();
            if (li == null) {
                li = liEmpty;
            }
            this.rows[i].enchantment = li;
            li = item.getSeedHexInfo();
            if (li == null) {
                li = liEmpty;
            }
            this.rows[i].seed = li;
            li = item.getCharNameInfo();
            if (li == null) {
                li = liEmpty;
            }
            this.rows[i].charName = li;
            ++i;
        }
    }

    @Override
    public int getRowCount() {
        if (this.rows == null) {
            return 0;
        }
        return this.rows.length;
    }

    @Override
    public int getColumnCount() {
        return GDMassImportRow.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return GDMassImportRow.columnNames[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.rows == null) {
            return null;
        }
        if (column == 0) {
            return this.rows[row].selected;
        }
        if (column == 1) {
            return this.rows[row].validIcon;
        }
        if (column == 2) {
            return this.rows[row].icon;
        }
        if (column == 3) {
            return this.rows[row].name.text;
        }
        if (column == 4) {
            return this.rows[row].level.text;
        }
        if (column == 5) {
            return this.rows[row].prefix.text;
        }
        if (column == 6) {
            return this.rows[row].suffix.text;
        }
        if (column == 7) {
            return this.rows[row].modifier.text;
        }
        if (column == 8) {
            return this.rows[row].component.text;
        }
        if (column == 9) {
            return this.rows[row].bonus.text;
        }
        if (column == 10) {
            return this.rows[row].enchantment.text;
        }
        if (column == 11) {
            return this.rows[row].seed.text;
        }
        if (column == 12) {
            return this.rows[row].charName.text;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 0;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (!this.isCellEditable(row, column)) {
            return;
        }
        if (column == 0) {
            this.rows[row].selected = (Boolean)value;
        }
        if (column == 1) {
            this.rows[row].validIcon = (ImageIcon)value;
        }
        if (column == 2) {
            this.rows[row].icon = (ImageIcon)value;
        }
        if (column == 3) {
            this.rows[row].name.text = (String)value;
        }
        if (column == 4) {
            this.rows[row].level.text = (String)value;
        }
        if (column == 5) {
            this.rows[row].prefix.text = (String)value;
        }
        if (column == 6) {
            this.rows[row].suffix.text = (String)value;
        }
        if (column == 7) {
            this.rows[row].modifier.text = (String)value;
        }
        if (column == 8) {
            this.rows[row].component.text = (String)value;
        }
        if (column == 9) {
            this.rows[row].bonus.text = (String)value;
        }
        if (column == 10) {
            this.rows[row].enchantment.text = (String)value;
        }
        if (column == 11) {
            this.rows[row].seed.text = (String)value;
        }
        if (column == 12) {
            this.rows[row].charName.text = (String)value;
        }
    }

    public Class getColumnClass(int column) {
        return GDMassImportRow.COLUMN_CLASSES[column];
    }

    public String getCellText(int row, int column) {
        if (column == 3) {
            return this.rows[row].name.text;
        }
        if (column == 4) {
            return this.rows[row].level.text;
        }
        if (column == 5) {
            return this.rows[row].prefix.text;
        }
        if (column == 6) {
            return this.rows[row].suffix.text;
        }
        if (column == 7) {
            return this.rows[row].modifier.text;
        }
        if (column == 8) {
            return this.rows[row].component.text;
        }
        if (column == 9) {
            return this.rows[row].bonus.text;
        }
        if (column == 10) {
            return this.rows[row].enchantment.text;
        }
        if (column == 11) {
            return this.rows[row].seed.text;
        }
        if (column == 12) {
            return this.rows[row].charName.text;
        }
        return "";
    }

    public Color getCellTextColor(int row, int column) {
        if (column == 3) {
            return this.rows[row].name.foreground;
        }
        if (column == 4) {
            return this.rows[row].level.foreground;
        }
        if (column == 5) {
            return this.rows[row].prefix.foreground;
        }
        if (column == 6) {
            return this.rows[row].suffix.foreground;
        }
        if (column == 7) {
            return this.rows[row].modifier.foreground;
        }
        if (column == 8) {
            return this.rows[row].component.foreground;
        }
        if (column == 9) {
            return this.rows[row].bonus.foreground;
        }
        if (column == 10) {
            return this.rows[row].enchantment.foreground;
        }
        if (column == 11) {
            return this.rows[row].seed.foreground;
        }
        if (column == 12) {
            return this.rows[row].charName.foreground;
        }
        return Color.BLACK;
    }

    public void setSelectAll(boolean selected) {
        if (this.rows == null) {
            return;
        }
        for (int i = 0; i < this.rows.length; ++i) {
            this.rows[i].selected = selected;
        }
        this.fireTableDataChanged();
    }

    public void selectValidOnly() {
        if (this.rows == null) {
            return;
        }
        for (int i = 0; i < this.rows.length; ++i) {
            this.rows[i].selected = this.rows[i].valid;
        }
        this.fireTableDataChanged();
    }

    public List<GDItem> getSelectedItems() {
        LinkedList<GDItem> list = new LinkedList<GDItem>();
        if (this.rows == null) {
            return list;
        }
        for (int i = 0; i < this.rows.length; ++i) {
            if (!this.rows[i].selected) continue;
            list.add(this.rows[i].item);
        }
        return list;
    }
}

