/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.util;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.character.GDChar;
import org.gdstash.character.GDCharSummary;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDMsgFormatter;

public class GDCharInfoList {
    public static List<GDCharFileInfo> gdCharFileInfos;

    public static void findChars(GDStashFrame frame, GDCharFileInfo reloadInfo) {
        List<GDCharFileInfo> infos = gdCharFileInfos;
        gdCharFileInfos = new LinkedList<GDCharFileInfo>();
        if (GDStashFrame.iniConfig == null) {
            return;
        }
        if (GDStashFrame.iniConfig.sectDir.savePath == null) {
            return;
        }
        String mainDir = GDStashFrame.iniConfig.sectDir.savePath + GDConstants.FILE_SEPARATOR + "main";
        GDCharInfoList.findCharsInDir(mainDir);
        String modDir = GDStashFrame.iniConfig.sectDir.savePath + GDConstants.FILE_SEPARATOR + "user";
        GDCharInfoList.findCharsInDir(modDir);
        GDCharInfoList.adjustCharInfos(infos, reloadInfo);
        if (frame != null) {
            if (frame.pnlCharEdit != null) {
                frame.pnlCharEdit.refreshCharSelection();
            }
            if (frame.pnlCharInventory != null) {
                frame.pnlCharInventory.refreshCharSelection();
            }
        }
    }

    private static void findCharsInDir(String charDir) {
        File file = new File(charDir);
        if (file.isDirectory()) {
            GDCharInfoList.processCharDir(file);
        }
        if (file.isFile()) {
            GDCharInfoList.processCharFile(file);
        }
    }

    private static void processCharDir(File dir) {
        if (dir == null) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file == null) continue;
            if (file.isDirectory()) {
                GDCharInfoList.processCharDir(file);
            }
            if (!file.isFile()) continue;
            GDCharInfoList.processCharFile(file);
        }
    }

    private static void processCharFile(File file) {
        GDCharSummary gdcSum;
        String s = file.getName().toUpperCase(GDConstants.LOCALE_US);
        if (s.equals("PLAYER.GDC") && (gdcSum = GDChar.readCharSummary(file)) != null) {
            GDCharFileInfo info = new GDCharFileInfo();
            info.charFile = file;
            info.gdcSummary = gdcSum;
            gdCharFileInfos.add(info);
        }
    }

    public static void adjustCharInfo(GDCharFileInfo info) {
        String s;
        if (info.gdcSummary == null) {
            return;
        }
        try {
            info.fileName = info.charFile.getCanonicalPath();
        }
        catch (IOException ex) {
            info.fileName = null;
        }
        String sHC = null;
        sHC = info.gdcSummary.isHardcore() ? GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_CHAR_HARDCORE_SHORT") : GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_CHAR_SOFTCORE_SHORT");
        String dir = info.charFile.getParentFile().getParentFile().getName();
        Object[] sArgs = new Object[]{info.gdcSummary.getCharName(), dir, sHC, info.gdcSummary.getLevel()};
        info.charInfo = s = GDMsgFormatter.format(GDMsgFormatter.rbUI, "TXT_CHAR_SELECT", sArgs);
    }

    public static void adjustCharInfos(List<GDCharFileInfo> infos, GDCharFileInfo reloadInfo) {
        if (gdCharFileInfos == null) {
            return;
        }
        for (GDCharFileInfo info : gdCharFileInfos) {
            GDCharInfoList.adjustCharInfo(info);
            if (infos == null) continue;
            for (GDCharFileInfo info2 : infos) {
                if (info.fileName.equals(info2.fileName) && info2.gdChar != null && info2 != reloadInfo && info2.gdChar.hasChanged()) {
                    info.gdChar = info2.gdChar;
                }
                if (reloadInfo == null || !info.fileName.equals(reloadInfo.fileName)) continue;
                if (info.gdChar == null) {
                    info.gdChar = new GDChar(info.charFile);
                }
                info.gdChar.read();
            }
        }
    }

    public static String[] getCharInfos() {
        int size = 1;
        if (gdCharFileInfos != null) {
            size += gdCharFileInfos.size();
        }
        String[] cis = new String[size];
        cis[0] = "";
        if (gdCharFileInfos == null) {
            return cis;
        }
        if (gdCharFileInfos.size() == 0) {
            return cis;
        }
        Iterator<GDCharFileInfo> iter = gdCharFileInfos.iterator();
        int i = 1;
        while (iter.hasNext()) {
            GDCharFileInfo info = iter.next();
            cis[i] = info.charInfo;
            ++i;
        }
        return cis;
    }

    public static class GDCharFileInfo {
        public File charFile;
        public String fileName;
        public GDCharSummary gdcSummary;
        public String charInfo;
        public GDChar gdChar;
    }
}

