/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDConstants;

public class GDImagePool {
    public static ImageIcon iconLogo460x215;
    public static ImageIcon iconLogo700x438;
    public static ImageIcon iconLogo64x64;
    public static BufferedImage imgDefaultSharedStash;
    public static BufferedImage imgCharBackground;
    public static BufferedImage imgDefaultCharStash;
    public static BufferedImage imgCharBag;
    public static BufferedImage imgCharInventory;
    public static BufferedImage imgCharEquipped;
    public static ImageIcon iconTab;
    public static ImageIcon iconTabHover;
    public static ImageIcon iconTabSelected;
    public static ImageIcon iconMsgError16;
    public static ImageIcon iconMsgInfo16;
    public static ImageIcon iconMsgSuccess16;
    public static ImageIcon iconMsgWarning16;
    public static ImageIcon iconTabCollection16;
    public static ImageIcon iconTabConfigure16;
    public static ImageIcon iconTabStashCraft16;
    public static ImageIcon iconTabFileImp16;
    public static ImageIcon iconTabStashTransfer16;
    public static ImageIcon iconTabCharEdit16;
    public static ImageIcon iconTabCharTransfer16;
    public static ImageIcon iconPlus16;
    public static ImageIcon iconMinus16;
    public static ImageIcon iconBtnCancel24;
    public static ImageIcon iconBtnDir24;
    public static ImageIcon iconBtnFilter24;
    public static ImageIcon iconBtnOk24;
    public static ImageIcon iconBtnReload24;
    public static ImageIcon iconBtnSave24;
    public static ImageIcon iconBtnSearch24;
    public static ImageIcon iconBtnTrash24;
    public static ImageIcon iconDBDelete24;
    public static ImageIcon iconItemCopy24;
    public static ImageIcon iconItemDelete24;
    public static ImageIcon iconItemMove24;
    public static ImageIcon iconPageCopy24;
    public static ImageIcon iconPageDelete24;
    public static ImageIcon iconPageMove24;
    public static ImageIcon iconCollectAll24;
    public static ImageIcon iconCollectFound24;
    public static ImageIcon iconCollectMiss24;
    public static ImageIcon iconConfigARZExport24;
    public static ImageIcon iconConfigDBImport24;
    public static ImageIcon iconConfigSettingSave24;
    public static ImageIcon iconMassAll24;
    public static ImageIcon iconMassNone24;
    public static ImageIcon iconMassGDSExport24;
    public static ImageIcon iconMassGDSLoad24;
    public static ImageIcon iconMassItemImport24;
    public static ImageIcon iconMassItemLoad24;
    public static ImageIcon iconMassValid24;
    public static ImageIcon iconMsgError32;
    public static ImageIcon iconMsgInfo32;
    public static ImageIcon iconMsgSuccess32;
    public static ImageIcon iconMsgWarning32;
    public static BufferedImage tileTopLeft;
    public static BufferedImage tileTopRight;
    public static BufferedImage tileTop;
    public static BufferedImage tileBottomLeft;
    public static BufferedImage tileBottomRight;
    public static BufferedImage tileBottom;
    public static BufferedImage tileCenterLeft;
    public static BufferedImage tileCenterRight;
    public static BufferedImage tileCenter;
    public static BufferedImage tileNoise;
    private static BufferedImage imgSharedStash;
    private static int sharedXOffset;
    private static int sharedYOffset;
    private static BufferedImage imgCharStash;
    private static BufferedImage imgCharBG;
    private static int charXOffset;
    private static int charYOffset;

    public static void loadLogos() {
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "GDS_Logo.png"));
            iconLogo64x64 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "GDStash_Logo.png"));
            iconLogo460x215 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (GDStashFrame.iniConfig.sectUI.fontSize >= 12) {
            try {
                Object filename = null;
                image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "GDStash_Logo_lrg.png"));
                iconLogo700x438 = new ImageIcon(image);
            }
            catch (IOException iOException) {}
        } else {
            iconLogo700x438 = iconLogo460x215;
        }
    }

    public static void loadTiles() {
        BufferedImage image = null;
        try {
            imgCharBackground = image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "GD_Char_BG.png"));
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            imgDefaultSharedStash = image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "GD_SharedStash_Tiles.png"));
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            imgDefaultCharStash = image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "GD_CharStash_Tiles.png"));
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            imgCharInventory = image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "GD_CharInventory_Tiles.png"));
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            imgCharEquipped = image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "GD_Char_Equipment_Tiles.png"));
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            imgCharBag = image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "GD_CharBag_Tiles.png"));
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "GD_Tab.png"));
            iconTab = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "GD_Tab_Hover.png"));
            iconTabHover = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "GD_Tab_Selected.png"));
            iconTabSelected = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            tileTopLeft = image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "tiles" + GDConstants.FILE_SEPARATOR + "Tile_TopLeft.png"));
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            tileTopRight = image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "tiles" + GDConstants.FILE_SEPARATOR + "Tile_TopRight.png"));
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            tileTop = image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "tiles" + GDConstants.FILE_SEPARATOR + "Tile_Top.png"));
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            tileCenterLeft = image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "tiles" + GDConstants.FILE_SEPARATOR + "Tile_CenterLeft.png"));
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            tileCenterRight = image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "tiles" + GDConstants.FILE_SEPARATOR + "Tile_CenterRight.png"));
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            tileCenter = image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "tiles" + GDConstants.FILE_SEPARATOR + "Tile_Center.png"));
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            tileBottomLeft = image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "tiles" + GDConstants.FILE_SEPARATOR + "Tile_BottomLeft.png"));
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            tileBottomRight = image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "tiles" + GDConstants.FILE_SEPARATOR + "Tile_BottomRight.png"));
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            tileBottom = image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "tiles" + GDConstants.FILE_SEPARATOR + "Tile_Bottom.png"));
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            tileNoise = image = ImageIO.read(new File("image" + GDConstants.FILE_SEPARATOR + "tiles" + GDConstants.FILE_SEPARATOR + "Tile_Noise.png"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        GDImagePool.buildSharedStash(8, 16);
        GDImagePool.buildCharStash(10, 18);
    }

    public static void buildSharedStash(int width, int height) {
        if (width == 8 && height == 16) {
            imgSharedStash = imgDefaultSharedStash;
            sharedXOffset = 2;
            sharedYOffset = 2;
            return;
        }
        int tileTopW = tileTopLeft.getWidth();
        int tileTopH = tileTopLeft.getHeight();
        int tileBottomW = tileBottomRight.getWidth();
        int tileBottomH = tileBottomRight.getHeight();
        int w = tileTopW + (width - 2) * 32 + tileBottomW;
        int h = tileTopH + (height - 2) * 32 + tileBottomH;
        BufferedImage stash = new BufferedImage(w, h, 1);
        Graphics2D g = stash.createGraphics();
        BufferedImage tile = null;
        int yPos = 0;
        for (int y = 0; y < height; ++y) {
            int xPos = 0;
            for (int x = 0; x < width; ++x) {
                tile = y == 0 ? (x == 0 ? tileTopLeft : (x == width - 1 ? tileTopRight : tileTop)) : (y == height - 1 ? (x == 0 ? tileBottomLeft : (x == width - 1 ? tileBottomRight : tileBottom)) : (x == 0 ? tileCenterLeft : (x == width - 1 ? tileCenterRight : tileCenter)));
                g.drawImage((Image)tile, xPos, yPos, null);
                xPos += tile.getWidth();
            }
            yPos += tile.getHeight();
        }
        imgSharedStash = stash;
        sharedXOffset = tileTopW - 32;
        sharedYOffset = tileTopH - 32;
    }

    public static void buildCharStash(int width, int height) {
        int x;
        if (width == 10 && height == 18) {
            imgCharStash = imgDefaultCharStash;
            imgCharBG = imgCharBackground;
            charXOffset = 2;
            charYOffset = 2;
            return;
        }
        int tileTopW = tileTopLeft.getWidth();
        int tileTopH = tileTopLeft.getHeight();
        int tileBottomW = tileBottomRight.getWidth();
        int tileBottomH = tileBottomRight.getHeight();
        int w = tileTopW + (width - 2) * 32 + tileBottomW;
        int h = tileTopH + (height - 2) * 32 + tileBottomH;
        BufferedImage stash = new BufferedImage(w, h, 1);
        Graphics2D g = stash.createGraphics();
        BufferedImage tile = null;
        int yPos = 0;
        for (int y = 0; y < height; ++y) {
            int xPos = 0;
            for (x = 0; x < width; ++x) {
                tile = y == 0 ? (x == 0 ? tileTopLeft : (x == width - 1 ? tileTopRight : tileTop)) : (y == height - 1 ? (x == 0 ? tileBottomLeft : (x == width - 1 ? tileBottomRight : tileBottom)) : (x == 0 ? tileCenterLeft : (x == width - 1 ? tileCenterRight : tileCenter)));
                g.drawImage((Image)tile, xPos, yPos, null);
                xPos += tile.getWidth();
            }
            yPos += tile.getHeight();
        }
        w = tileTopW + (width - 2) * 32 + tileBottomW + 234;
        h = tileTopH + (height - 2) * 32 + tileBottomH + 198;
        BufferedImage bg = new BufferedImage(w, h, 1);
        g = bg.createGraphics();
        tile = tileNoise;
        for (int y = 0; y < h; y += tile.getHeight()) {
            for (x = 0; x < w; x += tile.getWidth()) {
                g.drawImage((Image)tile, x, y, null);
            }
        }
        imgCharStash = stash;
        imgCharBG = bg;
        charXOffset = tileTopW - 32;
        charYOffset = tileTopH - 32;
    }

    public static void loadImages() {
        String dir16 = "16";
        String dir24 = "24";
        String dir32 = "32";
        if (GDStashFrame.iniConfig.sectUI.fontSize < 12) {
            dir24 = "16";
            dir32 = "24";
        }
        if (GDStashFrame.iniConfig.sectUI.fontSize > 14) {
            dir16 = "24";
            dir24 = "32";
        }
        if (GDStashFrame.iniConfig.sectUI.fontSize > 16) {
            dir32 = "48";
        }
        dir16 = "image" + GDConstants.FILE_SEPARATOR + "icons" + GDConstants.FILE_SEPARATOR + dir16 + GDConstants.FILE_SEPARATOR;
        dir24 = "image" + GDConstants.FILE_SEPARATOR + "icons" + GDConstants.FILE_SEPARATOR + dir24 + GDConstants.FILE_SEPARATOR;
        dir32 = "image" + GDConstants.FILE_SEPARATOR + "icons" + GDConstants.FILE_SEPARATOR + dir32 + GDConstants.FILE_SEPARATOR;
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(dir16 + "msg_error.png"));
            iconMsgError16 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir16 + "msg_info.png"));
            iconMsgInfo16 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir16 + "msg_success.png"));
            iconMsgSuccess16 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir16 + "msg_warn.png"));
            iconMsgWarning16 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir16 + "tab_collect.png"));
            iconTabCollection16 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir16 + "tab_config.png"));
            iconTabConfigure16 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir16 + "tab_file_import.png"));
            iconTabFileImp16 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir16 + "tab_stash_craft.png"));
            iconTabStashCraft16 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir16 + "tab_stash_trans.png"));
            iconTabStashTransfer16 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir16 + "tab_char_edit.png"));
            iconTabCharEdit16 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir16 + "tab_char_trans.png"));
            iconTabCharTransfer16 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir16 + "btn_plus.png"));
            iconPlus16 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir16 + "btn_minus.png"));
            iconMinus16 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "btn_cancel.png"));
            iconBtnCancel24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "btn_dir.png"));
            iconBtnDir24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "btn_filter.png"));
            iconBtnFilter24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "btn_ok.png"));
            iconBtnOk24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "btn_reload.png"));
            iconBtnReload24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "btn_save.png"));
            iconBtnSave24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "btn_search.png"));
            iconBtnSearch24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "btn_trash.png"));
            iconBtnTrash24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "db_delete.png"));
            iconDBDelete24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "item_copy.png"));
            iconItemCopy24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "item_delete.png"));
            iconItemDelete24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "item_move.png"));
            iconItemMove24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "page_copy.png"));
            iconPageCopy24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "page_delete.png"));
            iconPageDelete24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "page_move.png"));
            iconPageMove24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "coll_all.png"));
            iconCollectAll24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "coll_found.png"));
            iconCollectFound24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "coll_miss.png"));
            iconCollectMiss24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "cfg_arz_exp.png"));
            iconConfigARZExport24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "cfg_db_imp.png"));
            iconConfigDBImport24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "cfg_save.png"));
            iconConfigSettingSave24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "mass_all.png"));
            iconMassAll24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "mass_none.png"));
            iconMassNone24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "mass_valid.png"));
            iconMassValid24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "mass_gds_exp.png"));
            iconMassGDSExport24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "mass_gds_load.png"));
            iconMassGDSLoad24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "mass_item_imp.png"));
            iconMassItemImport24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir24 + "mass_item_load.png"));
            iconMassItemLoad24 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir32 + "msg_error.png"));
            iconMsgError32 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir32 + "msg_info.png"));
            iconMsgInfo32 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir32 + "msg_success.png"));
            iconMsgSuccess32 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            image = ImageIO.read(new File(dir32 + "msg_warn.png"));
            iconMsgWarning32 = new ImageIcon(image);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public static BufferedImage getSharedStashGrid() {
        return imgSharedStash;
    }

    public static int getSharedStashXOffset() {
        return sharedXOffset;
    }

    public static int getSharedStashYOffset() {
        return sharedYOffset;
    }

    public static BufferedImage getCharStashGrid() {
        return imgCharStash;
    }

    public static BufferedImage getCharStashBG() {
        return imgCharBG;
    }
}

