GLOBAL.setmetatable(GLOBAL.getfenv(1), {__index = function(self, index)
	return GLOBAL.rawget(GLOBAL, index)
end})

local function overwrite(tabula, name, func, post)
	if type(tabula) ~= "table" then return end 
	local old = tabula[name]
	tabula[name] = function(...)
		local unpack = unpack or table.unpack or _G.unpack
		
		local results_ante = {}
		if type(func) == "function" then results_ante = {func(...)} end 
		if #results_ante > 0 then return unpack(results_ante) end 
		
		local results_original = {}
		if type(old) == "function" then results_original = {old(...)} end 
		
		local results_post = {}
		if type(post) == "function" then results_post = {post(...)} end 
		if #results_post > 0 then return unpack(results_post) end 
		
		return unpack(results_original)
	end 
end 

--[[

TRAVELLING TO NEW WORLD 

LOAD ORDER: world -> age -> player
the clock component DID NOT LOAD with a new world 

INIT ORDER: age -> world -> clock -> age -> player 
when travelling to a new world, the age component is initilized twice, and 
once before the wordl? probabl by save game index? 

LOADING OLD WORLD
init order is the same, also age component is initiated twice 

LOAD ORDER: age -> clock -> world -> age -> player; 
this time the age component is also loaded twice 

choice between forcefully syncing cycle count with age and letting the age override the 
cycles only when there is no data for cycles 
]]

local FORCE_SYNC = false 

AddPlayerPostInit(function(inst)
	local aporkalypse = GetWorld().components.aporkalypse
	local manager = GetSeasonManager()
	
	overwrite(inst, "OnLoad", function(inst, data)
		local mod_data = data and data.day_count_continues_mod
		if not mod_data then return end
				
		local age = math.floor(inst.components.age:GetAge() / 480)
		local cycles = GetClock().numcycles
		
		if cycles == 0 or FORCE_SYNC then
		 
			print("continue day count mod: syncing cycle count with age")
			print("cycles", cycles, "age", age)
			
			GetClock().numcycles = age
			
			if manager.seasonmode == mod_data.seasonmode then 
				print("continue day count mod: including season data in sync since season mode is the same")
				print("percent_season", mod_data.percent_season, "current_season", mod_data.current_season)
				
				manager.percent_season = mod_data.percent_season
				manager.current_season = mod_data.current_season
			end 	
			
			if mod_data.aporkalypse_survivor and aporkalypse then 
				print("continue day count mod, player has already survived aporkalypse, toggling first_time to false")
				aporkalypse.first_time = false 
			end 

		else 
			print("continue day count mod: not syncing cycle with age since clock has loaded data")
		end  
	end)
	
	overwrite(inst, "OnSave", function(inst, data)
		data.day_count_continues_mod = {
			aporkalypse_survivor = aporkalypse and aporkalypse.first_time == false, 
			percent_season = manager.percent_season, 
			current_season = manager.current_season, 
			seasonmode = manager.seasonmode
		}
	end)
end)
