/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Objects;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.shared.Lock;
import org.apache.jena.shared.LockMRPlusSW;
import org.apache.jena.shared.LockMRSW;
import org.apache.jena.shared.LockMutex;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.Transactional;

public class TransactionalLock
implements Transactional {
    private final ThreadLocal<ReadWrite> txnMode = ThreadLocal.withInitial(() -> null);
    private final Lock lock;

    public static TransactionalLock create(Lock lock) {
        return new TransactionalLock(lock);
    }

    public static TransactionalLock createMRPlusSW() {
        return TransactionalLock.create((Lock)new LockMRPlusSW());
    }

    public static TransactionalLock createMRSW() {
        return TransactionalLock.create((Lock)new LockMRSW());
    }

    public static TransactionalLock createMutex() {
        return TransactionalLock.create((Lock)new LockMutex());
    }

    private TransactionalLock(Lock lock) {
        this.lock = lock;
    }

    @Override
    public void begin(ReadWrite readWrite) {
        if (this.isInTransaction()) {
            this.error("Already in a transaction");
        }
        boolean isRead = readWrite.equals((Object)ReadWrite.READ);
        this.lock.enterCriticalSection(isRead);
        this.txnMode.set(readWrite);
    }

    @Override
    public void commit() {
        this.endOnce();
    }

    @Override
    public void abort() {
        this.endOnce();
    }

    @Override
    public boolean isInTransaction() {
        return this.txnMode.get() != null;
    }

    public boolean isTransactionType(ReadWrite mode) {
        return Objects.equals((Object)mode, (Object)this.txnMode.get());
    }

    private ReadWrite getTransactionType(ReadWrite mode) {
        return this.txnMode.get();
    }

    @Override
    public void end() {
        if (this.isTransactionType(ReadWrite.WRITE)) {
            this.error("Write transaction - no commit or abort before end()");
        }
        this.endOnce();
    }

    private void endOnce() {
        if (this.isInTransaction()) {
            this.lock.leaveCriticalSection();
            this.txnMode.remove();
        }
    }

    private void error(String msg) {
        throw new JenaTransactionException(msg);
    }
}

