/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

import org.marc4j.converter.CharConverter;

public class Iso6937ToUnicode
extends CharConverter {
    public String convert(char[] data) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            char c = data[i];
            int len = data.length;
            if (this.isAscii(c)) {
                sb.append(c);
            } else if (this.isCombining(c) && this.hasNext(i, len)) {
                char d = this.getCombiningChar(c * 256 + data[i + 1]);
                if (d != '\u0000') {
                    sb.append(d);
                    ++i;
                } else {
                    sb.append(this.getChar(c));
                }
            } else {
                sb.append(this.getChar(c));
            }
            ++i;
        }
        return sb.toString();
    }

    private boolean hasNext(int pos, int len) {
        return pos < len - 1;
    }

    private boolean isAscii(int i) {
        return i >= 0 && i <= 127;
    }

    private boolean isCombining(int i) {
        return i >= 192 && i <= 223;
    }

    private char getChar(int i) {
        switch (i) {
            case 160: {
                return '\u00a0';
            }
            case 161: {
                return '\u00a1';
            }
            case 162: {
                return '\u00a2';
            }
            case 163: {
                return '\u00a3';
            }
            case 165: {
                return '\u00a5';
            }
            case 167: {
                return '\u00a7';
            }
            case 168: {
                return '\u00a4';
            }
            case 169: {
                return '\u2018';
            }
            case 170: {
                return '\u201c';
            }
            case 171: {
                return '\u00ab';
            }
            case 172: {
                return '\u2190';
            }
            case 173: {
                return '\u2191';
            }
            case 174: {
                return '\u2192';
            }
            case 175: {
                return '\u2193';
            }
            case 176: {
                return '\u00b0';
            }
            case 177: {
                return '\u00b1';
            }
            case 178: {
                return '\u00b2';
            }
            case 179: {
                return '\u00b3';
            }
            case 180: {
                return '\u00d7';
            }
            case 181: {
                return '\u00b5';
            }
            case 182: {
                return '\u00b6';
            }
            case 183: {
                return '\u00b7';
            }
            case 184: {
                return '\u00f7';
            }
            case 185: {
                return '\u2019';
            }
            case 186: {
                return '\u201d';
            }
            case 187: {
                return '\u00bb';
            }
            case 188: {
                return '\u00bc';
            }
            case 189: {
                return '\u00bd';
            }
            case 190: {
                return '\u00be';
            }
            case 191: {
                return '\u00bf';
            }
            case 208: {
                return '\u2015';
            }
            case 209: {
                return '\u00b9';
            }
            case 210: {
                return '\u2117';
            }
            case 211: {
                return '\u00a9';
            }
            case 212: {
                return '\u00ae';
            }
            case 213: {
                return '\u266a';
            }
            case 214: {
                return '\u00ac';
            }
            case 215: {
                return '\u00a6';
            }
            case 220: {
                return '\u215b';
            }
            case 223: {
                return '\u215e';
            }
            case 224: {
                return '\u2126';
            }
            case 225: {
                return '\u00c6';
            }
            case 226: {
                return '\u0110';
            }
            case 227: {
                return '\u00aa';
            }
            case 228: {
                return '\u0126';
            }
            case 230: {
                return '\u0132';
            }
            case 231: {
                return '\u013f';
            }
            case 232: {
                return '\u0141';
            }
            case 233: {
                return '\u00d8';
            }
            case 234: {
                return '\u0152';
            }
            case 235: {
                return '\u00ba';
            }
            case 236: {
                return '\u00de';
            }
            case 237: {
                return '\u0166';
            }
            case 238: {
                return '\u014a';
            }
            case 239: {
                return '\u0149';
            }
            case 240: {
                return '\u0138';
            }
            case 241: {
                return '\u00e6';
            }
            case 242: {
                return '\u0111';
            }
            case 243: {
                return '\u00f0';
            }
            case 244: {
                return '\u0127';
            }
            case 245: {
                return '\u0131';
            }
            case 246: {
                return '\u0133';
            }
            case 247: {
                return '\u0140';
            }
            case 248: {
                return '\u0142';
            }
            case 249: {
                return '\u00f8';
            }
            case 250: {
                return '\u0153';
            }
            case 251: {
                return '\u00df';
            }
            case 252: {
                return '\u00fe';
            }
            case 253: {
                return '\u0167';
            }
            case 254: {
                return '\u014b';
            }
            case 255: {
                return '\u00ad';
            }
        }
        return (char)i;
    }

    private char getCombiningChar(int i) {
        switch (i) {
            case 49473: {
                return '\u00c0';
            }
            case 49477: {
                return '\u00c8';
            }
            case 49481: {
                return '\u00cc';
            }
            case 49487: {
                return '\u00d2';
            }
            case 49493: {
                return '\u00d9';
            }
            case 49505: {
                return '\u00e0';
            }
            case 49509: {
                return '\u00e8';
            }
            case 49513: {
                return '\u00ec';
            }
            case 49519: {
                return '\u00f2';
            }
            case 49525: {
                return '\u00f9';
            }
            case 49696: {
                return '\u00b4';
            }
            case 49729: {
                return '\u00c1';
            }
            case 49731: {
                return '\u0106';
            }
            case 49733: {
                return '\u00c9';
            }
            case 49737: {
                return '\u00cd';
            }
            case 49740: {
                return '\u0139';
            }
            case 49742: {
                return '\u0143';
            }
            case 49743: {
                return '\u00d3';
            }
            case 49746: {
                return '\u0154';
            }
            case 49747: {
                return '\u015a';
            }
            case 49749: {
                return '\u00da';
            }
            case 49753: {
                return '\u00dd';
            }
            case 49754: {
                return '\u0179';
            }
            case 49761: {
                return '\u00e1';
            }
            case 49763: {
                return '\u0107';
            }
            case 49765: {
                return '\u00e9';
            }
            case 49767: {
                return '\u01f5';
            }
            case 49769: {
                return '\u00ed';
            }
            case 49772: {
                return '\u013a';
            }
            case 49774: {
                return '\u0144';
            }
            case 49775: {
                return '\u00f3';
            }
            case 49778: {
                return '\u0155';
            }
            case 49779: {
                return '\u015b';
            }
            case 49781: {
                return '\u00fa';
            }
            case 49785: {
                return '\u00fd';
            }
            case 49786: {
                return '\u017a';
            }
            case 49985: {
                return '\u00c2';
            }
            case 49987: {
                return '\u0108';
            }
            case 49989: {
                return '\u00ca';
            }
            case 49991: {
                return '\u011c';
            }
            case 49992: {
                return '\u0124';
            }
            case 49993: {
                return '\u00ce';
            }
            case 49994: {
                return '\u0134';
            }
            case 49999: {
                return '\u00d4';
            }
            case 50003: {
                return '\u015c';
            }
            case 50005: {
                return '\u00db';
            }
            case 50007: {
                return '\u0174';
            }
            case 50009: {
                return '\u0176';
            }
            case 50017: {
                return '\u00e2';
            }
            case 50019: {
                return '\u0109';
            }
            case 50021: {
                return '\u00ea';
            }
            case 50023: {
                return '\u011d';
            }
            case 50024: {
                return '\u0125';
            }
            case 50025: {
                return '\u00ee';
            }
            case 50026: {
                return '\u0135';
            }
            case 50031: {
                return '\u00f4';
            }
            case 50035: {
                return '\u015d';
            }
            case 50037: {
                return '\u00fb';
            }
            case 50039: {
                return '\u0175';
            }
            case 50041: {
                return '\u0177';
            }
            case 50241: {
                return '\u00c3';
            }
            case 50249: {
                return '\u0128';
            }
            case 50254: {
                return '\u00d1';
            }
            case 50255: {
                return '\u00d5';
            }
            case 50261: {
                return '\u0168';
            }
            case 50273: {
                return '\u00e3';
            }
            case 50281: {
                return '\u0129';
            }
            case 50286: {
                return '\u00f1';
            }
            case 50287: {
                return '\u00f5';
            }
            case 50293: {
                return '\u0169';
            }
            case 50497: {
                return '\u0100';
            }
            case 50501: {
                return '\u0112';
            }
            case 50505: {
                return '\u012a';
            }
            case 50511: {
                return '\u014c';
            }
            case 50517: {
                return '\u016a';
            }
            case 50529: {
                return '\u0101';
            }
            case 50533: {
                return '\u0113';
            }
            case 50537: {
                return '\u012b';
            }
            case 50543: {
                return '\u014d';
            }
            case 50549: {
                return '\u016b';
            }
            case 50720: {
                return '\u02d8';
            }
            case 50753: {
                return '\u0102';
            }
            case 50759: {
                return '\u011e';
            }
            case 50773: {
                return '\u016c';
            }
            case 50785: {
                return '\u0103';
            }
            case 50791: {
                return '\u011f';
            }
            case 50805: {
                return '\u016d';
            }
            case 51011: {
                return '\u010a';
            }
            case 51013: {
                return '\u0116';
            }
            case 51015: {
                return '\u0120';
            }
            case 51017: {
                return '\u0130';
            }
            case 51034: {
                return '\u017b';
            }
            case 51043: {
                return '\u010b';
            }
            case 51045: {
                return '\u0117';
            }
            case 51047: {
                return '\u0121';
            }
            case 51066: {
                return '\u017c';
            }
            case 51232: {
                return '\u00a8';
            }
            case 51265: {
                return '\u00c4';
            }
            case 51269: {
                return '\u00cb';
            }
            case 51273: {
                return '\u00cf';
            }
            case 51279: {
                return '\u00d6';
            }
            case 51285: {
                return '\u00dc';
            }
            case 51289: {
                return '\u0178';
            }
            case 51297: {
                return '\u00e4';
            }
            case 51301: {
                return '\u00eb';
            }
            case 51305: {
                return '\u00ef';
            }
            case 51311: {
                return '\u00f6';
            }
            case 51317: {
                return '\u00fc';
            }
            case 51321: {
                return '\u00ff';
            }
            case 51744: {
                return '\u02da';
            }
            case 51777: {
                return '\u00c5';
            }
            case 51885: {
                return '\u016e';
            }
            case 51809: {
                return '\u00e5';
            }
            case 51829: {
                return '\u016f';
            }
            case 52000: {
                return '\u00b8';
            }
            case 52035: {
                return '\u00c7';
            }
            case 52039: {
                return '\u0122';
            }
            case 52043: {
                return '\u0136';
            }
            case 52044: {
                return '\u013b';
            }
            case 52046: {
                return '\u0145';
            }
            case 52050: {
                return '\u0156';
            }
            case 52051: {
                return '\u015e';
            }
            case 52052: {
                return '\u0162';
            }
            case 52067: {
                return '\u00e7';
            }
            case 52075: {
                return '\u0137';
            }
            case 52076: {
                return '\u013c';
            }
            case 52078: {
                return '\u0146';
            }
            case 52082: {
                return '\u0157';
            }
            case 52083: {
                return '\u015f';
            }
            case 52084: {
                return '\u0163';
            }
            case 52559: {
                return '\u0150';
            }
            case 52565: {
                return '\u0170';
            }
            case 52591: {
                return '\u0151';
            }
            case 52597: {
                return '\u0171';
            }
            case 52768: {
                return '\u02db';
            }
            case 52801: {
                return '\u0104';
            }
            case 52805: {
                return '\u0118';
            }
            case 52809: {
                return '\u012e';
            }
            case 52821: {
                return '\u0172';
            }
            case 52833: {
                return '\u0105';
            }
            case 52837: {
                return '\u0119';
            }
            case 52841: {
                return '\u012f';
            }
            case 52853: {
                return '\u0173';
            }
            case 53024: {
                return '\u02c7';
            }
            case 53059: {
                return '\u010c';
            }
            case 53060: {
                return '\u010e';
            }
            case 53061: {
                return '\u011a';
            }
            case 53068: {
                return '\u013d';
            }
            case 53070: {
                return '\u0147';
            }
            case 53074: {
                return '\u0158';
            }
            case 53075: {
                return '\u0160';
            }
            case 53076: {
                return '\u0164';
            }
            case 53082: {
                return '\u017d';
            }
            case 53091: {
                return '\u010d';
            }
            case 53092: {
                return '\u010f';
            }
            case 53093: {
                return '\u011b';
            }
            case 53100: {
                return '\u013e';
            }
            case 53102: {
                return '\u0148';
            }
            case 53106: {
                return '\u0159';
            }
            case 53107: {
                return '\u0161';
            }
            case 53108: {
                return '\u0165';
            }
            case 53114: {
                return '\u017e';
            }
        }
        return '\u0000';
    }
}

