/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.wikidata.wdtk.util.DirectoryManager;
import org.wikidata.wdtk.util.DirectoryManagerImpl;

public class DirectoryManagerFactory {
    static Class<? extends DirectoryManager> dmClass = DirectoryManagerImpl.class;

    public static void setDirectoryManagerClass(Class<? extends DirectoryManager> clazz) {
        dmClass = clazz;
    }

    public static DirectoryManager createDirectoryManager(Path path, boolean readOnly) throws IOException {
        try {
            return dmClass.getConstructor(Path.class, Boolean.class).newInstance(path, readOnly);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e.toString(), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IOException) {
                throw (IOException)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException().toString(), e.getTargetException());
        }
    }

    public static DirectoryManager createDirectoryManager(String directory, boolean readOnly) throws IOException {
        return DirectoryManagerFactory.createDirectoryManager(Paths.get(directory, new String[0]), readOnly);
    }
}

