/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common;

import de.fau.cs.osr.ptk.common.AstEntityMap;
import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.ptk.common.ast.AstLeafNode;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.AstNodeList;
import de.fau.cs.osr.ptk.common.ast.AstNodePropertyIterator;
import de.fau.cs.osr.ptk.common.ast.AstStringNode;
import de.fau.cs.osr.ptk.common.ast.AstText;
import de.fau.cs.osr.utils.PrinterBase;
import de.fau.cs.osr.utils.StringTools;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class AstPrinter<T extends AstNode<T>>
extends AstVisitor<T> {
    protected final PrinterBase p;
    private boolean compact = true;

    public void visit(AstNode<T> n) {
        PrinterBase.Memoize m = this.p.memoizeStart(n);
        if (m != null) {
            if (n.isEmpty() && !this.hasVisibleProperties(n)) {
                this.p.indent(n.getNodeName());
                this.p.println("()");
            } else {
                this.printNode(n);
            }
            this.p.memoizeStop(m);
        }
    }

    public void visit(AstLeafNode<T> n) {
        if (n.isEmpty() && !this.hasVisibleProperties(n)) {
            this.p.indent(n.getNodeName());
            this.p.println("()");
        } else {
            this.printNode(n);
        }
    }

    public void visit(AstText<T> n) {
        if (!this.hasVisibleProperties(n)) {
            this.p.indent('\"');
            this.p.print(StringTools.escJava((String)n.getContent()));
            this.p.println('\"');
        } else {
            this.printNode(n);
        }
    }

    public void visit(AstStringNode<T> n) {
        if (!this.hasVisibleProperties(n)) {
            this.p.indent(n.getNodeName());
            this.p.print("(\"");
            this.p.print(StringTools.escJava((String)n.getContent()));
            this.p.println("\")");
        } else {
            this.printNode(n);
        }
    }

    public void visit(AstNodeList<T> n) {
        PrinterBase.Memoize m = this.p.memoizeStart(n);
        if (m != null) {
            String name = "";
            if (n.getNodeType() != 2) {
                name = n.getNodeName();
            }
            if (this.hasVisibleProperties(n)) {
                this.printNode(n);
            } else if (n.isEmpty()) {
                this.p.indent(name);
                this.p.println("[]");
            } else {
                boolean singleLine = false;
                if (this.isCompact() && n.size() <= 1) {
                    PrinterBase.OutputBuffer b = this.p.outputBufferStart();
                    this.printListOfNodes(n);
                    b.stop();
                    String output = b.getBuffer().trim();
                    if (this.isSingleLine(output)) {
                        this.p.indent(name);
                        this.p.print("[ ");
                        this.p.print(output);
                        this.p.println(" ]");
                        singleLine = true;
                    }
                }
                if (!singleLine) {
                    this.p.indent(name);
                    this.p.println('[');
                    this.p.incIndent();
                    this.printListOfNodes(n);
                    this.p.decIndent();
                    this.p.indentln(']');
                }
            }
            this.p.memoizeStop(m);
        }
    }

    protected boolean hasVisibleProperties(AstNode<T> n) {
        if (n.hasAttributes()) {
            return true;
        }
        int count = n.getPropertyCount();
        if (count > 2) {
            return true;
        }
        if (count == 0) {
            return false;
        }
        AstNodePropertyIterator i = n.propertyIterator();
        while (i.next()) {
            if (!(i.getName().equals("rtd") ? i.getValue() != null : !i.getName().equals("content") || !(n instanceof AstStringNode))) continue;
            return true;
        }
        return false;
    }

    protected void printNode(AstNode<T> n) {
        this.p.indent(n.getNodeName());
        this.p.println('(');
        this.p.incIndent();
        this.printNodeContent(n);
        this.p.decIndent();
        this.p.indentln(')');
    }

    protected void printNodeContent(AstNode<T> n) {
        if (this.hasVisibleProperties(n)) {
            this.printProperties(n);
        }
        this.printListOfNodes(n);
    }

    protected void printProperties(AstNode<T> n) {
        TreeMap<String, Object> props = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : n.getAttributes().entrySet()) {
            props.put("{A} " + entry.getKey(), entry.getValue());
        }
        AstNodePropertyIterator i = n.propertyIterator();
        while (i.next()) {
            if (i.getValue() == null && i.getName().equals("rtd")) continue;
            props.put("{P} " + i.getName(), i.getValue());
        }
        for (Map.Entry entry : props.entrySet()) {
            this.p.indent((String)entry.getKey());
            this.p.print(" = ");
            this.p.eatNewlinesAndIndents(1);
            this.printPropertyValue(entry.getValue());
            this.p.clearEatNewlinesAndIndents();
        }
    }

    protected void printPropertyValue(Object value) {
        if (value == null) {
            this.p.indentln("null");
        } else if (value instanceof String) {
            this.p.indent('\"');
            this.p.print(StringTools.escJava((String)((String)value)));
            this.p.println('\"');
        } else if (value instanceof AstNode) {
            this.p.incIndent();
            AstNode node = (AstNode)value;
            this.dispatch(node);
            this.p.decIndent();
        } else if (value instanceof AstEntityMap) {
            AstEntityMap map = (AstEntityMap)value;
            this.printEntityMap(map);
        } else if (value instanceof Collection) {
            this.printCollection((Collection)value);
        } else {
            this.p.indentln(value.toString());
        }
    }

    protected void printEntityMap(AstEntityMap<T> entityMap) {
        if (entityMap.getMap().isEmpty()) {
            this.p.indentln("-");
        } else {
            TreeMap<Integer, T> map = new TreeMap<Integer, T>(entityMap.getMap());
            this.p.indentln("{");
            this.p.incIndent();
            Iterator k = map.entrySet().iterator();
            while (k.hasNext()) {
                Map.Entry entry = k.next();
                this.p.indent('[');
                this.p.print(((Integer)entry.getKey()).toString());
                this.p.print("] = ");
                this.p.eatNewlinesAndIndents(1);
                this.printPropertyValue(entry.getValue());
                this.p.clearEatNewlinesAndIndents();
                this.p.ignoreNewlines();
                this.p.println(k.hasNext() ? "," : "");
            }
            this.p.decIndent();
            this.p.indentln('}');
        }
    }

    protected void printCollection(Collection<?> c) {
        if (c.isEmpty()) {
            this.p.indentln("C[]");
        } else {
            boolean singleLine = false;
            if (this.isCompact() && c.size() == 1) {
                PrinterBase.OutputBuffer b = this.p.outputBufferStart();
                this.printPropertyValue(c.toArray()[0]);
                b.stop();
                String output = b.getBuffer().trim();
                if (this.isSingleLine(output)) {
                    this.p.indent("C[ ");
                    this.p.print(output);
                    this.p.println(" ]");
                    singleLine = true;
                }
            }
            if (!singleLine) {
                this.p.indentln("C[");
                this.p.incIndent();
                Iterator<?> k = c.iterator();
                while (k.hasNext()) {
                    this.printPropertyValue(k.next());
                    this.p.ignoreNewlines();
                    this.p.println(k.hasNext() ? "," : "");
                }
                this.p.decIndent();
                this.p.indentln(']');
            }
        }
    }

    protected void printListOfNodes(AstNode<T> n) {
        int j = 0;
        String[] childNames = n.getChildNames();
        Iterator i = n.iterator();
        while (i.hasNext()) {
            if (!n.isList()) {
                this.p.indent(childNames[j++]);
            } else {
                this.p.indent('[');
                this.p.print(String.valueOf(j++));
                this.p.print(']');
            }
            this.p.print(" = ");
            this.p.eatNewlinesAndIndents(1);
            this.dispatch((AstNode)i.next());
            this.p.clearEatNewlinesAndIndents();
            this.p.ignoreNewlines();
            this.p.println(i.hasNext() ? "," : "");
        }
    }

    protected boolean isSingleLine(String text) {
        return text.indexOf(10) == -1 && text.indexOf(13) == -1;
    }

    public static <T extends AstNode<T>> String print(T node) {
        return AstPrinter.print(new StringWriter(), node).toString();
    }

    public static <T extends AstNode<T>> Writer print(Writer writer, T node) {
        new AstPrinter<T>(writer).go(node);
        return writer;
    }

    public AstPrinter(Writer writer) {
        this.p = new PrinterBase(writer);
        this.p.setMemoize(true);
        this.setCompact(true);
    }

    protected Object after(T node, Object result) {
        this.p.flush();
        return result;
    }

    public void setCompact(boolean compact) {
        this.compact = compact;
    }

    public boolean isCompact() {
        return this.compact;
    }
}

