/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.serialization;

import de.fau.cs.osr.ptk.common.serialization.TypeNameMapper;
import de.fau.cs.osr.utils.DualHashBidiMap;
import de.fau.cs.osr.utils.ReflectionUtils;
import de.fau.cs.osr.utils.StringTools;

public class SimpleTypeNameMapper
implements TypeNameMapper {
    private DualHashBidiMap typeToName;

    public SimpleTypeNameMapper() {
        this.typeToName = new DualHashBidiMap();
    }

    public SimpleTypeNameMapper(SimpleTypeNameMapper stnm) {
        this.typeToName = new DualHashBidiMap(stnm.typeToName);
    }

    public void add(Class<?> type, String name) {
        this.typeToName.put(type, (Object)name);
    }

    @Override
    public String nameForType(Class<?> n) {
        String typeAlias = (String)this.typeToName.get(n);
        if (typeAlias != null) {
            return typeAlias;
        }
        if (n.isArray()) {
            ReflectionUtils.ArrayInfo dim = ReflectionUtils.arrayDimension(n);
            String elementTypeName = this.nameForType(dim.elementClass);
            return elementTypeName + StringTools.strrep((String)"[]", (int)dim.dim);
        }
        if (ReflectionUtils.isBasicDataType(n)) {
            return ReflectionUtils.abbreviateBasicDataTypeName(n);
        }
        return this.nameForUnmappedType(n);
    }

    protected String nameForUnmappedType(Class<?> n) {
        return n.getName();
    }

    @Override
    public Class<?> typeForName(String name) {
        if (name.isEmpty()) {
            return this.typeForInvalidName(name);
        }
        Class type = (Class)this.typeToName.getKey((Object)name);
        if (type != null) {
            return type;
        }
        int nameEnd = name.indexOf("[]");
        if (nameEnd > 0) {
            int i;
            for (i = nameEnd + 2; i < name.length(); i += 2) {
                if (name.indexOf("[]", i) == i) continue;
                return this.typeForInvalidName(name);
            }
            return ReflectionUtils.arrayClassFor(this.typeForName(name.substring(0, nameEnd)), (int)((i - nameEnd) / 2));
        }
        if (ReflectionUtils.isBasicDataType((String)name)) {
            return ReflectionUtils.getTypeFromAbbreviation((String)name);
        }
        return this.typeForUnmappedName(name);
    }

    protected Class<?> typeForInvalidName(String name) {
        throw new IllegalArgumentException("Illegal type name '" + name + "'");
    }

    protected Class<?> typeForUnmappedName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e1) {
            return null;
        }
    }
}

