/*
 * Decompiled with CFR 0.152.
 */
package com.metaweb.lessen.tokenizers;

import com.metaweb.lessen.tokenizers.TokenizerBase;
import java.io.IOException;
import java.io.Reader;

public class ReaderTokenizer
extends TokenizerBase {
    protected static final int s_bufferSize = 32;
    protected final Reader _reader;
    protected final StringBuffer _sb = new StringBuffer(64);
    protected final char[] _chars = new char[32];
    protected int _sbStartIndex = 0;
    protected int _next = 0;
    protected boolean _eof = false;

    public ReaderTokenizer(Reader reader) {
        this._reader = reader;
        this.next();
    }

    protected boolean hasMoreChar() {
        return this.hasMoreChar(0);
    }

    protected void advance() {
        this.advance(1, false);
    }

    protected void advance(int by, boolean flush) {
        this._next += by;
        if (flush) {
            this.flush(this._next);
        }
    }

    protected void flush(int upToIndex) {
        int chop = upToIndex - this._sbStartIndex;
        if ((double)chop > 24.0) {
            this._sb.delete(0, chop);
            this._sbStartIndex += chop;
        }
    }

    protected char getCharRelative(int offset) {
        this.tryLoadAhead(offset + 1);
        return this._sb.charAt(this._next - this._sbStartIndex + offset);
    }

    protected char getCurrentChar() {
        return this.getCharRelative(0);
    }

    protected int getCurrentOffset() {
        return this._next;
    }

    protected String getText(int from, int to) {
        return this._sb.substring(from - this._sbStartIndex, to - this._sbStartIndex);
    }

    protected boolean hasMoreChar(int offset) {
        this.tryLoadAhead(offset + 1);
        return this._next - this._sbStartIndex + offset < this._sb.length();
    }

    protected void tryLoadAhead(int distance) {
        if (this._next - this._sbStartIndex + distance > this._sb.length() && !this._eof) {
            try {
                int c = this._reader.read(this._chars);
                if (c < 0) {
                    this._eof = true;
                    this._reader.close();
                } else {
                    this._sb.append(this._chars, 0, c);
                }
            }
            catch (IOException e) {
                this._eof = true;
            }
        }
    }
}

