/*
 * Decompiled with CFR 0.152.
 */
package com.metaweb.lessen.tokenizers;

import com.metaweb.lessen.tokenizers.Tokenizer;
import com.metaweb.lessen.tokens.NumericToken;
import com.metaweb.lessen.tokens.NumericWithUnitToken;
import com.metaweb.lessen.tokens.StringValueToken;
import com.metaweb.lessen.tokens.Token;
import com.metaweb.lessen.tokens.UriToken;

public abstract class TokenizerBase
implements Tokenizer {
    protected Token _token;

    protected abstract boolean hasMoreChar();

    protected abstract boolean hasMoreChar(int var1);

    protected abstract char getCurrentChar();

    protected abstract char getCharRelative(int var1);

    protected abstract int getCurrentOffset();

    protected abstract void advance();

    protected abstract void advance(int var1, boolean var2);

    protected void advance(int by) {
        this.advance(by, true);
    }

    protected abstract String getText(int var1, int var2);

    protected abstract void flush(int var1);

    public Token getToken() {
        return this._token;
    }

    public void next() {
        this._token = null;
        if (this.hasMoreChar()) {
            int distance;
            char c2;
            int tokenStart = this.getCurrentOffset();
            char c = this.getCurrentChar();
            if (TokenizerBase.isWhitespace(c)) {
                int distance2 = this.lookOverWhitespace(tokenStart);
                int tokenEnd = tokenStart + distance2;
                this._token = new Token(Token.Type.Whitespace, tokenStart, tokenEnd, this.getText(tokenStart, tokenEnd));
                this.advance(distance2);
                return;
            }
            if (Character.isDigit(c)) {
                this.parseNumber(tokenStart, 1);
                return;
            }
            if ("{}()[]:;,".indexOf(c) >= 0) {
                int tokenEnd = tokenStart + 1;
                this._token = new Token(Token.Type.Delimiter, tokenStart, tokenEnd, this.getText(tokenStart, tokenEnd));
                this.advance();
                return;
            }
            if (c == '~' || c == '|') {
                if (this.hasMoreChar(1) && this.getCharRelative(1) == '=') {
                    this.advance();
                }
            } else if (c == '/') {
                if (this.hasMoreChar(1)) {
                    c2 = this.getCharRelative(1);
                    if (c2 == '/') {
                        this.advance(2, false);
                        int commentStart = this.getCurrentOffset();
                        while (this.hasMoreChar() && (c2 = this.getCurrentChar()) != '\r' && c2 != '\n' && c2 != '\f') {
                            this.advance();
                        }
                        int tokenEnd = this.getCurrentOffset();
                        this._token = new StringValueToken(Token.Type.Comment, tokenStart, tokenEnd, this.getText(tokenStart, tokenEnd), this.getText(commentStart, tokenEnd));
                        return;
                    }
                    if (c2 == '*') {
                        int commentStart;
                        this.advance(2, false);
                        int commentEnd = commentStart = this.getCurrentOffset();
                        while (this.hasMoreChar()) {
                            c2 = this.getCurrentChar();
                            if (c2 == '*' && this.hasMoreChar(1) && this.getCharRelative(1) == '/') {
                                this.advance(2, false);
                                break;
                            }
                            ++commentEnd;
                            this.advance();
                        }
                        int tokenEnd = this.getCurrentOffset();
                        this._token = new StringValueToken(Token.Type.Comment, tokenStart, tokenEnd, this.getText(tokenStart, tokenEnd), this.getText(commentStart, commentEnd));
                        this.flush(tokenEnd);
                        return;
                    }
                }
            } else if (c == '@') {
                distance = this.lookOverIdentifier(1);
                if (distance > 0) {
                    int tokenEnd = tokenStart + 1 + distance;
                    this._token = new Token(Token.Type.AtIdentifier, tokenStart, tokenEnd, this.getText(tokenStart, tokenEnd));
                    this.advance(1 + distance);
                    return;
                }
            } else if (c == '#') {
                distance = this.lookOverName(1);
                if (distance > 0) {
                    int tokenEnd = tokenStart + 1 + distance;
                    this._token = new Token(Token.Type.HashName, tokenStart, tokenEnd, this.getText(tokenStart, tokenEnd));
                    this.advance(1 + distance);
                    return;
                }
            } else {
                if (c == '<' && this.hasMoreChar(3) && this.getCharRelative(1) == '!' && this.getCharRelative(2) == '-' && this.getCharRelative(3) == '-') {
                    int tokenEnd = tokenStart + 4;
                    this._token = new Token(Token.Type.CDataOpen, tokenStart, tokenEnd, this.getText(tokenStart, tokenEnd));
                    this.advance(4);
                    return;
                }
                if (c == '-') {
                    if (this.hasMoreChar(2) && this.getCharRelative(1) == '-' && this.getCharRelative(2) == '>') {
                        int tokenEnd = tokenStart + 3;
                        this._token = new Token(Token.Type.CDataClose, tokenStart, tokenEnd, this.getText(tokenStart, tokenEnd));
                        this.advance(3);
                        return;
                    }
                    if (this.hasMoreChar(1)) {
                        if (Character.isDigit(this.getCharRelative(1))) {
                            this.advance();
                            this.parseNumber(tokenStart, -1);
                            return;
                        }
                        distance = this.lookOverName(1);
                        if (distance > 0) {
                            int tokenEnd = tokenStart + 1 + distance;
                            this._token = new Token(Token.Type.Identifier, tokenStart, tokenEnd, this.getText(tokenStart, tokenEnd));
                            this.advance(1 + distance);
                            return;
                        }
                    }
                } else {
                    if (TokenizerBase.isNameStartChar(c)) {
                        int unicodeCodeDistance;
                        if (c == 'u' && this.hasMoreChar(1) && this.getCharRelative(1) == '+' && (unicodeCodeDistance = this.lookOverUnicodeCode(2)) > 0) {
                            int unicodeCodeDistance2;
                            int tokenEnd = tokenStart + 2 + unicodeCodeDistance;
                            this.advance(2 + unicodeCodeDistance, false);
                            if (this.hasMoreChar() && this.getCurrentChar() == '-' && (unicodeCodeDistance2 = this.lookOverUnicodeCode(1)) > 0) {
                                tokenEnd += 1 + unicodeCodeDistance2;
                                this.advance(1 + unicodeCodeDistance2, false);
                            }
                            this._token = new Token(Token.Type.UnicodeRange, tokenStart, tokenEnd, this.getText(tokenStart, tokenEnd));
                            this.flush(tokenEnd);
                            return;
                        }
                        int distance3 = this.lookOverName(0);
                        int tokenEnd = tokenStart + distance3;
                        String name = this.getText(tokenStart, tokenEnd);
                        if (this.hasMoreChar(distance3) && this.getCharRelative(distance3) == '(') {
                            this.advance(distance3 + 1, false);
                            if ("uri".equals(name) || "url".equals(name)) {
                                this.parseRestOfURI(tokenStart, name);
                                return;
                            }
                            this._token = new Token(Token.Type.Function, tokenStart, ++tokenEnd, this.getText(tokenStart, tokenEnd));
                            return;
                        }
                        this._token = new Token(Token.Type.Identifier, tokenStart, tokenEnd, this.getText(tokenStart, tokenEnd));
                        this.advance(distance3);
                        return;
                    }
                    if (c == '\"' || c == '\'') {
                        this.advance();
                        String value = this.parseString(c);
                        int tokenEnd = this.getCurrentOffset();
                        this._token = new StringValueToken(Token.Type.String, tokenStart, tokenEnd, this.getText(tokenStart, tokenEnd), value);
                        return;
                    }
                    if (c == '$' && this.hasMoreChar(1)) {
                        c2 = this.getCharRelative(1);
                        if (c2 == '{') {
                            int nameStart;
                            int nameEnd = nameStart = tokenStart + 2;
                            int distance4 = 2;
                            while (this.hasMoreChar(distance4)) {
                                c2 = this.getCharRelative(distance4);
                                if (c2 == '}') {
                                    ++distance4;
                                    break;
                                }
                                ++nameEnd;
                                ++distance4;
                            }
                            int tokenEnd = tokenStart + distance4;
                            this._token = new StringValueToken(Token.Type.Variable, tokenStart, tokenEnd, this.getText(tokenStart, tokenEnd), this.getText(nameStart, nameEnd));
                            this.advance(distance4);
                            return;
                        }
                        if (Character.isLetter(c2)) {
                            int nameStart = tokenStart + 1;
                            int distance5 = 1;
                            while (this.hasMoreChar(distance5) && Character.isLetter(c2 = this.getCharRelative(distance5))) {
                                ++distance5;
                            }
                            int tokenEnd = tokenStart + distance5;
                            this._token = new StringValueToken(Token.Type.Variable, tokenStart, tokenEnd, this.getText(tokenStart, tokenEnd), this.getText(nameStart, tokenEnd));
                            this.advance(distance5);
                            return;
                        }
                    }
                }
            }
            this.advance();
            int tokenEnd = this.getCurrentOffset();
            this._token = new Token(Token.Type.Operator, tokenStart, tokenEnd, this.getText(tokenStart, tokenEnd));
        }
    }

    protected void parseNumber(int tokenStart, int signum) {
        char c;
        int n = 0;
        double divide = 1.0;
        while (this.hasMoreChar() && Character.isDigit(c = this.getCurrentChar())) {
            n = n * 10 + (c - 48);
            this.advance();
        }
        if (this.hasMoreChar() && (c = this.getCurrentChar()) == '.') {
            this.advance();
            while (this.hasMoreChar() && Character.isDigit(c = this.getCurrentChar())) {
                n = n * 10 + (c - 48);
                divide *= 10.0;
                this.advance();
            }
        }
        Double num = (double)signum * (divide > 1.0 ? (double)n / divide : (double)n);
        if (this.hasMoreChar()) {
            c = this.getCurrentChar();
            if (c == '%') {
                this.advance();
                int tokenEnd = this.getCurrentOffset();
                this._token = new NumericToken(Token.Type.Percentage, tokenStart, tokenEnd, this.getText(tokenStart, tokenEnd), num);
                this.flush(tokenEnd);
                return;
            }
            if (Character.isLetter(c)) {
                int unitStart = this.getCurrentOffset();
                this.advance();
                while (this.hasMoreChar() && Character.isLetter(this.getCurrentChar())) {
                    this.advance();
                }
                int tokenEnd = this.getCurrentOffset();
                this._token = new NumericWithUnitToken(Token.Type.Dimension, tokenStart, tokenEnd, this.getText(tokenStart, tokenEnd), num, this.getText(unitStart, tokenEnd));
                this.flush(tokenEnd);
                return;
            }
        }
        int tokenEnd = this.getCurrentOffset();
        this._token = new NumericToken(Token.Type.Number, tokenStart, tokenEnd, this.getText(tokenStart, tokenEnd), num);
        this.flush(tokenEnd);
    }

    protected void parseRestOfURI(int tokenStart, String prefix) {
        char c;
        this.swallowWhitespace(false);
        String value = "";
        if (this.hasMoreChar()) {
            c = this.getCurrentChar();
            if (c == '\"' || c == '\'') {
                this.advance();
                value = this.parseString(c);
            } else {
                int valueStart = this.getCurrentOffset();
                this.advance();
                while (this.hasMoreChar() && !TokenizerBase.isWhitespace(c = this.getCurrentChar()) && c != ')') {
                    this.advance();
                }
                value = this.getText(valueStart, this.getCurrentOffset());
            }
        }
        this.swallowWhitespace(false);
        if (this.hasMoreChar() && (c = this.getCurrentChar()) == ')') {
            this.advance();
        }
        int tokenEnd = this.getCurrentOffset();
        this._token = new UriToken(tokenStart, tokenEnd, this.getText(tokenStart, tokenEnd), prefix, value);
    }

    protected String parseString(char delimiter) {
        int start;
        int end = start = this.getCurrentOffset();
        while (this.hasMoreChar()) {
            char c = this.getCurrentChar();
            if (c == delimiter) {
                end = this.getCurrentOffset();
                this.advance();
                break;
            }
            if (c == '\r' || c == '\n' || c == '\f') {
                end = this.getCurrentOffset();
                break;
            }
            if (c == '\\' && this.hasMoreChar(1)) {
                this.advance();
            }
            this.advance();
        }
        return this.getText(start, end);
    }

    protected void swallowWhitespace(boolean flush) {
        this.advance(this.lookOverWhitespace(0), flush);
    }

    protected int lookOverWhitespace(int index) {
        int distance = 0;
        while (this.hasMoreChar(distance) && Character.isWhitespace(this.getCharRelative(distance))) {
            ++distance;
        }
        return distance;
    }

    protected int lookOverIdentifier(int offset) {
        int distance2;
        int distance = 0;
        if (this.hasMoreChar(offset + distance) && (distance2 = this.lookOverNameStartChar(offset + distance)) > 0) {
            distance += distance2;
            distance += this.lookOverName(offset + distance);
        }
        return distance;
    }

    protected int lookOverName(int offset) {
        int distance2;
        int distance = 0;
        while (this.hasMoreChar(offset + distance) && (distance2 = this.lookOverNameChar(offset + distance)) > 0) {
            distance += distance2;
        }
        return distance;
    }

    protected int lookOverNameStartChar(int offset) {
        int distance = 0;
        if (this.hasMoreChar(offset + distance)) {
            char c = this.getCharRelative(offset + distance);
            if (TokenizerBase.isNameStartChar(c)) {
                ++distance;
            } else if (c == '\\' && this.hasMoreChar(offset + distance + 1)) {
                char c2 = this.getCharRelative(offset + distance + 1);
                if (TokenizerBase.isHexDigit(c2)) {
                    int distance2 = this.lookOverUnicodeCode(offset + distance + 1);
                    if (distance2 > 0) {
                        distance += distance2;
                    }
                } else if (c2 != '\r' && c2 != '\n' && c2 != '\f') {
                    distance += 2;
                }
            }
        }
        return distance;
    }

    protected int lookOverNameChar(int offset) {
        int distance = 0;
        if (this.hasMoreChar(offset + distance)) {
            char c = this.getCharRelative(offset + distance);
            if (TokenizerBase.isNameChar(c)) {
                ++distance;
            } else if (c == '\\' && this.hasMoreChar(offset + distance + 1)) {
                char c2 = this.getCharRelative(offset + distance + 1);
                if (TokenizerBase.isHexDigit(c2)) {
                    int distance2 = this.lookOverUnicodeCode(offset + distance + 1);
                    if (distance2 > 0) {
                        distance += distance2;
                    }
                } else if (c2 != '\r' && c2 != '\n' && c2 != '\f') {
                    distance += 2;
                }
            }
        }
        return distance;
    }

    protected int lookOverUnicodeChar(int offset) {
        int distance2;
        char c2;
        char c;
        int distance = 0;
        if (this.hasMoreChar(offset + distance) && (c = this.getCharRelative(offset + distance)) == '\\' && this.hasMoreChar(offset + distance + 1) && TokenizerBase.isHexDigit(c2 = this.getCharRelative(offset + distance + 1)) && (distance2 = this.lookOverUnicodeCode(offset + distance + 1)) > 0) {
            distance += distance2;
        }
        return distance;
    }

    protected int lookOverUnicodeCode(int offset) {
        int distance;
        for (distance = 0; distance < 6 && this.hasMoreChar(offset + distance) && TokenizerBase.isHexDigit(this.getCharRelative(offset + distance)); ++distance) {
        }
        return distance;
    }

    protected static boolean isWhitespace(char c) {
        return Character.isWhitespace(c);
    }

    protected static boolean isHexDigit(char c) {
        return Character.isDigit(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    protected static boolean isNameChar(char c) {
        return c == '_' || c == '-' || Character.isDigit(c) || Character.isLetter(c) || c > '\u00b1';
    }

    protected static boolean isNameStartChar(char c) {
        return c == '_' || Character.isLetter(c) || c > '\u00b1';
    }
}

